// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "hotspot_ns.h"
#include "param.h" // MAX_RES()

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>

namespace hotspot_ns {

	// Definition of a hotspot
	// Residue must lose this much SASA to be a hotspot
	float hs_sasa_diff_thres = { 5. };
	// Residue must have less than this total SASA in the complex
	float hs_bound_sasa_thres = { 40. };
	// Residue must have less than this total SASA in the complex
	float hs_smallprobe_sasa_thres = { 15. };
	// Residue must have less than this fa_atr in the complex
	// Note: total fa_atr, not just across the interface
	float hs_atr_thres = { -7 };
	// Residue must have less than this SASApack in the complex
	float hs_sasapack_thres = { 15. };
	// Residue must have more than this SASAprob in the complex
	float hs_sasaprob_thres = { 0. };
	// Residue must have more than this ballSASAprob in the complex
	float hs_res_ball_sasa_thres = { 0. };
	// The largest void sphere touching the hotspot sidechain must be smaller than this radius
	float hs_maxvoid_thres = { 1.25 };
	// Residue must have a sidechain Hbond at least this good to be a hotspot
	float hs_hb_thres = { -0.75 };
	// Threshold for "self-satisfying" sidechain Hbond
	float self_satisfying_hb_thres = { -0.2 };
	// Permissive threshold for sidechain Hbond
	float permissive_hb_thres = { -0.1 };

	// Jumpouts if conditions are not met
	//	int binding_mode_group_uns_thres = { 2 };
	//	int second_hbond_group_uns_thres = { 2 };
	//	int hotspot_env_group_uns_thres = { 4 };
	int binding_mode_group_uns_thres = { 3 };
	int second_hbond_group_uns_thres = { 3 };
	int hotspot_env_group_uns_thres = { 6 };

	// flags set during operation to reflect control flow
	bool hotspot_design = { false };
	int output_decoy_index_num = { 0 };
	int output_designs_per_binding_mode = { 1 };
	bool output_all_designs = { false };
	bool use_trie = { true };
	bool use_hotspot_conformers = { false };

	// options set ahead of time to control behavior
	bool allow_hotspot_on_either_chain = { false };
	bool require_Hbond_to_sidechain = { true };
	int burial_neighbor_thres = { 7 };
	bool use_soft_rep = { false };
	bool do_rotamer_improvement = { false };
	bool do_periphery_last = { false };
	bool make_periphery_polar = { false };
	//	int max_second_Hbond_rot = { 100 };
	int max_second_Hbond_rot = { 10000 };  // note: we're not allowing Asn/Gln or charged, so do all!
	int max_unplanned_AspAsn_neighbors = { 15 };

	// scale all energies involving the hotspot by this factor
	float hotspot_weight_factor = { 2. };
	// scale two-body energies across the interface by this factor
	float interface_weight_factor = { 1.25 };

	// reject all binding modes which lead to a design with delta_sasa greater than this
	float delta_sasa_thres = { 2500. };

  // never write PDBs worse than these
	float min_delta_sasa_output = { 1000. };
	float max_delta_score_output = { -10. };

	// an additive quantity applied to the reference energy of charged groups
	float electrostatic_complementarity_shift = { 0.3 };
	bool do_electrostatic_complementarity = { true };

	// to favor starting sequence on the non-AR side (chain 1)
	FArray1D_int starting_sequence( param::MAX_RES() );
	float favor_native_periphery_bonus = { -0.3 };

	bool preserve_IG = { true };
	bool preserve_RotamerSet = { true };

	bool screen_for_hotspot = { false };

	bool hotspot_on_AR = { false };

	RotamerOptions hs_rotamer_options;

  bool BENCHMARK = { false };

}


