// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_hotspot_ns
#define INCLUDED_hotspot_ns

// Rosetta Headers
#include "RotamerOptions.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

namespace hotspot_ns {

	// Definition of a hotspot
	extern float hs_sasa_diff_thres;
	extern float hs_bound_sasa_thres;
	extern float hs_smallprobe_sasa_thres;
	extern float hs_sasapack_thres;
	extern float hs_sasaprob_thres;
	extern float hs_res_ball_sasa_thres;
	extern float hs_atr_thres;
	extern float hs_maxvoid_thres;
	extern float hs_hb_thres;
	extern float permissive_hb_thres;
	extern float self_satisfying_hb_thres;

	// Jumpouts if conditions are not met
	extern int binding_mode_group_uns_thres;
	extern int second_hbond_group_uns_thres;
	extern int hotspot_env_group_uns_thres;

	// Control flow
	extern bool hotspot_design;
	extern int output_decoy_index_num;
	extern int output_designs_per_binding_mode;
	extern bool output_all_designs;
	extern bool use_trie;
	extern bool use_hotspot_conformers;

	extern bool allow_hotspot_on_either_chain;
	extern bool require_Hbond_to_sidechain;
	extern int burial_neighbor_thres;
	extern bool use_soft_rep;
	extern bool do_rotamer_improvement;
	extern bool do_periphery_last;
	extern bool make_periphery_polar;
	extern int max_second_Hbond_rot;
	extern int max_unplanned_AspAsn_neighbors;

	extern float hotspot_weight_factor;
	extern float interface_weight_factor;

	extern float delta_sasa_thres;

	extern float min_delta_sasa_output;
	extern float max_delta_score_output;

	extern float electrostatic_complementarity_shift;
	extern bool do_electrostatic_complementarity;

	extern FArray1D_int starting_sequence;
	extern float favor_native_periphery_bonus;

	extern bool preserve_IG;
	extern bool preserve_RotamerSet;

	extern bool screen_for_hotspot;

	extern bool hotspot_on_AR;

	extern RotamerOptions hs_rotamer_options;

  extern bool BENCHMARK;

}

#endif

