// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.36 $
//  $Date: 2005/10/26 23:31:43 $
//  $Author: johnk $


// Rosetta Headers
#include "hotspot_residue.h"
#include "param_aa.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <iostream>

//Utility Headers
#include <utility/basic_sys_util.hh>


////////////////////////////////////////////////////////////////////////////////
/// @begin hotspot_residue::init
///
/// @brief:
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors: John Karanicolas
///
/// @last_modified: 11/27/05
/////////////////////////////////////////////////////////////////////////////////
void hotspot_residue::init() {

	resnum = 0;
	aa = 0;
	aav = 0;

	hbond = 0.;
	atr_ene = 0.;
	resSASA = 0.;
	resSASA_smallprobe = 0.;
	deltaSASA = 0.;
	SASApack = 999.;
	SASAprob = 0.;
	ballSASAprob = 0.;
	maxvoid = 0.;
	Cbeta_atr = 999.;
	interface_Cbeta_atr = 999.;

	return;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin hotspot_residue::describe
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
std::string
hotspot_residue::describe() {

	using namespace param_aa;

	if ( ( resnum == 0 ) || ( aa == 0 ) || ( aav == 0 ) ) {
		std::cout << "ERROR - HOTSPOT_RESIDUE DESCRIBE METHOD WAS CALLED PRIOR TO SETUP" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	std::ostringstream output_stream;
	output_stream << "HOTSPOT " << aa_name1(aa) << ' ' << resnum <<
		' ' << F(9,3,hbond) << ' ' << F(9,3,atr_ene) <<
		' ' << F(9,3,resSASA) << ' ' << F(9,3,resSASA_smallprobe) << ' ' << F(9,3,deltaSASA) <<
		' ' << F(9,3,SASApack) << ' ' << F(9,3,SASAprob) <<
		' ' << F(9,3,ballSASAprob) << ' ' << F(9,3,maxvoid) <<
		' ' << F(9,3,Cbeta_atr) << ' ' << F(9,3,interface_Cbeta_atr);

	return output_stream.str();

}

