// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.12 $
//  $Date: 2005/08/25 21:39:29 $
//  $Author: johnk $

#ifndef INCLUDED_hotspot_residue
#define INCLUDED_hotspot_residue

#include "pose_fwd.h"

// C++ Headers
#include <string>

// jk Class definition for hotspot_residue
class hotspot_residue
{

private:

	int resnum;
	int aa;
	int aav;
	float hbond;
	float atr_ene;
	float resSASA;
	float resSASA_smallprobe;
	float deltaSASA;
	float SASApack;
	float SASAprob;
	float ballSASAprob;
	float maxvoid;
	float Cbeta_atr;
	float interface_Cbeta_atr;

	void init();

public:

	inline hotspot_residue() { init(); };

	inline hotspot_residue( int const new_resnum, int const new_aa, int const new_aav )
	{ init(); setup(new_resnum, new_aa, new_aav); };

	inline void setup( int const new_resnum, int const new_aa, int const new_aav )
	{ resnum = new_resnum; aa = new_aa; aav = new_aav; };

	inline void set_hbond( const float new_hbond ) { hbond = new_hbond; };

	inline void set_atr_ene( const float new_atr_ene ) { atr_ene = new_atr_ene; };

	inline void set_resSASA( const float new_resSASA ) { resSASA = new_resSASA; };

	inline void set_resSASA_smallprobe( const float new_resSASA_smallprobe ) { resSASA_smallprobe = new_resSASA_smallprobe; };

	inline void set_deltaSASA( const float new_deltaSASA ) { deltaSASA = new_deltaSASA; };

	inline void set_SASApack( const float new_SASApack ) { SASApack = new_SASApack; };

	inline void set_SASAprob( const float new_SASAprob ) { SASAprob = new_SASAprob; };

	inline void set_ballSASAprob( const float new_ballSASAprob ) { ballSASAprob = new_ballSASAprob; };

	inline void set_maxvoid( const float new_maxvoid ) { maxvoid = new_maxvoid; };

	inline void set_Cbeta_atr( const float new_Cbeta_atr ) { Cbeta_atr = new_Cbeta_atr; };

	inline void set_interface_Cbeta_atr( const float new_interface_Cbeta_atr )
	{ interface_Cbeta_atr = new_interface_Cbeta_atr; };

	inline int get_resnum() { return resnum; };

	inline float get_hbond() { return hbond; };

	inline float get_atr_ene() { return atr_ene; };

	inline float get_resSASA() { return resSASA; };

	inline float get_resSASA_smallprobe() { return resSASA_smallprobe; };

	inline float get_deltaSASA() { return deltaSASA; };

	inline float get_SASApack() { return SASApack; };

	inline float get_SASAprob() { return SASAprob; };

	inline float get_ballSASAprob() { return ballSASAprob; };

	inline float get_maxvoid() { return maxvoid; };

	inline float get_Cbeta_atr() { return Cbeta_atr; };

	inline float get_interface_Cbeta_atr() { return interface_Cbeta_atr; };

	std::string describe();

};


#endif
