// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15095 $
//  $Date: 2007-05-23 06:25:07 -0700 (Wed, 23 May 2007) $
//  $Author: sarel $

#ifndef INCLUDED_int_fullatom_energies
#define INCLUDED_int_fullatom_energies


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/Dimension.hh>


namespace int_fullatom_energies {


//tk energetic contributions to the fullaton energy for interface mode


//tk contributions to the TOTAL energy
//tk for protein complexes: complex_*(3)
//tk where 1: partner 1
//tk       2: partner 2
//tk       3: complex

inline Dimension & MAX_MUT_STRUCTS() { static Dimension d; return d; } // residues in protein chain

void
initialize_MAX_MUT_STRUCTS();


namespace complex_energies {
	extern FArray1D_float complex_atrenergy;
	extern FArray1D_float complex_repenergy;
	extern FArray1D_float complex_solenergy;
	extern FArray1D_float complex_probenergy;
	extern FArray1D_float complex_dunenergy;
	extern FArray1D_float complex_intraresenergy;
	extern FArray1D_float complex_unfenergy;
 	extern FArray1D_float complex_protonation_energy;
	extern FArray1D_float complex_hbenergy;
	extern FArray1D_float complex_resenergy;
	extern FArray1D_float complex_pair_energy;
	extern FArray1D_float complex_plane_energy;
	extern FArray1D_float complex_h2oenergy;
	extern FArray1D_float complex_h2ohbenergy;
	extern FArray1D_float complex_h2osolenergy;
	extern FArray1D_float complex_sasa_gsolt;
	extern FArray1D_float complex_sasa_polar;
	extern FArray1D_float complex_sasa_apolar;
	extern FArray1D_float complex_sasa_pack;
	extern FArray1D_float complex_bbhb_uns;
	extern FArray1D_float complex_schb_uns;
	extern FArray1D_float complex_gu_tot;
	extern FArray1D_float complex_Wgu_tot;
	//ja
	extern FArray2D_float complex_resenergy_res;
  extern FArray1D_float complex_elecenergy;
}
using namespace complex_energies;


//tk contributions to the TOTAL energy
//tk for wild-type complex wt_*(3)

namespace wt_energies {
	extern FArray1D_float wt_atrenergy;
	extern FArray1D_float wt_repenergy;
	extern FArray1D_float wt_solenergy;
	extern FArray1D_float wt_probenergy;
	extern FArray1D_float wt_dunenergy;
	extern FArray1D_float wt_intraresenergy;
	extern FArray1D_float wt_unfenergy;
 	extern FArray1D_float wt_protonation_energy;
	extern FArray1D_float wt_hbenergy;
	extern FArray1D_float wt_resenergy;
	extern FArray1D_float wt_pair_energy;
	extern FArray1D_float wt_h2oenergy;
	extern FArray1D_float wt_h2ohbenergy;
	extern FArray1D_float wt_h2osolenergy;
	extern FArray1D_float wt_sasa_gsolt;
	extern FArray1D_float wt_sasa_polar;
	extern FArray1D_float wt_sasa_apolar;
	extern FArray1D_float wt_sasa_pack;
	extern FArray1D_float wt_bbhb_uns;
	extern FArray1D_float wt_schb_uns;
	extern FArray1D_float wt_gu_tot;
	extern FArray1D_float wt_Wgu_tot;
}
using namespace wt_energies;


//tk contribution to the BINDING free energy
//tk for all mutations in the mutation list: dgbind_*(MAX_MUT_STRUCTS)
//tk where dgbind_*(1): denotes the WT binding energy

namespace dgbind_energies {
	extern FArray1D_float dgbind_atrenergy;
	extern FArray1D_float dgbind_repenergy;
	extern FArray1D_float dgbind_solenergy;
	extern FArray1D_float dgbind_probenergy;
	extern FArray1D_float dgbind_dunenergy;
	extern FArray1D_float dgbind_intraresenergy;
	extern FArray1D_float dgbind_unfenergy;
 	extern FArray1D_float dgbind_protonation_energy;
	extern FArray1D_float dgbind_hbenergy;
	extern FArray1D_float dgbind_resenergy;
	extern FArray1D_float dgbind_pair_energy;
	extern FArray1D_float dgbind_h2oenergy;
	extern FArray1D_float dgbind_h2ohbenergy;
	extern FArray1D_float dgbind_h2osolenergy;
	extern FArray1D_float D_sasa_gsolt;
	extern FArray1D_float D_sasa_polar;
	extern FArray1D_float D_sasa_apolar;
	extern FArray1D_float D_sasa_pack;
	extern FArray1D_float D_bbhb_uns;
	extern FArray1D_float D_schb_uns;
	extern FArray1D_float D_gu_tot;
	extern FArray1D_float D_Wgu_tot;
}
using namespace dgbind_energies;


//tk complex_fullatomE :total full atom energy,no backbone-backbone hbondenergies

namespace int_totals {
	extern FArray1D_float complex_fullatomE;
	extern FArray1D_float complex_hbenergy_srbb;
	extern FArray1D_float complex_hbenergy_lrbb;
}
using namespace int_totals;


//ds contributions to the intrinsic free energy for each chain in the complex.
//ds These variables are currently only used if the alter_spec_format flag is used.

namespace intrinsic_chain_energies {
	extern FArray1D_float chainA_atrenergy; // Chain "A"
	extern FArray1D_float chainA_repenergy;
	extern FArray1D_float chainA_solenergy;
	extern FArray1D_float chainA_probenergy;
	extern FArray1D_float chainA_dunenergy;
	extern FArray1D_float chainA_intraresenergy;
	extern FArray1D_float chainA_unfenergy;
 	extern FArray1D_float chainA_protonation_energy;
	extern FArray1D_float chainA_hbenergy;
	extern FArray1D_float chainA_resenergy;
	extern FArray1D_float chainA_pair_energy;
	extern FArray1D_float chainA_h2oenergy;
	extern FArray1D_float chainA_h2ohbenergy;
	extern FArray1D_float chainA_h2osolenergy;
	extern FArray1D_float chainB_atrenergy; // Chain "B"
	extern FArray1D_float chainB_repenergy;
	extern FArray1D_float chainB_solenergy;
	extern FArray1D_float chainB_probenergy;
	extern FArray1D_float chainB_dunenergy;
	extern FArray1D_float chainB_intraresenergy;
	extern FArray1D_float chainB_unfenergy;
 	extern FArray1D_float chainB_protonation_energy;
	extern FArray1D_float chainB_hbenergy;
	extern FArray1D_float chainB_resenergy;
	extern FArray1D_float chainB_pair_energy;
	extern FArray1D_float chainB_h2oenergy;
	extern FArray1D_float chainB_h2ohbenergy;
	extern FArray1D_float chainB_h2osolenergy;
}
using namespace intrinsic_chain_energies;


}


#endif
