// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-17 23:39:36 -0700 (Sat, 17 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_interface
#define INCLUDED_interface


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <utility/vector1.hh>
#include <utility/vector1.fwd.hh>

// variables pertaining to the definition of the interface


namespace interface {

extern int const max_docking_sites;

// array indicating residues at the interface under 6A definitions

namespace interface_data {
	extern FArray1D_bool int_res; // mark residues at the interface
	extern FArray1D< utility::vector1_int > int_res_list;
	extern FArray1D< utility::vector1_int > int_pair_list;
}
using namespace interface_data;


// array indicating residues at the interface under 8A definitions

namespace interface_data8 {
	extern FArray1D_bool int_res8; // mark residues at the interface
	extern FArray1D< utility::vector1_int > int_res_list8;
	extern FArray1D< utility::vector1_int > int_pair_list8;
}
using namespace interface_data8;


// stuff for remembering site constraints and scoring them
extern int const max_site_constraints;


namespace site_data {
	extern bool site_constraints_exist;
	extern FArray1D< utility::vector1_int > site_constraint_residues;
	extern FArray1D_float site_constraint_bonus;
	extern float site_constraint_filter_score;
	extern int N_site_constraints;
}
using namespace site_data;


// or for remembering the native site

namespace native_sites {
	extern FArray1D< utility::vector1_int > native_site_residues;
}
using namespace native_sites;


// distance constraints

namespace dist_data {
	extern bool dist_constraint_exists;
	extern FArray1D_int dist_constraint_residues;
	extern float dist_constraint_distance_sq;
}
using namespace dist_data;


//chu for calculating fraction of native contacts
//ora and number of contacts

namespace docking_contact_map {
	extern FArray2D_bool docking_native_contact_map;
	extern int n_native_contact;
	extern float frac_native_contact;
	extern float frac_nonnat_contact;
	extern int n_contacts;
}
using namespace docking_contact_map;


}


#endif
