// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "jmp_maps.h"
#include "param.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>

// Using
using namespace param;
using namespace param_torsion;


namespace jmp_maps {


Dimension const max_atomlist_length( MAX_ATOM() );


namespace jmp_maps_common {
	FArray3D_int jmp_atomlist( max_atomlist_length, jmp_total_torsion, MAX_RES() );
	FArray2D_int jmp_atomlist_length( jmp_total_torsion, MAX_RES() );
	FArray2D_int jmp_torsion_map( 3, jmp_total_torsion * MAX_RES() );
	int jmp_torsion_map_length;
	bool chi_in_map;
}


// keep a copy of this, it's used bu jmp_add_torsion
// initialized in

namespace jmp_maps_closest_chi_common {
	FArray4D_bool jmp_maps_closest_chi( MAX_CHI, MAX_ATOM(), MAX_AA(), MAX_AA_VARIANTS() );
}


// -----debugging---------

namespace jmp_maps_debug_common {
	FArray2D_int torsionlist_count( jmp_total_torsion, MAX_RES() );
	FArray2D_int atomlist_count( MAX_ATOM(), MAX_RES() );
}


}
