// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_jumping_refold
#define INCLUDED_jumping_refold

#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// jumping_refold Function Declarations

void
refold_pose(
	pose_ns::Pose & pose
);

void
jmp_refold_tree(
	pose_ns::Pose const & pose,
	bool const full_coord_init,
	FArray1D_bool const & new_bb,
	FArray1D_bool const & new_chi,
	FArray1D_bool const & new_jump
);

void
jumping_build_fullcoord(
	pose_ns::Pose const & pose,
	bool const full_coord_init,
	FArray1D_bool const & already_done
);

void
fold_first_residue(
	const bool fullatom,
	int const fold_start,
	bool const res_moved // is fold_start contained in fragment insert?
);

void
fold_edge(
	pose_ns::Pose const & pose,
	bool const fullatom,
	int const estart,
	int const estop,
	int const elabel,
	FArray1D_bool const & new_bb,
	FArray1D_bool const & new_jump
);

void
jmp_update_overlap_positions(
	pose_ns::Pose const & pose,
	int const chainbreak_overlap,
	FArray4D_float & overlap_Eposition
);

void
copy_coordinates_pose(
	bool const fullatom,
	int const nres,
	FArray3DB_float const & src_Epos,
	FArray2DB_float const & src_cen,
	FArray3DB_float const & src_fcoord,
	FArray3DB_float & dest_Epos,
	FArray2DB_float & dest_cen,
	FArray3DB_float & dest_fcoord
);

bool misc_in_sync(
	pose_ns::Pose const & pose
);

void
pose_to_misc(
	pose_ns::Pose const & pose
);

void
copy_pose_torsions_to_misc(
	pose_ns::Pose const & pose
);

void
rebuild_misc_centroids_n2c(
	int const begin,
	int const size,
	FArray1D_float const & c_xyz
);


#endif
