// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 16303 $
//  $Date: 2007-07-28 16:56:49 -0700 (Sat, 28 Jul 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_jumping_util
#define INCLUDED_jumping_util


// Rosetta Headers
#include "pose_fwd.h"

// Numeric Headers
#include <numeric/all.fwd.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


void
slide_N(
	int const seqpos,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz,
	FArray1Da_float n_xyz_out
);


void
build_C_coords(
	int const pos,
	float const phi,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz,
	FArray1Da_float c_xyz,
	FArray1Da_float c_xyz_out
);


void
build_ideal_C_coords(
	float const phi,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz,
	FArray1Da_float c_xyz,
	FArray1Da_float c_xyz_out
);


void
build_ideal_N_CA_coords(
	float const psi,
	float const omega,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz,
	FArray1Da_float c_xyz,
	FArray1Da_float n_xyz_out,
	FArray1Da_float ca_xyz_out
);


void
get_ncac(
	FArray2Da_float pos, //input
	numeric::xyzMatrix_double & p //output
);


void
get_ncac_full_coord(
	FArray2Da_float pos,
	numeric::xyzMatrix_double & p
);


void
get_coordinate_system(
	numeric::xyzMatrix_double const & p, // input
	numeric::xyzMatrix_double & m  // output
);


void
get_coordinate_system(
	FArray2Da_float Epos,
	numeric::xyzMatrix_double & m
);


numeric::xyzMatrix_double
get_coordinate_system(
	FArray2Da_float Epos
);


void
update_geometry( int const pos );


void
build_stub(
	int const stub_res,
	int const dir,
	FArray1Da_float c_xyz,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz
);


void
build_stub_pose(
	pose_ns::Pose const & pose,
	int const stub_res,
	int const dir,
	FArray1Da_float c_xyz,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz
);


int
pick_loopy_cutpoint(
	int const nres,
	FArray1D_float const & cut_bias_sum
);


void
jmp_rotation_matrix(
	FArray2Da_double Rzyx,
	double const alpha_x,
	double const alpha_y,
	double const alpha_z
);


void
jmp_xrotation(
	FArray2Da_double R,
	double const alpha
);


void
jmp_yrotation(
	FArray2Da_double R,
	double const alpha
);


void
jmp_zrotation(
	FArray2Da_double R,
	double const alpha
);


void
Dvect_multiply(
	FArray2Da_double R,
	FArray1Da_double v,
	FArray1Da_double Rv // output
);


void
get_rosetta_torsions(
	FArray1Da_float phi_out,
	FArray1Da_float psi_out,
	int const nres // input
);


void
set_use_rosetta_torsions( bool const setting );


bool
get_use_rosetta_torsions();


void
build_nh_simple(
	int const aa,
	int const aav,
	float const phi,
	FArray2Da_float fcoord
);



void
put_one_full_coord_nh( int const seqpos );


void
change_color(
	FArray1Da_int color, // input/output
	int const nres, // input
	int const old_color,
	int const new_color
);


bool
jmp_end_bias_check(
	pose_ns::Fold_tree const & fold_tree,
	int const nres,
	int const begin,
	int const size
);


void
build_default_stub(
	int const seqpos,
	FArray1Da_float c_xyz,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz
);


void
rebuild_default_stub(
	int const seqpos,
	FArray1Da_float c_xyz,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz
);


void
set_rosetta_fullatom_flag( bool const setting );


int
aa2int( char const aa, bool & fail );

int
aa2int( char const aa );


void
insert_init_frag(
	pose_ns::Pose & pose,
	const int begin,
	const int size
);

void
insert_random_frags(
	const int frag_size,
	pose_ns::Pose & pose,
	const int loop_begin,
	const int loop_end,
	const int frag_offset
);

void
choose_offset_frag(
	const int frag_size,
	pose_ns::Pose & pose,
	const int loop_begin,
	const int loop_end,
	const int frag_offset = 0
);

bool
score_filter(
	const float score,
	const std::string & tag,
	const float acceptance_rate
);

numeric::xyzVector_double
random_unit_vector(
);


numeric::xyzMatrix_double
random_axis_rotation_matrix(
	double const alpha // degrees!
);

numeric::xyzMatrix_double
random_reorientation_matrix();


numeric::xyzMatrix_double
X_rot(
	const double angle
); // degrees


numeric::xyzMatrix_double
Y_rot(
	const double angle
); // degrees


numeric::xyzMatrix_double
Z_rot(
	const double angle
); // degrees


numeric::xyzMatrix_double
X_rot_rad(
	const double angle
); // radians


numeric::xyzMatrix_double
Y_rot_rad(
	const double angle
); // radians


numeric::xyzMatrix_double
Z_rot_rad(
	const double angle
); // radians


bool
Epos_init(
	FArray2Da_float Epos
);


bool
Epos_init_zero(
	FArray2Da_float Epos
);


bool
mapping_from_file(
	std::string const & filename,
	std::string const & seq1,
	std::string const & seq2,
	FArray1D_int & mapping,
	std::string const target_tag1 = "tag1",
	std::string const target_tag2 = "tag2"
);


void
put_nh_current_pose(
	int const seqpos,
	FArray3DB_float const & fcoord,
	FArray1D_float & nhcoord
);


bool
symm_check(
	pose_ns::Pose const & pose
);


#endif
