// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.2 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

// Rosetta Headers
#include "kin_bonded_atom_FS.h"
#include "jumping_util.h"
#include "kin_util.h"
#include "pose.h"
#include "aaproperties_pack.h"
#include "atom_tree_minimize.h" // update_nblist! should just make method?

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
//#include <ObjexxFCL/FArray4D.h>
//#include <ObjexxFCL/formatted.io.h>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/constants.hh>
#include <numeric/conversions.hh>
#include <numeric/xyz.functions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/orstream.hh>

// C++ Headers
#include <cstdlib>
#include <cstdio>


namespace kin {

	void
	Bonded_atom_FS::update_torsions(
		Stub &,// stub_in, // doesnt get modified
		Coords const & coords,
		bool const recursive // = true
	)
	{
		Stub stub( get_input_stub( coords ) );
		Bonded_atom::update_torsions( stub, coords, recursive );
	}

  /////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////

	void
	Bonded_atom_FS::update_coords(
																Stub &, //stub_in, // unchanged
		Coords & coords
	) const
	{
		Stub stub( get_input_stub( coords ) );
		Bonded_atom::update_coords( stub, coords );

// 		Stub stub( get_input_stub( coords ) );
// 		stub.M *= X_rot_rad( phi ) * Z_rot_rad( theta );
// 		stub.v += d * stub.M.col_x();

// 		coords.set_xyz( atom_id, stub.v );

// 		for ( std::vector< Atom* >::const_iterator it= atoms.begin(),
// 						it_end = atoms.end(); it != it_end; ++it ) {
// 			(*it)->update_coords( stub, coords );
// 		}
	}

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	bool
	Bonded_atom_FS::keep_torsion_fixed(
		Kin_torsion_type const type
	) const
	{
		if ( type == D ) {
			return false;
		} else if ( type == PHI ) {
			return keep_phi_fixed;
		} else if ( type == THETA ) {
			return keep_theta_fixed;
		} else {
			std::cout << "Bonded_atom::keep_torsion_fixed: BAD_TYPE: " <<type <<
				std::endl;
			assert( false );
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		return false;
	}


	/////////////////////////////////////////////////////////////////////////////
	// this will not modify last_torsion
	//
	void
	Bonded_atom_FS::setup_min_map(
		Torsion_id & last_torsion, // const
		Minimizer_map & min_map
	) const
	{

		Torsion_id last_torsion_local( last_torsion );

		if ( !phi_fixed ) {
			Torsion_id phi_torsion( atom_id, PHI );
			min_map.add_torsion( phi_torsion, last_torsion_local );
			last_torsion_local = phi_torsion;
		}

		if ( !theta_fixed ) {
			Torsion_id theta_torsion( atom_id, THETA );
			min_map.add_torsion( theta_torsion, last_torsion_local );
			last_torsion_local = theta_torsion;
		}

		if ( !d_fixed ) {
			Torsion_id d_torsion( atom_id, D );
			min_map.add_torsion( d_torsion, last_torsion_local );
			last_torsion_local = d_torsion;
		}

		// add me to the min_map
		min_map.add_atom( atom_id, last_torsion_local );

		for ( std::vector< Atom* >::const_iterator it=atoms.begin(),
						it_end = atoms.end(); it != it_end; ++it ) {
			(*it)->setup_min_map( last_torsion_local, min_map );
		}
	}



} // namespace kin
// 		using numeric::constants::d::pi;

// 		Stub stub( get_input_stub( coords ) );

// 		numeric::xyzVector_double w;
// 		coords.get_xyz( atom_id, w );

// 		w-= stub.v;
// 		d = w.length();

// 		if ( d < 1e-2 ) {
// 			// phi, theta dont make much sense
// 			std::cout << "very small d= " << d << ' ' << atom_id << std::endl;
// 			phi = 0.0;
// 			theta = 0.0;
// 		} else {
// 			if ( d < 1e-1 ) {
// 				std::cout << "WARNING:: small d but we are calculating phi,theta: " <<
// 					d << std::endl;
// 			}
// 			w.normalize();
// 			double const x( dot( w, stub.M.col_x() ) );
// 			double const y( dot( w, stub.M.col_y() ) );
// 			double const z( dot( w, stub.M.col_z() ) );

// 			double const tol( 1e-6 );
// 			if ( x < -1.0 + tol ) {
// 				theta = pi;
// 				phi = pi;
// 			} else if ( x > 1.0 - tol ) {
// 				theta = 0.0;
// 				phi = 0.0;
// 			} else {
// 				theta = std::acos( x ); // DANGER
// 				if ( theta < 1e-2 || pi - theta < 1e-2 ) {
// 					// less than 0.57 degrees
// 					std::cout << "WARNING:: small theta but we are calculating phi: " <<
// 						theta << std::endl;
// 				}
// 				phi  = std::atan2( z, y );
// 			} // small theta
// 		} // small d

// 		stub.M *= X_rot_rad( phi );


// 		if ( recursive ) {
// 			stub.M *= Z_rot_rad( theta );
// 			coords.get_xyz( atom_id, stub.v );
//  			if ( true ) { // debug
//  				Stub tmp_stub( get_stub( coords ) );
//  				float dev( distance( tmp_stub.M.col_x(), stub.M.col_x() ) +
//  									 distance( tmp_stub.M.col_y(), stub.M.col_y() ) +
//  									 distance( tmp_stub.M.col_z(), stub.M.col_z() ) +
//  									 distance( tmp_stub.v,         stub.v         ) );
//  				std::cout << "Bonded_atom_FS:: update_torsions: stub_dev= " <<
// 					dev << ' ' << atom_id << std::endl;
//  			}

// 			for ( std::vector< Atom* >::const_iterator it= atoms.begin(),
// 							it_end = atoms.end(); it != it_end; ++it ) {
// 				(*it)->update_torsions( stub, coords );
// 			}
// 		}
