// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.2 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

// Rosetta Headers
#include "kin_coords.h"
#include "jumping_util.h"
#include "kin_util.h"
#include "pose.h"
#include "aaproperties_pack.h"
#include "atom_tree_minimize.h" // update_nblist! should just make method?

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
//#include <ObjexxFCL/FArray4D.h>
//#include <ObjexxFCL/formatted.io.h>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/constants.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/orstream.hh>

// C++ Headers
#include <cstdlib>
#include <cstdio>


namespace kin {

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// Coords_FArray
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////

	Coords_FArray::Coords_FArray(
		FArray3D_float & source
	):
		src_coords( source )
	{}



	/////////////////////////////////////////////////////////////////////////////
	void
	Coords_FArray::set_xyz(
		Atom_id const & atom_id,
		numeric::xyzVector_double const & xyz
	)
	{
		int const offset( src_coords.index( 1, atom_id.atomno(), atom_id.rsd() ) );
		for ( int k=0; k<3; ++k ) {
			src_coords[ offset + k ] = xyz[k];
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Coords_FArray::set_xyz(
		Atom_id const & atom_id,
		numeric::xyzVector_float const & xyz
	)
	{
		int const offset( src_coords.index( 1, atom_id.atomno(), atom_id.rsd() ) );
		for ( int k=0; k<3; ++k ) {
			src_coords[ offset + k ] = xyz[k];
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Coords_FArray::get_xyz(
		Atom_id const & atom_id,
		numeric::xyzVector_double & xyz
	) const
	{
		int const offset( src_coords.index( 1, atom_id.atomno(), atom_id.rsd() ) );
		for ( int k=0; k<3; ++k ) {
			xyz[k] = src_coords[ offset + k ];
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Coords_FArray::get_xyz(
		Atom_id const & atom_id,
		numeric::xyzVector_float & xyz
	) const
	{
		int const offset( src_coords.index( 1, atom_id.atomno(), atom_id.rsd() ) );
		for ( int k=0; k<3; ++k ) {
			xyz[k] = src_coords[ offset + k ];
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	numeric::xyzVector_float
	Coords_FArray::get_xyz(
		Atom_id const & atom_id
	) const
	{
		return numeric::xyzVector_float
			( &src_coords(1,atom_id.atomno(), atom_id.rsd() ) );
	}




	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// Coords_FArray_const
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////

	Coords_FArray_const::Coords_FArray_const(
		FArray3D_float const & source
	):
		src_coords( source )
	{}



	/////////////////////////////////////////////////////////////////////////////
	void
	Coords_FArray_const::set_xyz(
		Atom_id const & ,
		numeric::xyzVector_double const &
	)
	{
		std::cout << "No set_xyz!" << std::endl;
		assert( false );
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Coords_FArray_const::set_xyz(
		Atom_id const & ,
		numeric::xyzVector_float const &
	)
	{
		std::cout << "No set_xyz!" << std::endl;
		assert( false );
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Coords_FArray_const::get_xyz(
		Atom_id const & atom_id,
		numeric::xyzVector_double & xyz
	) const
	{
		int const offset( src_coords.index( 1, atom_id.atomno(), atom_id.rsd() ) );
		for ( int k=0; k<3; ++k ) {
			xyz[k] = src_coords[ offset + k ];
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Coords_FArray_const::get_xyz(
		Atom_id const & atom_id,
		numeric::xyzVector_float & xyz
	) const
	{
		int const offset( src_coords.index( 1, atom_id.atomno(), atom_id.rsd() ) );
		for ( int k=0; k<3; ++k ) {
			xyz[k] = src_coords[ offset + k ];
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	numeric::xyzVector_float
	Coords_FArray_const::get_xyz(
		Atom_id const & atom_id
	) const
	{
		return numeric::xyzVector_float
			( &src_coords(1,atom_id.atomno(), atom_id.rsd() ) );
	}
}
