// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.2 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

// Rosetta Headers
#include "kin_fixed_atom.h"
#include "jumping_util.h"
#include "kin_util.h"
#include "pose.h"
#include "aaproperties_pack.h"
#include "atom_tree_minimize.h" // update_nblist! should just make method?

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
//#include <ObjexxFCL/FArray4D.h>
//#include <ObjexxFCL/formatted.io.h>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/constants.hh>
#include <numeric/conversions.hh>
#include <numeric/xyz.functions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/orstream.hh>

// C++ Headers
#include <cstdlib>
#include <cstdio>


namespace kin {

	/////////////////////////////////////////////////////////////////////////////
	float
	Fixed_atom::get_torsion(
		Kin_torsion_type const type
	) const
	{
		if ( type == X ) {
			return xyz(1);
		} else if ( type == Y ) {
			return xyz(2);
		} else if ( type == Z ) {
			return xyz(3);
		} else {
			std::cout << "Fixed_atom::get_torsion: bad type: " << type <<
				std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		return 0.0;
	}

	/////////////////////////////////////////////////////////////////////////////
	void
	Fixed_atom::update_coords(
		Stub & stub,
		Coords & coords
	) const
	{
		coords.set_xyz( atom_id, stub.M * xyz + stub.v );
	}


	/////////////////////////////////////////////////////////////////////////////
	void
	Fixed_atom::update_torsions(
		Stub & stub,
		Coords const & coords,
		bool const //recursive
	)
	{
		numeric::xyzVector_double v;
		coords.get_xyz( atom_id, v );
		xyz = stub.M.transposed() * ( v - stub.v );
	}




	/////////////////////////////////////////////////////////////////////////////
	void
	Fixed_atom::show() const
	{
		std::cout << "FIXED_ATOM: " << atom_id << std::endl;
		std::cout << "   PARENT: ";
		if ( parent ) {
			std::cout << parent->atom_id << std::endl;
		} else {
			std::cout << " NULL" << std::endl;
		}
	}



	/////////////////////////////////////////////////////////////////////////////
	void
	Fixed_atom::setup_min_map(
		Torsion_id & last_torsion,
		Minimizer_map & min_map
	) const
	{
		// add me to the min_map
		min_map.add_atom( atom_id, last_torsion );
	}



	/////////////////////////////////////////////////////////////////////////////
	void
	Fixed_atom::copy_torsions(
		Atom const & src
	)
	{
		assert( atom_id == src.atom_id );
		xyz(1) = src.get_torsion(X);
		xyz(2) = src.get_torsion(Y);
		xyz(3) = src.get_torsion(Z);
	}


	/////////////////////////////////////////////////////////////////////////////
	Atom*
	Fixed_atom::copy( Atom* parent_in ) const
	{
		Fixed_atom* new_me = new Fixed_atom();

		new_me->atom_id = atom_id;
		new_me->parent = parent_in;

		new_me->xyz = xyz;
		return new_me;
	}


	/////////////////////////////////////////////////////////////////////////////
	void
	Fixed_atom::update_domain_map(
		int & current_color,
		int &,// biggest_color,
		FArray1D_int & domain_map
	) const
	{
		int color( current_color );

		// update domain_map
		int const current_map( domain_map( atom_id.rsd() ) );
		if ( current_map < 0 ) {
			// unassigned
			domain_map( atom_id.rsd() ) = color;
		} else if ( current_map == 0 || current_map == color ) {
			// leave the same
		} else {
			// color change within a residue
			domain_map( atom_id.rsd() ) = 0;
		}
	}

} // namespace kin
