// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_id
#define INCLUDED_kin_id


// Rosetta Headers
#include "util_basic.h"
#include "jump_classes.h"
#include "kin_stub.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/Fmath.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/constants.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>
#include <list>


namespace kin {

	extern int const dir_jump;

	/////////////////////////////////////////////////////////////////////////////
	// Atom_id
	/////////////////////////////////////////////////////////////////////////////

	// data to uniquely specify an atom
	// could change -- pointer?
	class Atom_id {
	public:
		// construction
		Atom_id():atomno_(0),rsd_(0) {};

		Atom_id(
			Atom_id const & src
		):
			atomno_( src.atomno() ),
			rsd_( src.rsd() )
		{}

		Atom_id(
			int const atomno_in,
			int const rsd_in
		):
			atomno_( atomno_in ),
			rsd_( rsd_in )
		{}

		inline
		int
		atomno() const { return atomno_; }

		inline
		int
		rsd() const { return rsd_; }

		inline
		int &
		atomno() { return atomno_; }

		inline
		int &
		rsd() { return rsd_; }

	protected:
		// data
		int atomno_;
		int rsd_;

	public:
		// friends
		friend
		std::ostream &
		operator <<(
			std::ostream & os,
			Atom_id const & a
		);

		friend
		bool
		operator ==(
			Atom_id const & a,
			Atom_id const & b
		) { return a.atomno() == b.atomno() && a.rsd() == b.rsd(); }

		friend
		bool
		operator !=(
			Atom_id const & a,
			Atom_id const & b
		) { return a.atomno() != b.atomno() || a.rsd() != b.rsd(); }

		friend
		bool
		operator <(
			Atom_id const & a,
			Atom_id const & b
		) { return a.rsd() < b.rsd() ||
					a.rsd() == b.rsd() && a.atomno() < b.atomno(); }

	};

	extern Atom_id const BOGUS_ATOM;
	extern Atom_id const CHAINBREAK_BOGUS_ATOM;


	/////////////////////////////////////////////////////////////////////////////
	// Kin_torsion_type
	/////////////////////////////////////////////////////////////////////////////

	enum Kin_torsion_type { PHI, THETA, D, RB1, RB2, RB3, RB4, RB5, RB6,
													RB_TRANSLATION, RB_ROTATION, X, Y, Z, ALL };

	/////////////////////////////////////////////////////////////////////////////
	// helpful conversion
	inline
	Kin_torsion_type
	get_rb_type( int const k ) {
		assert( k>=1 && k<=6 );
		return ( k == 1 ? RB1 : ( k==2 ? RB2 : ( k == 3 ? RB3 :
					 ( k == 4 ? RB4 : ( k==5 ? RB5 : RB6 ) ) ) ) );
	}

	/////////////////////////////////////////////////////////////////////////////
	inline
	int
	get_rb_number( Kin_torsion_type const t ) {
		if ( t == PHI || t == THETA || t == D ) return 0;
		else {
			return ( t == RB1 ? 1 : ( t == RB2 ? 2 : ( t == RB3 ? 3 :
						 ( t == RB4 ? 4 : t == RB5 ? 5 : 6 ) ) ) );
		}
	}

	/////////////////////////////////////////////////////////////////////////////
	inline
	float
	subtract_kin_torsions(
		float const value1,
		float const value2,
		Kin_torsion_type const t
	)
	{
		if ( t == D || t == RB1 || t == RB2 || t == RB3 ) {
			return value1 - value2;
		} else if ( t == PHI || t == THETA || t == RB4 || t == RB5 || t == RB6 ) {
			// stolen from subtract_radian_angles:
			float const a( value1 - value2 );
			float const x( numeric::constants::f::pi_2 );
			// stolen from periodic_range:
			float const halfx = 0.5f * x;
			return ( ( a >= halfx || a < -halfx ) ?
							 mod( mod( a, x ) + ( x + halfx ), x ) - halfx :
							 a );
		} else {
			std::cout << "bad torsion type for subtract_kin_torsions: " <<
				t << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
		return 0.0;
	}

	/////////////////////////////////////////////////////////////////////////////
	// Torsion_id
	/////////////////////////////////////////////////////////////////////////////

	class Torsion_id {
	public:
		Torsion_id(){};
		Torsion_id(
			Atom_id const & atom_id_in,
			Kin_torsion_type const & type_in
		):
			atom_id_( atom_id_in ),
			type_( type_in )
		{};

		inline
		Atom_id const &
		atom_id() const { return atom_id_; }

		inline
		Kin_torsion_type
		type() const { return type_; }

	private:
		Atom_id atom_id_;
		Kin_torsion_type type_;

	public:
		// friends
		friend
		std::ostream &
		operator <<(
			std::ostream & os,
			Torsion_id const & a
		);
		friend
		bool
		operator ==(
			Torsion_id const & a,
			Torsion_id const & b
		) { return a.atom_id() == b.atom_id() && a.type() == b.type(); }
		friend
		bool
		operator !=(
			Torsion_id const & a,
			Torsion_id const & b
		) { return a.atom_id() != b.atom_id() || a.type() != b.type(); }
		friend
		bool
		operator <(
			Torsion_id const & a,
			Torsion_id const & b
		) { return a.atom_id() < b.atom_id() ||
					a.atom_id() == b.atom_id() && a.type() < b.type(); }

	};

	extern Torsion_id const BOGUS_TORSION;
}


#endif
