// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 04:43:15 $
//  $Author: pbradley $

#ifndef INCLUDED_kin_moving_atom
#define INCLUDED_kin_moving_atom


// Rosetta Headers
#include "util_basic.h"
#include "jump_classes.h"
#include "kin_stub.h"
#include "kin_id.h"
#include "kin_min.h"
#include "kin_atom.h"
#include "kin_coords.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/conversions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
//#include <iosfwd>
#include <cassert>
#include <vector>
#include <string>
#include <map>
#include <list>

namespace kin {

	class Moving_atom : public Atom {
	public:


		///////////////////////////////////////////////////////////////////////////
		// go back and forth between torsions and coords
		virtual
		void
		update_coords(
			Stub & stub,
			Coords & coords // could be a simple wrapper for FArray
		) const = 0;


		virtual
		void
		update_torsions(
			Stub & stub,
			Coords const & coords,
			bool const recursive = true
		) = 0;


		///////////////////////////////////////////////////////////////////////////
		// access torsions
		virtual
		void
		set_torsion(
			Kin_torsion_type const type,
			float const value
		) = 0;


		virtual
		float
		get_torsion(
			Kin_torsion_type const type
		) const = 0;


		virtual
		pose_ns::Jump const &
		jump() const = 0;


		virtual
		pose_ns::Jump &
		jump() = 0;


		///////////////////////////////////////////////////////////////////////////
		// for minimizing
		virtual
		void
		setup_min_map(
			Torsion_id & last_torsion,
			Minimizer_map & min_map
		) const = 0;


		virtual
		void
		get_torsion_axis_and_end_pos(
			Coords const & coords,
			numeric::xyzVector_float & axis,
			numeric::xyzVector_float & end_pos,
			Kin_torsion_type const type
		) const = 0;


		///////////////////////////////////////////////////////////////////////////
		// miscellaneous inspection
		virtual
		bool
		is_jump() const = 0;


		virtual
		bool
		torsions_fixed() const = 0;


		virtual
		void
		show() const;


		virtual
		bool
		get_torsion_moved() const { return torsion_moved; }




		///////////////////////////////////////////////////////////////////////////
		// setting miscellaneous stuff
		virtual
		void
		set_torsion_moved(
			bool const setting,
			bool const include_fixed_torsions,
			bool const recursive
		);


		virtual
		void
		set_allow_move(
			Kin_torsion_type const type,
			bool const setting
		) = 0;


		///////////////////////////////////////////////////////////////////////////
		// update domain map
		virtual
		void
		update_domain_map(
			int & current_color,
			int & biggest_color,
			FArray1D_int & domain_map
		) const;


		///////////////////////////////////////////////////////////////////////////
		// for optimizing the tree
		virtual
		Atom*
		trim_fixed_atoms(
			Atom* & parent_in,
			bool & good_stub_in
		);


		///////////////////////////////////////////////////////////////////////////
		// manage atom_list
		virtual
		void
		add_atom( Atom* );


		virtual
		void
		delete_atom( Atom* );


		virtual
		void
		insert_atom( Atom* );


		virtual
		void
		erase();


		virtual
		int
		nchildren() const;


		virtual
		Atom const *
		child( int const k ) const;


		virtual
		Atom *
		child( int const k );


		virtual
		void
		replace_atom(
			Atom* const old_atom,
			Atom* const new_atom
		);

		virtual
		bool
		downstream( const Atom* atom1 ) const ;

		virtual
		bool
		fixed_downstream( const Atom* atom1, Kin_torsion_type const fixed_tor_id ) const ;

		///////////////////////////////////////////////////////////////////////////
		// get stub information
		virtual
		Stub
		get_stub(
			Coords const & coords
		) const;


		virtual
		Stub
		get_input_stub(
			Coords const & coords
		) const;


		virtual
		Atom_id const &
		stub_atom1() const;


		virtual
		Atom_id const &
		stub_atom2() const;


		virtual
		Atom_id const &
		stub_atom3() const;


		virtual
		Atom_id const &
		input_stub_atom0() const;


		virtual
		Atom_id const &
		input_stub_atom1() const;


		virtual
		Atom_id const &
		input_stub_atom2() const;


		virtual
		Atom_id const &
		input_stub_atom3() const;

		//friend class Atom_tree;

		//protected:

		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		// protected methods
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////

		// useful helper function for manipulating stubs
		virtual
		void
		update_stub(
			Stub & stub
		) const = 0;


		// when subtrees have changed their coordinates
		virtual
		void
		update_child_torsions(
			Atom* const child,
			Coords const & coords
		);


		// routines for navigating the tree
		virtual
		Atom const *
		previous_sibling() const;


		virtual
		Atom const *
		previous_child(
			Atom const * child
		) const;


		virtual
		Atom *
		next_child(
			Atom const * child
		);


		virtual
		std::vector< Atom* >::const_iterator
		nonjump_atoms_begin() const;


		virtual
		std::vector< Atom* >::iterator
		nonjump_atoms_begin();


		virtual
		bool
		stub_defined() const;


		virtual
		Atom const *
		get_nonjump_atom(
			int const i
		) const;


		virtual
		void
		update_atom_pointer(
			FArray2D< Atom* > & atom_pointer
		);


		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////
		// data
		///////////////////////////////////////////////////////////////////////////
		///////////////////////////////////////////////////////////////////////////

		bool torsion_moved;
		std::vector< Atom* > atoms;
	};
}

#endif
