// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17158 $
//  $Date: 2007-09-12 14:38:32 -0700 (Wed, 12 Sep 2007) $
//  $Author: davis $

#ifndef INCLUDED_ligand
#define INCLUDED_ligand

//Rosetta headers
#include "atom_chem.h"
#include "ligand_ns.h"
#include "hbonds_ns.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <iosfwd>
#include <vector>
#include <string>

//Forward declarations


// ligand Function Declarations


bool
get_ligand_flag(
);

inline
bool
get_ligand_flexible_flag(
){
	return ligand::ligand_flexible;
}

Ligand &
get_ligand_one();


void
set_ligand_flag( bool setting );


void
get_ligand_packer_weights( bool const soft_rep_status );


bool
get_recompute_ligand_interface(Ligand & molecule);


void
atom_num_from_atom_char(
	std::string const & ac,
	int & at,
	int & hyb
);

void
set_ros_atom_by_name(
	std::string const & name,
	Atom & atom
);

void
read_pdb_hetero(
	utility::io::irstream & iunit,
	Ligand & molecule,
	std::string resid_tag = "" //default is '', do not check the res_id column
);

int
read_mdl(
	utility::io::izstream & iunit,
	Ligand * molecule
);

void
reset_hetero();

void
get_hetatom_num(
	std::string const & sname, //cems short name
	int & number // atom number
);


void
make_pdb_hetero(
	utility::io::orstream & iunit,
	Ligand & molecule
);

int
write_mdl(
	utility::io::orstream & iunit,
	Ligand & molecule
);

int
read_ligand_conformations_sdfile(
	utility::io::izstream & iunit,
	Ligand & molecule
);

void
reset_satisfied_ha_hbond(
	Ligand & molecule
);


void
count_satisfied_ha_hbond(
	int & don_sat,
	int & don_non,
	int & acc_sat,
	int & acc_non,
	Ligand & molecule
);

int
generate_base_ligand_conformations(
);

void
update_hetero_atom_charge(
	float const total_charge,
	Ligand & molecule
);


void
hetero_atom_amino_acid_distance(
	int const aa,
	FArray2Da_float coord,
	FArray1Da_float het_coord,
	float & dis2,
	bool & neighbor
);


void
get_sc_haE(
	int const aaid,
	int const aa,
	int const aav,
	FArray2Da_float coord,
	float & solvE,
	float & atrE,
	float & repE,
	bool eval_bb,
	bool eval_sc,
	Ligand & molecule
);


void
get_sc_haD_chi(
	int const aaid,
	int const aa,
	int const aav,
	FArray2Da_float coord,
	int & chi,
	FArray1Da_float f1,
	FArray1Da_float f2,
	Ligand & molecule
);


void
get_sc_ha_h2oE(
	int const aaid,
	int const aa,
	int const aav,
	FArray2Da_float coord,
	float & h2oE,
	Ligand & molecule
);


void
get_sc_ha_hbondE(
	int const aaid,
	int const aa,
	int const aav,
	FArray2Da_float coord,
  bool const eval_bb,
  bool const eval_sc,
  Ligand & molecule,
  float & hbondE,
  hbonds::HBDerivType deriv_type = hbonds::hbderiv_NONE,
  FArray2DB_float & f1 = hbonds::NODERIV2D,
  FArray2DB_float & f2 = hbonds::NODERIV2D
);

void
get_sc_ha_coulombE(
	int const aaid,
	int const aa,
	int const aav,
	FArray2Da_float coord,
	Ligand * ligand,
	float & elecE,
	bool eval_bb,
	bool eval_sc
);


void
warshel_elec(
	float q1,
	float q2,
	float r2,
	float limit2,
	float & E
);


void
simple_elec(
	float q1,
	float q2,
	float r2,
	float limit2,
	float & E
);

float
get_ligand_ligandE(
	Ligand & molecule1,
	Ligand & molecule2,
	float & solvE,
	float & atrE,
	float & repE,
	float & hbE,
	float & elecE
);

void
detect_ligand_interface(
	Ligand & molecule,
	bool multiple_conformations,
	int total_residue,
	FArray1D_int const & res,
	FArray3D_float const & full_coord
);


void
ligand_center(
	FArray1Da_float center_coordinates,
	Ligand & molecule
);


void
detect_ligand_interface_res(
	int aaid,
	Ligand & molecule,
	bool multiple_conformations,
	FArray1D_int const & res,
	FArray3D_float const & full_coord
);


void
detect_number_of_contacts(
	FArray1DB_int const & res,
	FArray3DB_float const & full_coord,
	int const aaid,
	int & contacts,
	Ligand & molecule
);


void
calc_number_of_ligand_contacts(
	int & number_lig_contacts,
	Ligand & molecule
);


void
derivative_ligand_pos(
	FArray1Da_float TR,
	FArray1Da_float dE_dTR,
	int nfree,
	Ligand & molecule
);

void
ligand_centroid_vdw(
	float & ligand_centroid_VDW_E,
	Ligand & molecule
);

void
ligand_bb_vdw(
	float & ligand_bb_VDW_E,
	Ligand & molecule
);

void
ligand_bb_fa_vdw(
	float & ligand_bb_VDW_E,
	Ligand & molecule
);

int
get_dihedral_energy(
	std::pair< atom_chem::LigandAtomType, atom_chem::LigandAtomType > atompairtype,
	double dihedral,
	double & dihedE,
	double & deriv_dihedE,
	bool const output_warning
);

ligand::LigandCartesianCoord
get_ligand_cartesian_conformation(
	const Ligand & molecule
);


/// @brief  Sets the conformation of the ligand to the passed cartesian coord
/// conformation
void
set_ligand_cartesian_conformation(
	ligand::LigandCartesianCoord & conformation,
	Ligand & molecule
);

void
superimpose_ligand_cartn_coords(
	ligand::LigandCartesianCoord       & mobile,
	ligand::LigandCartesianCoord const & target
);

ligand::LigandInternalCoord
get_ligand_internal_conformation(
	const Ligand & molecule
);
#endif
