// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.8 $
//  $Date: 2005/09/16 16:36:10 $
//  $Author: pbradley $

#ifndef INCLUDED_loop_class
#define INCLUDED_loop_class

// Rosetta Headers

#include <vector>
//#include <iostream>

///////////////////////////////////////////////////////////////////////////////
namespace pose_ns {
  ////////////////////////////////////////////////////////////////////////////
  // single loop definition
  class Loop {

    int start_;
    int stop_;
    int cut_;
		int offset_;
    bool extended_;

	public:
    Loop():
      start_(0),
      stop_(0),
      cut_(0),
			offset_(0),
      extended_(false)
		{}

		Loop(
			int const start_in, int const stop_in,
			int const cut_in, int const offset_in = 0,
			bool const extended_in = false
		):
			start_( start_in ),
			stop_( stop_in ),
			cut_( cut_in ),
			offset_( offset_in ),
			extended_( extended_in )
		{}

		inline bool is_extended() const { return extended_; }
		inline int start() const { return start_; }
		inline int stop() const { return stop_; }
		inline int cut() const { return cut_; }
		inline int offset() const { return offset_; }
		inline int size() const { return stop_ - start_ + 1; }

		inline void set_extended( bool input ) { extended_ = input; }
		inline void set_start( int input ) { start_ = input; }
		inline void set_stop( int input ) { stop_ = input; }
		inline void set_cut( int input ) { cut_ = input; }
		inline void set_offset( int input ) { offset_ = input; }

		friend std::ostream & operator<<(std::ostream & is, const Loop & loop);
  };
	///////////////////////////////////////////////////////////////////////////
	// a list of loops
	class Loops {
	public:
		typedef std::vector< Loop > Loop_list;
		typedef Loop_list::iterator iterator;
		typedef Loop_list::const_iterator const_iterator;

	private:
		Loop_list loop_list;

	public:
		inline int num_loop() const { return loop_list.size(); }
		inline const_iterator begin() const { return loop_list.begin(); }
		inline const_iterator end() const { return loop_list.end(); }
		inline iterator v_begin() { return loop_list.begin(); }
		inline iterator v_end() { return loop_list.end(); }
		inline Loop at( int const x ) const { return loop_list.at(x); }

		//constructor
		Loops(){};
		//copy constructor
		Loops( const Loops & src ):loop_list(src.loop_list) {}
		//operator
		Loops & operator =( Loops const & src ) {
			loop_list = src.loop_list;
			return *this;
		}

		friend std::ostream & operator<<( std::ostream & os, const Loops & loops );

		void
		read_loops_from_file(
			std::string const filename
		);

		void
		write_loops_to_file(
			std::string const filename
		);


		void
		add_loop(
			int const start,
			int const stop,
			int const cut,
			int const offset = 0,
			bool const extended = false
		);

		void
		add_loop(
			const Loops::const_iterator & it
		);

		void
		add_loop(
			const Loops::iterator & it
		);

		void
		add_overlap_loop(
			Loops loops
		);

		void
		add_overlap_loop(
			const Loop loop
		);

		void
		delete_loop(
			int const start,
			int const stop
		);

		const_iterator one_random_loop() const;

		int
		loop_size(
			int const loop_num
		) const;

		int
		loop_size() const;

		void sequential_order();

		void clear();

	};
}

#endif
