// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 22095 $
//  $Date: 2008-04-25 12:32:22 -0700 (Fri, 25 Apr 2008) $
//  $Author: sraman $

// Rosetta Headers
#include "loop_relax.h"
#include "aa_name_conversion.h"
#include "after_opts.h"
#include "chuck.h"
#include "constraints.h"
#include "design.h"
#include "docking_ns.h"
#include "files_paths.h"
#include "fragments.h"
#include "fragments_pose.h"
#include "fragments_ns.h"
#include "fold_loops.h"
#include "force_barcode.h"
#include "fullatom.h"
#include "fullatom_setup.h"
#include "idealize.h"
#include "initialize.h"
#include "jumping_refold.h"
#include "jumping_util.h"
#include "jumping_loops.h"
#include "jumping_diagnostics.h"
#include "loop_class.h"
#include "maps.h"
#include "make_pdb.h"
#include "minimize.h"
#include "misc.h" // damn
#include "monte_carlo.h"
#include "nblist.h"
#include "options.h"
#include "output_decoy.h"
#include "param.h" // MAX_POS
#include "pdb.h"
#include "pose.h"
#include "pose_io.h"
#include "pose_loops.h"
#include "pose_fwd.h"
#include "pose_design.h"
#include "pose_docking.h"
#include "pose_idealize.h"
#include "pose_rms.h"
#include "pose_symmetric_docking.h"
#include "pose_vdw.h"
#include "ramachandran.h"
#include "random_numbers.h"
#include "relax.h"
#include "runlevel.h"
//#include "relax_structure.h"
#include "score.h"
#include "silent_input.h" //psh add this for silent pdb
#include "smallmove.h"
#include "ssblocks.h" // charlie's heap stuff
#include "torsion_bbmove_trials.h"
#include "trajectory.h"
#include "util_basic.h"
#include "util_vector.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/FArray5D.hh>
#include <ObjexxFCL/formatted.io.hh>
#include <ObjexxFCL/string.functions.hh>


// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <fstream>
#include <vector>
#include <string>
#include <list>
#include <map>


// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>
#include <utility/io/ocstream.hh>
#include <utility/file/file_sys_util.hh>

// BOINC
#ifdef BOINC
#ifdef _WIN32
#include "boinc_win.h"
#endif
#include "boinc_api.h"
#include "boinc_rosetta_util.h"
#endif

namespace loopcst
{
	std::map< int, float > coord_cst;
	bool coord_cst_exist(false);
	float loop_skip_rate(0.0);
	float loop_combine_rate(0.0);
	bool loop_model_exist(false);
	float total_chain_break_score(0.0);
	std::vector< float > chain_breaks;
	pose_ns::Loops loops_built;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin loop_relax
///
/// @brief called from relax_structure to relax loops defined by loop_file
///
/// @detailed this routine will use build_random_loops to rebuild loop regions
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////

bool loop_relax (){

	using namespace pose_ns;
	using namespace files_paths;

#ifdef BOINC
	std::string const checkpoint_decoy_name( "farlxcheck" );
	std::string const checkpoint_loops_file( "loopscheck");
	int attempted_decoys(0);
	int num_decoys(0);
	int farlx_stage(0);
	int set_stage(0);
	time_t stage0_time, stage1_time, stage2_time, stage3_time, stage9_time;
	double time_diff(0.0);
	restoreDecoyInfo( attempted_decoys, num_decoys, farlx_stage );
#endif

#ifdef BOINC
	int const n_loop_fail_tol( 1 );
	int const n_score_filter_fail_tol( 1 );
#else
	int const n_loop_fail_tol( 2 ); // try building loops this many times
	int const n_score_filter_fail_tol( 2 ); // retry this many times if fails score_filter
#endif
	int const loop_build_round( 1 ); // build full loops this many times

	bool const exist_vary_omega( score_get_vary_omega() );
	score_set_vary_omega(false);

// save the status
	reset_loop_chain_breaks();

	bool idealize_fail( false );
	int n_score_filter_fail( 0 );
	bool loop_modeling_fail( false );
	bool passed_score_filter( false );

	Pose pose, init_pose_obj;
	bool const ideal_pose( false );
	bool const init_coord( true );

	Loops output_loops;

	bool const full_atom( get_fullatom_loop_flag() ); //default is false
	Pose save_fullatom_pose;

	bool found_loops;
	float score_filter_cutoff;

	// save the barcode state
	bool const exist_barcode( barcode_exist() );
	std::vector<int> ori_loops_begin, ori_loops_end;

	// optionally build obligate loops
	Loops output_obligate_loops;

#ifdef BOINC
	if( farlx_stage > 9 ) goto L100;
#endif

	set_pose_flag( true );
	pose_from_misc( pose, files_paths::input_fa, ideal_pose, init_coord );
	if( pose.fullatom() ) {
		save_fullatom_pose = pose;
		pose.set_fullatom_flag( full_atom, false );
	}
	set_pose_flag( false );

#ifdef BOINC
	boinc_params::pct_complete += 0.001;
	boinc_fraction_done(boinc_params::pct_complete);
	if( farlx_stage > 0 ) goto STAGE1;
	time( &stage0_time );
#endif

	if ( !build_obligate_loops( pose, output_obligate_loops, full_atom ) ){
		loop_modeling_fail = true;
		goto L100;
	}

#ifdef BOINC
	boinc_params::pct_complete += 0.001;
  boinc_fraction_done(boinc_params::pct_complete);

	//checkpoint stage1
	time(&stage1_time);
	time_diff = difftime( stage1_time, stage0_time );
	if ( time_diff > get_checkpoint_interval() &&
			get_do_checkpointing() &&
			get_obligate_loop_exist() &&
			farlx_stage < 1 ){
		set_stage = 1;
		boinc_begin_critical_section();
		checkpoint_decoys(attempted_decoys, num_decoys, set_stage);
		output_obligate_loops.write_loops_to_file( checkpoint_loops_file );
		set_pose_flag(true);
		pose.dump_pdb( checkpoint_decoy_name );
		set_pose_flag(false);
		boinc_end_critical_section();
	}

STAGE1:
	// recover from checkpoint stage1
	if( farlx_stage == 1 ){
		output_obligate_loops.read_loops_from_file( checkpoint_loops_file );
		read_checkpoint_decoy( checkpoint_decoy_name, pose.fullatom() /*fullatom*/ );
		set_pose_flag(true);
		pose_from_misc( pose, files_paths::input_fa, ideal_pose, init_coord );
		set_pose_flag(false);
		initialize_random_numbers();
	}else if( farlx_stage > 1 ) goto STAGE2;

#endif


	// loop relax
	if( get_loop_rebuild() ){

		get_loop_modeling_option();

		found_loops = read_loop_file( ori_loops_begin, ori_loops_end );
		if ( !found_loops )
			goto L100;

		read_coord_cst();

		verify_loop_file( pose, ori_loops_begin, ori_loops_end );

		score_filter_cutoff = get_score_filter_cutoff();

		// save the initial pose in case failed scorefilter
		init_pose_obj = pose;

		while( !passed_score_filter &&
			n_score_filter_fail < n_score_filter_fail_tol ){

			n_score_filter_fail++;

			// reset pose
			pose = init_pose_obj;

			set_pose_flag( true );
			set_barcode_status( true );

			int loop_nfail( 0 );
			bool loop_done( false );
			while( !loop_done && loop_nfail <= n_loop_fail_tol ){
				loop_nfail++;
				output_loops.clear();
				for ( int i = 0; i < loop_build_round; ++i ){
					bool obligate( false );
					loop_done = build_random_loops( pose, ori_loops_begin, ori_loops_end, output_loops, full_atom, obligate );
				}
			}

			if ( !loop_done ){
				loop_modeling_fail = true;
				goto L100;
			}

			pose_to_misc( pose );

			set_pose_flag( false );
			set_barcode_status( false );
			float score_filter_score = score6();
			monte_carlo_reset();
			passed_score_filter = score_filter( score_filter_score, "looprlx", score_filter_cutoff);

		}// finished centroid mode
	}

	set_barcode_status( exist_barcode );
	reset_barcode_list();

	output_loops.add_overlap_loop( output_obligate_loops );

	if( get_output_loops_file() && ( get_loop_rebuild() || get_obligate_loop_exist() )){
		std::string loops_filename = files_paths::pdb_out_path + files_paths::start_file + ".loopout";
		output_loops.write_loops_to_file( loops_filename );
	}

	if( save_fullatom_pose.total_residue() == pose.total_residue() ) {
		set_pose_flag( true );
		pose.set_fullatom_flag( true, false );
		pose.recover_sidechain( save_fullatom_pose );
		repack_loops( output_loops, pose );
		set_pose_flag( false );
	}

#ifdef BOINC
	boinc_params::pct_complete += 0.001;
  boinc_fraction_done(boinc_params::pct_complete);

	// checkpoint stage2
	time(&stage2_time);
	time_diff = difftime( stage2_time, stage1_time );
	if ( time_diff > get_checkpoint_interval() && get_do_checkpointing()
			&& get_loop_rebuild() && farlx_stage < 2 ){
		set_stage = 2;
		boinc_begin_critical_section();
		checkpoint_decoys(attempted_decoys, num_decoys, set_stage);
		output_loops.write_loops_to_file( checkpoint_loops_file );
		set_pose_flag(true);
		pose.dump_pdb( checkpoint_decoy_name );
		set_pose_flag(false);
		boinc_end_critical_section();
	}

STAGE2:
	// recover from checkpoint stage2
	if( farlx_stage == 2 ){
		output_loops.read_loops_from_file( checkpoint_loops_file );
		read_checkpoint_decoy( checkpoint_decoy_name, pose.fullatom() /*fullatom*/ );
		set_pose_flag(true);
		pose_from_misc( pose, files_paths::input_fa, ideal_pose, init_coord );
		set_pose_flag(false);
		initialize_random_numbers();
	}else if( farlx_stage > 2 ) goto STAGE3;

#endif


	if ( ( get_loop_farlx_flag() || !get_loop_rebuild() ) && !loop_modeling_fail ) {

		set_pose_flag( true );

		if( !get_loop_rebuild() ){

			std::string loops_filename;
			stringafteroption( "loopout_file", "", loops_filename);
			if ( loops_filename == "" ){
				std::cout << "No loopout_file specified! Try to find loopoutfile in start_path!"
				<< std::endl;
				loops_filename = files_paths::start_path + files_paths::start_file + ".loopout";
			}
			output_loops.clear();
			output_loops.read_loops_from_file( loops_filename );
		}

		loop_refinement( pose, output_loops );
		//loop_fa_relax( pose, ori_loops_begin, ori_loops_end );
		set_pose_flag( false );
		monte_carlo_reset();
	}

	// save loop building information
	set_pose_flag( true );
	jmp_get_chainbreaks_by_loops( pose, output_loops, loopcst::chain_breaks );
	loopcst::loops_built = output_loops;
	set_pose_flag( false );

#ifdef BOINC
	boinc_params::pct_complete += 0.001;
  boinc_fraction_done(boinc_params::pct_complete);

	// checkpoint stage2
	time(&stage3_time);
	time_diff = difftime( stage3_time, stage2_time );
	if ( time_diff > get_checkpoint_interval() && get_do_checkpointing()
			&& get_loop_farlx_flag() && farlx_stage < 3 ){
		set_stage = 3;
		boinc_begin_critical_section();
		checkpoint_decoys(attempted_decoys, num_decoys, set_stage);
		set_pose_flag(true);
		pose.dump_pdb( checkpoint_decoy_name );
		set_pose_flag(false);
		output_loops.write_loops_to_file( checkpoint_loops_file );
		boinc_end_critical_section();
	}

STAGE3:
	// recover from checkpoint stage2
	if( farlx_stage == 3 ){
		output_loops.read_loops_from_file( checkpoint_loops_file );
		read_checkpoint_decoy( checkpoint_decoy_name, true /*fullatom*/ );
		set_pose_flag(true);
		pose_from_misc( pose, true, ideal_pose, init_coord );
		set_pose_flag(false);
		initialize_random_numbers();
	}else if( farlx_stage > 3 ) goto STAGE9;

#endif

	if( !loop_modeling_fail &&
			( relax_options::farlx || relax_options::cenrlx || get_idealization() )
		) {
		if( get_pose_idlz_flag() ){ //will only idealize segment(s) specified in the loops file
			set_pose_flag( true );
			idealize_pose( pose, false );
			pose_to_misc( pose );
			set_pose_flag( false );
			monte_carlo_reset();
		} else {
		// centroid idealization
			bool const save_fullatom_flag = get_fullatom_flag();
			set_pose_flag( true );
			pose_to_misc( pose );
			set_pose_flag( false );
			monte_carlo_reset();

			set_fullatom_flag(false);
			bool const save_no_faidl = get_no_faidl();
			set_no_faidl( true );
			idealize( idealize_fail );
			set_fullatom_flag( save_fullatom_flag );
			monte_carlo_reset();
			set_no_faidl( save_no_faidl );
			if( !files_paths::idealized_structure ) idealize_fail = true;
			files_paths::input_fa = false; // idealization has removed sidechains
		}
	}else if ( get_pose_silent_out_flag() ){
		set_pose_flag( true );
		Fold_tree f;
		pose_loops_build_fold_tree(pose.total_residue(),output_loops,f);
		pose.set_fold_tree(f);
		/* rhiju's fullatom output
		silent_io::Silent_out silent_out(files_paths_pdb_out_prefix_nochain()+"_relax.out");
		if (relax_options::looprlx_nonideal_silent_output){
			pose.set_vary_bond_geometry_flag( true );
			std::string filename;
			retrieve_decoy_name(filename);
		  score_set_evaluate_all_terms(true);
		  pose.score( score12 ); // output-score
			silent_out.write(filename, pose);
		}
		*/
		//chu's fullatom output
		/*
			silent_io::Silent_out silent_out;

      pose_docking_silent_output_setup(pose,silent_out);
      pose_docking_output_silent_structure(pose,silent_out);
		*/

		pose.score( score12 ); // force energy eval before output to be sure
		silent_out_save_decoy_pose( pose );

		pose_to_misc( pose );
		set_pose_flag( false );
		score6();
		monte_carlo_reset();
	}

#ifdef BOINC
	boinc_params::pct_complete += 0.001;
  boinc_fraction_done(boinc_params::pct_complete);

	// checkpoint stage2
	time(&stage9_time);
	time_diff = difftime( stage9_time, stage3_time );
	if ( time_diff > get_checkpoint_interval() && get_do_checkpointing()
			&& ( get_idealization() || relax_options::farlx || relax_options::cenrlx )
			&& farlx_stage < 9 ){
		set_stage = 9;
		boinc_begin_critical_section();
		checkpoint_decoys(attempted_decoys, num_decoys, set_stage);
		if( get_fullatom_flag() ) dump_fullatom_pdb( checkpoint_decoy_name );
		else dump_pdb( checkpoint_decoy_name );
		boinc_end_critical_section();
	}

STAGE9:
	// recover from checkpoint stage2
	if( farlx_stage == 9 ){
		read_checkpoint_decoy( checkpoint_decoy_name, get_fullatom_flag() /*fullatom*/ );
		initialize_random_numbers();
	}
#endif


L100:
	set_pose_flag( false );
	if ( !loop_modeling_fail && !idealize_fail
		&& ( relax_options::farlx || relax_options::cenrlx || get_idealization() ) )
		files_paths::idealized_structure = true;
	else files_paths::idealized_structure = false;
	initialize_maps();

	set_barcode_status( exist_barcode );
	reset_barcode_list();

	score_set_vary_omega( exist_vary_omega );

#ifdef BOINC
#else
	// output centroid score file
	if ( relax_options::farlx && !relax_options::cenrlx )
		output_score_only();
#endif

	fillin_loop_bvalue( output_loops, 10.0 );
	fillin_loop_occupancy( output_loops );
	if ( loop_modeling_fail || idealize_fail ) return false;

	return true;

}

///////////////////////////////////////////////////////////////////////////////////
bool
build_obligate_loops(
	pose_ns::Pose & pose,
	pose_ns::Loops & output_loops,
	bool const & full_atom
)
{

	if ( !get_obligate_loop_exist() ) return true;

	// read in the loop regions
	std::vector<int> loops_begin, loops_end;
	bool build_loop_good( true );

	read_obligate_loop_file( loops_begin, loops_end );

	if ( static_cast<int>( loops_begin.size() ) > 0 ) {
		verify_loop_file( pose, loops_begin, loops_end );
		set_pose_flag( true );
		pose_to_misc( pose );
		set_barcode_status( true );
		set_loop_modeling_exist( true ); //note: assume loop modeling for obligate loops
		bool const obligate( true );
		build_loop_good = build_random_loops( pose, loops_begin, loops_end, output_loops, full_atom, obligate );
		set_loop_modeling_exist( false );
		pose_to_misc( pose );
		set_pose_flag( false );

		// finished loop_modelling
		// clear off barcode cst
		set_barcode_status( false );
		monte_carlo_reset();
	}else{
		std::cout <<
			"##########################################################" << std::endl;
		std::cout <<
			"# WARNING::No obligate loopfile defined! #"                 << std::endl;
		std::cout <<
			"##########################################################" << std::endl;
	}

	return build_loop_good;

}


////////////////////////////////////////////////////////////////////////////////
/// @begin build_random_loops
///
/// @brief randomly choosing loop stems based on loop_file, then build loops
///  from the chosen stems using make_one_loop
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
bool
build_random_loops (
	pose_ns::Pose & pose,
	std::vector<int> const & loops_begin,
	std::vector<int> const & loops_end,
	pose_ns::Loops & output_loops,
	bool const & full_atom,
	bool const & obligate
)
{

	using namespace pose_ns;
	using namespace docking;

	// link to native pose if exists

	if ( get_native_exists() )
		pose.set_native_pose();

	int const nres( pose.total_residue() );

	// save the input pose for rmsd calculations
	Pose init_pose;
	init_pose = pose;

	classical_constraints::BOUNDARY::set_max_seqSep(nres);
	set_use_nblist( false );
	// minimizer params:
	minimize_exclude_sstype( false, false );
	if( get_ccd_closure_exist() )
		monte_carlo_set_simannealing(true);
	else monte_carlo_set_simannealing(false);

	if ( get_random_frag_state() ){
		pick_random_frags( 200, 100, 75, 25 );
		// randomly pick 100 of the top 200 3mers and 25 of the top 75 9mers.
		// different choice for each trajectory to spread out sampling
	}

	if ( get_ssblock_state() ) {
		decide_block_state();
		choose_frag_set_top_N_frags( 200 );
	} else {
		choose_frag_set_top_N_frags( 200 );
	}

	pose.set_fullatom_flag( full_atom, false );

	int const num_loop = static_cast <int>( loops_begin.size() );

	std::vector< int > free_res; // stores residue numbers in real loops
	for ( int ll = 0; ll < num_loop; ++ll ){
			std::cout << "Loop res " << loops_begin.at( ll ) << " " << loops_end.at( ll ) << std::endl;
		for ( int k = loops_begin.at( ll );	k <= loops_end.at( ll ); ++k )
				free_res.push_back(k);
	}

	std::vector<int> inter_res; // residues in-between loop_file defined loops

	// now go through all the loop regions
	Pose stage_pose; // stores a pose at certain stage
	std::vector< int > folded_loops; // loops folded
	int num_desired_loops ( get_desired_loops_exist()? std::min( desired_loops(), num_loop) :num_loop );
	if ( obligate || get_loop_modeling_exist() ) num_desired_loops = num_loop; // build all obligate loops
	for ( int loop_counter = 0; loop_counter < num_desired_loops; ++loop_counter ){

		// save the original pose at this stage
		stage_pose = pose;

		// randomly select one loop from the loop regions
		inter_res.clear();
		int selected_loop, def_loop_begin, def_loop_end, combine_number;
		bool loops_combined( false );
		bool use_selected_loop =
				select_one_loop( nres, selected_loop, loops_begin, loops_end, folded_loops,
												 inter_res, def_loop_begin, def_loop_end, loops_combined,
												 combine_number, loop_counter );

		if ( ! use_selected_loop && !obligate ) continue; // skip this loop

		// params record the behaviors of individual loop modeling process
		int   nfail( 0 );
		int   n_chain_break_fail( 1 );
		bool  is_chain_break( true );
		bool  rmsd_acceptable( false );
		int   barcst_extend_begin( 0 );
		int   barcst_extend_end( 0 );
		int total_combine( 0 );
		if ( loops_combined ) total_combine = combine_number;
		int backward_combine( 0 );
		int const allowed_failure_before_extend(15);
		int const allowed_failure_before_stop( get_random_loop_exist()? 20:5);

		// select further random stems which will be constrainted by barcode cst
		if ( get_random_loop_exist() ){
			barcst_extend_begin = static_cast <int> ( ran3() * 2 );
			barcst_extend_end = static_cast <int> ( ran3() * 2 );
		}
#ifdef BOINC
		boinc_params::pct_complete += 0.0001;
		boinc_fraction_done(boinc_params::pct_complete);
#endif

		Loop loop_built;
		float loop_chain_break(0);
		// start the loop building cycle
		while ( is_chain_break || !rmsd_acceptable )
		{

			if( nfail > allowed_failure_before_stop ) break; //return false;

			nfail++;

			// refresh pose
			pose = stage_pose;
			pose_to_misc( pose ); //vats REMOVE THIS

			// combine next loop if this loop can't be closed after 20 iterations
			if ( get_random_loop_exist() && get_combine_if_fail_exist() ){
				if ( n_chain_break_fail % allowed_failure_before_extend == 0 ){
					if ( selected_loop + total_combine + 1 < num_loop ){
						def_loop_end = loops_end.at( selected_loop + total_combine + 1 );
						if( !get_loop_modeling_exist() ) folded_loops.push_back( selected_loop + total_combine + 1);
						total_combine++; // one more combined loop
					} else if ( selected_loop - backward_combine > 0 ){
						def_loop_begin   = loops_begin.at( selected_loop - backward_combine - 1 );
						if( !get_loop_modeling_exist() ) folded_loops.push_back( selected_loop - backward_combine - 1 );
						backward_combine++;
					}
					else break;// return false; // give up if no loop to combine
					if( !get_loop_modeling_exist() ) loop_counter++;
					barcst_extend_begin = static_cast <int> ( ran3() * 2 );
					barcst_extend_end = static_cast <int> ( ran3() * 2 );
				}
			}

			// further extend loop regions, and add barcode constraints on these
			// extended regions
			int loop_begin, loop_end;
			barcode_extend_stems( barcst_extend_begin, barcst_extend_end, loop_begin, loop_end,
														def_loop_begin, def_loop_end, free_res,
														nres, selected_loop, total_combine,
														backward_combine, loops_begin, loops_end );
			// alter_loop_residues with homolgous sequences
			alter_homologous_seqs( pose, loop_begin, loop_end );
			// Now really make a loop

			int cutpoint(0);

			//update occ infor
			for (int jj = loop_begin; jj <= loop_end; ++jj ){
				pose.pdb_info().set_pdb_occ( jj, 1.0 );
				}

			if( get_ccd_closure_exist() )
				build_loop_with_ccd_closure( pose, loop_begin, loop_end, cutpoint, full_atom );
			else build_loop_with_ccd_move( pose, loop_begin, loop_end, cutpoint, full_atom );
			loop_built.set_start( loop_begin );
			loop_built.set_stop ( loop_end );
			loop_built.set_cut( cutpoint );

			// extend more barcode regions
			extend_barcode_regions_if_chain_break( pose, loop_begin, loop_end,
						n_chain_break_fail, is_chain_break, barcst_extend_begin, barcst_extend_end );

			restore_seq( pose, stage_pose, loop_begin, loop_end );
			if ( loop_begin != 1 && loop_end != nres )
				loop_chain_break = pose.get_0D_score( pose_ns::CHAINBREAK );
			if( docking::docking_pose_symm_looprlx ) {
				pose.update_backbone_bonds_and_torsions();
				pose_ns::Pose test_pose;
				create_monomer_pose( pose, test_pose, nres );
				pose = test_pose;
			}

			rmsd_acceptable = acceptable_rmsd_change( stage_pose, pose );
			std::cout << "rmsd_acceptable " << rmsd_acceptable << std::endl;

		}
		// accepted this loop


		loopcst::total_chain_break_score += loop_chain_break;

		pose.update_backbone_bonds_and_torsions();

		if ( !docking::docking_pose_symm_looprlx ) {
			pose.simple_fold_tree( nres );
		}
		output_loops.add_overlap_loop( loop_built );

		show_decoy_status(pose);

	}// all loops folded

	for ( int i = 0 ; i < static_cast<int>(folded_loops.size()); ++i )
		std::cout << "folded loops: " << folded_loops.at(i) << std::endl;


	if ( !acceptable_overall_rmsd_change( init_pose, pose ) ) {
		pose = init_pose;
		return false;
	}

	return true;

}

////////////////////////////////////////////////////////////////////////////////
bool
acceptable_overall_rmsd_change(
	pose_ns::Pose const & init_pose,
	pose_ns::Pose const & pose
)
{

	if ( get_loop_modeling_exist() ) return true; // always acceptable if loop_model

	// params control the behaviors of all loop modeling processes
	float const rmsd_tol( get_rmsd_tolerance() );
	float const overall_rmsd( CA_rmsd( pose, init_pose ) );

	if( overall_rmsd > rmsd_tol ){
		std::cout << "###############################################" << std::endl;
		std::cout << "# WARNINNG: pose changed too much!            #" << std::endl;
		std::cout << "# over rmsd = " << overall_rmsd                  << std::endl;
		std::cout << "# will remodel loops                          #" << std::endl;
		std::cout << "###############################################" << std::endl;
		return false;
	}else
		return true;

}

////////////////////////////////////////////////////////////////////////////////
bool
acceptable_rmsd_change(
	pose_ns::Pose const & stage_pose,
	pose_ns::Pose const & pose
)
{

	if ( get_loop_modeling_exist() ) return true; // always acceptable if loop_model

	// params control the behaviors of all loop modeling processes
	float const rmsd_tol( get_rmsd_tolerance() );
	float const stage_rmsd( CA_rmsd( pose, stage_pose ) );
	std::cout << "tol: " << rmsd_tol << " stage_rms: " << stage_rmsd << std::endl;

	return ( ran3() > stage_rmsd/ rmsd_tol );

}

//////////////////////////////////////////////////////////////////////////////
void
extend_barcode_regions_if_chain_break(
	pose_ns::Pose const & pose,
	int const & loop_begin,
	int const & loop_end,
	int & n_chain_break_fail,
	bool & is_chain_break,
	int & barcst_extend_begin, // output
	int & barcst_extend_end
)
{

	static int n_small_chain_break_fail = { 1 };
	static bool barcst_flip_flop = { true };
	static bool barcst_small_flip_flop = { true };
	is_chain_break = false;

	// params control the behaviors of all loop modeling processes
	float const chain_break_tol( get_chain_break_tolerance() );
	float chain_break_score;

	int const nres = pose.total_residue();


	if ( loop_begin != 1 && loop_end != nres )
		chain_break_score = pose.get_0D_score( pose_ns::CHAINBREAK );
	else chain_break_score = 0;

	std::cout << "loop_begin and loop_end  " << loop_begin << " " << loop_end << " " << chain_break_score << std::endl;

	// extend more barcode regions
	if ( chain_break_score > chain_break_tol ){
		is_chain_break = true;
		n_chain_break_fail++;
		if( chain_break_score <= 10* chain_break_tol ) n_small_chain_break_fail++;
		if ( get_random_loop_exist() ){
			if ( chain_break_score > 10* chain_break_tol ) {
				if( barcst_flip_flop ){
//					if (loop_begin != 1 && loop_end != nres &&
//							pose.secstruct( loop_begin - 1) != 'H' &&
//							pose.secstruct( loop_begin - 1) != 'E' )
					barcst_extend_begin++;
					barcst_flip_flop = false;
				}else{
					barcst_extend_end++;
					barcst_flip_flop = true;
				}
			}
			else if ( n_small_chain_break_fail % 3 == 0 ) {
				if( barcst_small_flip_flop ){
					barcst_extend_begin++;
					barcst_small_flip_flop = false;
				}else{
					barcst_extend_end++;
					barcst_small_flip_flop = true;
				}
			}
		}
	}

}

////////////////////////////////////////////////////////////////////////////////
void
barcode_extend_stems(
	int & barcst_extend_begin,
	int & barcst_extend_end,
	int & loop_begin,
	int & loop_end,
	int const & old_loop_begin,
	int const & old_loop_end,
	std::vector<int> const & free_res,
	int const & nres,
	int const & selected_loop,
	int const & total_combine,
	int const & backward_combine,
	std::vector<int> const & loops_begin,
	std::vector<int> const & loops_end
)
{

	int const num_loop( static_cast<int>( loops_begin.size() ) );
	// further extend loop regions, and add barcode constraints on these
	// extended regions
	int barcst_begin ( old_loop_begin );
	int barcst_end   ( old_loop_end   );
	barcst_extend_begin = std::min( 5, barcst_extend_begin );// extend 5 res at most
	barcst_extend_end = std::min( 5, barcst_extend_end );// extend 5 res at most
	loop_update_active_cst_list ( barcst_begin, barcst_end, free_res,
																		barcst_extend_begin, barcst_extend_end );
	barcst_begin -= barcst_extend_begin;
	barcst_end   += barcst_extend_end;
	while ( barcst_begin < 1    ) barcst_begin++;
	while ( barcst_end   > nres ) barcst_end--;

	// make sure not to extend the stems to loop regions
	if ( selected_loop - backward_combine > 0 )
		while ( barcst_begin <= loops_end.at( selected_loop - backward_combine - 1 ) + 1 )
			barcst_begin++;
	if ( selected_loop + total_combine != num_loop-1 )
		while ( barcst_end >= loops_begin.at(selected_loop+total_combine+1) - 1 )
			barcst_end--;

	// shorten loops when do looprlx ( loop_modeling)
	if( !get_loop_modeling_exist() && shorten_long_terminal_loop() ){
		if( barcst_end == nres && barcst_end - barcst_begin > 10 )
			barcst_begin = barcst_end - 10;
		if( barcst_begin == 1 && barcst_end - barcst_begin > 10 )
			barcst_end = barcst_begin + 10;
	}

	// make sure loop length is greater than 3
	if ( barcst_end - barcst_begin < 2 && barcst_begin != 1 && barcst_end != nres ){
		barcst_begin -= 1;
		barcst_end   += 1;
	}
	//vats hack REMOVE THIS
 	loop_begin = barcst_begin;
	loop_end   = barcst_end;
	//	loop_begin = loops_begin.at( 0 );
	//	loop_end = loops_end.at( 0 );

	// show the loop sequence for sanity-checking
	std::cout << " loop_begin: " << loop_begin <<
							 " loop_end:   " << loop_end   <<
							 " loop_sequence: ";
	for ( int i=loop_begin; i<= loop_end; ++i )
		std::cout << misc::residue1(i);
	std::cout << std::endl;

}

////////////////////////////////////////////////////////////////////////////////
void
set_looprlx_allow_move_map(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end
)
{
	int const nres( pose.total_residue() );
	for ( int i = 1; i <= nres; ++i ) {
		if ( i >= loop_begin && i <= loop_end
		// the following condition can be used if want to keep the inter_res
		// region fixed duing loop building. Temperarily commented out
//		&& std::find( inter_res.begin(), inter_res.end(), i ) == inter_res.end()
		)
			pose.set_allow_bb_move( i, true );
		else pose.set_allow_bb_move( i, false );
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin select_one_loop
///
/// @brief: select a loop from loop_begins and loop_ends
///
/// @detailed: randomly choose a loop region from loop_files, then decide if we
///  want to skip this loop or not. If decided not to skip, then decide if we
///  want to combine this loop with another loop. This is followed by extending
///  the loop stems into non-loop regions up to 3 residues. retuen the loop
///  starting and ending points.
///
/// @param  inter_res - [out]? - stores residue numbers inbetween real loops
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
bool select_one_loop(
	int nres,
	int & selected_loop,
	std::vector<int> const & loops_begin,
	std::vector<int> const & loops_end,
	std::vector<int> & folded_loops,
	std::vector<int> & inter_res,
	int & loop_begin,
	int & loop_end,
	bool & are_loops_combined,
	int & combine_interval,
	int & loop_counter
)
{

	int const num_loops = static_cast <int> (loops_begin.size());

	// make how many loop combination(s) per structure on average
	float const loop_combine_rate( get_loop_combine_rate() );
	float const num_of_loops_to_combine( ran3() * (num_loops-1) * loop_combine_rate );

	do selected_loop = static_cast <int> (ran3() * num_loops );
	while( std::find( folded_loops.begin(), folded_loops.end(), selected_loop ) !=
				folded_loops.end() );
	folded_loops.push_back(selected_loop);

	loop_begin = loops_begin.at( selected_loop );
	loop_end = loops_end.at( selected_loop );
	combine_interval = 0;

	if ( !get_random_loop_exist() ) return true;

	if ( ran3() < get_skip_loop_rate() )
		return false; // skip this loop

	combine_interval = 1;
	// combine consecutive loop regions
	if ( selected_loop < num_loops - combine_interval && num_of_loops_to_combine > 0 ) {
		int const longer_loop_size ( loops_end.at( selected_loop + combine_interval ) -
																	 loops_begin.at( selected_loop ) );
		int loop_limit;
		int const terminal_loop(12);
		int const internal_loop(50);	// bkidd, modified for testing rigid body motion
		if( loops_end.at( selected_loop + combine_interval ) == nres ||
				loops_begin.at( selected_loop ) == 1 )
					loop_limit = terminal_loop;
		else  loop_limit = internal_loop;
		// don't merge internal loops longer than 50,
		// or terminal loops longer than 12

		if ( ran3() < num_of_loops_to_combine/(num_loops-1+1e-10 ) &&
				 longer_loop_size <= loop_limit ) {

			loop_begin = loops_begin.at( selected_loop );
			loop_end   = loops_end.at( selected_loop + combine_interval );

			for ( int ll = 0; ll < combine_interval; ++ll ){
				for ( int k = loops_end.at( selected_loop + ll );
							k <= loops_begin.at( selected_loop + ll + 1 ); ++k )
					inter_res.push_back(k);
				if( !get_loop_modeling_exist() ) {
					folded_loops.push_back(selected_loop+ll+1);
					loop_counter++;
				}
			}
			are_loops_combined = true;
		}
	}

	// choose random taking off points
	int const old_loop_begin( loop_begin );
	int const old_loop_end  ( loop_end   );

	int rand_extension = 1;
	int rand_limit = 3;
	if ( get_loop_modeling_exist() ){
		rand_extension = 0;
		rand_limit = 2;
	}

	do {
		if ( loop_begin != 1 )
			loop_begin = old_loop_begin - static_cast <int> (ran3() * rand_limit )
									+ rand_extension;
		if ( loop_end != nres )
			loop_end = old_loop_end + static_cast <int> (ran3() * rand_limit )
								- rand_extension;
	} while ( loop_end - loop_begin < 0	|| loop_begin < 1
						|| loop_end > nres );

	return true;

	/* the following code can make a fold tree for two loops
	{
	// fold_tree for two loops:
		Fold_tree f;
		f.add_edge(1,loop1_begin-1,-1);

		f.add_edge(loop1_begin-1,cutpoint1,-1);
		f.add_edge(cutpoint1+1,loop1_end+1,-1);
		f.add_edge(loop1_begin-1,loop1_end+1,1); // jump1

		f.add_edge(loop1_end+1,loop2_begin-1,-1)

		f.add_edge(loop2_begin-1,cutpoint2,-1);
		f.add_edge(cutpoint2+1,loop2_end+1,-1);
		f.add_edge(loop2_begin-1,loop2_end+1,2); // jump2

		f.add_edge(loop2_end+1,nres,-1);
		f.reorder(1);

		pose->set_fold_tree(f);
		pose->jumps_from_position();
		pose->set_allow_jump_move( false );

		insert_random_frags( 3, pose, loop1_begin, loop1_end, 0 );
		insert_random_frags( 3, pose, loop2_begin, loop2_end, 0 );
		pose->refold();
		pose->score( weight_map );
	}
	*/

}

////////////////////////////////////////////////////////////////////////////////
/// @begin choose_cutpoint
///
/// @brief: randomly choose a cutpoint in the loop region
///
/// @detailed
///
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
int choose_cutpoint
(
	pose_ns::Pose const & pose,
	int loop_begin,
	int loop_end
)
{

	int const loop_size  ( loop_end - loop_begin + 1 );
	int const nres( pose.total_residue() );

	// set up a weight-map for picking cutpoints, we want the cut to be internal to
	// the loop, so that the splice-rmsds are calculated between idealized atoms
	// so also only use chainbreak_overlap = 1
	int const      n_cutpoints ( loop_size - 1 );
	FArray1D_float cut_weight( n_cutpoints );
	float          total_cut_weight( 0 );
	for ( int i = 1; i <= n_cutpoints; ++i ) {
		// eg: for a 7 rsd loop: 1 2 3 4 3 2 1
		float const weight ( std::max( i, n_cutpoints-i + 1 ) );
		total_cut_weight += weight;
		cut_weight(i) = total_cut_weight;
	}
	// choose the cutpoint:
	int cutpoint(0);

	if ( loop_begin > 1 && loop_end < nres ){
		char ss;
		int nfail( 0 );
		do {
			nfail++;
			float const weight ( total_cut_weight * ran3() );
			for ( int i = 1; i <= n_cutpoints; ++i ) {
				if ( weight <= cut_weight(i) ) {
					cutpoint = loop_begin + i - 1;
					break;
				}
			}
			ss = pose.secstruct( cutpoint );
		}
		// no cut point in the secondary structures
		while ( ( ss == 'H' || ss == 'E' ) && nfail < 20 );

		if ( cutpoint == 0 ) {
			cutpoint = ( loop_begin + n_cutpoints/2 );
			std::cout << "cutpoint choice problem; setting = "
								<< cutpoint << std::endl;
		}
		assert ( cutpoint >= loop_begin && cutpoint < loop_end );
	} else if( loop_begin == 1 ) {
		cutpoint = 1;
	}else if ( loop_end == nres ){
		cutpoint = nres;
	}

	return cutpoint;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin build_loop_with_ccd_closure
///
/// @brief ab-initio model of a loop using the pose mode, where we can grow
///  from both end of the loops and try to close at the cutpoint.
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void
build_loop_with_ccd_closure
(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end,
	int & cutpoint,
	bool const & full_atom
)
{

	using namespace pose_ns;

	int const nres( pose.total_residue() );

	set_looprlx_allow_move_map( pose, loop_begin, loop_end );

	if ( cutpoint == 0 ) //vats if cutpoint not provided then choose one
		cutpoint = choose_cutpoint( pose, loop_begin, loop_end );
	std::cout << "cutpoint: " << cutpoint << std::endl;

	int const loop_size( loop_end - loop_begin + 1 );
	int const cycles2( get_loop_modeling_exist() ? 3:2 );
//	int const cycles3( get_loop_modeling_exist() ? 10*loop_size:5*loop_size);
	float const cycle_ratio( std::max( 0.5f, get_looprlx_cycle_ratio() ) );
	int const base_cycles( std::max( 15, static_cast<int>( 5*loop_size*cycle_ratio )));
	int const cycles3( get_loop_modeling_exist() ? 2*base_cycles:base_cycles );

	FArray1D_bool allow_repack( nres, false );
	for ( int i = loop_begin; i <= loop_end; ++i )
		allow_repack( i ) = true;
	// repack loop residues

	// make fold trees for loops

	if ( pose.num_jump() <= 1 ) { //vats keep input fold tree if pose has multiple jumps
		if ( loop_begin == 1 || loop_end == nres )
			pose.simple_fold_tree( nres );
		else{
			pose.one_jump_tree( nres, loop_begin-1, loop_end+1, cutpoint );
			pose.set_allow_jump_move( false );
		}
	}

	int idl_begin( loop_begin ), idl_end( loop_end );
	pose.insert_ideal_bonds( idl_begin, idl_end );

	Score_weight_map weight_map;
	if( full_atom ){
		weight_map.set_weights( score12 );
	}	else { // centroid weights
		setup_score_weight_map( weight_map, score4L );
		if( get_use_sspair_during_looprlx()) weight_map.set_weight( SSPAIR, 1.0 );
		if( get_use_rsigma_during_looprlx()) weight_map.set_weight( RSIGMA, 1.0 );
//		weight_map.set_weights( score4L );
//		weight_map.set_weight( ENV, 1.0 );
//		weight_map.set_weight( PAIR, 1.0 );
//		weight_map.set_weight( VDW, 1.0 );
//		weight_map.set_weight( CB, 1.0 );
	//optionally you can use the following energy terms (much slower though)
		//if( get_loop_modeling_exist() ){
		//	weight_map.set_weight( SSPAIR, 1.0 );
		//	weight_map.set_weight( HB_LRBB, 1.0 );
		//	weight_map.set_weight( HB_SRBB, 0.5 );
		//}
	}

	// loop mode specific weights
	weight_map.set_weight( BARCODE, 1.0 );
	weight_map.set_weight( CHAINBREAK, 1.0 );
	weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );
	weight_map.set_weight( CST_SCORE, 1.0 );

	score_set_cst_mode(3);

	// perturb the initial loop conformation
	int begin;
	if ( get_loop_modeling_exist() ){
		insert_random_frags( 3, pose, loop_begin, loop_end, 0 );
		// size=3, frag_offset=0
	}else{
		for ( int i = 0; i < loop_size; ++i ){
			if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
				one_loop_choose_fragment_cst_pose( pose, 1.5, 1, begin, cutpoint );
			else
				one_loop_choose_fragment_coord_pose( pose, 1.2, 1, begin, cutpoint );
		}
	}

	if( full_atom )	pose.repack( allow_repack, false );

	// setup monte_carlo object
	pose.score( weight_map );
	show_decoy_status( pose );
	float const init_temp( 2.0 ), final_temp( 1.0 );
	float const gamma =
		std::pow( (final_temp/init_temp), (1.0f/(cycles2*cycles3)) );
	Monte_carlo mc( pose, weight_map, init_temp );

	bool do_ccd_moves( false );
	if( loop_begin != 1 && loop_end != nres ) do_ccd_moves = true;

	int const cutoff9 = get_use_9mer_frag_cutoff();
	int const cutoff3 = { 6 };
	int const cutoff1 = { 3 };

	float temperature = init_temp;
	for( int c2 = 1; c2 <= cycles2; ++c2 ) {
		pose = mc.low_pose();

		pose.score( weight_map );
		show_decoy_status( pose );
		append_trajectory( pose.get_0D_score(SCORE), pose.get_0D_score(RMSD) );

		for( int c3 = 1, size, begin; c3 <= cycles3; ++c3 ) {
			temperature *= gamma;
			mc.set_temperature( temperature );

			if( loop_size > cutoff9 ){
				size = 9;
				if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
					one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
				else
					one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
				if( do_ccd_moves ) looprlx_fast_ccd_close_loops( pose, loop_begin, loop_end, cutpoint );
				if( full_atom ) pose.repack( allow_repack, true );
				pose.main_minimize( weight_map, "linmin" );
				mc.boltzmann( pose );
			}
			if( loop_size > cutoff3 ){
				size = 3;
				if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
					one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
				else
					one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
				if( do_ccd_moves ) looprlx_fast_ccd_close_loops( pose, loop_begin, loop_end, cutpoint );
				if( full_atom ) pose.repack( allow_repack, true );
				pose.main_minimize( weight_map, "linmin" );
				mc.boltzmann( pose );
			}
			if( loop_size > cutoff1 ){
				size = 1;
				if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
					one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
				else
					one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
				if( do_ccd_moves ) looprlx_fast_ccd_close_loops( pose, loop_begin, loop_end, cutpoint );

				if( full_atom ) pose.repack( allow_repack, true );
				pose.main_minimize( weight_map, "linmin" );
				mc.boltzmann( pose );
			}
		}

	}
	pose = mc.low_pose();

}

////////////////////////////////////////////////////////////////////////////////
/// @begin build_loop_with_ccd_move
///
/// @brief ab-initio model of a loop using the pose mode, where we can grow
///  from both end of the loops and try to close at the cutpoint.
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void build_loop_with_ccd_move
(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end,
	int & cutpoint,
	bool const & full_atom
)
{

	using namespace pose_ns;
	using namespace docking;

	cutpoint = choose_cutpoint( pose, loop_begin, loop_end );
	std::cout << "cutpoint: " << cutpoint << std::endl;

	pose_ns::Pose save_pose,new_pose;
	if( docking::docking_pose_symm_looprlx ) {
		save_pose = pose;
		pose_ns::Loops one_loop;
		one_loop.add_loop( loop_begin, loop_end, cutpoint, 0 , false );
		initialize_looprlx_symm_pose( save_pose, full_atom, one_loop, new_pose );
		pose = new_pose;
		pose_loops_set_allow_bb_move( pose, one_loop );
	} else {
		//		new_pose = pose;
		set_looprlx_allow_move_map( pose, loop_begin, loop_end );
		if ( loop_begin == 1 || loop_end == pose.total_residue() ) {
			pose.simple_fold_tree( pose.total_residue() );
		} else {
			pose.one_jump_tree( pose.total_residue(), loop_begin-1, loop_end+1, cutpoint );
			pose.set_allow_jump_move( false );
		}
	}

	int const nres( pose.total_residue() );
	int const loop_size( loop_end - loop_begin + 1 );
	int const cycles2( 10 );
//	int const cycles3( 10* loop_size );
	float const cycle_ratio( std::max( 0.5f, get_looprlx_cycle_ratio() ) );
	int const cycles3( std::max( 30, static_cast<int>( 10*loop_size*cycle_ratio)));

	FArray1D_bool allow_repack( nres, false );
  std::cout << "Inside ccd_move " << loop_begin << " " << loop_end << " " << nres << std::endl;

 	for ( int i = loop_begin; i <= loop_end; ++i )
		allow_repack( i ) = true;

	// repack loop residues

	pose.insert_ideal_bonds( loop_begin, loop_end );

	Score_weight_map weight_map;
	if( full_atom ){
		weight_map.set_weights( score12 );
//		initialize_fullatom();
//		set_rot_limit( 45, 27 );
//	  design::active_rotamer_options.set_ex12( true, false );
	}	else { // centroid weights
	// setup the scoring function
		weight_map.set_weight( ENV, 1.0 );
		weight_map.set_weight( PAIR, 1.0 );
		weight_map.set_weight( VDW, 1.0 );
		weight_map.set_weight( CB, 1.0 );
	//optionally you can use the following to make better loops
		if( get_use_rg_during_looprlx() ) weight_map.set_weight( RG, 1.0 );
	//psh if building sheet or hairpin, strand pairing based on ss and rsigma can be turned on
		if( get_use_sspair_during_looprlx()) weight_map.set_weight( SSPAIR, 1.0 );
		if( get_use_rsigma_during_looprlx()) weight_map.set_weight( RSIGMA, 1.0 );
//	weight_map.set_weight( SSPAIR, 1.0 );
		if( get_use_hb_during_looprlx() ){
			weight_map.set_weight( HB_LRBB, 1.0 );
			weight_map.set_weight( HB_SRBB, 0.5 );
		}
	}

	if( docking::docking_pose_symm_looprlx ){
	Fold_tree f1( pose.fold_tree() );
	FArray1D_float cut_weight( f1.get_num_fold_tree_cutpoint(), 0.0f );
  const FArray1D_int & cutpoint_map( f1.get_cutpoint_map() );
  weight_map.set_1D_weight( CUT_WEIGHT, cut_weight );

	cut_weight( cutpoint_map( cutpoint ) ) = 1.0;
	weight_map.set_1D_weight( CUT_WEIGHT, cut_weight );
	}

	// loop mode specific weights
	weight_map.set_weight( BARCODE, 1.0 );
	weight_map.set_weight( CHAINBREAK, 0.0 );
	weight_map.set_weight( CHAINBREAK_OVERLAP, 0.0 );
	//vats HACK, not quite set this back to 0.0
	//	weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );

	weight_map.set_weight( CST_SCORE, 1.0 );

	score_set_cst_mode(3);

	// perturb the initial loop conformation
	int begin;
	if ( get_loop_modeling_exist() ){
		insert_random_frags( 3, pose, loop_begin, loop_end, 0 );
		// size=3, frag_offset=0
	}else{
		for ( int i = 0; i < loop_size; ++i ){
			if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
				one_loop_choose_fragment_cst_pose( pose, 1.5, 1, begin, cutpoint );
			else
				one_loop_choose_fragment_coord_pose( pose, 1.2, 1, begin, cutpoint );
		}
	}
	if( full_atom ) pose.repack( allow_repack, false );

	// setup monte_carlo object
	pose.score( weight_map );
	Monte_carlo mc( pose, weight_map, 2 );

	//vats hack REMOVE THIS
	//   mc.set_temperature( 1000 );
	std::cout << "starting loop pose" << std::endl;
	show_decoy_status( pose );

	float final_weight;
	int overlap( 0 );
	if( full_atom ) final_weight = 10.0; // need to increase chainbreak_weight in fullatom
	else final_weight = 5.0;
	float const delta_weight ( final_weight / cycles2 );
	bool do_ccd_moves( false );
	if ( loop_begin != 1 && loop_end != nres )
		do_ccd_moves = true;

	for ( int c2 = 1 ; c2 <= cycles2; ++c2 ) {
		// statistics
		int frag_accepts( 0 ),
				frag_trials ( 0 ),
				ccd_accepts ( 0 ),
				ccd_trials  ( 0 );

		int const cutoff9 = get_use_9mer_frag_cutoff();
		int const cutoff3 = { 6 };
		int const cutoff1 = { 3 };

		pose = mc.low_pose();
		if ( loop_begin != 1 && loop_end != nres ){
			weight_map.set_weight( CHAINBREAK, c2 * delta_weight );
			if ( c2 > cycles2/2 ) overlap = 1; // total conjecture
			weight_map.set_weight( CHAINBREAK_OVERLAP, overlap );
		}

		pose.score( weight_map );
		mc.set_weight_map( weight_map );
		mc.reset( pose );
		show_decoy_status( pose );
		append_trajectory( pose.get_0D_score(SCORE), pose.get_0D_score(RMSD) );

		for ( int c3 = 1, size, begin; c3 <= cycles3; ++c3 ) {
			if ( !do_ccd_moves ||
						overlap == 0 ||
						ran3() * cycles2 > c2 )
			{
				if( loop_size > cutoff9 ){
					size = 9;
					if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
						one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
					else
						one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
					if( full_atom ) pose.repack( allow_repack, true );
					mc.set_weight_map( weight_map );
					bool const accepted ( mc.boltzmann( pose ) );
					if ( accepted )	++frag_accepts;
					++frag_trials;
				}
				if( loop_size > cutoff3 ){
					size = 3;
					if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
						one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
					else
						one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
					if( full_atom ) pose.repack( allow_repack, true );
					mc.set_weight_map( weight_map );
					bool const accepted ( mc.boltzmann( pose ) );
					if ( accepted )	++frag_accepts;
					++frag_trials;
				}
				if( loop_size > cutoff1 ){
					size = 1;
					if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
						one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
					else
						one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
					if( full_atom ) pose.repack( allow_repack, true );
					mc.set_weight_map( weight_map );
					bool const accepted ( mc.boltzmann( pose ) );
					if ( accepted )	++frag_accepts;
					++frag_trials;
				}
			} else {
				pose_to_misc( pose );
				ccd_moves( 5, pose, loop_begin, loop_end, cutpoint );
				if ( full_atom ) pose.repack( allow_repack, true );
				mc.set_weight_map( weight_map );
				bool const accepted ( mc.boltzmann( pose ) );
				if ( accepted )	++ccd_accepts;
				++ccd_trials;
			}

		}

		if ( ccd_trials == 0 ) ++ccd_trials;
		if ( frag_trials == 0 ) ++frag_trials;
		std::cout     << "accepts: frag,ccd " << c2  << ' ' <<
			frag_trials << ' ' << ccd_trials    << ' ' <<
			float( 100.0*frag_accepts ) /frag_trials   << ' ' <<
			float( 100.0*ccd_accepts  ) /ccd_trials    << std::endl;
	}

	// recover low, rescore with overlap = 1 for compatibility with ccd closure
	if ( loop_begin != 1 && loop_end != nres )
	weight_map.set_weight(CHAINBREAK_OVERLAP, 1.0 );

	pose = mc.low_pose();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin insert_one_random_frags
///
/// @brief insert a fragment at random
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void
insert_one_random_frags(
	const int frag_size,
	pose_ns::Pose & pose,
	const int loop_begin,
	const int loop_end,
	const int frag_offset
)
{
	choose_offset_frag( frag_size, pose, loop_begin, loop_end, frag_offset );
}

////////////////////////////////////////////////////////////////////////////////
/// @begin read_loop_file
///
/// @brief read in the loop file defined as -loop_file in command line
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
bool
read_loop_file(
	std::vector<int> & loop_begin,
	std::vector<int> & loop_end
)
{

	std::string filename;
	stringafteroption( "loop_file", "", filename);
	if ( filename == "" ){
		std::cout << "No loop_file specified! Try to find loopfile in start_path!"
		<< std::endl;
		filename = files_paths::start_path + files_paths::start_file + ".loopfile";
	}
	utility::io::izstream data( filename.c_str() );
	if ( !data ) {
		std::cout << "Couldn't open loop file " << filename << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	std::string line;
	while ( getline( data, line ) ) {
		std::istringstream line_stream( line );
		int begin,end;
		line_stream >> begin >> end;
		if ( !line_stream.fail() ) {
			loop_begin.push_back ( begin );
			loop_end.push_back ( end );
			std::cout << "loop: " << ' ' << begin << ' ' << end << std::endl;
		}
	}
	data.close();

	if ( static_cast< int >( loop_begin.size() ) <= 0 ) {
		std::cout <<
			"##########################################################" << std::endl;
		std::cout <<
			"# WARNING::Calling loop_relax without defining loopfile! #" << std::endl;
		std::cout <<
			"##########################################################" << std::endl;

		return false;
	}

	std::sort( loop_begin.begin(), loop_begin.end() );
	std::sort( loop_end.begin(), loop_end.end() );

	return true;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin read_obligate_loop_file
///
/// @brief read in the obligate_loop files
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void
read_obligate_loop_file(
	std::vector<int> & loop_begin,
	std::vector<int> & loop_end
)
{

	std::string filename;
	filename = files_paths::start_path + files_paths::start_file + ".obligate_loopfile";
	utility::io::izstream data( filename.c_str() );
	if ( !data ) {
		std::cout << "Couldn't open loop file " << filename << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	std::string line;
	while ( getline( data, line ) ) {
		std::istringstream line_stream( line );
		int begin,end;
		line_stream >> begin >> end;
		if ( !line_stream.fail() ) {
			loop_begin.push_back ( begin );
			loop_end.push_back ( end );
			std::cout << "loop: " << ' ' << begin << ' ' << end << std::endl;
		}
	}
	data.close();
}
////////////////////////////////////////////////////////////////////////////////
/// @begin verify_loop_file
///
/// @brief make sure there is nothing funny about the loop definitions
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 03/24/2006
/////////////////////////////////////////////////////////////////////////////////
void
verify_loop_file(
	pose_ns::Pose const & pose,
	std::vector<int> const & loop_begin,
	std::vector<int> const & loop_end
)
{

	int nres = pose.total_residue();

	for ( int i = 0; i < int( loop_begin.size() ); ++i ){
		if ( loop_begin[i] < 1 || loop_end[i] > nres ){
			std::cout << "ERROR:: Loop definition out of boundary! " << std::endl;
			std::cout << loop_begin[i] << " " << loop_end[i] << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
	}

}
////////////////////////////////////////////////////////////////////////////////
/// @begin get_rmsd_tolerance
///
/// @brief get the rmsd tolerance to deviate from the original pose
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
float
get_rmsd_tolerance()
{
	static float rmsd_tol = { 10000.0 };
	static bool init = { false };

	if ( !init ) {
		realafteroption( "rmsd_tol", 10000.0, rmsd_tol);
		if( rmsd_tol <= 0 ) rmsd_tol = 10000.0;
		init = true;
	}
	return rmsd_tol;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_loop_combine_rate
///
/// @brief the rate for combining the loops
///
/// @detailed default is no loop recombine
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
float
get_loop_combine_rate()
{

	using namespace loopcst;

	static bool init = { false };

	if ( !init ) {
		realafteroption( "loop_combine_rate", 0.0, loop_combine_rate);
		init = true;
	}
	return loop_combine_rate;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_loop_combine_rate
///
/// @brief the rate for combining the loops
///
/// @detailed default is no loop recombine
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void
set_loop_combine_rate(
	float const & rate
)
{

	using namespace loopcst;

	loop_combine_rate = rate;

}
////////////////////////////////////////////////////////////////////////////////
/// @begin get_chain_break_tolerance()
///
/// @brief
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
float
get_chain_break_tolerance()
{
	static float chain_break_tol = { 0.2 };
	static bool init = { false };

	if ( !init ) {
		realafteroption( "chain_break_tol", 0.2, chain_break_tol);
		init = true;
	}
	return chain_break_tol;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_random_loop_exist
///
/// @brief decide if we want to deviate from the loop_file
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
bool
get_random_loop_exist()
{
	static bool random_loop_exist = { false };
	static bool init = { false };

	if ( !init ) {
		random_loop_exist = truefalseoption("random_loop");
		init = true;
	}
	return random_loop_exist;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_idealization
///
/// @brief whether or not to idealize after loop building. Idealization will
/// ensure the following relax runs to be safe when refold is needed
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
bool
get_idealization()
{
	static bool idealize = { false };
	static bool init = { false };

	if ( !init ) {
		idealize = truefalseoption("looprlx_idealization");
		init = true;
	}
	return idealize;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin show_decoy_status
///
/// @brief show scores of the current pose
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void
show_decoy_status(
	pose_ns::Pose & pose
)
{

	calc_rms( pose );
#ifdef BOINC
#else
	pose.show_scores( std::cout );
	std::cout << std::endl;
#endif
}

////////////////////////////////////////////////////////////////////////////////
/// @begin show_decoy_status
///
/// @brief show scores of the current pose
///
/// @detailed
/// 	overloaded from above to also output to a status file with the move type
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors Monica Berrondo
///
/// @last_modified April 25 2006
/////////////////////////////////////////////////////////////////////////////////
void
show_decoy_status(
	pose_ns::Pose & pose,
	std::string move_type
)
{

	if ( runlevel_ns::runlevel >= runlevel_ns::verbose ) {
		calc_rms( pose );
		pose.show_scores( std::cout );
		std::cout << std::endl;
	}
	if ( files_paths::use_decoy_status ) {
		calc_rms( pose );
		std::ofstream outfile ("decoy.status", std::ios::out|std::ios::app);
		pose.show_scores( outfile );
		outfile << move_type << std::endl;
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin choose_loop_fragment_cst_pose
///
/// @brief choose a loop fragment based on the satisfation of distance constraints
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void
one_loop_choose_fragment_cst_pose(
	pose_ns::Pose & pose,
	float tolerance,
	int size,
	int & frag_begin,
	const int cutpoint
)
{
	using namespace fragments::chuck;
	using namespace fragments::frag_pointer;
	using namespace fragments;
	using namespace misc;
	using namespace param;
	using namespace classical_constraints::BOUNDARY;

//local
	int size_bin;
	int ncst;
	FArray1D_int cst_list( classical_constraints::constants::MAX_CONSTRAINTS );
	int top_N_frags;
	float dist2;
	float cst_score, check_score;
	int jnn_num,final_nn_num,max_nn_num, nn_num; // ptrs into frag list

	FArray2D_float R( 3, 3 );
	FArray1D_float L( 3 );

	size_bin = get_index_by_frag_size(size);
	precompute_frag_movement(size,size_bin,total_residue); // make sure it's initialized

	// retrieve the insert map, total_insert, insert_size from pose
	int total_insert;
	const FArray1D_int & insert_map
		( pose.get_insert_map( total_insert ) );
	const FArray1D_int & insert_size
		( pose.get_insert_size() );

	if ( total_insert <= 0 ) {
		// debug:
		std::cout << "choose_fragment_pose:: total_insert <= 0 "
							<< total_insert << std::endl;
		frag_begin = 0;
		size = 0;
		return;
	}

	// store input value
//	const int init_size  ( size < total_insert ? size : total_insert );
	int init_size = size;

//	int map_site = static_cast< int >( ran3() * ( total_insert - init_size + 1) ) + 1;
	int map_site = static_cast< int > (ran3() * total_insert) + 1; //directly insert anywhere and not worry about frag size

	int start_map_site = map_site;
	int counter = 0;
	int counter2 = 0;

L300:

	size = init_size; // in jumping_mode, size may change, so reset it

	frag_begin = insert_map(map_site);

	// trim back as necessary: insert_size stores the length of the longest
	// allowed insert that begins at begin
	size = std::min( insert_size( frag_begin ), size);
	assert ( size > 0 ); //debug

	++counter;
	choose_frag_get_top_N_frags(top_N_frags);

// make a list of relevant constraints:
	ncst = 0;
	int np_pairs = classical_constraints::BOUNDARY::np_pairs();
	for ( int i = 1; i <= np_pairs; ++i ) {
		if ((frag_begin+size-1 <= cutpoint &&
				pairSeqSep(i) >= size &&
				( std::min(constraintPair(i,1),constraintPair(i,2)) <= frag_begin &&
				 std::max(constraintPair(i,1),constraintPair(i,2)) >= frag_begin+size-1 &&
				 std::max(constraintPair(i,1),constraintPair(i,2)) <= cutpoint ) ||
				(std::min(constraintPair(i,1),constraintPair(i,2)) >= frag_begin+size-1 &&
				 std::min(constraintPair(i,1),constraintPair(i,2)) <= cutpoint &&
				 std::max(constraintPair(i,1),constraintPair(i,2)) >= cutpoint+1 ) )
				||
				(
					frag_begin >= cutpoint+1 &&
					pairSeqSep(i) >= size &&
					( std::min(constraintPair(i,1),constraintPair(i,2)) <= cutpoint &&
					 std::max(constraintPair(i,1),constraintPair(i,2)) >= cutpoint+1 &&
					 std::max(constraintPair(i,1),constraintPair(i,2)) <= frag_begin ) ||
					( std::min(constraintPair(i,1),constraintPair(i,2)) >= cutpoint+1 &&
					 std::min(constraintPair(i,1),constraintPair(i,2)) <= frag_begin &&
					 std::max(constraintPair(i,1),constraintPair(i,2)) >= frag_begin+size-1
					)
				))
		{
			++ncst;
			cst_list(ncst) = i;
		}
	}
	if ( ncst == 0 ) {
		size = init_size;
		choose_fragment_pose( pose, size, frag_begin, false, false );
		return;
	}

//	std::cout << "WARNING:::::::::::::::::::::::::::enter cst" << std::endl;

	{     //scope

	pose_to_misc( pose );

	FArray2D_float ZtC( 3, 3 );
	FArray1D_float O2( 3 );
	FArray2D_float A2( 3, 3 );
	FArray1D_float U2( 3 );

	compute_frag_move(Eposition(1,1,frag_begin),phi(frag_begin),
	 Eposition(1,1,frag_begin+size),phi(frag_begin+size),A2,U2,ZtC,O2);

// evaluate constraints:
	cst_score = 0.0;
	for ( int i = 1; i <= ncst; ++i ) {
		FArray1D_float xyz1( 3 ), xyz2( 3 );
		get_noe_coords(cst_list(i),xyz1,xyz2);
		noe_dist2(xyz1,xyz2,dist2);
		cst_score += std::max(dist2-pairRadius2(cst_list(i)),0.0f);
	}

	if ( get_ssblock_state() ) {
		max_nn_num = std::min(align_depth(frag_begin,size_bin),block_depth(frag_begin,size_bin));
		jnn_num = static_cast< int >
			( ran3() * max_nn_num ) + 1;
		nn_num = block_frag_pointer(jnn_num,frag_begin,size_bin);
	} else {
		max_nn_num = std::min(top_N_frags,align_depth(frag_begin,size_bin));
		jnn_num = static_cast< int >
			( ran3() * max_nn_num ) + 1;
	}

	if( max_nn_num == 0 ){
		goto L199;
	}

	++counter2;
	final_nn_num = jnn_num-1;
	if ( final_nn_num == 0 ) final_nn_num = max_nn_num;

	while ( jnn_num != final_nn_num ) {

		//error check
		if( counter2 > top_N_frags * total_insert ){
			size = init_size;
			choose_fragment_pose( pose, size, frag_begin, false, false );
			return;
		}

		if (get_ssblock_state()) nn_num =block_frag_pointer(jnn_num,frag_begin,size_bin);
		else nn_num = jnn_num;

		precompute_fragmove_noedist(frag_rot(1,1,nn_num,frag_begin,size_bin),
		 frag_off(1,nn_num,frag_begin,size_bin),A2,U2,ZtC,O2,R,L);
		check_score = 0.0;
		for ( int i = 1; i <= ncst; ++i ) {
			FArray1D_float xyz1( 3 ), xyz2( 3 ), tmp( 3 );
			if ( (constraintPair(cst_list(i),1) <= cutpoint &&
					  constraintPair(cst_list(i),2) <= cutpoint ) ||
					 (constraintPair(cst_list(i),1) > cutpoint &&
					  constraintPair(cst_list(i),2) > cutpoint)){
				get_noe_coords(cst_list(i),xyz1,xyz2);
				if (constraintPair(cst_list(i),1) > constraintPair(cst_list(i),2)){
					tmp = xyz2;
					xyz2 = xyz1;
					xyz1 = tmp;
				}
				frag_move_noe_dist2(xyz1,xyz2,R,L,dist2);
			} else if ( frag_begin+size-1 <= cutpoint ){
				// cst_pair_min <= cutpoint, cst_pair_max > cutpoint
				get_noe_coords(cst_list(i),xyz1,xyz2);
				if (constraintPair(cst_list(i),1) < constraintPair(cst_list(i),2)){
					tmp = xyz2;
					xyz2 = xyz1;
					xyz1 = tmp;
				}
				frag_move_xyz( xyz2, R, L );
				noe_dist2( xyz1,xyz2,dist2);
			} else if ( frag_begin > cutpoint ){
				// cstpair_min <= cutpoint, cstpair_max > cutpoint
				// B--------P1----   -----P2--FFF----E
				// we need to move P2, but R,L were calculated from N->C so E'=RE+L
				// so for P2 we do P2'=Rt*(P2-L)
				get_noe_coords(cst_list(i),xyz1,xyz2);
				if (constraintPair(cst_list(i),1) > constraintPair(cst_list(i),2)){
					tmp = xyz2;
					xyz2 = xyz1;
					xyz1 = tmp;
				}
				inverse_frag_move_xyz( xyz2, R, L );
				noe_dist2( xyz1,xyz2,dist2);
			}
			check_score += std::max(dist2-pairRadius2(cst_list(i)),0.0f);
		}

		if ( check_score <= cst_score * tolerance ) {
			for ( int i = 0; i <= size-1; ++i ) { // different than what's in structure
				if ( align_name(frag_begin,nn_num,size_bin) != pose.name(i+frag_begin) )
				 goto L200;
			}
		}
		++jnn_num;
		++counter2;
		if ( jnn_num > max_nn_num ) jnn_num = 1;
//		std::cout << "jnn_num / max_nn_num " << jnn_num << " / " << max_nn_num << std::endl;
	}

L199:
	++map_site;
	if ( map_site > total_insert ) map_site = 1;
//	std::cout << "map_site / total_insert " << map_site << " / " << total_insert << std::endl;

	if ( map_site == start_map_site ) {
		std::cout << "WARNING:: unable to find any cst_frags" << std::endl;
		size = init_size;
		choose_fragment_pose( pose, size, frag_begin, false, false );
		return;
	}
	goto L300; // try next insertion point

	} //end scope

L200:

	// insert into pose arrays once we are happy:
	for ( int i = 0; i <= size-1; ++i ) {
		pose.set_phi       (i+frag_begin, align_phi   (frag_begin,nn_num,i,size_bin) );
		pose.set_psi       (i+frag_begin, align_psi   (frag_begin,nn_num,i,size_bin) );
		pose.set_omega     (i+frag_begin, align_omega (frag_begin,nn_num,i,size_bin) );
		pose.set_secstruct (i+frag_begin, ss_type     (frag_begin,nn_num,i,size_bin) );
		pose.set_name      (i+frag_begin, align_name  (frag_begin,nn_num,size_bin) );
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin one_loop_choose_fragment_coord_pose
///
/// @brief choose a loop fragment based on the coordinate constraints
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void
one_loop_choose_fragment_coord_pose(
	pose_ns::Pose & pose,
	float tolerance,
	int size,
	int & frag_begin,
	const int cutpoint
)
{
	using namespace fragments::chuck;
	using namespace fragments::frag_pointer;
	using namespace fragments;
	using namespace misc;
	using namespace param;

	int size_bin;
	int ncst;
	std::vector< int > cst_res;
	int top_N_frags;
	float dist2;
	std::vector<float> cst_score, check_score;
	int jnn_num,final_nn_num,max_nn_num, nn_num; // ptrs into frag list

	FArray2D_float R( 3, 3 );
	FArray1D_float L( 3 );

	size_bin = get_index_by_frag_size(size);
	precompute_frag_movement(size,size_bin,total_residue); // make sure it's initialized

	// retrieve the insert map, total_insert, insert_size from pose
	int total_insert;
	const FArray1D_int & insert_map
		( pose.get_insert_map( total_insert ) );
	const FArray1D_int & insert_size
		( pose.get_insert_size() );

	if ( total_insert <= 0 ) {
		// debug:
		std::cout << "choose_fragment_pose:: total_insert <= 0 " << total_insert << std::endl;
		frag_begin = 0;
		size = 0;
		return;
	}

	// store input value
	const int init_size  ( size < total_insert ? size : total_insert );

	int map_site = static_cast< int >( ran3() * ( total_insert - init_size + 1) ) + 1;

	int start_map_site = map_site;
	int counter = 0;
	int counter2 = 0;

L300:

	size = init_size; // in jumping_mode, size may change, so reset it

	frag_begin = insert_map(map_site);

	// trim back as necessary: insert_size stores the length of the longest
	// allowed insert that begins at begin
	size = std::min( insert_size( frag_begin ), size);
	assert ( size > 0 ); //debug

	++counter;
	choose_frag_get_top_N_frags(top_N_frags);

	// make a list of relevant constraints:
	ncst = 0;
	for ( int i = 1; i <= total_residue; ++i ) {
		if ((frag_begin+size <= cutpoint &&
				 i >= frag_begin+size &&
				 i <= cutpoint ) ||
				(frag_begin >= cutpoint+1 &&
				 i >= cutpoint+1 &&
				 i <= frag_begin)
			 )
		{
			++ncst;
			cst_res.push_back(i);
		}
	}
	if ( ncst == 0 ) {
		size = init_size;
		choose_fragment_pose( pose, size, frag_begin, false, false );
		return;
	}


	{     //scope

	pose_to_misc( pose );

	FArray2D_float ZtC( 3, 3 );
	FArray1D_float O2( 3 );
	FArray2D_float A2( 3, 3 );
	FArray1D_float U2( 3 );

	compute_frag_move(Eposition(1,1,frag_begin),phi(frag_begin),
	 Eposition(1,1,frag_begin+size),phi(frag_begin+size),A2,U2,ZtC,O2);

	// evaluate coordinate constraints:
	cst_score.clear();
	for ( int i = 1; i <= ncst; ++i ) {
//		FArray1D_float xyz( 3 );
//		get_XYZ(i,2,xyz);
		cst_score.push_back( get_coord_cst( cst_res.at(i-1) ) );
	}

	if ( get_ssblock_state() ) {
		max_nn_num = std::min(align_depth(frag_begin,size_bin),block_depth(frag_begin,size_bin));
		jnn_num = static_cast< int >
			( ran3() * max_nn_num ) + 1;
		nn_num = block_frag_pointer(jnn_num,frag_begin,size_bin);
	} else {
		max_nn_num = std::min(top_N_frags,align_depth(frag_begin,size_bin));
		jnn_num = static_cast< int >
			( ran3() * max_nn_num ) + 1;
	}

	if( max_nn_num == 0 ){
		goto L199;
	}

	++counter2;
	final_nn_num = jnn_num-1;
	if ( final_nn_num == 0 ) final_nn_num = max_nn_num;

	while ( jnn_num != final_nn_num ) {

		//error check
		if( counter2 > top_N_frags * total_insert ){
			size = init_size;
			choose_fragment_pose( pose, size, frag_begin, false, false );
			return;
		}
		if (get_ssblock_state()) nn_num =block_frag_pointer(jnn_num,frag_begin,size_bin);
		else nn_num = jnn_num;

		precompute_fragmove_noedist(frag_rot(1,1,nn_num,frag_begin,size_bin),
		 frag_off(1,nn_num,frag_begin,size_bin),A2,U2,ZtC,O2,R,L);
		check_score.clear();
		for ( int i = 1; i <= ncst; ++i ) {
			FArray1D_float xyz( 3 ), newxyz( 3 );
			int atom = 2;
			classical_constraints::BOUNDARY::get_XYZ(cst_res.at(i-1),atom,xyz);
			newxyz = xyz;
			if ( i <= cutpoint )
			{
				frag_move_xyz( newxyz, R, L );
			} else if ( i >=  cutpoint + 1 ){
				inverse_frag_move_xyz( newxyz, R, L );
			}
//			ref_pose.get_XYZ(cst_res.at(i-1),atom,xyz);
			classical_constraints::BOUNDARY::noe_dist2( xyz,newxyz,dist2);
			check_score.push_back( std::sqrt(dist2) );
		}
		if ( accept_coord_cst( check_score, cst_score, tolerance ) ) {
			for ( int i = 0; i <= size-1; ++i ) { // different than what's in structure
				if ( align_name(frag_begin,nn_num,size_bin) != pose.name(i+frag_begin) )
				 goto L200;
			}
		}
		++jnn_num;
		++counter2;
		if ( jnn_num > max_nn_num ) jnn_num = 1;
	}

L199:
	++map_site;
	if ( map_site > total_insert ) map_site = 1;

	if ( map_site == start_map_site ) {
		std::cout << "WARINING:: unable to find any cst_frags" << std::endl;
		size = init_size;
		choose_fragment_pose( pose, size, frag_begin, false, false );
		return;
	}
	goto L300; // try next insertion point

	} //end scope

L200:

	// insert into pose arrays once we are happy:
	for ( int i = 0; i <= size-1; ++i ) {
		pose.set_phi       (i+frag_begin, align_phi   (frag_begin,nn_num,i,size_bin) );
		pose.set_psi       (i+frag_begin, align_psi   (frag_begin,nn_num,i,size_bin) );
		pose.set_omega     (i+frag_begin, align_omega (frag_begin,nn_num,i,size_bin) );
		pose.set_secstruct (i+frag_begin, ss_type     (frag_begin,nn_num,i,size_bin) );
		pose.set_name      (i+frag_begin, align_name  (frag_begin,nn_num,size_bin) );
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_coord_cst
///
/// @brief read in the coordinate constraints
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
float get_coord_cst( int i )
{

	using namespace loopcst;

	return coord_cst[i];

}

////////////////////////////////////////////////////////////////////////////////
/// @begin read_coord_cst
///
/// @brief read in the coordinate constraints
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void read_coord_cst()
{

	using namespace loopcst;

	if ( truefalseoption ("coordcst") )
		coord_cst_exist = true;

	if ( get_coord_cst_exist() ){
		std::string filename;
		stringafteroption( "coordcst", "", filename);
		if ( filename == "" ){
			std::cout << "No coordcst_file specified! Try to find coordcst file in start_path!"
			<< std::endl;
			filename = files_paths::start_path + files_paths::start_file + ".coordcst";
		}
		utility::io::izstream data( filename.c_str() );
		if ( !data ) {
			std::cout << "couldnt open coordcst file!! " << filename << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		std::string line;

		while ( getline( data, line ) ) {
			std::istringstream line_stream( line );
			int res;
			float cst;
			line_stream >> res >> cst;
			if ( !line_stream.fail() ) {
				coord_cst[res] = cst;
				std::cout << "coord cst: " << ' ' << res << ' ' << cst << std::endl;
			}
		}
		data.close();
	}else{
		for (int i=1; i<= misc::total_residue; ++i )
			coord_cst[i] = 10000.0;
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin accept_coord_cst
///
/// @brief decide whether or not to accept the fragment based on coordinate
///  constraints
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
bool
accept_coord_cst(
	std::vector<float> const & check_score,
	std::vector<float> const & cst_score,
	float tolerance
)
{
	assert (check_score.size() == cst_score.size() );
	int const len = static_cast<int> (check_score.size());
	int violates = 0;
	for ( int i = 0; i < len; ++i ){
		if ( check_score.at(i) > cst_score.at(i) * tolerance ) violates++;
	}
	if ( violates >= len * 0.5 * ran3() ) return false;
	else return true;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_coord_cst_exist
///
/// @brief whether or not to use the coordinate constraints
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
bool get_coord_cst_exist()
{
	using namespace loopcst;

	return coord_cst_exist;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_coord_cst_exist
///
/// @brief set whether or not to use the coordinate constraints
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void set_coord_cst_exist( bool truefalse )
{

	using namespace loopcst;

	coord_cst_exist = truefalse;

}
////////////////////////////////////////////////////////////////////////////////
/// @begin alter_homologous_seqs
///
/// @brief change the sequence in the loop region tempararily to a homologous
///  sequence
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void alter_homologous_seqs(
	pose_ns::Pose & pose,
	int const & start,
	int const & end
)
{

	if ( !get_alter_seqs_exist() ) return;

	std::vector< std::string > alterseqs = read_alter_seqs();

	int const alterseq_size ( static_cast< int > (alterseqs.size()) );
	std::string thisseq = alterseqs.at( static_cast<int> (ran3() * alterseq_size) );
	for ( int i = start; i <= end; ++i ){
		int thisres;
		num_from_res1( thisseq.at(i-1), thisres );
		pose.set_res( i, thisres );
	}

	pose_to_misc( pose );

}

////////////////////////////////////////////////////////////////////////////////
/// @begin read_alter_seqs
///
/// @brief read homologous sequences which will be used in alter_sequence
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
std::vector<std::string> read_alter_seqs(
)
{

	static bool init = { false };
	static std::vector< std::string > alter_seqs;

	if ( !get_alter_seqs_exist() ) return alter_seqs;

	if ( !init ){
		std::string filename;
		stringafteroption( "alter_seqs", "junk.out", filename);
		utility::io::izstream data( filename.c_str() );
		if ( !data ) {
			std::cout << "couldnt open alter_seqs file!! " << filename << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		std::string line;
		std::string oneseq;

		while ( getline( data, line ) ) {
			std::istringstream line_stream( line );
			char first;
			std::string rest;
			line_stream >> first;
			if ( !line_stream.fail() ){
				if ( first == '>' ) {
					if ( oneseq != "" )
						alter_seqs.push_back( oneseq );
					oneseq = "";
					continue;
				}
				else {
					line_stream >> rest;
					oneseq += first + rest;
				}
			}
		}
		alter_seqs.push_back( oneseq );
		data.close();

		init = true;
	}

	return alter_seqs;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_alter_seqs_exist
///
/// @brief decied whether or not to use alter sequences
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
bool get_alter_seqs_exist(
)
{

	static bool init = { false };
	static bool alter_seqs_exist = { false };


	if ( !init ){
		if (truefalseoption ("alter_seqs") ){
			alter_seqs_exist = true;
		}
		init = true;
	}

	return alter_seqs_exist;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin restore_seq
///
/// @brief change the sequence back to the original sequence
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void restore_seq(
	pose_ns::Pose & pose,
	pose_ns::Pose const & old_pose,
	int const & start,
	int const & end
)
{

	if ( !get_alter_seqs_exist() ) return;

	for ( int i = start; i <= end; ++i ){
		pose.set_res( i, old_pose.res( i) );
	}

	pose_to_misc( pose );

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_score_filter_cut
///
/// @brief cutoff to set the score filter
///
/// @detailed default is no filter
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
float get_score_filter_cutoff(
)
{

	static bool init = { false };
	static float score_filter_cutoff = { 1.0 };


	if ( !init ){
		realafteroption( "score_filter_cutoff", 1.0, score_filter_cutoff);
		init = true;
	}

	return score_filter_cutoff;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_skip_loop_rate
///
/// @brief rate to skip the loops
///
/// @detailed default is 0
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
float get_skip_loop_rate(
)
{

	using namespace loopcst;

	static bool init = { false };

	if ( !init ){
		realafteroption( "loop_skip_rate", 0.0, loop_skip_rate);
		init = true;
	}

	return loop_skip_rate;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_skip_loop_rate
///
/// @brief rate to skip the loops
///
/// @detailed default is 0
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void set_skip_loop_rate(
	float const & rate
)
{

	using namespace loopcst;

	loop_skip_rate = rate;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin get_loop_modeling_exist
///
/// @brief wether or not to use loop barcode cst
///
/// @detailed default is using it
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void get_loop_modeling_option(
)
{

	using namespace loopcst;

	loop_model_exist =  truefalseoption( "loop_model" );

}

bool get_loop_modeling_exist(
)
{

	using namespace loopcst;

	return loop_model_exist;

}
////////////////////////////////////////////////////////////////////////////////
/// @begin set_loop_modeling_exist
///
/// @brief set loop modelling mode
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void set_loop_modeling_exist(
	bool truefalse )
{

	using namespace loopcst;

	loop_model_exist = truefalse;

}

/////////////////////////////////////////////////////////////////////////////////
void
loop_refinement(
	pose_ns::Pose & pose,
	pose_ns::Loops & all_loops
)
{

	using namespace pose_ns;
	using namespace files_paths;

	// no constraints
//	bool save_constraints_exist( classical_constraints::BOUNDARY::get_constraints_exist() );
//	classical_constraints::BOUNDARY::set_constraints_exist( false );
	// minimizer params:
	minimize_exclude_sstype( false, false );
	minimize_set_vary_phipsi( true );
	minimize_set_vary_chi( true );
	minimize_set_vary_omega( false ); // NOT omega, but everything else
	minimize_set_vary_rb_angle( true );
	minimize_set_vary_rb_trans( true );
	minimize_set_tolerance( 0.005 );
	minimize_set_local_min( false, 0 ); // all non-move-list rsds minimized

	score_set_try_rotamers( false ); // may be turned on inside moves
	set_use_nblist(false);
	set_smallmove_size( 2.0, 2.0, 3.0 );
	score_set_cst_mode(3);

	std::cout << "refine loops in fullatom mode" << std::endl;
	// refine loops only if in fullatom
	pose_setup_packer();

	set_loops_ns_fast( get_loop_fast_refine_exist() );
	set_loops_ns_fixnatsc( get_loop_fix_natsc_exist() );

	// set up fold_tree and allow_bb_move properly
	std::cout << all_loops << std::endl;

	// do the refinement one at a time
	if( !pose.fullatom() ) pose.set_fullatom_flag( true, true );

	pose_set_allow_chi_move_loops( all_loops, pose );

	for( Loops::iterator it=all_loops.v_begin(), it_end=all_loops.v_end();
			 it != it_end; ++it ) {
		if( get_random_cutpoint() && !get_loop_rebuild() ){
			it->set_cut( choose_cutpoint( pose, it->start(), it->stop() ) );
		}
		Loops loops;
		loops.add_loop( it );

		pose.simple_fold_tree( pose.total_residue() );
		Fold_tree f;
		pose_loops_build_fold_tree( pose.total_residue(), loops, f );
		pose.set_fold_tree( f );
		std::cout << "Loop_fold_tree: " << f ;
		pose.set_allow_jump_move( false );
		pose_loops_set_allow_bb_move( pose, loops );

		// trim
		Pose trim_pose;
		Loops trim_loops;
		FArray1D_bool trim_res( pose.total_residue(), false );
		pose_update_cendist( pose ); // this is required for trim
		pose_loops_select_trim_residues( pose, loops, trim_res );
		pose_loops_trim_template( pose, loops, trim_res, trim_pose, trim_loops );
		trim_pose.set_allow_jump_move( false );
		pose_loops_set_allow_bb_move( trim_pose, trim_loops );

		trim_pose.set_fullatom_flag( true, true );
		Score_weight_map weight_map;
		setup_score_weight_map( weight_map, score12 );
		weight_map.set_weight( CHAINBREAK, 1.0 );
		weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );
		weight_map.set_weight( CST_SCORE, 1.0 );
		pose_refine_loops_with_ccd( trim_pose, weight_map, trim_loops );
//		pose_refine_loops_with_ccd( pose, weight_map, loops );

		// trim_reset
		pose_loops_trim_template_reset( pose, loops, trim_res, trim_pose,
			trim_loops );
		pose.update_backbone_bonds_and_torsions();

		if( !get_loop_fix_natsc_exist() ){
			FArray1D_bool allow_repack( pose.total_residue() );
			allow_repack = true;
			pose.set_allow_chi_move( allow_repack );
			pose.repack( allow_repack, true );
		}
	}
	pose.simple_fold_tree( pose.total_residue() );
	pose_loops_reset_global_ns();

	// minimizer params:
	minimize_reset();
//	classical_constraints::BOUNDARY::set_constraints_exist( save_constraints_exist );

}


///////////////////////////////////////////////////////////////////////////////
/// @begin loop_fa_relax
///
/// @brief full atom relax of a loop segment defined by a loops file. Does
///        minimization, repack, small moves followed by ccd closure.
/// @detailed
///
/// @param
/// @param
/// @param
/// @param
/// @param
/// @param
///
/// @global_read
///
/// @global_write
///
///
/// @references
///
/// @authors sraman
///
/// @last_modified
///////////////////////////////////////////////////////////////////////////////w/

void
loop_fa_relax(
	pose_ns::Pose & pose,
	std::vector<int> const & loop_begin,
	std::vector<int> const & loop_end
)
{
	using namespace pose_ns;
	using namespace files_paths;

	pose.set_fullatom_flag( true, true );
	assert( files_paths::input_fa == true );
  const int total_loops( loop_begin.size() );
	assert ( total_loops == int(loop_end.size()) );
	int const inner_cycles( 12 );
	int const outer_cycles( 5 );
	float const mc_temp( 1.2 );
	const int nres( pose.total_residue() );
	const pose_ns::Fold_tree & fold_tree (pose.fold_tree() );
	pose.simple_fold_tree( nres );

	std::vector<int> num_loop;
	std::cout << "Inside loop_fa_relax " << std::endl;
	pose.set_fullatom_flag( true, true );

	pose_setup_packer();

  if ( !get_fullatom_flag() ) {
		std::cout << "fullatom poses only" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	// minimizer params:
	minimize_exclude_sstype( false, false );
	minimize_set_vary_phipsi( true );
	minimize_set_vary_chi( true );
	minimize_set_vary_omega( false ); // NOT omega, but everything else
	minimize_set_vary_rb_angle( true );
	minimize_set_vary_rb_trans( true );
	minimize_set_tolerance( 0.001 );
	minimize_set_local_min( false, 0 ); // all non-move-list rsds minimized

	// miscellaneous
	score_set_try_rotamers( false ); // may be turned on inside moves
	set_use_nblist(true);
	set_smallmove_size( 2.0, 2.0, 3.0 );
	bool const try_rotamers( true );
	float const energycut = 0.001;
	Score_weight_map weight_map;
	//	setup_score12_weight_map( weight_map );
	setup_score_weight_map( weight_map, score12 );
	weight_map.set_weight( CHAINBREAK, 1.0 );
	weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );
	pose.score( weight_map );
	Monte_carlo mc( pose, weight_map, mc_temp );

	// assert unbroken chain?

	for (int kk = 0; kk < total_loops; ++kk){
		num_loop.push_back(kk);
	}

	if ( fold_tree.get_num_jump() > 0 ) {
		std::cout << "currently only supports unbroken chains but " <<
			" that would be easy to change" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

  random_shuffle( num_loop.begin(), num_loop.end() );

	for (int jj = 0; jj < total_loops; ++jj) {

		int loop_size = loop_end[num_loop[jj]] - loop_begin[num_loop[jj]] + 1;

		int n_small_moves ( std::min(5,loop_size/2) );

		int cutpoint( choose_cutpoint( pose,
								loop_begin[num_loop[jj]], loop_end[num_loop[jj]] ) );

		//////////////////
		// set allow move:
		FArray1D_bool loop_residue(nres,false);
		for ( int i=1; i<= nres; ++i ) {
			if ( i >= loop_begin[num_loop[jj]] && i <= loop_end[num_loop[jj]] ) {
				pose.set_allow_bb_move( i, true );
				pose.set_allow_chi_move( i, true );
				loop_residue( i ) = true;
			} else {
				pose.set_allow_bb_move( i, false );
				pose.set_allow_chi_move( i, false ); // NOTE!!
			}
		}

		//////////////////
		// setup fold_tree
		if ( loop_begin[num_loop[jj]] == 1 || loop_end[num_loop[jj]] == nres )
			pose.simple_fold_tree( nres );
		else{
			pose.one_jump_tree( nres, loop_begin[num_loop[jj]]-1,
													loop_end[num_loop[jj]]+1, cutpoint );
			pose.set_allow_jump_move(1,false);
		}
		pose.score( weight_map );

		mc.reset( pose );
		for ( int i=1; i<= outer_cycles; ++i ) {
			float const chainbreak_weight( i ); // CHANGE ME
			weight_map.set_weight( CHAINBREAK, chainbreak_weight );
			mc.set_weight_map( weight_map );

			pose = mc.low_pose();

			// repack the loop positions
			pose.repack( loop_residue, true );
			pose.score( weight_map );
			mc.boltzmann( pose );

			// minimize
			pose.main_minimize( weight_map, "dfpmin" );
			mc.boltzmann( pose );

			for ( int j = 1; j <= inner_cycles; ++j ) {
				// small moves, min
				// std::cout << "Inner cycles " << j << std::endl;
				pose_small_min_trial( pose, mc, weight_map, "dfpmin",
															n_small_moves,try_rotamers, energycut );

				// ccd trial:
				if ( loop_begin[num_loop[jj]] != 1 && loop_end[num_loop[jj]] != nres )
					pose_ccd_min_trial( pose, mc, weight_map, "dfpmin",
															loop_begin[num_loop[jj]], loop_end[num_loop[jj]],
															cutpoint, 100, try_rotamers, energycut );
			}

				// try dunbrack closing at the end

			pose.main_minimize( weight_map, "dfpmin");
			pose.score( weight_map);
			pose.show_scores( std::cout ); std::cout<< std::endl;
			mc.boltzmann( pose );
		}
		pose = mc.low_pose();
		pose.update_backbone_bonds_and_torsions();
		pose.simple_fold_tree( nres );
	}
  pose = mc.low_pose();

	//output_decoy_pose(pose);
}

///////////////////////////////////////////////////////////////////////////////
/// @begin get_loop_farlx_flag()
///
/// @brief fullatom relax of loop regions
///
/// @detailed
///
/// @param
/// @param
/// @param
/// @param
/// @param
/// @param
///
/// @global_read
///
/// @global_write
///
///
/// @references
///
/// @authors sraman
///
/// @last_modified
///////////////////////////////////////////////////////////////////////////////w/
bool
get_loop_farlx_flag()
{

	static bool init = { false };
	static bool loop_farlx = { false };

	if ( !init ){
		if( truefalseoption("loop_farlx") )	loop_farlx = true;
		init = true;
	}

	return loop_farlx;

}

///////////////////////////////////////////////////////////////////////////////
/// @begin get_loop_rebuild()
///
/// @brief
///
/// @detailed
///
/// @param
/// @param
/// @param
/// @param
/// @param
/// @param
///
/// @global_read
///
/// @global_write
///
///
/// @references
///
/// @authors sraman
///
/// @last_modified
///////////////////////////////////////////////////////////////////////////////
bool get_loop_rebuild()
{

	static bool init = { false };
	static bool rebuild_loop = { true };

	if ( !init ) {
		if( truefalseoption("loop_farlx_only") ) rebuild_loop = false;
		init = true;
	}

	return rebuild_loop;

}

///////////////////////////////////////////////////////////////////////////////
/// @begin get_fullatom_loop_flag()
///
/// @brief fullatom rebuilding of loop regions
///
/// @detailed
///
/// @param
/// @param
/// @param
/// @param
/// @param
/// @param
///
/// @global_read
///
/// @global_write
///
///
/// @references
///
/// @authors sraman
///
/// @last_modified
///////////////////////////////////////////////////////////////////////////////w/
bool
get_fullatom_loop_flag()
{

	static bool init = { false };
	static bool fullatom_loop = { false };

	if ( !init ){
		if( truefalseoption("fullatom_loop") )	fullatom_loop = true;
		init = true;
	}

	return fullatom_loop;

}


///////////////////////////////////////////////////////////////////////////////
/// @begin get_pose_idlz_flag()
///
/// @brief fullatom rebuilding of loop regions
///
/// @detailed
///
/// @param
/// @param
/// @param
/// @param
/// @param
/// @param
///
/// @global_read
///
/// @global_write
///
///
/// @references
///
/// @authors sraman
///
/// @last_modified
///////////////////////////////////////////////////////////////////////////////w/
bool
get_pose_idlz_flag()
{

	static bool init = { false };
	static bool pose_idlz = { false };

	if ( !init ){
		if( truefalseoption("pose_idlz") ) pose_idlz = true;
		init = true;
	}

	return pose_idlz;

}

bool
get_obligate_loop_exist()
{

	static bool init = { false };
	static bool obligate_loop_exist = { false };

	if ( !init ){
		if( truefalseoption("obligate_loops") ) obligate_loop_exist = true;
		init = true;
	}

	return obligate_loop_exist;

}

int
desired_loops()
{

	static bool init = { false };
	static int desired_loop = { 1 };

	if ( !init ){
		intafteroption("num_desired_loops", 1, desired_loop );
		init = true;
	}

	return desired_loop;

}

bool
get_desired_loops_exist(){

	static bool init = { false };
	static bool desired_loop_exist = { false };

	if ( !init ){
		if( truefalseoption("loops_subset") ) desired_loop_exist = true;
		init = true;
	}

	return desired_loop_exist;

}
///////////////////////////////////////////////////////////////////////////////
void
looprlx_fast_ccd_close_loops(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end,
	int const & cutpoint
)
{
	using namespace pose_ns;

	// param for ccd_closure
	int   const ccd_cycles = { 100 }; // num of cycles of ccd_moves
	float const ccd_tol = { 0.01 }; // criterion for a closed loop
	bool  const rama_check = { false };
	float const max_rama_score_increase = { 2.0 }; // dummy number when rama_check is false
	float const max_total_delta_helix = { 10.0 }; // max overall angle changes for a helical residue
	float const max_total_delta_strand = { 50.0 }; // ... for a residue in strand
	float const max_total_delta_loop = { 75.0 }; // ... for a residue in loop
	// output for ccd_closure
	float forward_deviation, backward_deviation; // actually loop closure msd, both dirs
	float torsion_delta, rama_delta; // actually torsion and rama score changes, averaged by loop_size

	// ccd close this loop
	fast_ccd_loop_closure( pose, loop_begin, loop_end, cutpoint, ccd_cycles,
		ccd_tol, rama_check, max_rama_score_increase, max_total_delta_helix,
		max_total_delta_strand, max_total_delta_loop, forward_deviation,
		backward_deviation, torsion_delta, rama_delta );
}

bool
get_ccd_closure_exist(){

	static bool init = { false };
	static bool ccd_closure_exist = { false };

	if ( !init ){
		if( truefalseoption("ccd_closure") ) ccd_closure_exist = true;
		init = true;
	}

	return ccd_closure_exist;

}

bool
get_loop_fast_refine_exist(){

	static bool init = { false };
	static bool fast_refine_exist = { false };

	if ( !init ){
		if( truefalseoption("fast_loop_farlx") ) fast_refine_exist = true;
		init = true;
	}

	return fast_refine_exist;

}

bool
get_loop_fix_natsc_exist(){

	static bool init = { false };
	static bool fix_natsc_exist = { false };

	if ( !init ){
		if( truefalseoption("looprlx_fix_natsc") ) fix_natsc_exist = true;
		init = true;
	}

	return fix_natsc_exist;

}


bool
shorten_long_terminal_loop(){

	static bool init = { false };
	static bool short_loop = { false };

	if ( !init ){
		if( truefalseoption("shorten_long_terminal_loop") ) short_loop = true;
		init = true;
	}

	return short_loop;

}

void
fillin_loop_bvalue(
	pose_ns::Loops const & output_loops,
	float bfactor
){

	using namespace pdb;

	bvalue = 0.0;
	for( pose_ns::Loops::const_iterator it = output_loops.begin(), it_end = output_loops.end();
			 it != it_end; ++it ) {
		for( int i = it->start(); i <= it->stop(); ++i )
			for( int j = 1; j <= param::MAX_ATOM(); ++j )
				bvalue( j, i ) = bfactor;
	}

}


void
fillin_loop_occupancy(
	pose_ns::Loops const & output_loops
){

	using namespace pdb;

	// initial missing
	FArray2D_float new_occ( param::MAX_ATOM(), param::MAX_RES(), 1.0 );
	for( int i = 1; i <= param::MAX_RES(); ++i ){
		if( occupancy( 1, i ) <= 0.0 || occupancy( 2, i ) <= 0.0
				||occupancy( 3, i ) <= 0.0 || occupancy( 4, i ) <= 0.0 ){
			for( int j = 1; j <= param::MAX_ATOM(); ++j ){
				new_occ( j, i ) = -1.0;
			}
		}
	}

	// rebuilt by looprlx
	for( pose_ns::Loops::const_iterator it = output_loops.begin(), it_end = output_loops.end();
			 it != it_end; ++it ) {
		for( int i = it->start(); i <= it->stop(); ++i )
			for( int j = 1; j <= param::MAX_ATOM(); ++j )
				new_occ( j, i ) = 1.0;
	}

	occupancy= new_occ;

}



bool
get_output_loops_file()
{

	static bool init = { false };
	static bool out_loop = { false };

	if ( !init ){
		if( truefalseoption("output_loops_built") ) out_loop = true;
		init = true;
	}

	return out_loop;

}

void
repack_loops(
	pose_ns::Loops const & loops,
	pose_ns::Pose & pose
)
{

	FArray1D_bool allow_repack( pose.total_residue() );
	allow_repack = false;

	// rebuilt by looprlx
	for( pose_ns::Loops::const_iterator it = loops.begin(), it_end = loops.end();
			 it != it_end; ++it ) {
		for( int i = it->start(); i <= it->stop(); ++i )
				allow_repack( i ) = true;
	}

	pose.set_allow_chi_move( allow_repack );
	RotamerOptions saved_rotamer_options = design::active_rotamer_options;
	design::active_rotamer_options.use_input_sc = false; // yab: never consider input sidechain, prevents
	                                               //      problems when sidechain is not initially
	                                               //      present and '-use_input_sc is on,
	                                               //      backbone can drastically move anyway so
	                                               //      shouldn't be much reason to keep input sc

	pose.repack( allow_repack, false );
	design::active_rotamer_options = saved_rotamer_options; // yab: reset

}


void
pose_set_allow_chi_move_loops(
	pose_ns::Loops const & loops,
	pose_ns::Pose & pose
)
{

	FArray1D_bool allow_repack( pose.total_residue() );
	allow_repack = false;

	// rebuilt by looprlx
	for( pose_ns::Loops::const_iterator it = loops.begin(), it_end = loops.end();
			 it != it_end; ++it ) {
		for( int i = it->start(); i <= it->stop(); ++i )
				allow_repack( i ) = true;
	}

	pose.set_allow_chi_move( allow_repack );

}


bool
get_combine_if_fail_exist()
{

	static bool init = { false };
	static bool combine_loop = { true };

	if ( !init ){
		if( truefalseoption("no_combine_if_fail") ) combine_loop = false;
		init = true;
	}

	return combine_loop;

}


float
get_total_chain_break_score(
)
{

	return loopcst::total_chain_break_score;

}


void
reset_loop_chain_breaks()
{
	using namespace loopcst;

	if( !get_looprlx_exist() ) return;

	loops_built.clear();
	chain_breaks.clear();
	total_chain_break_score = 0;

}


void
output_loop_chain_breaks(
	std::ostream & iunit
)
{
// rebuilt by looprlx
	using namespace loopcst;

	int i = 0;
	for( pose_ns::Loops::const_iterator it = loops_built.begin(), it_end = loops_built.end();
			 it != it_end; ++it ) {
		iunit << "  loopstart stop cut chain_break: " << I( 4, it->start() ) << ' '
			<< I( 4, it->stop() ) << ' ' << I( 4, it->cut() ) << ' ' <<
			F( 5, 2, chain_breaks.at(i) ) << '\n';
		i++;
	}

}


bool
get_looprlx_exist(){

	return relax_options::looprlx;
}


float
get_looprlx_cycle_ratio()
{
	static float looprlx_cycle_ratio( 1.0 );
  static bool init = {false};

	if ( !init ) {
		realafteroption( "looprlx_cycle_ratio", 1.0, looprlx_cycle_ratio );
		init = true;
	}
	return looprlx_cycle_ratio;
}


bool
get_random_cutpoint(){

	static bool init = { false };
	static bool random_cut = { false };

	if ( !init ){
		if( truefalseoption("loop_farlx_random_cut") ) random_cut = true;
		init = true;
	}

	return random_cut;

}

bool
get_use_rg_during_looprlx(){

	static bool init = { false };
	static bool use_rg = { false };

	if ( !init ){
		if( truefalseoption("use_rg") ) use_rg = true;
		init = true;
	}

	return use_rg;

}

bool
get_use_hb_during_looprlx(){

	static bool init = { false };
	static bool use_hb = { false };

	if ( !init ){
		if( truefalseoption("use_hb") ) use_hb = true;
		init = true;
	}

	return use_hb;

}

bool
get_use_sspair_during_looprlx(){

	static bool init = { false };
	static bool use_sspair = { false };

	if ( !init ){
		if( truefalseoption("use_sspair") ) use_sspair = true;
		init = true;
	}

	return use_sspair;

}

bool
get_use_rsigma_during_looprlx(){

	static bool init = { false };
	static bool use_rsigma = { false };

	if ( !init ){
		if( truefalseoption("use_rsigma") ) use_rsigma = true;
		init = true;
	}

	return use_rsigma;

}

int
get_use_9mer_frag_cutoff(){

	static bool init = { false };
	static int use_9mer_frag = { 16 };

	if ( !init ){
		intafteroption("9mer_frag_cutoff", 16, use_9mer_frag );
		init = true;
	}

	return use_9mer_frag;

}


////////////////////////////////////////////////////////////////////////////////
/// @begin frag_move_xyz
///
/// @brief move coord xyz according to R and L matrices
///
/// @detailed
///
/// @param  xyz2 - [in] -
/// @param  R - [in/out]? -
/// @param  L - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
frag_move_xyz(
	FArray1Da_float xyz,
	FArray2Da_float R,
	FArray1Da_float L
)
{

	xyz.dimension( 3 );

	R.dimension( 3, 3 );
	L.dimension( 3 );

	FArray1D_float tmp( 3 );

	rotate(R,xyz,tmp);

	xyz(1) = tmp(1) + L(1);
	xyz(2) = tmp(2) + L(2);
	xyz(3) = tmp(3) + L(3);

}

////////////////////////////////////////////////////////////////////////////////
/// @begin inverse_frag_move_xyz
///
/// @brief  reverse move of xyz based on R and L
///
/// @detailed xyz2' = R^transposed * ( xyz2 - L )
///
/// @param  xyz2 - [in] -
/// @param  R - [in/out]? -
/// @param  L - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
inverse_frag_move_xyz(
	FArray1Da_float xyz,
	FArray2Da_float R,
	FArray1Da_float L
)
{

	xyz.dimension( 3 );

	R.dimension( 3, 3 );
	L.dimension( 3 );

	FArray1D_float tmp( 3 );

	tmp(1) = xyz(1) - L(1);
	tmp(2) = xyz(2) - L(2);
	tmp(3) = xyz(3) - L(3);

	transpose3(R);
	rotate(R,tmp,xyz);

}
