// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8300 $
//  $Date: 2006-05-10 12:02:18 -0700 (Wed, 10 May 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "loops_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/DimensionExpressions.hh>


// Using
using namespace param;


namespace loops_ns {


int const n2c = { 1 };
int const c2n = { -1 };


namespace loop_splicing {
	bool randomize_dir;
	int splice_dir;
}


int const max_loop = { MAX_SEGMENTS - 1 }; // ROBETTA 50
int const max_loop_depth = { 40 }; // ROBETTA 500
int const max_loop_size = { 40 }; // ROBETTA 200


namespace loop_int {
	FArray1D_int loop_map( MAX_RES() ); // loop number that each res is in
	FArray1D_int loop_begin( max_loop );
	FArray1D_int loop_end( max_loop );
	int num_loop = { 0 };
	FArray1D_int loop_depth( max_loop ); // number of conformations of each loop
}


namespace loop_real {
	FArray4D_float overlap_coord( 3, 5, max_loop, 2 ); // xyz,atom,loop#,n/c
	FArray4D_float best_overlap_coord( 3, 5, max_loop, 2 );
	FArray4D_float low_overlap_coord( 3, 5, max_loop, 2 );
//car note: should just keep phi,psi,omega etc in 1 array dimensioned by
//car MAX_RES--> loops will not overlap, save space
	FArray3D_float loop_phi( max_loop_size, max_loop_depth, max_loop ); // loop angles
	FArray3D_float loop_psi( max_loop_size, max_loop_depth, max_loop );
	FArray3D_float loop_omega( max_loop_size, max_loop_depth, max_loop );
}


namespace loop_char {
	FArray3D_char loop_secstruct( max_loop_size, max_loop_depth, max_loop, ' ' );
	FArray2D_string loop_name( max_loop_depth, max_loop, std::string( 4, ' ' ) );
}


namespace loop_conflicts {
	FArray1D_int loop_rank( max_loop ); // rank order to build loops
	FArray1D_float conflicts( max_loop );
		// any conflicts for each loop region will be stored here
}


namespace loop_start {
	FArray1D_int start_loop_begin( max_loop );
	FArray1D_int start_loop_end( max_loop );
	int start_num_loop;
	FArray1D_int start_loop_depth( max_loop );
}


namespace loop_bool {
	bool permute = { false };
	bool screen = { false };
	bool fast;
	bool fa_refine;
	bool fold;
	bool trim = { false };
	bool idl_breaks;
	bool fix_natsc;
	bool sequential; // fold loops sequentially, not simultaneously
	bool dunbrack_close = { false };
	bool fold_with_dunbrack = { false };
	bool grow = { false };
	bool vdw_max_on = { false };
	float vdw_max = { 999. };
	bool rg_max_on = { false };
	float rg_max = { 999. };
	bool wiggle_jxn = { false };
}

namespace loop_flag_bool {
	bool loop_flag = { false };
	bool pose_loop_flag = { false };
}

namespace pose_hijack {
	int store_num_loop;
	int store_loop_begin;
	int store_loop_end;
	FArray2D_float store_overlapN( 3, 5 );
	FArray2D_float store_overlapC( 3, 5 );
	int loop_num;
	int store_residue;
	FArray1D_int store_res( MAX_RES() );
	FArray1D_int store_resvariant( MAX_RES() );
	FArray3D_float Estore_position( 3, MAX_POS, MAX_RES() );
	FArray2D_float store_centroid( 3, MAX_RES() );
	FArray1D_float store_phi( MAX_RES() );
	FArray1D_float store_psi( MAX_RES() );
	FArray1D_float store_omega( MAX_RES() );
	FArray3D_float store_fullcoord( 3, MAX_ATOM(), MAX_RES() );
	FArray1D_char store_secstruct( MAX_RES(), ' ' );
	FArray1D_string store_name( MAX_RES(), std::string( 4, ' ' ) );
}

namespace trim_hijack {

	bool trim_on = { false };
	Dimension active; // Array allocation toggle (for memory savings when !trim_on)
	// The active toggle is a memory saving hack and should be considered an interim patch
	// until this is refactored into more appropriate objects and data structures
	//loops
	int store_num_loop;
	FArray1D_int store_loop_begin( active * max_loop );
	FArray1D_int store_loop_end( active * max_loop );
	FArray1D_int store_loop_depth( active * max_loop );
	FArray3D_float store_loop_phi( active * max_loop_size, max_loop_depth, max_loop );
	FArray3D_float store_loop_psi( active * max_loop_size, max_loop_depth, max_loop );
	FArray3D_float store_loop_omega( active * max_loop_size, max_loop_depth, max_loop );
	FArray3D_char store_loop_secstruct( active * max_loop_size, max_loop_depth, max_loop, ' ' );
	FArray2D_string store_loop_name( active * max_loop_depth, max_loop, std::string( 4, ' ' ) );
	//pose
	int store_residue;
	FArray1D_int store_res( active * MAX_RES() );
	FArray1D_int store_resvariant( active * MAX_RES() );
	int store_total_domains;
	FArray1D_int store_domain_end( active * MAX_SEGMENTS );
	FArray3D_float Estore_position( active * 3, MAX_POS, MAX_RES() );
	FArray2D_float store_centroid( active * 3, MAX_RES() );
	FArray1D_float store_phi( active * MAX_RES() );
	FArray1D_float store_psi( active * MAX_RES() );
	FArray1D_float store_omega( active * MAX_RES() );
	FArray3D_float store_fullcoord( active * 3, MAX_ATOM(), MAX_RES() );
	FArray1D_char store_secstruct( active * MAX_RES(), ' ' );
	FArray1D_string store_name( active * MAX_RES(), std::string( 4, ' ' ) );
	FArray1D_bool store_allow_insert( active * MAX_RES() );
	//fragments
	FArray4D_float store_align_phi( active * MAX_RES(), MAX_NEIGH(), DRange( 0, MAX_LEN() ),
																	n_frag_sizes() );
	FArray4D_float store_align_psi( active * MAX_RES(), MAX_NEIGH(), DRange( 0, MAX_LEN() ),
																	n_frag_sizes() );
	FArray4D_float store_align_omega( active * MAX_RES(), MAX_NEIGH(), DRange( 0, MAX_LEN() ),
																		n_frag_sizes() );
	FArray2D_int store_align_depth( active * MAX_RES(), n_frag_sizes() );
	FArray4D_char store_ss_type( active * MAX_RES(), MAX_NEIGH(), DRange( 0, MAX_LEN() ),
															 n_frag_sizes(), ' ' );
	FArray3D_string store_align_name( active * MAX_RES(), MAX_NEIGH(), n_frag_sizes(),
																		 std::string( 4, ' ' ) );
	FArray3D_char store_align_chain( active * MAX_RES(), MAX_NEIGH(), n_frag_sizes(), ' ' );
	FArray4D_char store_align_res_id( active * MAX_RES(), MAX_NEIGH(), DRange( 0, MAX_LEN() ),
																		n_frag_sizes(), ' ' );
	FArray3D_int store_align_resseq( active * MAX_RES(), MAX_NEIGH(), n_frag_sizes() );
	//mapping
	FArray1D_int trim_map( active * MAX_RES() );

}


} // namespace loops_ns
