// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 11295 $
//  $Date: 2006-11-14 13:49:04 -0800 (Tue, 14 Nov 2006) $
//  $Author: johnk $

#ifndef INCLUDED_map_sequence
#define INCLUDED_map_sequence


// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <vector>
#include <map>
#include <list>
#include <string>
#include <utility>


typedef float (*Scoring_Function)();

// fwd defn
class Fragment;

bool
map_misc_coords(
	const bool fa_input,
	const bool coords_init,
	const bool ideal_pos
);

bool
map_pose_sequence(
	pose_ns::Pose & pose,
	const std::string & target_sequence,
	const FArray1D_int & start_mapping
);

bool
setup_start_mapping(
	const std::string & target_sequence,
	const std::string & start_sequence,
	FArray1D_int & mapping
);

int
get_map_sequence_alignment_length(
);

void
build_terminal_loops(
	pose_ns::Pose & pose,
	const std::string & target_sequence,
	FArray1D_int & mapping
);

bool
build_random_loop(
	pose_ns::Pose & pose,
	const std::string & target_sequence,
	FArray1D_int & mapping
);

bool
rebuild_loop(
	pose_ns::Pose & pose,
	const std::string & target_sequence,
	const int init_target_begin,
	const int init_target_end,
	const int init_template_begin,
	const int init_template_end
);

void
frag_close(
  const pose_ns::Pose & pose,
	const int begin,
	const int size,
	const int cutpoint,
	const int frag_offset, // add this to begin, get begin in fragment sequence
	const int cycles1,
	const int cycles2,
	const int big_num_fragments,
	const int little_num_fragments,
	const int ccd_cycles,
	std::vector< Fragment > & fragment_list // output
);

float
calc_overlap_dev(
	const int cutpoint,
	const int ncut,
	const FArray3DB_float & Eposition,
	const FArray4D_float & overlap_Eposition
);

void
scored_frag_close(
	pose_ns::Score_weight_map const & weight_map,
	pose_ns::Pose const & pose_in,
	const int loop_begin,
	const int loop_end,
	const int frag_size,
	const int frag_offset,
	const int cycles1,
	const int cycles2,
	const bool do_ccd_moves,
	std::vector< Fragment > & fragment_list
);

#endif
