// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_maps_ns
#define INCLUDED_maps_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ headers
#include <list>


// maps to track where movement is allowed and has occured


namespace protein_maps {

  //--------------
  // torsion angles
  //--------------
  //
  extern FArray1D_bool allow_insert; // can torsion angles change?
  extern FArray1D_int insert_map; // list of all moveable residues
  extern int total_insert; // length of insert_map

  //--------------
  // rigid body interfaces
  //--------------
  //

  //--------------
  // side chains
  //--------------
  //
  //CAR NOTE:  design and docking use their own calls to the packer/rotamer trials
  //car        and allow_repack,allow_rottrial are not relevant
  //
  // side chains that differ between best and current are specified by
  // global array new_rotamer. The new_rotamer namespace is included only
  // in functions requiring direct access; all other access should be by method.
  extern FArray1D_bool allow_rottrial;
  // sidechains that can be moved by packer
  extern FArray1D_bool allow_repack;
  // sc that can be moved by rot_trials

}


namespace move_map {

  extern FArray1D_bool new_rotamer;
  extern FArray1D_bool new_phipsi;
//rigid body movements
  extern int nrb_max_value;
  extern FArray1D_int new_rigidbody;

	struct RbMove {
		int begin;
		int end;

		//RbMove constructor
		explicit
		RbMove( int begin_a = 0, int end_a = 0 ):
			begin( begin_a ),
			end( end_a ) {}

	};
	typedef std::list< move_map::RbMove > RbMoves;
	extern RbMoves rbmoves;

	//movemaps
	extern FArray1D_bool res_moved;
	extern FArray2D_bool pair_moved;
	extern FArray1D_bool res_moved_bbonly;
	extern FArray2D_bool pair_moved_bbonly;
	extern bool movemap_current;
}


#endif
