// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13347 $
//  $Date: 2007-03-08 04:43:32 -0800 (Thu, 08 Mar 2007) $
//  $Author: ion $


// Rosetta Headers
#include "minimize_ns.h"
#include "param.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Using
using namespace param;
using namespace param_torsion;

namespace minimize_ns {


//--------minimizer options --------------------------------------
//    (could be set by command line or in options.cc)

//  flags to control exclusions

//  flags to control local minimization

//  tolerance for gradient minimization functions


namespace minimize_options {
	bool minimize_vary_phipsi_default = { true };
	bool minimize_vary_omega_default = { false };
	bool minimize_vary_chi_default = { false };
	bool minimize_vary_rb_angle_default = { true };
	bool minimize_vary_rb_trans_default = { true };
	bool minimize_excludeH_default = { true };
	bool minimize_excludeE_default = { false };
	bool minimize_local_min_default = { false };
	int minimize_local_window_default = { 5 };
	float minimize_tolerance_default = { 0.005 };
}


//---------minimizer state-----------------------------------------
//  flags to control which torsion angles are included in minimization

//  flags to control exclusions

//  flags to control local minimization

//  tolerance for gradient minimization functions


namespace minimize_state {
	bool minimize_vary_phipsi;
	bool minimize_vary_omega;
	bool minimize_vary_chi;
	bool minimize_vary_rb_angle;
	bool minimize_vary_rb_trans;
	bool minimize_excludeH;
	bool minimize_excludeE;
	bool minimize_local_min; // minimize locally only
	int minimize_local_window;
	float minimize_tolerance;
	// rbs,derivs get multiplied by this before going into (dE_d)phipsi
	// used in jump_(un)pack_phipsi, jmp_dfunc_vdw
	float const rb_translation_scale_factor( 10.0 );
}

//---------minimizer data-----------------------------------------
//car variables for pack_torsion


namespace minimizer_data {
	FArray1D_int angle_map( MAX_RES() * jmp_total_torsion ); // note: jmp_total_torsion
	FArray1D_int angle_type( MAX_RES() * jmp_total_torsion );
	FArray1D_int angle_direction( MAX_RES() * jmp_total_torsion ); // new!
	int map_length;
//	FArray1D_bool resinmap( MAX_RES() );
	FArray2D_bool minimize_allow_torsion( jmp_total_torsion, MAX_RES() ); // new logic
	int minimize_fold_begin;
	int minimize_fold_end;
}

//--- minimizer exclusion list state------------------------------


namespace exclude_list_state {
	bool minimize_exclude_list_init = { false };
}

	// namespaces not included by default in namespace minimize_ns
namespace deriv_precalc {
	float vdw_factor;
	float tether_factor;
	float fa_rep_factor;
	float fa_atr_factor;
	float fa_solv_factor;
}

namespace save_pose {
	FArray1D_float save_phi( MAX_RES() );
	FArray1D_float save_psi( MAX_RES() );
	FArray1D_float save_omega( MAX_RES() );
	FArray3D_float Esave_position( 3, MAX_POS, MAX_RES() );
	FArray2D_float save_centroid( 3, MAX_RES() );
	FArray3D_float save_full_coord( 3, MAX_ATOM(), MAX_RES() );
//	FArray2D_float save_hetero_atom_coord( 3, HETERO_ATOM_MAX() );
//kwk replaced by a standard vector of xyzVectors
	std::vector<numeric::xyzVector_float> save_hetero_atom_coord;
	FArray1D_int save_res( MAX_RES() );
	FArray1D_int save_res_variant( MAX_RES() );
	bool hijack = { false };
}

namespace unpack_refoldchi_share {
	FArray2D_bool update_chi( MAX_CHI, MAX_RES() );
	FArray2D_float new_chi( MAX_CHI, MAX_RES() );
}

namespace brent_common {
	float brent_abs_tolerance = { 0.01 };
}

namespace F1COM {
	//rhiju Increased NMAX by a factor of 10 to allow bond distances and angles to be minimized.
	Dimension const NMAX( MAX_RES() * total_torsion * 10 );
	int NCOM;
	FArray1D_float PCOM( NMAX );
	FArray1D_float XICOM( NMAX );
}

namespace func_switch {
	int switch_value = { 0 };
	int func_evals;
}

namespace linmin_param {
	float ax_init = { 0.0 };
	float xx_init = { 1.0 };
	float bx_init = { 2.0 };
}

}
