// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13347 $
//  $Date: 2007-03-08 04:43:32 -0800 (Thu, 08 Mar 2007) $
//  $Author: ion $

#ifndef INCLUDED_minimize_ns
#define INCLUDED_minimize_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>
// C++ headers
#include <vector>

namespace minimize_ns {


//--------minimizer options --------------------------------------
//    (could be set by command line or in options.cc)

//  flags to control exclusions

//  flags to control local minimization

//  tolerance for gradient minimization functions

namespace minimize_options {
	extern bool minimize_vary_phipsi_default;
	extern bool minimize_vary_omega_default;
	extern bool minimize_vary_chi_default;
	extern bool minimize_vary_rb_angle_default;
	extern bool minimize_vary_rb_trans_default;
	extern bool minimize_excludeH_default;
	extern bool minimize_excludeE_default;
	extern bool minimize_local_min_default;
	extern int minimize_local_window_default;
	extern float minimize_tolerance_default;
}
using namespace minimize_options;


//---------minimizer state-----------------------------------------
//  flags to control which torsion angles are included in minimization

//  flags to control exclusions

//  flags to control local minimization

//  tolerance for gradient minimization functions

namespace minimize_state {
	extern bool minimize_vary_phipsi;
	extern bool minimize_vary_omega;
	extern bool minimize_vary_chi;
	extern bool minimize_vary_rb_angle;
	extern bool minimize_vary_rb_trans;
	extern bool minimize_excludeH;
	extern bool minimize_excludeE;
	extern bool minimize_local_min; // minimize locally only
	extern int minimize_local_window;
	extern float minimize_tolerance;
	extern float const rb_translation_scale_factor;
}
using namespace minimize_state;


//---------minimizer data-----------------------------------------
//car variables for pack_torsion

namespace minimizer_data {
	extern FArray1D_int angle_map;
	extern FArray1D_int angle_type;
	extern FArray1D_int angle_direction; // new!
	extern int map_length;
//	extern FArray1D_bool resinmap;
	extern FArray2D_bool minimize_allow_torsion; // new logic
	extern int minimize_fold_begin;
	extern int minimize_fold_end;
}
using namespace minimizer_data;


//--- minimizer exclusion list state------------------------------

namespace exclude_list_state {
	extern bool minimize_exclude_list_init;
}
using namespace exclude_list_state;

namespace deriv_precalc {
	extern float vdw_factor;
	extern float tether_factor;
	extern float fa_rep_factor;
	extern float fa_atr_factor;
	extern float fa_solv_factor;
}

namespace save_pose {
	extern FArray1D_float save_phi;
	extern FArray1D_float save_psi;
	extern FArray1D_float save_omega;
	extern FArray3D_float Esave_position;
	extern FArray2D_float save_centroid;
	extern FArray3D_float save_full_coord;
	extern std::vector<numeric::xyzVector_float> save_hetero_atom_coord;
	extern FArray1D_int save_res;
	extern FArray1D_int save_res_variant;
	extern bool hijack;
}

namespace unpack_refoldchi_share {
	extern FArray2D_bool update_chi;
	extern FArray2D_float new_chi;
}

namespace brent_common {
	extern float brent_abs_tolerance;
}

namespace F1COM {
	extern Dimension const NMAX;
	extern int NCOM;
	extern FArray1D_float PCOM;
	extern FArray1D_float XICOM;
}

namespace func_switch {
	extern int switch_value;
	extern int func_evals;
}

namespace linmin_param {
	extern float ax_init;
	extern float xx_init;
	extern float bx_init;
}

}


#endif
