// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13027 $
//  $Date: 2007-02-22 13:32:38 -0800 (Thu, 22 Feb 2007) $
//  $Author: yab $


// Rosetta Headers
#include "misc.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2Dp.hh>
#include <ObjexxFCL/FArray3Dp.hh>

#include <cstdlib>
#include <iostream>
// Using
using namespace param;


namespace misc {


//--------
// query
//--------


namespace ints {
	int total_residue = { -1 };
	FArray1D_int res( MAX_RES(), 0);
	int total_domains;
	FArray1D_int domain_end( MAX_SEGMENTS );
}


namespace chars {
	FArray1D_string residue3( MAX_RES(), std::string( 3, ' ' ) );
	FArray1D_char residue1( MAX_RES(), ' ' );
}


//car atom and centroid types for atom_vdw tables:
//car 1 = N,2 = CA,3 = CB,4 = C,5 = O,6-25 = centroids

namespace radii {
	FArray1D_short atom_type( MAX_POS * MAX_RES() );
	FArray2Dp_short Eatom_type( atom_type, MAX_POS, MAX_RES() ); // 2D view
	FArray1D_short atom_type_cen( MAX_RES() );
}

namespace sstype {
	std::string sstype( "xx" );
}

//-------
// decoy
//-------


//  current

namespace current_pose {
	FArray2D_float position( 3, MAX_POS * MAX_RES(), 0.0f );
	FArray3Dp_float Eposition( position, 3, MAX_POS, MAX_RES() ); // 3D view
	FArray2D_float centroid( 3, MAX_RES(), 0.0f );
	FArray1D_float phi( MAX_RES(), 0.0f );
	FArray1D_float psi( MAX_RES(), 0.0f );
	FArray1D_float omega( MAX_RES(), 0.0f );
	FArray3D_float full_coord( 3, MAX_ATOM(), MAX_RES(), 0.0f );
	FArray1D_int res_variant( MAX_RES(), 1 ); //bk set all amino acids to aa_variation 1
	FArray1D_string name( MAX_RES(), std::string( 4, ' ' ) );
	FArray1D_char secstruct( MAX_RES(), ' ' );
	FArray3D_float centroid_parm_eachres( 5, DRange( -1, 1), MAX_RES(), 0.0f );
}


// last accepted

namespace best_pose {
	FArray3D_float best_full_coord( 3, MAX_ATOM(), MAX_RES(), 0.0f );
	FArray2D_float best_position( 3, MAX_POS * MAX_RES(), 0.0f );
	FArray3Dp_float Ebest_position( best_position, 3, MAX_POS, MAX_RES() ); // 3D view
	FArray2D_float best_centroid( 3, MAX_RES(), 0.0f );
	FArray1D_float best_phi( MAX_RES() );
	FArray1D_float best_psi( MAX_RES(), 0.0f );
	FArray1D_float best_omega( MAX_RES(), 0.0f );
	FArray1D_int best_res( MAX_RES(), 0 );
	FArray1D_int best_res_variant( MAX_RES(), 1 );
	FArray1D_string best_name( MAX_RES(), std::string( 4, ' ' ) );
	FArray1D_char best_secstruct( MAX_RES(), ' ' );
	FArray3D_float best_centroid_parm_eachres( 5, DRange( -1, 1), MAX_RES(), 0.0f );
}

}

//pb: temporary just to get things working:
namespace pose_flag_ns {
	bool pose_flag_setting( false );
}
void set_pose_flag(
	const bool setting
)
{
	using namespace pose_flag_ns;
	if ( setting == pose_flag_setting ) return;
//	std::cout << "setting pose_flag from: " << pose_flag_setting <<	" to: " <<
//		setting << std::endl;
	pose_flag_setting = setting;
}

