// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13347 $
//  $Date: 2007-03-08 04:43:32 -0800 (Thu, 08 Mar 2007) $
//  $Author: ion $


// Rosetta Headers
#include "namespace_low_pose.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>

// Using
using namespace param;


namespace low_pose {
	FArray1D_float low_phi( MAX_RES() );
	FArray1D_float low_psi( MAX_RES() );
	FArray1D_float low_omega( MAX_RES() );
	FArray3D_float Elow_position( 3, MAX_POS, MAX_RES() );
	FArray1D_int low_res( MAX_RES() );
	FArray2D_float low_centroid( 3, MAX_RES() );
	FArray3D_float low_full_coord( 3, MAX_ATOM(), MAX_RES() );
	std::vector<numeric::xyzVector_double> low_hetero_atom_coord;
//	FArray2D_float low_hetero_atom_coord( 3, HETERO_ATOM_MAX() ); // low_coordinates
	FArray1D_int low_res_variant( MAX_RES() );
	FArray1D_string low_name( MAX_RES(), std::string( 4, ' ' ) );
	FArray1D_char low_secstruct( MAX_RES(), ' ' );
	FArray3D_float low_centroid_parm_eachres( 5, DRange( -1, 1), MAX_RES(), 0.0f );
}
