// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8380 $
//  $Date: 2006-05-15 20:52:03 -0700 (Mon, 15 May 2006) $
//  $Author: murphp $


// Rosetta Headers
#include "nblist_ns.h"
#include "param.h"
#include "param_torsion.h"

// ObjexxFCL Headers
#include <ObjexxFCL/DimensionExpressions.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>

// Using
using namespace param;
using namespace param_torsion;


namespace nblist {


//car length of all atom list
int const undefined_global_atm = { -10 };
 // // ctsa -switched this to -10 so that the
	//// ha in contraints mode could keep
	//// its -1 value

//car conversions between all atom lists and residue and atom numbers
//car atoms are numbered starting from residues at the nterminus
//car within each residue, the atom order is
//car centroid: n,(hn),ca,(ha),(cb,centroid/sc),c,o


//car pointers into residue and atom lists
//	FArray1D_int global_atm_num2res_atm_num_map_start( MAX_RES() );

//car neighbor lists

//car neighbor list lengths
//car  for global_atm_num2res_num_map(nb(k,i)) < global_atm_num2res_num_map(i)  (ie nb nterminal to i)
//car    neighbors are listed in ascending order (n to c)
//car  for global_atm_num2res_num_map(nb(k,i)) < global_atm_num2res_num_map(i)  (ie nb cterminal to i)
//car        nb's are listed desending order (c to n)
//car intraresidue neighbors are on the list

//car relevant list portion (ie avoid double counting ie i > j & constant regions
//car for a scoring function, only neighbors nb_start(i) to nb_end(i) must
//car be evaluated

//car


int const MAX_NB = { 500 };


// <murphp>
// //car parameters for total number of total atoms
// //car  +2 here because constraints have a separate atom number for HA and HN
// //car  (ie there are two copies of HA and HN)
// Dimension const MAX_TOTAL_ATOMS( ( MAX_ATOM() + 2 ) * MAX_RES() ); // residues in protein chain

Dimension MAX_TOTAL_ATOMS; // the total # of atoms which we will subsequently be changing at the beginning of setup_allatom_list

// </murphp>

namespace nb_list {
	int total_atoms;
	FArray1D_int global_atm_num2res_num_map( MAX_TOTAL_ATOMS );
	FArray1D_int global_atm_num2res_atm_num_map( MAX_TOTAL_ATOMS );
	FArray2D_int res_atm_num2global_atm_num_map( DRange( -1, MAX_ATOM() ), MAX_RES() );
	FArray2D_int torsion2rigid_body_start_map( total_torsion, MAX_RES() );
	FArray2D_int nb( MAX_NB, MAX_TOTAL_ATOMS );
	FArray1D_int nb_len( MAX_TOTAL_ATOMS ); // neighbors relevant for LJ/vdw
	FArray1D_int drv_nb_len( MAX_TOTAL_ATOMS ); // neighbors relevant for deriv
	FArray1D_int nb_start( MAX_TOTAL_ATOMS );
	FArray1D_int nb_end( MAX_TOTAL_ATOMS );
}


namespace bestnb_list {
	FArray2D_int best_nb( MAX_NB, MAX_TOTAL_ATOMS );
	FArray1D_int best_nb_len( MAX_TOTAL_ATOMS );
	 // neighbors relevant for LJ/vdw
	FArray1D_int best_nb_start( MAX_TOTAL_ATOMS );
	FArray1D_int best_nb_end( MAX_TOTAL_ATOMS );
}


} // namespace nblist
