// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17778 $
//  $Date: 2007-10-14 15:40:32 -0700 (Sun, 14 Oct 2007) $
//  $Author: andre $

#ifndef INCLUDED_orient_rms
#define INCLUDED_orient_rms


#include <numeric/xyzVector.hh>
// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

#include <vector>
#include <list>


// orient_rms Function Declarations


void
calc_rms();


void
calc_dme( float & dme_err );


void
fast_rms_to_native(
	FArray2DB_float const & p2,
	float & fast_rms
);


void
orient_rms_to_native(
	FArray2Da_float p2,
	float & fast_rms
);


void
orient_rms(
	FArray3Da_float p1,
	FArray3Da_float p2,
	int nres,
	float & fast_rms
);


void
orient_region(
	int nres, // logical size of  coordinate
	FArray3Da_float xyz1, // coordinate array
	FArray3Da_float xyz1_full, // full_coord to be moved
	FArray3Da_float xyz2, // coordinate array
	int alignregions, // number of contig regions to align over
	FArray1Da_int alignstart,
	FArray1Da_int alignend,
	int rmsregions, // number of contig regions to calc rms over
	FArray1Da_int rmsstart,
	FArray1Da_int rmsend,
	float & rms
);


void
fast_rms_x(
	FArray2Da_float p1,
	FArray2Da_float p2,
	float & fast_rms
);


void
fast_region_rms_x(
	int nres, // logical size of  coordinate
	FArray3Da_float xyz1, // coordinate arrays
	FArray3Da_float xyz2,
	int alignregions, // number of contig regions to align over
	FArray1Da_int alignstart,
	FArray1Da_int alignend,
	int rmsregions, // number of contig regions to calc rms over
	FArray1Da_int rmsstart,
	FArray1Da_int rmsend,
	float & rms
);


void
fast_rms_ca(
	FArray2Da_double p1,
	FArray2Da_double p2,
	int nres,
	float & fast_rms
);

/// @brief compares second list of points with first list of points
/// returning index of the set of points in the second list that
/// is most different in terms of rms from the points in the first
/// list. The return value is the minimum rms of the set to any set
/// in the first list
//kwk
float
calc_rms_maximal_minimal_rms(
	std::list< std::vector < numeric::xyzVector< double > > > & points1,
	std::list< std::vector < numeric::xyzVector< double > > > & points2,
	std::list< std::vector < numeric::xyzVector< double > > > & resulting_vector,
	size_t max_size_of_points1,
	float minimal_rms_limit
);

/// @brief wrapper function to superimpose and then calculate rms of
/// two vector of points
//kwk
float
calc_rms_wrapper(
	std::vector< numeric::xyzVector< double > > & points1,
	std::vector< numeric::xyzVector< double > > & points2
);

void
fast_rms_atoms(
	FArray2Da_double p1,
	FArray2Da_double p2,
	int nres,
	float & fast_rms
);

void
findUU(
	FArray2DB_double & XX,
	FArray2DB_double & YY,
	FArray1DB_double const & WW,
	int Npoints,
	FArray2DB_double & UU,
	double & sigma3
);


void
findUU_trans(
	FArray2Da_double XX,
	FArray2Da_double YY,
	FArray1Da_double WW,
	int Npoints,
	FArray2Da_double UU,
	double & sigma3,
	FArray1Da_double xx_offset,
	FArray1Da_double yy_offset
);


void
fixEigenvector( FArray2Da_double m_v );


void
UU_rotate(
	FArray2Da_float coord,
	int num,
	FArray1DB_double const & xx_off,
	FArray1DB_double const & yy_off,
	FArray2DB_double const & uu
);


void
calc_rms_fast(
	float & rms_out,
	FArray2Da_double xx,
	FArray2Da_double yy,
	FArray1Da_double ww,
	int npoints,
	double ctx
);


void
BlankMatrixMult(
	FArray2Da_double A,
	int n,
	int np,
	int transposeA,
	FArray2Da_double B,
	int m,
	int transposeB,
	FArray2Da_double AxB_out
);


void
BlankMatrixMult4(
	FArray2Da_float A,
	int n,
	int np,
	int transposeA,
	FArray2Da_float B,
	int m,
	int transposeB,
	FArray2Da_float AxB_out
);


void
MatrixMult(
	FArray2Da_double A,
	int n,
	int np,
	int transposeA,
	FArray2Da_double B,
	int m,
	int transposeB,
	FArray2Da_double AxB_out
);


void
MatrixMult4(
	FArray2Da_float A,
	int n,
	int np,
	int transposeA,
	FArray2Da_float B,
	int m,
	int transposeB,
	FArray2Da_float AxB_out
);


void
calc_residue_dist(
	FArray1D_float & residue_dist
);


void
get_gdtmm_scores(
	float & mm_1_1,
	float & mm_2_2,
	float & mm_3_3,
	float & mm_4_3,
	float & mm_7_4,
	float & gdtmm
);


void
shuffle_chains_for_symmetry(
   FArray2D_float & shuffled_position
);

void
shuffle_chains_for_symmetry(
  FArray2D_double & start,
  FArray2D_double & shuffled,
  int const N,
  int const nres,
  int const nres_monomer
);
#endif
