// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19866 $
//  $Date: 2008-01-23 11:54:04 -0800 (Wed, 23 Jan 2008) $
//  $Author: possu $

#ifndef INCLUDED_packer_weights
#define INCLUDED_packer_weights

#include<map>
#include<string>

#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/formatted.o.hh>


//jjh A fullatom packer weight class
// JSS this should manage the real weights, not just keep a copy.

class PackerWeights {

private:
	bool lock_;
  bool display_;

	FArray1D_float Waa_;
	float Wsol_;
	float Wdun_;
	float Wref_;
 	float WpH_;
	float Wone_;
	float Wpair_;
	float Wplane_total_;
	float Watr_;
	float Wrep_;
	float Wintra_;
	float Wh2o_;
	float Wh2o_intra_;
	float Wh2o_lj_;
	float Wh2o_hb_;

	float Whbond_bb_;
	float Whbond_sc_;
	float Whbond_bb_sc_;
	float Whb_srbb_; // JSS moved these score weights here in refactoring to change categorization
	float Whb_lrbb_;
	float Whb_sc_;

	float Wgb_elec_;
	float Wdna_bs_;
	float Wdna_bp_;
  float Wsasa_;

	float Wlig_rep_;
	float Wlig_atr_;
	float Wlig_h2o_;
	float Wlig_hb_;
	float Wlig_cou_;
	float Wlig_sol_;
	float Wlig_vir_;
  float Wele_;
		
	
	bool hbond_wts_nonzero_; // r

public:
//jjh I'm being stingy on the constructor since I don't want
//jjh people to assume how many weights there are in total.  People
//jjh tend to add them willy-nilly, and I want them to have
//jjh to consciously put in the data, and the set/get methods.

//JSS I collapsed the param_pack namespace into an instance of this class,
//JSS so I've changed the constructor to give the default weights.
	PackerWeights();

	//lin read the weights from the file
	void read_weight_file(std::string const & filename_in);
	void print();
  void set_lock() {lock_ = true;};
  void release_lock(){lock_ = false;};
  void set_display() {display_ = true;};
  void release_display() {display_ = false;};

private: // some helpful values/functions for controlling access/accessors
	bool should_update(std::string const & message, float const oldval = -999.0, float const newval = -9999.0) const; // check if changes & check lock
	void update_weight(std::string const & message, float & Weight, float const val) { // update a weight
		if (should_update(message, Weight, val)) Weight = val;
	};
	void check_hbond_nonzero() {
		hbond_wts_nonzero_ = hbond_bbwts_nonzero() || hbond_scwts_nonzero();
	}

public:
	//JSS special accessors

		void set_Whbond_bbsc(float const bb, float const sc, float const bb_sc) {
			if (should_update("Whbond_bb", Whbond_bb_, bb)
					|| should_update("Whbond_sc", Whbond_sc_, sc)
					|| should_update("Whbond_bb_sc", Whbond_bb_sc_, bb_sc)) {
				Whbond_bb_ = bb;
				Whbond_sc_ = sc;
				Whbond_bb_sc_ = bb_sc;
				check_hbond_nonzero();
			}
		}

		void set_Whb_srlrsc(float const sr, float const lr, float const sc) {
			if (should_update("Whb_srbb", Whb_srbb_, sr)
					|| should_update("Whb_lrbb", Whb_lrbb_, lr)
					|| should_update("Whb_sc", Whb_sc_, sc)) {
				Whb_srbb_ = sr;
				Whb_lrbb_ = lr;
				Whb_sc_ = sc;
				check_hbond_nonzero();
			}
		}

	bool hbond_wts_nonzero() { return hbond_wts_nonzero_; }
	bool hbond_bbwts_nonzero() { return Whbond_bb_ != 0.0 && (Whb_srbb_ != 0.0 || Whb_lrbb_ != 0.0); }
	bool hbond_scwts_nonzero() { return (Whbond_sc_ != 0.0 || Whbond_bb_sc_ != 0.0) && Whb_sc_ != 0.0; }

//JSS Each single weight WT has two accessors
//	float WT() const { return WT_; };
//	void set_WT(float const val) {update_weight("WT", WT_, val); };
//if you need more to happen on a set:
// 	void set_WT(float const val) {if(should_update("WT", WT_, val)) { WT_ = val; do_more_for_WT();}};

//jjh Permit setting the Waa array with either an array at one fell swoop
//jjh or by setting individual values by index

///Start Waa///

	float Waa( int const index ) const 	{ return Waa_( index ); } // return single value
	FArray1D_float const & Waa() const { return Waa_; } // return whole array

	void
	SetWaaWithArray( FArray1D_float const & Waa_a  )
	{
	  should_update("Waa array");
		Waa_ = Waa_a;
	}

	void
	set_Waa( int const index, float const val )
	{
		update_weight("Waa("+ I(3,index) + ")", Waa_(index), val);
	}

///End Waa///

	//lin setting and get the weight by name
	void
	SetWeight( std::string const & name, float const & value );

	float
	GetWeight( std::string const & name );

	float Wsol() const { return Wsol_;};
	void set_Wsol(float const val) { update_weight("Wsol", Wsol_, val); };
	float Wdun() const { return Wdun_;};
	void set_Wdun(float const val) { update_weight("Wdun", Wdun_, val); };
	float Wref() const { return Wref_;};
	void set_Wref(float const val) { update_weight("Wref", Wref_, val); };
	float WpH() const { return WpH_;};
	void set_WpH(float const val) { update_weight("WpH", WpH_, val); };
	float Wone() const { return Wone_;};
	void set_Wone(float const val) { update_weight("Wone", Wone_, val); };
	float Wpair() const { return Wpair_;};
	void set_Wpair(float const val) { update_weight("Wpair", Wpair_, val); };
	float Wplane_total() const { return Wplane_total_;};
	void set_Wplane_total(float const val) { update_weight("Wplane_total", Wplane_total_, val); };
	float Watr() const { return Watr_;};
	void set_Watr(float const val) { update_weight("Watr", Watr_, val); };
	float Wrep() const { return Wrep_;};
	void set_Wrep(float const val) { update_weight("Wrep", Wrep_, val); };
	float Wintra() const { return Wintra_;};
	void set_Wintra(float const val) { update_weight("Wintra", Wintra_, val); };
	float Wh2o() const { return Wh2o_;};
	void set_Wh2o(float const val) { update_weight("Wh2o", Wh2o_, val); };
	float Wh2o_intra() const { return Wh2o_intra_;};
	void set_Wh2o_intra(float const val) { update_weight("Wh2o_intra", Wh2o_intra_, val); };
	float Wh2o_lj() const { return Wh2o_lj_;};
	void set_Wh2o_lj(float const val) { update_weight("Wh2o_lj", Wh2o_lj_, val); };
	float Wh2o_hb() const { return Wh2o_hb_;};
	void set_Wh2o_hb(float const val) { update_weight("Wh2o_hb", Wh2o_hb_, val); };

	float Whbond_bb() const { return Whbond_bb_;};
	void set_Whbond_bb(float const val) { update_weight("Whbond_bb", Whbond_bb_, val); check_hbond_nonzero(); };
	float Whbond_sc() const { return Whbond_sc_;};
	void set_Whbond_sc(float const val) { update_weight("Whbond_sc", Whbond_sc_, val); check_hbond_nonzero(); };
	float Whbond_bb_sc() const { return Whbond_bb_sc_;};
	void set_Whbond_bb_sc(float const val) { update_weight("Whbond_bb_sc", Whbond_bb_sc_, val); check_hbond_nonzero(); };
	float Whb_srbb() const { return Whb_srbb_;};
	void set_Whb_srbb(float const val) { update_weight("Whb_srbb", Whb_srbb_, val); check_hbond_nonzero(); };
	float Whb_lrbb() const { return Whb_lrbb_;};
	void set_Whb_lrbb(float const val) { update_weight("Whb_lrbb", Whb_lrbb_, val); check_hbond_nonzero(); };
	float Whb_sc() const { return Whb_sc_;};
	void set_Whb_sc(float const val) { update_weight("Whb_sc", Whb_sc_, val); check_hbond_nonzero(); };

	float Wgb_elec() const { return Wgb_elec_;};
	void set_Wgb_elec(float const val) { update_weight("Wgb_elec", Wgb_elec_, val); };
	float Wdna_bs() const { return Wdna_bs_;};
	void set_Wdna_bs(float const val) { update_weight("Wdna_bs", Wdna_bs_, val); };
	float Wdna_bp() const { return Wdna_bp_;};
	void set_Wdna_bp(float const val) { update_weight("Wdna_bp", Wdna_bp_, val); };
	float Wsasa() const { return Wsasa_;};
	void set_Wsasa(float const val) { update_weight("Wsasa", Wsasa_, val); };
	float Wlig_rep() const { return Wlig_rep_;};
	void set_Wlig_rep(float const val) { update_weight("Wlig_rep", Wlig_rep_, val); };
	float Wlig_atr() const { return Wlig_atr_;};
	void set_Wlig_atr(float const val) { update_weight("Wlig_atr", Wlig_atr_, val); };
	float Wlig_h2o() const { return Wlig_h2o_;};
	void set_Wlig_h2o(float const val) { update_weight("Wlig_h2o", Wlig_h2o_, val); };
	float Wlig_hb() const { return Wlig_hb_;};
	void set_Wlig_hb(float const val) { update_weight("Wlig_hb", Wlig_hb_, val); };
	float Wlig_cou() const { return Wlig_cou_;};
	void set_Wlig_cou(float const val) { update_weight("Wlig_cou", Wlig_cou_, val); };
	float Wlig_sol() const { return Wlig_sol_;};
	void set_Wlig_sol(float const val) { update_weight("Wlig_sol", Wlig_sol_, val); };
	float Wlig_vir() const { return Wlig_vir_;};
	void set_Wlig_vir(float const val) { update_weight("Wlig_vir", Wlig_vir_, val); };
  float Wele() const { return Wele_; };
  void set_Wele(float const val) { update_weight("Wele", Wele_, val); };
};// class PackerWeights

#endif
