// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12328 $
//  $Date: 2007-01-30 05:08:39 -0800 (Tue, 30 Jan 2007) $
//  $Author: sheffler $


//Rosetta Headers
#include "packing_measures.h"
#include "after_opts.h"
#include "atom_is_backbone.h"
#include "RotamerDotsFWD.h"
#include "aaproperties_pack.h"
#include "decoystats.h" // for rsd_exposed_sasa
#include "design.h"
#include "FArray_xyz_functions.h"
//#include "files_paths.h"
#include "fullatom_extra_props.h"
#include "fullatom_sasa.h"
#include "fullatom_sasa_ns.h"
#include "pack_geom_inline.h"
#include "interface.h"
#include "ligand_ns.h"
#include "make_pdb.h"
#include "misc.h"
#include "namespace_options.h"
#include "native.h"
#include "orient_rms.h"
#include "param.h"
#include "param_aa.h"
#include "status.h"
#include "random_numbers.h"
#include "read_paths.h"
#include "rms.h"
#include "RotamerDots.h"
#include "template_pack.h"
#include "util_vector.h"
//KMa phospho_ser
#include "add_pser.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray4Da.hh>
#include <ObjexxFCL/FArray5Da.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/constants.hh>
#include <numeric/numeric.functions.hh>
#include <numeric/xyzMatrix.hh>
#include <numeric/xyzVector.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/vector1.hh>
#include <utility/io/izstream.hh>

// C++ Headers
#include <cmath>
#include <cstdlib>
#include <sstream>
#include <iosfwd>
#include <ostream>
#include <map>
#include <string>

#define N_PR_BIN 30
#define BALL_N_PR_BIN 30
#define SASA_CENTER_RADIUS 5.0f


namespace packing_ns {

	map<string,bool> packing_flags;
	namespace packing_options {
		float min_hole_radius             = 0.5f;    //holes smaller than this won't even be computed
		float max_hole_radius             = 9999.0f; // holes bigger than this won't be reported ( >3A aren't computed )
		float cavity_burial_probe_radius    = 1.4f;    // probe radius for pruning out exposed "cavity balls"
		float max_hole_sasa               = 0.0001f; // sasa limit for hole to be considered buried
		//int   min_cluster_size            = 0;       // clusters below this size won't be in packing_pdb
		//int   min_cluster_size_aspiration = 4;       // clusters at least this big will always show up in the packing pdb
		float min_cluster_surface_area    = 35.0f; // cater mol. is about 25
		float min_cluster_volume          = 20.0f; // water mol. is about 11
		float min_cluster_ball_radius     = 0.0f;		 // clusters which don't have at least one ball bigger than
		float max_cluster_ball_radius     = 999.f;	 // clusters which have a ball bigger than
																								 // this will be ignored, unless sufficient size (see aspiration above)
		int   rms_occ_ball_radius         = -1;

		// these options are still legit, but they're handled through the options map
		//bool  compute_complete_burial     = false;   // iterate hole burial computation until convergence, no matter how long
		//bool  holes_bury_holes            = true;    // all holes to bury other holes for pruning (yes, this actually makes sense)
		//bool  compute_rms_stats           = true;    // compute lots of rms data along with packing stats
		//bool  stats_ignore_exposed_holes  = true;		 // don't consider exposed holes
		//bool  skip_missing_density        = false;   // attempts to be smart about incomplete natives/decoys (experimental!)

	}

  using namespace param;

	bool heavy_atoms_only = false;

  int const pr_bin_5  = N_PR_BIN+1- 5;
  int const pr_bin_9  = N_PR_BIN+1- 9;
  int const pr_bin_14 = N_PR_BIN+1-14;
  int const pr_bin_20 = N_PR_BIN+1-20;
  int const pr_bin_30 = N_PR_BIN+1-30;
	int const n_pr_bin  = N_PR_BIN;
  int const	max_sasa_offset_bins = 50;

  unsigned int const HUGE_UNSIGNED_INT = 1234567890;

	int const N_CAVBALL_DISBINS = 10;

	FArray3D_float rsq_min( MAX_ATOMTYPES(), MAX_ATOMTYPES(), N_PR_BIN );
	//void ballsasa_probe_radii_decrement_initializer(ObjexxFCL::FArray1D_float&);

	int const N_DIM_S20 = 501;
	int const N_DIM_S09 = 601;
	FArray1D_float bsasa920_weights;
	FArray2D_float bsasa920_quantiles;
	FArray2D_float sasa_dot_locations;
	FArray2D_int   sasa_dot_neighbors;
	FArray1D_float ballsasa_probe_radii;
	void sasa_dot_locations_initializer();
	void ballsasa_probe_radii_decrement_initializer();
	bool read_bsasa920_quantiles();


	void initialize_packing_measures() {
		packing_initialize_options();

		if ( packing_flags["fasc_cols"] ) { // any packing flags
			using namespace score_file_ns;
			new_float_cols["packing"]   = -1234;
			new_int_cols  ["length"]    = -1234;
			new_float_cols["packprune"] = -1234;
			new_int_cols  ["num_holes"] = -1234;
			// lots of stuff about clusters could be added here
		}


	}



	void packing_initialize_options()
	{
		static bool init = false;
		if ( ! init ) {

			using namespace packing_options;
			packing_flags["min_hole_radius"]             = false;
			packing_flags["max_hole_radius"]             = false;
			packing_flags["cavity_burial_probe_radius"]    = false;
			packing_flags["max_hole_sasa"]               = false;
			packing_flags["min_cluster_volume"]          = false;
			packing_flags["min_cluster_surface_area"]    = false;
			//packing_flags["min_cluster_size_aspiration"] = false;
			packing_flags["min_cluster_ball_radius"]     = false;
			packing_flags["max_cluster_ball_radius"]     = false;
			packing_flags["compute_complete_burial"]     = false;
			packing_flags["holes_dont_bury_holes"]       = false;
			packing_flags["compute_rms_stats"]           = false;
			packing_flags["stats_ignore_exposed_holes"]  = false;
			packing_flags["skip_missing_density"]        = false;
			packing_flags["no_prune"]                    = false;
			packing_flags["absolute_rms_occ"]            = false;
			packing_flags["relative_rms_occ"]            = false;
			packing_flags["output_all_cavity_balls"]     = false;
			packing_flags["fasc_cols"] = false; // this one we need to know about
			for( int ii=0; ii < options::arg_count; ii++ ) {
				string arg = options::arg_vector[ii];
				if( arg.substr(0,9) == "-packing_" ) {
					arg = arg.substr(9);
					if ( packing_flags.count(arg) ) {
						cout <<  "packing_measures: enabling option: " << arg << endl;
						packing_flags[ arg ] = true; // at this point, anything is valid
					} else {
						cout <<  "packing_measures: don't rcognise option: " << arg << endl;
						exit(-1);
					}
				}
			}

      if ( packing_flags["min_hole_radius"] )
        min_hole_radius =              realafteroption("packing_min_hole_radius");
      if ( packing_flags["max_hole_radius"] )
				max_hole_radius =              realafteroption("packing_max_hole_radius");
			if ( packing_flags["cavity_burial_probe_radius"] )
				cavity_burial_probe_radius =     realafteroption("packing_cavity_burial_probe_radius");
      if ( packing_flags["max_hole_sasa"] )
				max_hole_sasa =                realafteroption("packing_max_hole_sasa");
      if ( packing_flags["min_cluster_volume"] )
        min_cluster_volume =           realafteroption("packing_min_cluster_volume");
      if ( packing_flags["min_cluster_surface_area"] )
        min_cluster_surface_area =     realafteroption("packing_min_cluster_surface_area");
			//if ( packing_flags["min_cluster_size_aspiration"] )
        //min_cluster_size_aspiration =   intafteroption("packing_min_cluster_size_aspiration");
			if ( packing_flags["min_cluster_ball_radius"] )
        min_cluster_ball_radius      = realafteroption("packing_min_cluster_ball_radius");
			if ( packing_flags["max_cluster_ball_radius"] )
        max_cluster_ball_radius      = realafteroption("packing_max_cluster_ball_radius");
			if ( packing_flags["absolute_rms_occ"] )
				rms_occ_ball_radius          = intafteroption("packing_absolute_rms_occ");
			if ( packing_flags["relative_rms_occ"] )
				rms_occ_ball_radius          = intafteroption("packing_relative_rms_occ");
			init = true;

		}
	}



CavityBallCluster::CavityBallCluster(int const id, vector1<CavityBall*> const balls) :
	id_(id),
	largest_cavity_ball_radius_(-1234),
	surface_area_(-1234),
	volume_(-1234)
{
	cavity_balls_ = balls;
	for(int ii=1; ii<=(int)balls.size();ii++) {
		if (balls[ii]->radius_ > largest_cavity_ball_radius_ ) {
			largest_cavity_ball_radius_ = balls[ii]->radius();
		}
	}

	sort< vector1<CavityBall*>::iterator >( cavity_balls_.begin(), cavity_balls_.end() );

}

void CavityBallCluster::compute_surface_area()
{
	; //TODO
}



void CavityBallCluster::compute_volume()
{
	; // TODO
}

string const CavityBallCluster::str() const
{
	ostringstream s;
	s << "CavClust "
		<< I(5,id_) << ' '
		<< F(6,2, largest_cavity_ball_radius_) << ' '
		<< F(8,2, surface_area() ) << ' '
		<< F(8,2, volume() ) << ' '
		<< ' ';
	for (int ii=1; ii<=(int)cavity_balls_.size(); ii++) {
		s << cavity_balls_[ii]->id() << ' ';
	}
	return s.str();

}


CavityBall::CavityBall(int const id,
											 int const atom, int const res,
											 float const x, float const y, float const z,
											 float const r):
atom_(atom),
res_(res),
xyz_(x,y,z),
radius_(r),
sasa_(-1234.0f),
surrounding_sasa_(N_CAVBALL_DISBINS,30,0.0f),
//surrounding_sasa_5A_(30,0.0f),
heavyatom_(false),
num_other_balls_overlap_(-1234),
num_buried_other_balls_overlap_(-1234),
num_big_other_balls_overlap_(-1234),
num_big_buried_other_balls_overlap_(-1234),
cluster_id_(-1234),
id_(id),
cluster_(NULL)
{

	hole_sasa_     .clear();
	hole_sasa_     .resize(N_PR_BIN,0);

	neighbor_count_.clear();
	avg_bfactor_   .clear();
	avg_occupancy_ .clear();
	absolute_shell_rms_.clear();
	relative_shell_rms_.clear();
	neighbor_count_.resize(N_CAVBALL_DISBINS,-1234);
	avg_bfactor_   .resize(N_CAVBALL_DISBINS,-1234);
	avg_occupancy_ .resize(N_CAVBALL_DISBINS,-1234);
	absolute_shell_rms_.resize(N_CAVBALL_DISBINS,-1234);
	relative_shell_rms_.resize(N_CAVBALL_DISBINS,-1234);

}


bool CavityBall::cmp( CavityBall * a, CavityBall * b ) {
	return a->radius() > b->radius();
}

bool CavityBall::overlaps( CavityBall const *b ) const {
	return distto(b) < -0.5;
}

string const CavityBall::str() const {
		ostringstream oss;
		oss << "CavityBall "
			<< I(4,id_)
			<< I(4,res_)
			<< I(4,atom_)
			<< F(8,3,radius_)
			<< F(8,3,sasa_)
			<< I(5, num_other_balls_overlap_ )
			<< I(5, num_buried_other_balls_overlap_ )
			<< I(5, num_big_other_balls_overlap_ )
			<< I(5, num_big_buried_other_balls_overlap_ )
			<< ' ' << xyz_.x() << ',' << xyz_.y() << ',' << xyz_.z()
			<< ' ';
		for (int ii=1; ii <= (int)big_buried_neighboring_cavity_balls_.size(); ii++) {
			oss<< big_buried_neighboring_cavity_balls_[ii]->id_ << ' ';
		}
		return oss.str();
	}

	// new convention is to use rosetta atom# for atom# line
	// and 500 + rosetta res# for res number
	// before, atom# was 10 x radius and res# was
	// hole index in proteinSasa's cavity_balls_ array
  string const CavityBall::heteroAtomLine( int const hetresnum, float const occ ) const
	{
    return "HETATM" + I( 5, ( id_ ) ) + "  V   WSS Z"
		+ I( 4, hetresnum ) + "    "
		+ F( 8, 3, xyz_(1) ) + F( 8, 3, xyz_(2) ) + F( 8, 3, xyz_(3) )
		+ F( 6, 2, occ ) + ' ' + F( 5, 2, radius_ );
  }

  ProteinSasa::ProteinSasa() {
		done_init_ = false;
	}

  ProteinSasa::~ProteinSasa() {
    ;// delete residues
  }

  bool ProteinSasa::init() {
    bool v = true;
    // from fullatom sasa

    if ( ! done_init_ ) {

			packing_initialize_options();

			bsasa_score_              = -1234.0f;
			bsasa_score_weighted_     = -1234.0f;
			bsasa_score_log_          = -1234.0f;
			bsasa_score_weighted_log_ = -1234.0f;
			bsasa_score_pruned_       = -1234.0f;

			sasa_dot_locations_initializer();
      ballsasa_probe_radii_decrement_initializer();
      input_sasa_dats();
      read_bsasa920_quantiles();
      //bsasa920_weights_.dimension(501,-1234.0f);
      //bsasa920_quantiles_.dimension(501,601,-1234.0f);
			//input_sasa_dats();
      //read_bsasa920_quantiles(501,601,bsasa920_quantiles_, bsasa920_weights_);

      for(int ii = 1; ii <= (int)fullatom_ex_props::aradii.size1(); ii++)
				atom_radii_[(AtomType)ii] = fullatom_ex_props::aradii(ii);
      valid_ = false;
      cavity_ball_burial_computed_ = false;
      done_init_ = true;

      cavity_balls_.clear();
			bsasa_score_pruned_ = -1234;
			num_buried_cavity_balls_  = -1234;
			num_exposed_cavity_balls_ = -1234;

			// defaults, used to be params to corresponding functions
			// can be set with public functions for object

			init_MAX_RES();
		} else if ( res_bsasa_score_.size() != unsigned(misc::total_residue) ) {
			// if MAX_RES has changed, re-initialize several arrays
			init_MAX_RES();
		}

    return v;
  }

bool ProteinSasa::init_MAX_RES() {
		bool v = true;
	// from fullatom sasa

		rsd_sasa_.dimension(packing_ns::n_pr_bin, MAX_RES(), -1234.0f );
		atom_sasa_.dimension(packing_ns::n_pr_bin, MAX_ATOM(), MAX_RES(), -1234.0f );
		atom_sasa_center_.dimension(3, MAX_ATOM(), MAX_RES(), 0.0f );
		atom_sasa_dots_.dimension(packing_ns::n_pr_bin,  MAX_ATOM(), MAX_RES(), HUGE_UNSIGNED_INT );
		atom_bsasa_score_.dimension(MAX_ATOM(),MAX_RES(),-1234);
		atom_bsasa_score_weighted_.dimension(MAX_ATOM(),MAX_RES(),-1234);
		ball_atom_sasa_count_.dimension(packing_ns::n_pr_bin,MAX_ATOM(),MAX_RES(),-1234);
		ball_atom_sasa_area_.dimension(packing_ns::n_pr_bin,MAX_ATOM(),MAX_RES(),-1234);
		largest_probe_radius_bin_.dimension(MAX_ATOM(),MAX_RES(),N_PR_BIN);
		res_bsasa_score_.dimension(MAX_RES(),-1234.0f);
		atom_sasa_masks_.dimension(fullatom_sasa::nbytes, MAX_ATOM(), MAX_RES(), packing_ns::n_pr_bin );

    return v;
  }


  void ProteinSasa::update() {
		//cerr << "init" << endl;
    init();
		//cerr << "done init, sasa routine next" << endl;
		phils_sasa_routine();
		//cerr << "done sasa, returning" << endl;
    return;
  }

  bool ProteinSasa::precompute_sasa(float const radius) {
    float tmp = radius;
    //valid_ = true;
    return tmp == radius;
  }

  bool ProteinSasa::precompute_sasa_multiple_radii(vector<float> const radii) {
    vector<float> tmp = radii;
    //valid_ = true;
    return false;
  }

  void ProteinSasa::set_atom_radii( FArray1D_float const & radii ) {
    //atom_radii_.clear();
    assert( radii.size1() <= atom_radii_.size() );
    for(int ii = 1; ii <= (int)radii.size1(); ii++)
      atom_radii_[(AtomType)ii] = radii(ii);
    valid_ = false;
  }

  void ProteinSasa::set_atom_radii( vector<float>  const & radii ) {
    //atom_radii_.clear();
    assert( radii.size() <= atom_radii_.size() );
    for(int ii = 1; ii <= (int)radii.size(); ii++)
      atom_radii_[(AtomType)ii] = radii[ii];
    valid_ = false;
  }


// here is where small/big balls get filtered out... as well as exposed one of course
string ProteinSasa::getHeteroAtoms( bool const require_size_ok,
																		bool const require_buried,
																		bool const require_cluster_ok ) const
{
	using namespace packing_options;
	string s;
	int const max_res = MAX_RES()();

	if ( packing_flags["output_all_cavity_balls"] )
		for (int ii=1; ii <= (int)cavity_balls_.size(); ++ii)
			s += cavity_balls_[ii].heteroAtomLine( max_res + ii, -1 ) + "\n";

	for ( int cluster = 1; cluster <= (int)cavity_ball_clusters_.size(); cluster++ ) {
		CavityBallCluster const * const cbc = &cavity_ball_clusters_[cluster];
		s += "COMMENT " + cbc->str() + '\n'; // this prints meta-info about the cluster...
		for (int ii = 1; ii <= (int)cbc->size(); ii++) {
			CavityBall *cb = cbc->cavity_ball(ii);
			if ( !cavity_ball_all_ok( cb->id() , require_size_ok,require_buried,require_cluster_ok )   )
				s += "COMMENT ";
			float occ = cb->cluster_id_;
			if ( packing_flags["absolute_rms_occ"] ) {
				occ = cb->absolute_shell_rms_[ rms_occ_ball_radius ];
				cout <<  "packing_measures: using absolte rms in occ col " << rms_occ_ball_radius << endl;
			}
			if ( packing_flags["relative_rms_occ"]) {
				occ = cb->relative_shell_rms_[ rms_occ_ball_radius ];
				cout <<  "packing_measures: using relative rms in occ col " << rms_occ_ball_radius << endl;
			}
			s += cb->heteroAtomLine( max_res + cluster, occ ) + "\n";
		}
	}
	return s;

}



			 //327 344 44 340
	// this is pretty basic...
  void ProteinSasa::print_all_holes() const {
    for( int ii = 1; ii <= (int)cavity_balls_.size(); ii++) {
      CavityBall h = cavity_balls_[ii];
			cout << h.str() << endl;
    }

  }

void ProteinSasa::print_all_clusters() const {
	for ( int ii=1; ii<=(int)cavity_ball_clusters_.size(); ii++) {
		cout <<  cavity_ball_clusters_[ii].str() << endl;
	}
}



  // why do I get less hetatms in the pdb than in cavity_balls_? ???????????????? !!!!!!!!!! TODO
void ProteinSasa::output_packing_statistics( utility::io::ozstream & out,
																						 string const decoy_id,
																						 bool const require_size_ok   , // defaults here are
																						 bool const require_buried    , // pretty permissive
																						 bool const require_cluster_ok ) //const -- not const yet...
{
    using namespace misc;

    //cout <<  "PACKING: output_packing_stats! " << decoy_id << endl;

    if( ! valid_ ) {
			cout << "packing_measures: can't output packing status until initialized" << endl;
			exit(-1);
		}

    if( ! cavity_ball_burial_computed_ )
			cout << "packing_measures: can't output packing status until hole burial computed" << endl;

    for( int ii = 1; ii <= (int)cavity_balls_.size(); ii++ ) {
			if ( !cavity_ball_all_ok( ii, require_size_ok, require_buried, require_cluster_ok ) ) {
				continue;
			}
			CavityBall * h =	&cavity_balls_[ii];
			if( h->sasa_ > 0.0f )
				continue;

			// BETTER TO REINIT HERE!!!! change this & make sure to init to -1234 rather than 0
			//h->surrounding_sasa_(dis_bin,pr) = 0.0f;
			//h->neighbor_count_[dis_bin] = 0;
			//h->neighbor_count_5A_ = 0;

			for( int pr = packing_ns::n_pr_bin; pr >= 1; pr-- ) { // higher pr_bin = smaller probe...
				int const pr_bin = n_pr_bin - pr + 1;
				// for each hole and probe size, remember ball's sasa
				h->hole_sasa_[pr] = sasa_of_sphere( h->xyz_, h->radius_, (float)pr / 10.0f );

				for(int res = 1; res <= misc::total_residue; res++ ) {
					int  aai = misc::res(res);
					int  aav = misc::res_variant(res);
					//if( aai>20 || aav!=1 ) // HETERO PROBLEM?!?!
					//	continue;

					for(int atom = 1; atom <= aaproperties_pack::natoms(aai,aav); atom++) {
						if ( packing_flags["skip_missing_density"] && pdb::missing_input_atom(atom,res) ) {
							cerr << "skip missing atom: " << atom << ',' << res << endl ;
							goto LsasaNextBall;
						}
						int const at = aaproperties_pack::fullatom_type(atom,aai,aav);
						if( heavy_atoms_only && 22 <= at && at <= 25 ) continue;
						//						if( at == 26 ) continue;
						if ( packing_flags["stats_ignore_exposed_holes"] && atom_sasa_(1,atom,res) > 0) // !!!! if exposed to largest probe
							continue;

						float const xx = abs( h->xyz_.x() - full_coord(1,atom,res) );
						float const yy = abs( h->xyz_.y() - full_coord(2,atom,res) );
						float const zz = abs( h->xyz_.z() - full_coord(3,atom,res) );
						float const dis2 = xx*xx + yy*yy + zz*zz;

						//if( dis2 <= 25. ) {
						//	if (pr_bin == n_pr_bin )
						//		h->neighbor_count_5A_++;
						//	h->surrounding_sasa_5A_(pr) += atom_sasa(pr_bin,atom,res);
						//}

						for( int dis_bin = N_CAVBALL_DISBINS; dis_bin >= 1; dis_bin-- ) {
							float const d = (float)dis_bin ;
							float const dis_thresh = d + h->radius_;
							// now loop over all atoms and get stats for those within d;
							if( xx > dis_thresh ) { break; }
							if( yy > dis_thresh ) { break; }
							if( zz > dis_thresh ) { break; }
							if( dis2 > dis_thresh*dis_thresh ) {
								break;// break; // we know we're done with this atom... if it's not
												 // within higher dist, it won't be within a lower dist
							}
							h->surrounding_sasa_(dis_bin,pr) += atom_sasa_(pr_bin,atom,res);
							if( pr_bin == 1 ){ // don't do this for every pr_bin... loop order a little funny
								h->neighbor_count_[dis_bin] += 1;
								h->avg_bfactor_   [dis_bin] += pdb::bvalue(atom,res);
								h->avg_occupancy_ [dis_bin] += pdb::occupancy(atom,res);
							}
						}
						// break goes here, out of shrinking dist

					}
				}
      }
			for( int dis_bin = N_CAVBALL_DISBINS; dis_bin >= 1; dis_bin-- ) {
				h->avg_bfactor_  [dis_bin] /= h->neighbor_count_[dis_bin];
				h->avg_occupancy_[dis_bin] /= h->neighbor_count_[dis_bin];
			}
LsasaNextBall: ;
		}


		/// RMS STUFF


		if ( native::native_exists ) {//&& packing_flags["compute_rms_stats"] ) {
			cout << "packing_measures: compute RMS stats" << endl;
			using namespace  native;

			// get "absolute" translation/rotation data
			FArray2D_double abs_rotation( 3, 3, 0.0f );
			FArray1D_double abs_decoy_offset( 3 );
			FArray1D_double abs_native_offset( 3 );
			{
				FArray2D_double natCA(3,total_residue,0.0f);
				FArray2D_double decCA(3,total_residue,0.0f);
				FArray1D_double abs_weights(total_residue,1.0f);
				double abs_sigma3;
				for (int ii=1; ii<=total_residue; ++ii) {
					for (int kk=1; kk<=3; ++kk) {
						natCA(kk,ii) = native_coord(kk,2,ii);
						decCA(kk,ii) =   full_coord(kk,2,ii);
					}
				}
				findUU_trans( decCA, natCA, abs_weights,
											total_residue, abs_rotation, abs_sigma3,
											abs_decoy_offset, abs_native_offset );
			}
			// done abs stuff

			for( int ii = 1; ii <= (int)cavity_balls_.size(); ii++ ) {
				if ( !cavity_ball_all_ok( ii, require_size_ok, require_buried, require_cluster_ok ) ) {
					continue;
				}
				CavityBall * h =	&cavity_balls_[ii];
				if( h->sasa_ > 0.0f )
					continue;

				for( int dis_bin = N_CAVBALL_DISBINS; dis_bin >= 2; dis_bin-- ) {
					const float d = (float)dis_bin;
					float const dis_thresh = d + h->radius_;
					float const dis_thresh2 = dis_thresh*dis_thresh;

					FArray2D_double native_points( 3, MAX_ATOM()()*MAX_RES()() );
					FArray2D_double decoy_points ( 3, MAX_ATOM()()*MAX_RES()() );
					int Npoints = 0;
					for(int res = 1; res <= misc::total_residue; res++ ) {
						int  aai = misc::res(res);
						int  aav = misc::res_variant(res);

						for(int atom = 1; atom <= aaproperties_pack::natoms(aai,aav); atom++) {
							if ( packing_flags["skip_missing_density"] && native_occupancy(atom,res) == -1.0f ) {
								cerr << "skip hole from missing nat. density: " << native_occupancy(atom,res) << ',' << ii << ',' << atom << ',' << res << endl ;
								h->absolute_shell_rms_[dis_bin] = -1234;
								h->relative_shell_rms_[dis_bin] = -1234;
								goto LrmsNextBall;  // there is missing density somewhere around this ball, skip to next ball

							}
							int const at = aaproperties_pack::fullatom_type(atom,aai,aav);
							if( /*heavy_atoms_only &&*/ 22 <= at && at <= 25 ) continue;
							//							if( at == 26 ) continue;
							if ( atom_sasa_(1,atom,res) > 0 && atom > 5 ) // if exposed and not backbone, ignore for RMS
								continue;

							float const xx = abs( h->xyz_.x() - full_coord(1,atom,res) );
							float const yy = abs( h->xyz_.y() - full_coord(2,atom,res) );
							float const zz = abs( h->xyz_.z() - full_coord(3,atom,res) );
							if( xx > dis_thresh ) { continue; }
							if( yy > dis_thresh ) { continue; }
							if( zz > dis_thresh ) { continue; }

							float const dis2 = xx*xx + yy*yy + zz*zz;
							if ( dis2 <= dis_thresh2 ) {
								Npoints++;
								native_points(1,Npoints) = native_coord(1,atom,res);
								decoy_points (1,Npoints) =   full_coord(1,atom,res);
								native_points(2,Npoints) = native_coord(2,atom,res);
								decoy_points (2,Npoints) =   full_coord(2,atom,res);
								native_points(3,Npoints) = native_coord(3,atom,res);
								decoy_points (3,Npoints) =   full_coord(3,atom,res);
							}


						}
					}

					//assert(Npoints == h->neighbor_count_[dis_bin]);

					if ( Npoints < 3) {
						h->absolute_shell_rms_[dis_bin] = -1234;
						h->relative_shell_rms_[dis_bin] = -1234;
						continue;
					}
					// from here we know we have at least 3 points

					FArray2D_double  decoy_points_copy( decoy_points);
					FArray2D_double native_points_copy(native_points);

					FArray1D_double ww(Npoints,1.0f);
					FArray1D_double p1_offset( 3 );
					FArray1D_double p2_offset( 3 );
					FArray2D_double uu( 3, 3, 0.0f );
					double sigma3;
					findUU_trans( decoy_points, native_points, ww,
												Npoints, uu, sigma3,
												p1_offset, p2_offset );

					FArray2D_float decoy_points_float( 3, Npoints, -1234. );
					for (int ii=1; ii<=Npoints; ii++) {
						decoy_points_float(1,ii) = (float)decoy_points(1,ii);
						decoy_points_float(2,ii) = (float)decoy_points(2,ii);
						decoy_points_float(3,ii) = (float)decoy_points(3,ii);
					}

					FArray1D_double zero(3,0.0f);
					UU_rotate( decoy_points_float, Npoints, zero, zero, uu );

					int relrmscount = 0;
					float relrms = 0.0;
					for ( int ii=1; ii<=Npoints; ii++) {
						++relrmscount;
						for ( int kk = 1; kk <= 3; ++kk ) {
							float const d = abs(decoy_points_float(kk,ii) - native_points(kk,ii));
							relrms += d * d;
						}
					}
					h->relative_shell_rms_[dis_bin] = std::sqrt(relrms/relrmscount);


					// absolute stuff using already computed trans/rot
					// reset coords to undo above modifications
					for (int ii=1; ii<=Npoints; ii++) {
						for ( int kk = 1; kk <= 3; ++kk ) {
							decoy_points_float(kk,ii) = (float)decoy_points_copy(kk,ii);
							native_points(kk,ii) = native_points_copy(kk,ii);
						}
					}
					UU_rotate( decoy_points_float, Npoints, abs_decoy_offset, abs_native_offset, abs_rotation );
					int absrmscount = 0;
					float absrms = 0.0;
					for ( int ii=1; ii<=Npoints; ii++) {
						++absrmscount;
						for ( int kk = 1; kk <= 3; ++kk ) {
							float const d = abs(decoy_points_float(kk,ii) - native_points(kk,ii));
							absrms += d * d;
						}
					}
					h->absolute_shell_rms_[dis_bin] = std::sqrt(absrms/absrmscount);

					assert( h->relative_shell_rms_[dis_bin] <= h->absolute_shell_rms_[dis_bin] );

				}
LrmsNextBall: ;
			}

		}



    for ( int ii=1; ii<= (int)cavity_balls_.size(); ii++) {
      CavityBall const * const h = &cavity_balls_[ii];
			string lbl = "BUR ";
			if( h->sasa_ > 0.0f ){
				continue; // optionally output exposed balls as well, thought this isn't a good idea
				lbl = "EXP ";
			}
      out << lbl
				  << decoy_id << ' '
				  << I( 5, h->res() ) << I( 4, h->atom() )
				  << F(9,3,h->radius_)
  				<< I(4, h->num_other_balls_overlap_)
	  			<< I(4, h->num_buried_other_balls_overlap_)
  				<< I(4, h->num_big_other_balls_overlap_)
				  << I(4, h->num_big_buried_other_balls_overlap_)
				  << F(9,3,atom_bsasa_score(h->atom(),h->res()) )
				  << F(9,3,h->sasa_)
				;

			out << "       " ;

			for ( int dis_bin=2; dis_bin<=N_CAVBALL_DISBINS; dis_bin++)
				out << F(9,2,h->absolute_shell_rms_[dis_bin]);
			out << "       " ;
			for ( int dis_bin=2; dis_bin<=N_CAVBALL_DISBINS; dis_bin++)
				out << F(9,2,h->relative_shell_rms_[dis_bin]);
			out << "       " ;

			for ( int dis_bin=2; dis_bin<=N_CAVBALL_DISBINS; dis_bin++)
				out << F(9,2,h->avg_occupancy_[dis_bin]);
			out << "       " ;
			for ( int dis_bin=2; dis_bin<=N_CAVBALL_DISBINS; dis_bin++)
				out << F(9,2,h->avg_bfactor_[dis_bin]);
			out << "       " ;
			//out << h->neighbor_count_5A_;
			//atom neighbor counts
			for( int dis_bin=1; dis_bin <=N_CAVBALL_DISBINS; dis_bin++ ) {
				out <<  I(5, h->neighbor_count_[dis_bin] ) << ' ';
			}
			//out << "       ";

			// sasa for various radii of holes (not including other holes, protein only)
			for( int ii=1; ii<= 20; ii++ ) // up to 2.0A
				out <<  F(8,2,h->hole_sasa_[ii]) << ' ';
			//out << "       ";

			// 5A from centers cutoff, like current packing score
			//for( int ii=1; ii<= 30; ii++ )
			//	out <<  F(8,3,h->surrounding_sasa_5A_(ii) ) << ' ';
			//out << "       ";

			// sasa for varisou radii of surrounding shell of atoms for different shell sizes
			for( int dis_bin=2; dis_bin <=N_CAVBALL_DISBINS; dis_bin++ ) { // within 2A up to N_CAVBALL_DISBINSA of ball surface
				for( int jj=1; jj<= 20; jj++ ) { // only report up to 2.0
					out <<  F(8,2,h->surrounding_sasa_(dis_bin,jj) - h->surrounding_sasa_(dis_bin,30) ) << ' '; // subtract sasa 3.0 from all
				}
				//out << "      ";
			}
      out <<  endl;
    }

		//cerr <<  "         done writing data, returning" << decoy_id << endl;

  }


/*
float const relative_rms( vector1<xyzVector_float> const p1,
													vector1<xyzVector_float> const p2,
													vector1<float>           const w            )
{
	return -1234;
}

float const absolute_rms( vector1<xyzVector_float> const p1,
													vector1<xyzVector_float> const p2,
													vector1<float>           const w,
													vector1<xyzVector_float> const ca1,
												  vector1<xyzVector_float> const ca2					)
{
		return -1234;
}
*/

	////////////////////////////////////////////////////////////////////
	bool ProteinSasa::makePackingPDB( utility::io::ozstream & out,
																		bool const compute_burial,
																		bool const require_size,
																		bool const require_buried,
																		bool const require_cluster_ok )
{

		if( ! valid_ ) {
			compute_atom_bsasa_score();
		}
		if ( compute_burial && !cavity_ball_burial_computed_ ) {
			cout << "HOLES DONT BURY HOLES FLAG!!! " << !packing_flags["holes_dont_bury_holes"] << endl;
			compute_cavity_ball_burial( !packing_flags["holes_dont_bury_holes"] );
		}

    cout << "ProteinSasa::makePackingPDB" << endl;

    include_packing_in_outpdbs( require_size, require_buried, require_cluster_ok );
		make_pdb( out , true );
		uninclude_packing_in_outpdbs();

		//print_all_clusters();

    return true;
  }



	// took out anything below which makes changes to the object...
  // you'll have to call compute_aotm_bsasa... and compute_cavity_ball_burial
  // on your own for this to work (see makePackingPdb)
bool ProteinSasa::include_packing_in_outpdbs( bool const require_size_ok    , // defaults here are
																							bool const require_buried     , // pretty permissive
																							bool const require_cluster_ok  ) const
{
	for(int res = 1; res <= misc::total_residue; res++ ) {
		int  aai = misc::res(res);
		int  aav = misc::res_variant(res);

		//if( aai>25 || aav!=1 )
		//	continue;
		for(int atom = 1; atom <= aaproperties_pack::natoms(aai,aav); atom++) {
			//			int const at = aaproperties_pack::fullatom_type(atom,aai,aav);
			//			if( at == 26 ) continue;

			float bs  = this->atom_bsasa_score_weighted(atom,res);
			if( bs < 0 || bs > 1 )
				continue;
			if( 0.0 > bs || bs > 1.0 )
				bs = this->bsasa_score_weighted();
			make_pdb_ns::bfactor( atom, res ) = bs;
		}
	}
	make_pdb_ns::bfactor( 4, 1 ) = 0.0;
	make_pdb_ns::bfactor( 4, misc::total_residue ) = 0.0;

	// this is where the balls come from
	make_pdb_ns::nonscored_hetero_atoms = this->getHeteroAtoms( require_size_ok,
																															require_buried,
																															require_cluster_ok );

	return true;
}


	bool ProteinSasa::uninclude_packing_in_outpdbs() const {
		// should we reset the bfactor and occ values here?
    make_pdb_ns::nonscored_hetero_atoms = "";
		return true;
	}




			///////////////////////////////////////
  void ProteinSasa::probe_calc_min_rsq( FArray2Da_float rsq_min, float const radius, float & overall_min) {
    using namespace param; // for MAX_ATOMTYPES
    rsq_min.dimension( MAX_ATOMTYPES(), MAX_ATOMTYPES() );
    for ( int i = 1, e = MAX_ATOMTYPES(); i <= e; ++i ) {
      for ( int j = i; j <= e; ++j ) {
				rsq_min(i,j) = rsq_min(j,i) =
					numeric::square( ( atom_radii_[(AtomType)i] + radius ) + ( atom_radii_[(AtomType)j] + radius ) );
				overall_min = std::max(rsq_min(i,j),overall_min);
      }
    }
  }





  // copied from fullatom_sasa.cc
  // minor changes for speed (mostly use of constants)
  void get_overlap( FArray1DB_float const & a,
										float const ra,
										FArray1DB_float const & b,
										float const rb,
										float const dist,
										int & olp
									)
  {

    //cj    min distance cutoff
    float const epsilon = 0.01;

    if ( dist < epsilon ) {
      //cj    atoms too close, causes round off error
      //cj    use this cutoff
      if ( ra < rb ) {
				olp = 100;
      } else {
				olp = 1;
      }
    } else if ( rb+dist <= ra ) {
      //cj    If atom a completely engulfs atom b, consider a to have
      //cj    no overlap due to atom b.
      olp = 1;
    } else if ( rb+dist <= ra ) {
      //cj    If atom a is completely engulfed by atom b, then turn it
      //cj    completely off (i.e. d2 = 99).
      olp = 100;
    } else {
      //cj    Otherwise, compute the amount of overlap using the law of cosines.
      //cj    "costh" is the angle of the cone of intersection that atom b
      //cj    imposes on atom a.  "ra" is the radius of atom a, and "rb" is
      //cj    the radius of atom b.  "sqrtd" is the actual distance between
      //cj    the a and b centers, while "dist" is the square of this distance.
      float const costh = (ra*ra+dist*dist-rb*rb)/(2*ra*dist);
      olp = static_cast< int >((1.0f-costh)*50)+1;
      if ( olp > 100 ) {
				olp = 100;
      } else if ( olp < 0 ) {
				//cj       We already hopefully accounted for this possibility by requiring that
				//cj       dist < epsilon, but in case not we don't want a potential bug to go
				//cj       unnoticed.
				std::cout << "problem in calculating overlap between:" << std::endl;
				std::cout << "a  " <<
				F( 7, 3, a(1) ) << ' ' << F( 7, 3, a(2) ) << ' ' << F( 7, 3, a(3) ) <<
				std::endl;
				std::cout << "b  " <<
				F( 7, 3, b(1) ) << ' ' << F( 7, 3, b(2) ) << ' ' << F( 7, 3, b(3) ) <<
				std::endl;
				std::cout << "ra=" << SS( ra ) << std::endl;
				std::cout << "rb=" << SS( rb ) << std::endl;
				std::cout << "dist=" << SS( dist ) << std::endl;
				std::cout << "costh=" << SS( costh ) << std::endl;
				std::cout << "Teminiating calculation" << std::endl;
				utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
      }
    }
  }

  ////////////////////////////////////////////////////////////////
  float ProteinSasa::sasa_of_sphere(xyzVector_float xyz, float radius,
																		float const probe_radius) {

    using namespace aaproperties_pack; // for fullatom_type & natoms
    using namespace fullatom_sasa;
    using namespace interface;
    using namespace ligand;
    using namespace misc;              // for full_coord
    using namespace param;             // for paramters
    using namespace param_aa;             // for paramters
    using namespace numeric::constants::f;

    valid_ = false;
    int in,it,
      //jn,jt,
      olp,
      aphi,theta,
      point,masknum;//,aa,lig_int_count;

			FArray1D_float ic( 3 );
			FArray1D_float jc( 3 );
			float fraction,total_sa,expose;//,dist_sq,total_sasa5,total_sasa14,
																		 //sasa14,sasa5,offset,norm_sasa5;

				// save these fields which are initialized the first time through
				FArray1D_float tmp_rsq_min( MAX_ATOMTYPES() );
				float mx = 0.0;
				//probe_calc_min_rsq( tmp_rsq_min, probe_radius, tmp );
				for ( int i = 1, e = MAX_ATOMTYPES(); i <= e; ++i ) {
					tmp_rsq_min(i) = numeric::square( atom_radii_[(AtomType)i] + 2*probe_radius + radius ) ;
					if( tmp_rsq_min(i) > mx )
						mx = tmp_rsq_min(i);
				}
				//float const abs_min_rsq = mx; !!!!!!

				FArray1D_ubyte tmp_sasa_mask( fullatom_sasa::nbytes );
				for ( int bb = 1; bb <= nbytes; ++bb ) {
					tmp_sasa_mask( bb ) = 0; // atom_sasa_masks_(bb,ia,ir,pr_bin)
				}

				//cj----now do calculations: get the atom_sasa_masks_ by looping over all_atoms x all_atoms

				for ( int ir = 1; ir <= total_residue; ++ir ) {
					in = res(ir);
					for ( int ia = 1, iae = natoms(in,res_variant(ir)); ia <= iae; ++ia ) {
						// store the coordinates and atom type, since we will reuse this a bunch
						for ( int m = 1; m <= 3; ++m )
							ic(m) = misc::full_coord(m,ia,ir); // make const?
						it = fullatom_type(ia,in,res_variant(ir)); // make const?
						//						if ( it != 26 ) {
							float const irad_base = atom_radii_[(AtomType)it]; // no probe radius included
																																 //cj   could do this more efficiently if found neighbors first???
																																 //jg  loop over jr>ir, to cover all pair-wise interactions
																																 // 	  for ( int jr = ir; jr <= total_residue; ++jr ) {
																																 // 	    jn = res(jr);
																																 // 	    for ( int ja = 1, jae = natoms(jn,res_variant(jr)); ja <= jae; ++ja ) {
							for ( int m = 1; m <= 3; ++m )
								jc(m) = xyz(m);
							//jt = fullatom_type(ja,jn,res_variant(jr));
							//if ( jt != 26 ) { //not water ?
							//cj       getting squared distance between atoms (faster than taking sqrt)
							float const dist_sq = vec_dist2(ic,jc);
							if ( dist_sq <= tmp_rsq_min(it) ) {
								//car ignore all zero distances, either i,j are same atom or it's
								//car an invalid pair for some reason...
								if ( dist_sq <= 0.0 ) goto L100;
								float const dist = std::sqrt(dist_sq);
								float const irad = irad_base + probe_radius;
								float const jrad = radius + probe_radius;
								// account for i overlapping j:
								get_overlap(jc,jrad,ic,irad,dist,olp);
								get_orientation(jc,ic,aphi,theta, dist);
								point = angles(aphi,theta);
								masknum = point*100+olp;
								for ( int bb = 1; bb <= nbytes; ++bb ) {
									tmp_sasa_mask(bb) = bit_or( tmp_sasa_mask(bb), masks(bb,masknum) );
								}
								//}    // pr_bin
							} else if ( dist_sq > 289.0 ) {
								// 289 = 17A^2 = 10A + 2 (1.4 + 2.1)
								goto L110; // this residue is too far away
													 // go to next residue j
							}         // dij_sq <= rij_sq
L100:;
							//      }   // jk if not water
							//}            // ja
L110:;
							//}             // jr


							//					}  // jk if not water
				}                  // ia
	}                     // ir


				//-----calculate the per-residue sasa

				float const four_pi = 4.0f * pi;
				//float sphere_sasa = 0.0f;
				//for ( int pr_bin = 1; pr_bin <= packing_ns::n_pr_bin; ++pr_bin ) {
				//float const probe_radius = ballsasa_probe_radii(pr_bin);
				//cout << "probe radius " << pr_bin << ' ' << probe_radius << endl;;
				int ctr = 0;
				for ( int bb = 1; bb <= nbytes; ++bb ) {
					ctr += bit_count[tmp_sasa_mask(bb)]; // atom_sasa_masks_(bb,ia,ir,pr_bin)
				}
				//int const sphere_sasa_dots = maskbits-ctr; // sheffler !!!!!!!
				fraction = static_cast< float >( ctr ) / maskbits;
				total_sa = four_pi * ( radius * radius );
				expose = ( 1.0f - fraction ) * total_sa;
				//	}        // ia
				//}        // ir
				//}        // pr_bin

				return expose;

  }


  void ProteinSasa::phils_sasa_routine( ) {
    using namespace aaproperties_pack; // for fullatom_type & natoms
    using namespace fullatom_sasa;
    using namespace interface;
    using namespace ligand;
    using namespace misc;              // for full_coord
    using namespace param;             // for paramters
    using namespace param_aa;             // for paramters
    using namespace numeric::constants::f;

		//		cout << "PACKING: main sasa routine 30 radii" << endl;

    valid_ = false;
    int in,it,      jn,jt,      olp,      aphi,theta,      point,masknum;  //,aa,lig_int_count;

		FArray1D_float ic( 3 );
		FArray1D_float jc( 3 );
		float fraction,total_sa,expose;//,dist_sq,total_sasa5,total_sasa14,
																	 //sasa14,sasa5,offset,norm_sasa5;

			// save these fields which are initialized the first time through


			//-----initialize atom_sasa_masks_ to zero
			float tmp = 0.0;
			for ( int pr_bin = 1; pr_bin <= packing_ns::n_pr_bin; ++pr_bin ) {
				probe_calc_min_rsq( rsq_min(1,1,pr_bin),ballsasa_probe_radii(pr_bin),tmp);
			}
			//float const abs_min_rsq = tmp;

			for ( int pr_bin = 1; pr_bin <= packing_ns::n_pr_bin; ++pr_bin ) {
				for ( int ir = 1; ir <= total_residue; ++ir ) {
					in = res(ir);
					for ( int ia = 1, iae = natoms(in,res_variant(ir)); ia <= iae; ++ia ) {
						//cj     first zero mask for all atoms
						for ( int bb = 1, l = atom_sasa_masks_.index(bb,ia,ir,pr_bin);
									bb <= nbytes; ++bb, ++l ) {
							atom_sasa_masks_[ l ] = 0; // atom_sasa_masks_(bb,ia,ir,pr_bin)
						}
					}               // ia
				}                  // ir
			}

			//cj----now do calculations: get the atom_sasa_masks_ by looping over all_atoms x all_atoms
			static FArray1D_bool printed(100,false);
			for ( int ir = 1; ir <= total_residue; ++ir ) {
				in = res(ir);
				for ( int ia = 1, iae = natoms(in,res_variant(ir)); ia <= iae; ++ia ) {
					// store the coordinates and atom type, since we will reuse this a bunch
					for ( int m = 1; m <= 3; ++m )
						ic(m) = misc::full_coord(m,ia,ir); // make const?
					it = fullatom_type(ia,in,res_variant(ir)); // make const?
					if( packing_ns::heavy_atoms_only && it >= 22 ){ // !!!!!!!!!!!!!!!!!!!!!!!!!!
						continue;
					}
					//					if ( it != 26 ) {
						float const irad_base = atom_radii_[(AtomType)it]; // no probe radius included
																															 //cj   could do this more efficiently if found neighbors first???
																															 //jg  loop over jr>ir, to cover all pair-wise interactions
						for ( int jr = ir; jr <= total_residue; ++jr ) {
							jn = res(jr);
							for ( int ja = 1, jae = natoms(jn,res_variant(jr)); ja <= jae; ++ja ) {
								for ( int m = 1; m <= 3; ++m )
									jc(m) = misc::full_coord(m,ja,jr);
								jt = fullatom_type(ja,jn,res_variant(jr));
								if( packing_ns::heavy_atoms_only && jt >= 22 )
									continue;

								//								if ( jt != 26 ) { //not water ?
																	//cj       getting squared distance between atoms (faster than taking sqrt)
									float const dist_sq = vec_dist2(ic,jc);
									if ( dist_sq <= rsq_min(it,jt,1) ) {
										//car ignore all zero distances, either i,j are same atom or it's
										//car an invalid pair for some reason...
										if ( dist_sq <= 0.0 ) goto L100;
										float const jrad_base = atom_radii_[(AtomType)jt]; // no probe radius included
										float const dist = std::sqrt(dist_sq);
										for ( int pr_bin = 1; pr_bin <= packing_ns::n_pr_bin; ++pr_bin ) {
											if ( dist_sq > rsq_min(it,jt,pr_bin) ) goto L100;
											float const probe_radius = ballsasa_probe_radii(pr_bin);
											float const irad = irad_base + probe_radius;
											float const jrad = jrad_base + probe_radius;
											// account for j overlapping i:
											get_overlap(ic,irad,jc,jrad,dist,olp);
											get_orientation(ic,jc,aphi,theta, dist);
											// what is this?
											point = angles(aphi,theta);
											masknum = point*100+olp;

											for ( int bb = 1, l = atom_sasa_masks_.index(bb,ia,ir,pr_bin);
														bb <= nbytes; ++bb, ++l ) { // [ l ] = (bb,ia,ir,pr_bin)
												atom_sasa_masks_[ l ] = bit_or( atom_sasa_masks_[ l ], masks(bb,masknum) );
											}
											// account for i overlapping j:
											get_overlap(jc,jrad,ic,irad,dist,olp);
											get_orientation(jc,ic,aphi,theta, dist);
											point = angles(aphi,theta);
											masknum = point*100+olp;
											for ( int bb = 1, l = atom_sasa_masks_.index(bb,ja,jr,pr_bin);
														bb <= nbytes; ++bb, ++l ) { // [ l ] = (bb,ja,jr,pr_bin)
												atom_sasa_masks_[ l ] = bit_or( atom_sasa_masks_[ l ], masks(bb,masknum) );
											}
										}    // pr_bin
									} else if ( dist_sq > 289.0 ) {
										// 289 = 17A^2 = 10A + 2 (1.4 + 2.1)
										goto L110; // this residue is too far away
															 // go to next residue j
									}         // dij_sq <= rij_sq
L100:;
									//								}   // jk if not water
							}            // ja
L110:;
						}             // jr


						// if ligand flag sum over all heteroatoms
						// TOOK THIS OUT BECAUSE LIGAND OBJECT SYSTEM HAS CHANGED!!

						// if ( ligand::ligand_flag && int_res(ir) ) {
						// 	    for ( int ja = 0; ja < int(ligand::ligand_one->trial_ligand.size()); ++ja ) {
						// 	      int const jt = ligand::ligand_one->trial_ligand[ja]->get_ros_atom_type();
						// 	      if ( jt > MAX_REALTYPES ) goto L123;
						// 	      copy_to_FArray(ligand::ligand_one->trial_ligand[ja]->get_coordinates(),jc);
						// 	      float const dist_sq = vec_dist2(ic,jc);
						// 	      if ( dist_sq <= rsq_min(it,jt,1) ) {
						// 		if ( dist_sq <= 0.0 ) goto L123;
						// 		float const jrad_base = atom_radii_[(AtomType)jt]; // no probe radius included
						// 		float const dist = std::sqrt(dist_sq);
						// 		for ( int pr_bin = 1; pr_bin <= packing_ns::n_pr_bin; ++pr_bin ) {
						// 		  if ( dist_sq > rsq_min(it,jt,pr_bin) ) goto L123;
						// 		  float const probe_radius = ballsasa_probe_radii(pr_bin);
						// 		  float const irad = irad_base + probe_radius;
						// 		  float const jrad = jrad_base + probe_radius;
						// 		  get_overlap(ic,irad,jc,jrad,dist,olp);
						// 		  get_orientation(ic,jc,aphi,theta, dist);
						// 		  point = angles(aphi,theta);
						// 		  masknum = point*100+olp;
						// 		  for ( int bb = 1, l = atom_sasa_masks_.index(bb,ia,ir,pr_bin);
						// 			bb <= nbytes; ++bb, ++l ) { // [ l ] = (bb,ia,ir,pr_bin)
						// 		    atom_sasa_masks_[ l ] = bit_or( atom_sasa_masks_[ l ], masks(bb,masknum) );
						// 		  }
						// 		}      // pr_bin
						// 	      }
						// 	    L123:;
						// 	    }            // ja
						// 	  }
						// end sum over all heteroatoms


							//					}  // jk if not water
				}                  // ia
			}                     // ir


			//-----calculate the per-residue sasa

			float const four_pi = 4.0f * pi;
			for ( int pr_bin = 1; pr_bin <= packing_ns::n_pr_bin; ++pr_bin ) {
				//float const probe_radius = ballsasa_probe_radii(pr_bin);
				//cout << "probe radius " << pr_bin << ' ' << probe_radius << endl;;
				for ( int ir = 1; ir <= total_residue; ++ir ) {
					rsd_sasa_(pr_bin,ir) = 0.0;
					in = res(ir);
					for ( int ia = 1, iae = natoms(in,res_variant(ir)); ia <= iae; ++ia ) {
						it = fullatom_type(ia,in,res_variant(ir));
						//						if( it == 26 )
						//							continue;
						if( packing_ns::heavy_atoms_only && it >= 22 && it <= 25 )
							continue;

						float const irad = atom_radii_[(AtomType)it]; //!!!!!!!!! dont include probe !!!!!!!!!!!!!
						int ctr = 0;
						for ( int bb = 1, l = atom_sasa_masks_.index(bb,ia,ir,pr_bin);
									bb <= nbytes; ++bb, ++l ) {
							ctr += bit_count[atom_sasa_masks_[ l ]]; // atom_sasa_masks_(bb,ia,ir,pr_bin)

						}
						atom_sasa_dots_(pr_bin,ia,ir) = maskbits-ctr; // sheffler
						fraction = static_cast< float >( ctr ) / maskbits;
						total_sa = four_pi * ( irad * irad );
						expose = ( 1.0f - fraction ) * total_sa;
						rsd_sasa_(pr_bin,ir) += expose;
						atom_sasa_(pr_bin,ia,ir) = expose;
					}        // ia
				}        // ir
			}        // pr_bin

			int ball_count = 0;
			cavity_balls_.clear();

			for ( int ir = 1; ir <= total_residue; ++ir ) {
				in = res(ir);
				for ( int ia = 1, iae = natoms(in,res_variant(ir)); ia <= iae; ++ia ) {
					it = fullatom_type(ia,in,res_variant(ir));
					//					if( it == 26 )
					//						continue;
					if( packing_ns::heavy_atoms_only && it >= 22 && it <= 25) //!!!!!!!!!!!!!!!!!!!!
						continue;

					float const irad = atom_radii_[(AtomType)it]; //!!!!!!!!! dont include probe !!!!!!!!!!!!!

					// get largest accessible probe radius for atom ir,ia
					int ii;
					for(ii = packing_ns::n_pr_bin; ii >=  1; ii--) {
						//cout << ii << ' ' << atom_sasa_dots_(ii,ia,ir) << endl;
						if( atom_sasa_dots_(ii,ia,ir) == 0 ){
							break;
						}
					}
					if( ii < 1 || ii >= packing_ns::n_pr_bin || atom_sasa_dots_(ii+1,ia,ir) == 0 )
						continue;

					int const largest_pr_bin = ii+1;
					largest_probe_radius_bin_(ia,ir) = largest_pr_bin;

					// zero center (shouldn't be necessary...)
					for(int ii=1; ii<=3; ii++)
						atom_sasa_center_(ii,ia,ir) = 0;

					// now check over all the dots
					int counter = 0;
					for ( int bb = 1, l = atom_sasa_masks_.index(bb,ia,ir,largest_pr_bin);
								bb <= nbytes; ++bb, ++l ) {
						ubyte const mask = atom_sasa_masks_[ l ]; // atom_sasa_masks_(bb,ia,ir,pr_bin)
						int NSHORT = 8;
						if( bb == 21 ) NSHORT = 2; // 162 dots...
						for ( short k = 0; k < NSHORT; ++k ) {
							if ( !( bit_test( static_cast<short>(mask), k ) ) ) {
								const int dot = 8*(bb-1)+k+1;
								const float x = sasa_dot_locations(1,dot);
								const float y = sasa_dot_locations(2,dot);
								const float z = sasa_dot_locations(3,dot);
								atom_sasa_center_(1,ia,ir) += x;
								atom_sasa_center_(2,ia,ir) += y;
								atom_sasa_center_(3,ia,ir) += z;
								++counter;
								//cout << "bit_test... pass " << bb << ' ' << k << ' '
								//   << largest_pr_bin << ' ' << x << ',' << y << ',' << z << endl;
							}
						}
					} // end bit tests

					//cout << ia << ' ' << ir << ' ' << largest_probe_radius_bin_(ia,ir) << ' ' << counter << endl;

					int mindot = -1;
					float mindis = 99999;
					for ( int bb = 1, l = atom_sasa_masks_.index(bb,ia,ir,largest_pr_bin);
								bb <= nbytes; ++bb, ++l ) {
						ubyte const mask = atom_sasa_masks_[ l ]; // atom_sasa_masks_(bb,ia,ir,pr_bin)
						int NSHORT = 8;
						if( bb == 21 ) NSHORT = 2; // 162 dots...
						for ( short k = 0; k < NSHORT; ++k ) {
							if ( !( bit_test( static_cast<short>(mask), k ) ) ) {
								const int dot = 8*(bb-1)+k+1;
								const float x = sasa_dot_locations(1,dot) - atom_sasa_center_(1,ia,ir);
								const float y = sasa_dot_locations(2,dot) - atom_sasa_center_(1,ia,ir);
								const float z = sasa_dot_locations(3,dot) - atom_sasa_center_(1,ia,ir);
								float const d2 = x*x + y*y + z*z;
								if ( d2  < mindis ) {
									mindis = d2;
									mindot = dot;
								}
								//cout << "bit_test... pass " << bb << ' ' << k << ' '
								//   << largest_pr_bin << ' ' << x << ',' << y << ',' << z << endl;
							}
						}
					} // end bit tests

					//cout << atom_sasa_center_(1,pr_bin,ia,ir) << ' '
					//       << atom_sasa_center_(2,pr_bin,ia,ir) << ' '
					//   << atom_sasa_center_(3,pr_bin,ia,ir) << ' ' << endl;

					// now compute actual "hole center" for the atom
					float const probe_radius = ballsasa_probe_radii(largest_pr_bin);
					//float clen = 0.0f;
					//for( int ii = 1; ii<=3; ii++)
					//	clen += atom_sasa_center_(ii,ia,ir)*atom_sasa_center_(ii,ia,ir);
					//clen = sqrt(clen); // this is the total length of the avg dot vector
														 //cout << "this better be 1! " << clen << endl;
														 //cout << (irad+probe_radius) << endl;

					 /////////// try "median" dot.... !!!!!!!!!!!!! NEW!!!!
										atom_sasa_center_(1,ia,ir) = sasa_dot_locations(1,mindot);
										atom_sasa_center_(2,ia,ir) = sasa_dot_locations(2,mindot);
										atom_sasa_center_(3,ia,ir) = sasa_dot_locations(3,mindot);
										//clen = 1.0;

					for(int ii=1; ii<=3; ii++) {
						if( /*clen > 0. && */probe_radius >= packing_options::min_hole_radius ) { //!!!!!!!!!!!!!!!!!!!!!!! THRESH!!!!!!!
							//atom_sasa_center_(ii,ia,ir) /= clen;                // normalize
							atom_sasa_center_(ii,ia,ir) *= (irad+probe_radius); // * atomrad + probe rad
							atom_sasa_center_(ii,ia,ir) += misc::full_coord(ii,ia,ir); // add atom ccords
						}
						else {
							atom_sasa_center_(ii,ia,ir) = -1234;
						}
					}
					if( /*clen > 0 &&*/ atom_sasa_center_(1,ia,ir) != -1234.0f )
					{
						ball_count++;
						CavityBall const h( ball_count,
																ia, ir,
																atom_sasa_center_(1,ia,ir),
																atom_sasa_center_(2,ia,ir),
																atom_sasa_center_(3,ia,ir),
																probe_radius );
						cavity_balls_.push_back(h);
					}

				}              // ia
			}                  // ir

			//			cout << "         main sasa done" << endl;

			valid_ = true;
			cavity_ball_burial_computed_ = false;

			this->compute_neighboring_holes( );

  }


int
ProteinSasa::compute_cavity_ball_burial( bool const holes_bury_holes ,
																				 int  const max_iters,
																				 int  const threshold_diff )
{

	if ( packing_flags["no_prune"] ) {
		return 0;
	}
	//	cout << "about to prune cavity balls hbh: " << holes_bury_holes << endl;
	if ( !valid_ ) {
		cerr << "ERROR: tried to prune invalid ProteinSasa object!!" << endl;
		exit(-1);
	}

	float probe_radius = packing_options::cavity_burial_probe_radius;

	int num_prune_steps(0);
	num_buried_cavity_balls_ = (int)cavity_balls_.size();

	while( true ) {

		int l = num_buried_cavity_balls_;

		this->compute_cavity_ball_burial_single_pass( probe_radius, holes_bury_holes );
		++num_prune_steps;
		//		cout << "compute_cavity_ball_burial reduced number of voids from "
		//			<< I(5,l) << " to  " << I(5,num_buried_cavity_balls_)
		//			<< " ( tot: " << cavity_balls_.size()
		//			<< " pruned: "   << num_exposed_cavity_balls_
		//			<< " remaining: "<< num_buried_cavity_balls_
		//			<< " )" << endl;
		if ( !packing_flags["compute_complete_burial"] )
			if ( (num_prune_steps >= max_iters || (l - num_buried_cavity_balls_) <= threshold_diff ) )
				break;
		if ( l == num_buried_cavity_balls_ && num_prune_steps >= max_iters )
			break;

	}

	//	cout << "compute_cavity_ball_burial was executed " << num_prune_steps << " times." << endl;

	cavity_ball_burial_computed_ = true;
	this->compute_neighboring_holes( );
	bsasa_score_pruned_ = this->compute_pruned_bsasa_score();
	setup_fasc_cols();

	return num_prune_steps;
}




void ProteinSasa::compute_cavity_ball_burial_single_pass( float const probe_radius,
																													bool  const holes_bury_holes ) {
	using namespace aaproperties_pack; // for fullatom_type & natoms
	using namespace fullatom_sasa;
	using namespace interface;
	using namespace ligand;
	using namespace misc;              // for full_coord
	using namespace param;             // for paramters
	using namespace param_aa;             // for paramters
	using namespace numeric::constants::f;

	FArray2D_ubyte prune_sasa_masks( fullatom_sasa::nbytes, (int)cavity_balls_.size() );
	for( int ii = 1; ii <= (int) cavity_balls_.size(); ii++ ) {
		for ( int bb = 1, l = prune_sasa_masks.index(bb,ii);
					bb <= nbytes; ++bb, ++l ) {
			prune_sasa_masks[ l ] = 0;
		}
	}


	// LOOP HOLE
	for( int ii = 1; ii <= (int) cavity_balls_.size(); ii++ )
	{
		//if ( //cavity_balls_[ii].radius_ < packing_options::min_hole_radius || // this is a bit of a cheat it seems..
		//		 //cavity_balls_[ii].radius_ > packing_options::max_hole_radius ||
		//		 cavity_balls_[ii].sasa_ > packing_options::max_hole_sasa ) {
		//	continue;
		//}

		// zero masks for each ball

		FArray1D_float ic( 3 );
		for ( int m = 1; m <= 3; ++m )
			ic(m) = cavity_balls_[ii].xyz_(m); // make const?
		float const irad_base = cavity_balls_[ii].radius_;
		float const irad = irad_base + probe_radius;

		// LOOP RES
		for ( int jr = 1; jr <= total_residue; ++jr ) {
			int const jn = res(jr);
			// LOOP ATOM
			for ( int ja = 1, jae = natoms(jn,res_variant(jr)); ja <= jae; ++ja ) {
				FArray1D_float jc( 3 );
				for ( int m = 1; m <= 3; ++m )
					jc(m) = misc::full_coord(m,ja,jr);
				int const jt = fullatom_type(ja,jn,res_variant(jr));

				//				if( jt==26)
				//					continue;
				if( packing_ns::heavy_atoms_only && jt >= 22 && jt <= 25 )
					continue;

				int olp,aphi,theta,point,masknum;//,aa,lig_int_count;
				float const jrad_base = atom_radii_[(AtomType)jt]; // no probe radius included
				float const jrad = jrad_base + probe_radius;

				float const dis_thresh = (irad+jrad);
				float const xx = abs( ic(1) - jc(1) );
				if( xx > dis_thresh ) { continue; }
				float const yy = abs( ic(2) - jc(2) );
				if( yy > dis_thresh ) { continue; }
				float const zz = abs( ic(3) - jc(3) );
				if( zz > dis_thresh ) { continue; }
				float const dis2 = xx*xx + yy*yy + zz*zz;
				if( dis2 > dis_thresh*dis_thresh )
					continue;
				float const dist = sqrt( dis2 );

				/*if ( dist+0.5 < irad_base+jrad_base ) {
					cerr << "HOLE TOO CLOSE TO ATOM!!!! " << dist << endl;
					cerr << "atom: "<< ja << " res: " << jr << " rad: " << jrad << endl;
					cerr << "atom coords: "
						<< full_coord(1,ja,jr) << ','
						<< full_coord(2,ja,jr) << ','
						<< full_coord(3,ja,jr) << endl;
					cerr << cavity_balls_[ii].str() << endl;
				} */

				// is this necessary?
				float const dist_sq = vec_dist2(ic,jc);
				if ( dist_sq <= 0.0 )
					continue;

				get_overlap    (ic,irad, jc ,jrad , dist, olp);
				get_orientation(ic, jc ,aphi,theta, dist);
				point = angles(aphi,theta);
				masknum = point*100+olp;
				for ( int bb = 1, l = prune_sasa_masks.index(bb,ii);
							bb <= nbytes; ++bb, ++l ) { // [ l ] = (bb,ia,ir,pr_bin)
					prune_sasa_masks[ l ] = bit_or( prune_sasa_masks[ l ], masks(bb,masknum) );
				}
								/*					 }   // jk if not water         */
		  }            // ja
		}           // jr
  }  //holes

	//cerr << "DONE ATOMS" << endl;

	// LOOP HOLE  --
	if ( !holes_bury_holes ) {
		//		cout << "packing_measures: not burying holes with other holes!" << endl;
	} else {

		//for( int ii = 2; ii <= (int) cavity_balls_.size(); ii++ ) {
		for( int ii = 1; ii <= (int) cavity_balls_.size(); ii++ ) {
			// store the coordinates and atom type, since we will reuse this a bunch
			if ( //cavity_balls_[ii].radius_ < packing_options::min_hole_radius ||
					 //cavity_balls_[ii].radius_ > packing_options::max_hole_radius ||
					 cavity_balls_[ii].sasa_ > packing_options::max_hole_sasa ) {
				continue;
			}
			FArray1D_float ic( 3 );
			for ( int m = 1; m <= 3; ++m )
				ic(m) = cavity_balls_[ii].xyz_(m); // make const?
			float const irad_base = cavity_balls_[ii].radius_;
			float const irad = irad_base + probe_radius;

			//for( int jj = 1; jj < ii;  jj++ ) { // this only hits each pair once (ii loop too!)
			  for( int jj = 1; jj <= (int)cavity_balls_.size();  jj++ ) { // this goes over all ordered pairs

				//if( ii == jj ) // alwaysw les than ii in loop structure
				//	continue;
				if ( //cavity_balls_[jj].radius_ < packing_options::min_hole_radius ||
						 //cavity_balls_[jj].radius_ > packing_options::max_hole_radius ||
						 cavity_balls_[jj].sasa_ > packing_options::max_hole_sasa ) {
					continue;
				}

				FArray1D_float jc( 3 );
				for ( int m = 1; m <= 3; ++m )
					jc(m) = cavity_balls_[jj].xyz_(m); // make const?
				int olp,aphi,theta,point,masknum;//,aa,lig_int_count;
					float const jrad_base = cavity_balls_[jj].radius_;
					float const jrad = jrad_base + probe_radius;
					float const dis_thresh = (irad+jrad);
					float const xx = abs( ic(1) - jc(1) );
					if( xx > dis_thresh ) { continue; }
					float const yy = abs( ic(2) - jc(2) );
					if( yy > dis_thresh ) { continue; }
					float const zz = abs( ic(3) - jc(3) );
					if( zz > dis_thresh ) { continue; }

					//cerr << cavity_balls_[ii].print() << endl;
					//cerr << cavity_balls_[jj].print() << endl;

					//float const dis2 = xx*xx + yy*yy + zz*zz;
					//if( dis2 > dis_thresh*dis_thresh )
					//	continue;
					//float const dist = sqrt( dis2 );

					float const dist_sq = vec_dist2(ic,jc);
					float const dist = std::sqrt(dist_sq);
					if ( dist_sq <= 0.0 )
						continue;
					if( sqrt(dist_sq) > irad+jrad )
						continue;
					//if( sqrt(dist_sq) < min(irad_base,jrad_base) )
					//continue;

					// jj overlaping ii...
					get_overlap    (ic,irad, jc ,jrad , dist, olp);
					get_orientation(ic, jc ,aphi,theta, dist);
					point = angles(aphi,theta);
					masknum = point*100+olp;
					for ( int bb = 1, l = prune_sasa_masks.index(bb,ii); bb <= nbytes; ++bb, ++l ) {
						prune_sasa_masks[ l ] = bit_or( prune_sasa_masks[ l ], masks(bb,masknum) );
					}

		/*			//ii overlaping jj
					get_overlap    (jc,jrad, ic ,irad , dist, olp);
					get_orientation(jc, jc ,aphi,theta, dist);
					point = angles(aphi,theta);
					masknum = point*100+olp;
					for ( int bb = 1, l = prune_sasa_masks.index(bb,jj); bb <= nbytes; ++bb, ++l ) {
						prune_sasa_masks[ l ] = bit_or( prune_sasa_masks[ l ], masks(bb,masknum) );

					}       */
		   }
		} // end loop jj
	}  // ii -- hole
	//} // end if include_centers

	//cerr << "DONE HOLES" << endl;

	//-----calculate the per-"hole" sasa

	num_buried_cavity_balls_ = 0;
	num_exposed_cavity_balls_ = 0;
	for( int ii = 1; ii <= (int)cavity_balls_.size(); ii++ ) {
		int ctr = 0;
		for ( int bb = 1, l = prune_sasa_masks.index(bb,ii);
					bb <= nbytes; ++bb, ++l ) {
						ctr += bit_count[prune_sasa_masks[ l ]]; // prune_sasa_masks(bb,ia,ir,pr_bin)
		}
		float const r = cavity_balls_[ii].radius();
		cavity_balls_[ii].sasa_ = (float)(maskbits - ctr) / (float)maskbits * 4.0/3.0*3.14159* r * r * r;
		//cerr << "PACKING: set sasa for cav ball" << cavity_balls_[ii].str() << endl;
		if( cavity_balls_[ii].sasa_ > 0 )
			num_exposed_cavity_balls_++;
		else
			num_buried_cavity_balls_++;
	}

	//cerr << "DONE AREAS" << endl;

}


float ProteinSasa::compute_hole_sasa( CavityBall * cb ,
																			float const probe_radius,
																			vector1<CavityBall*> & other_holes) // TODO allow masks as arg?
{

	using namespace aaproperties_pack; // for fullatom_type & natoms
	using namespace fullatom_sasa;
	using namespace interface;
	using namespace ligand;
	using namespace misc;              // for full_coord
	using namespace param;             // for paramters
	using namespace param_aa;             // for paramters
	using namespace numeric::constants::f;

	FArray1D_ubyte hole_sasa_mask( fullatom_sasa::nbytes );
	for ( int bb = 1;	bb <= nbytes; ++bb )
		hole_sasa_mask(bb) = 0;

	FArray1D_float ic( 3 );
	for ( int m = 1; m <= 3; ++m )
		ic(m) = cb->xyz_(m); // make const?
	float const irad_base = cb->radius_;
	float const irad = irad_base + probe_radius;

		// LOOP RES
	for ( int jr = 1; jr <= total_residue; ++jr ) {
		int const jn = res(jr);
		// LOOP ATOM
		for ( int ja = 1, jae = natoms(jn,res_variant(jr)); ja <= jae; ++ja ) {
			FArray1D_float jc( 3 );
			for ( int m = 1; m <= 3; ++m )
				jc(m) = misc::full_coord(m,ja,jr);
			int const jt = fullatom_type(ja,jn,res_variant(jr));
			//			if( jt==26)	continue;
			if( packing_ns::heavy_atoms_only && jt >= 22 && jt <= 25 )
				continue;

			int olp,aphi,theta,point,masknum;//,aa,lig_int_count;
			float const jrad_base = atom_radii_[(AtomType)jt]; // no probe radius included
			float const jrad = jrad_base + probe_radius;

			float const dis_thresh = (irad+jrad);
			float const xx = abs( ic(1) - jc(1) );
			if( xx > dis_thresh ) { continue; }
			float const yy = abs( ic(2) - jc(2) );
			if( yy > dis_thresh ) { continue; }
			float const zz = abs( ic(3) - jc(3) );
			if( zz > dis_thresh ) { continue; }
			float const dis2 = xx*xx + yy*yy + zz*zz;
			if( dis2 > dis_thresh*dis_thresh )
				continue;
			float const dist = sqrt( dis2 );

			// is this necessary?
			float const dist_sq = vec_dist2(ic,jc);
			if ( dist_sq <= 0.0 )
				continue;

			get_overlap    (ic,irad, jc ,jrad , dist, olp);
			get_orientation(ic, jc ,aphi,theta, dist);
			point = angles(aphi,theta);
			masknum = point*100+olp;
			for ( int bb = 1;	bb <= nbytes; ++bb ) {
				hole_sasa_mask(bb) = bit_or( hole_sasa_mask(bb), masks(bb,masknum) );
			}
		}            // ja
	}           // jr

	for( int jj = 1; jj < (int)other_holes.size();  jj++ ) { // ABOVE IS jj < ii for more efficient triangle
		CavityBall *cb2 = other_holes[jj];
		if ( cb == cb2 )
			continue;
		//if ( //cavity_balls_[jj].radius_ < packing_options::min_hole_radius ||
		//		 //cavity_balls_[jj].radius_ > packing_options::max_hole_radius ||
		//		 cavity_balls_[jj].sasa_ > packing_options::max_hole_sasa ) {         // still do this check here?
		//	                                                        // TODO make this requirement elsewhere!
		//	continue;
		//}

		FArray1D_float jc( 3 );
		for ( int m = 1; m <= 3; ++m )
			jc(m) = cavity_balls_[jj].xyz_(m); // make const?
		int olp,aphi,theta,point,masknum;//,aa,lig_int_count;
		float const jrad_base = cavity_balls_[jj].radius_;
		float const jrad = jrad_base + probe_radius;
		float const dis_thresh = (irad+jrad);
		float const xx = abs( ic(1) - jc(1) );
		if( xx > dis_thresh ) { continue; }
		float const yy = abs( ic(2) - jc(2) );
		if( yy > dis_thresh ) { continue; }
		float const zz = abs( ic(3) - jc(3) );
		if( zz > dis_thresh ) { continue; }

		float const dist_sq = vec_dist2(ic,jc);
		float const dist = std::sqrt(dist_sq);
		if ( dist_sq <= 0.0 )
			continue;
		if ( sqrt(dist_sq) > irad+jrad )
			continue;

		// jj overlaping ii...
		get_overlap    (ic,irad, jc ,jrad , dist, olp);
		get_orientation(ic, jc ,aphi,theta, dist);
		point = angles(aphi,theta);
		masknum = point*100+olp;
		for ( int bb = 1; bb <= nbytes; ++bb )
				hole_sasa_mask(bb) = bit_or( hole_sasa_mask(bb), masks(bb,masknum) );

		////ii overlaping jj TODO somehow allow for this to make more efficient?
												// requires masks to be input as argument
		//get_overlap    (jc,jrad, ic ,irad , dist, olp);
		//get_orientation(jc, jc ,aphi,theta, dist);
		//point = angles(aphi,theta);
		//masknum = point*100+olp;
		//for ( int bb = 1, l = prune_sasa_masks.index(bb,jj); bb <= nbytes; ++bb, ++l )
		//	prune_sasa_masks[ l ] = bit_or( prune_sasa_masks[ l ], masks(bb,masknum) );

	} // end loop over other_holes

	int ctr = 0;
	for ( int bb = 1;	bb <= nbytes; ++bb )
		ctr += bit_count[hole_sasa_mask(bb)];
	float const r = cb->radius();

	return (float)(maskbits - ctr) / (float)maskbits * 4.0/3.0*3.14159* r * r * r;

}//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! not tested!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



void ProteinSasa::build_restricted_hole_set( FArray1D_bool & allowed_residue,
																						 vector< CavityBall > & restricted_hole_set,
																						 bool const require_size_ok    , // defaults here are
																						 bool const require_buried     , // pretty permissive
																						 bool const require_cluster_ok  ) const
{
	// traverse the existing hole list, keeping those based on "allowed_residue"
	restricted_hole_set.clear();

	for (int ii = 1; ii <= (int)cavity_balls_.size(); ii++) {
		if ( cavity_ball_all_ok(ii, require_size_ok,
														require_buried,
														require_cluster_ok )        )
		{

			CavityBall const cb = cavity_balls_[ii];
			if ( allowed_residue( cb.res() ) ) {
				restricted_hole_set.push_back(cb); // keep it
			}

		}
	}
	return;
}


// changed these to include more "advanced" pruning options...
// defaults for the 4 added params should be ok so you probably
// don't need to worry about them.
// maybe subject to change...
void ProteinSasa::build_restricted_hole_set( FArray2D_bool & allowed_atom,
																						 vector< CavityBall > & restricted_hole_set,
																						 bool const require_size_ok    , // defaults here are
																						 bool const require_buried     , // pretty permissive
																						 bool const require_cluster_ok ) const
{
    // traverse the existing hole list, keeping those based on "allowed_atom"
	restricted_hole_set.clear();

	for (int ii = 1; ii <= (int)cavity_balls_.size(); ii++) {
		if ( cavity_ball_all_ok(ii, require_size_ok,
														require_buried,
														require_cluster_ok )        )
		{

			CavityBall const cb = cavity_balls_[ii];
			if ( allowed_atom( cb.atom(), cb.res() ) ) {
				restricted_hole_set.push_back(cb); // keep it
			}


		}
	}
	return;
}


void ProteinSasa::build_restricted_cluster_set( FArray1D_bool & allowed_residue,
																						 vector< CavityBallCluster > & restricted_cluster_set,
																						 bool const require_size_ok    , // defaults here are
																						 bool const require_buried     , // pretty permissive
																						 bool const require_cluster_ok  ) const
{
	// traverse the existing hole list, keeping those based on "allowed_residue"
	restricted_cluster_set.clear();

	for ( int cluster = 1; cluster <= (int)cavity_ball_clusters_.size(); cluster++ ) {
		CavityBallCluster const * const cbc = &cavity_ball_clusters_[cluster];

		bool found_allowed_residue(false);
		for (int ii = 1; ii <= (int)cbc->size(); ii++) {
			CavityBall *cb = cbc->cavity_ball(ii);
			if ( cavity_ball_all_ok( cb->id() , require_size_ok,require_buried,require_cluster_ok ) ) {
				if ( allowed_residue( cb->res() ) ) {
					found_allowed_residue=true;
					break;
				}
			}
		}
		if ( found_allowed_residue ) restricted_cluster_set.push_back(*cbc); // keep it
	}

	return;
}


// changed these to include more "advanced" pruning options...
// defaults for the 4 added params should be ok so you probably
// don't need to worry about them.
// maybe subject to change...
void ProteinSasa::build_restricted_cluster_set( FArray2D_bool & allowed_atom,
																						 vector< CavityBallCluster > & restricted_cluster_set,
																						 bool const require_size_ok    , // defaults here are
																						 bool const require_buried     , // pretty permissive
																						 bool const require_cluster_ok ) const
{
    // traverse the existing hole list, keeping those based on "allowed_atom"
	restricted_cluster_set.clear();

	for ( int cluster = 1; cluster <= (int)cavity_ball_clusters_.size(); cluster++ ) {
		CavityBallCluster const * const cbc = &cavity_ball_clusters_[cluster];

		bool found_allowed_atom(false);
		for (int ii = 1; ii <= (int)cbc->size(); ii++) {
			CavityBall *cb = cbc->cavity_ball(ii);
			if ( cavity_ball_all_ok( cb->id() , require_size_ok,require_buried,require_cluster_ok ) ) {
				if ( allowed_atom( cb->atom(), cb->res() ) ) {
					found_allowed_atom=true;
					break;
				}
			}
		}
		if ( found_allowed_atom ) restricted_cluster_set.push_back(*cbc); // keep it
	}

	return;
}


  float ProteinSasa::find_sidechain_max_hole( int const resnum, bool const require_hydrophobic ) {
    // note: require_hydrophobic is false if not passed in explicitly
    // traverse the existing hole list,
    // check that the hole belongs to the appropriate resnum and is a sidechain atom

    using namespace aaproperties_pack;

    float maxvoid = 0.;
    for( int ii = 1; ii <= (int)cavity_balls_.size(); ii++ ) {
			if ( cavity_balls_[ii].sasa_ > 0 )
			{                             // john, I put this in because I think it's what you want..
			  continue;                   // I changed things so that no holes are removed, but you
			}														  // can check their sasa_ to make sure it's 0
      if ( (cavity_balls_[ii]).res() == resnum ) {
				int const atomnum = (cavity_balls_[ii]).atom();

				bool valid_atom = false;
				if ( atomnum >= 5 ) {
					if ( ! require_hydrophobic ) {
						valid_atom = true;
					} else {
						int const atomtype = fullatom_type(atomnum,misc::res(resnum),misc::res_variant(resnum));
						// jk consider only backbone and carbon or sulfur or hydrophobic H
						if ( ( atomtype <= 6 ) || ( atomtype == 16 ) || ( atomtype == 23 ) || ( atomtype == 24 ) ) {
							valid_atom = true;
						}
					}
				}

				if ( valid_atom ) {
					float const radius = (cavity_balls_[ii]).radius();
					if ( radius > maxvoid ) maxvoid = radius;
				}
      }
    }

    return maxvoid;
  }

float ProteinSasa::compute_pruned_bsasa_score( bool const require_size_ok,
																							 bool const require_buried,
																							 bool const require_cluster_ok  ) const
{

	if ( ! (valid_ && cavity_ball_burial_computed_) )
		return -1;
	//	cout << "PACKING: computing pruned bsasa score" << endl;

	float tot = 0.0f;
	int count = 0;

	for (int ii = 1; ii <= (int)cavity_balls_.size(); ii++) {
		if ( cavity_ball_all_ok(ii, require_size_ok,
														require_buried,
														require_cluster_ok )        )
		{

			CavityBall const *cb = &cavity_balls_[ii];
			if( this->atom_bsasa_score( cb->atom(), cb->res() )  >= 0.0f ) {
				tot += this->atom_bsasa_score( cb->atom(), cb->res() ) ;
				count++;
			}


		}
	}

	float prunescore = tot / (float)count ;
	//	cout << "pruned score: " << prunescore << " unpruned: " << bsasa_score_weighted_ << endl;
	return prunescore;

}




  //////////////////////////////////////////////////////////////////////
  //    compute_atom_bsasa_score
  /////////////////////////////////////////////////////////////////////
  void ProteinSasa::compute_atom_bsasa_score( ) {

		//cerr << "PACKING: compute_atom_bsasa_score, updating..." << endl;
    update();
		//cerr << "PACKING: updated..." << endl;

		//cerr<< "PACKING: compute atom bsasa score" << endl;

    /*
		 for(int res = 1; res <= misc::total_residue; res++ ) {
			 int  aai = misc::res(res);
			 int  aav = misc::res_variant(res);
			 if( aai>20 || aav!=1 )
				 continue;

			 for(int atom = 1; atom <= aaproperties_pack::natoms(aai,aav); atom++) {

				 // don't bother if atom isn't buried to biggest probe
				 if( atom_sasa_dots_(1,atom,res) != 0 )
					 continue;
				 // if too few beighbors, don't bother
				 //if( (*atom_neighbors_10)(atom,res) < 200 )
				 //continue;
				 int atype = aaproperties_pack::fullatom_type( atom, aai , aav );
				 if(atype > 25)
					 continue;

			 }
		 }
		 */

		set<int> tmp;
		hole_neighbors_.clear();
		hole_neighbors_.resize( (MAX_ATOM()()*(MAX_RES()()+1))+1, tmp );

    for ( int res1 = 1; res1 <= misc::total_residue; ++res1 ) {
      int const aa1 = misc::res(res1);
      int const aav1 = misc::res_variant(res1);

      for ( int atom1 = 1, atom1e = aaproperties_pack::natoms(aa1,aav1); atom1 <= atom1e; ++atom1 ) {
				int const pr_bin = largest_probe_radius_bin_(atom1,res1);

				//cout << "pr_bin " << pr_bin << ' ' << atom_sasa_dots_(1,atom1,res1) << endl;
				// stop if no good bin or exposed -> no cav. center
				if( pr_bin <= 0 || atom_sasa_dots_(1,atom1,res1) != 0 )
					continue;

				//int const atype1 = aaproperties_pack::fullatom_type(atom1,aa1,aav1);

				FArray1D_float xyz(3);
				for(int ii=1; ii<=3; ii++)
					xyz(ii) = atom_sasa_center_(ii,atom1,res1);

				FArray1D_int counts(3,0); // 5 7.5 and 10 nb bins
				int center_radius_count = 0;

				for(int ii = 1; ii <= BALL_N_PR_BIN; ii++) {
					ball_atom_sasa_count_(ii,atom1,res1) = 0;
					ball_atom_sasa_area_ (ii,atom1,res1) = 0.0f;
				}

				//AtomBall ab(xyz); !!!!!!!
				for ( int res2 = 1; res2 <= misc::total_residue; ++res2 ) {
					int const aai2  = misc::res(res2);
					int const aav2 = misc::res_variant(res2);
					for (int atom2=1, atom2e=aaproperties_pack::natoms(aai2,aav2); atom2 <= atom2e; ++atom2) {
						float dis;
						//						int const aai2 = misc::res(res2);
						//						int const aav2 = misc::res_variant(res2);
						//						int const at = aaproperties_pack::fullatom_type(atom2,aai2,aav2);
						//						if( at == 26 ) continue;

						distance_bk( misc::full_coord(1,atom2,res2), xyz, dis );
						//cout << "DIST " << dis << endl;
						if( dis <= SASA_CENTER_RADIUS ) {
							for(int ii = 1; ii <= BALL_N_PR_BIN; ii++) {
								ball_atom_sasa_count_(ii,atom1,res1) += atom_sasa_dots_(ii,atom2,res2);
								ball_atom_sasa_area_ (ii,atom1,res1) += atom_sasa_(ii,atom2,res2);
							}
							center_radius_count++;
							hole_neighbors_[MAX_ATOM()()*res1+atom1].insert(res2);

							//ab.addAtom(atom2,res2); !!!!!!!!!!
						} //ball_pr_bin
						if(dis <  5.0f) counts(1)++;
						if(dis <  7.5f) counts(2)++;
						if(dis < 10.0f) counts(3)++;
					} // atom2
				} //res2
      } //atom1
				//cout << res1 << ' ' << atom_sasa_dots_(1,5,res1) << endl;
    } //res1

    bsasa_score_              = 0.0f;
    bsasa_score_weighted_     = 0.0f;
    bsasa_score_log_          = 0.0f;
    bsasa_score_weighted_log_ = 0.0f;

    int atom_count = 0;
    float tot_weight = 0.0;

    for ( int res1 = 1; res1 <= misc::total_residue; ++res1 ) {
      int const aa1 = misc::res(res1);
      int const aav1 = misc::res_variant(res1);
      for ( int atom1 = 1, atom1e = aaproperties_pack::natoms(aa1,aav1);
						atom1 <= atom1e; ++atom1 ) {

				int s20 = ball_atom_sasa_count_(packing_ns::pr_bin_20,atom1,res1);
				int s9  = ball_atom_sasa_count_(packing_ns::pr_bin_9 ,atom1,res1) ;

				s9  = std::max(0,std::min(s9-s20,600))+1; // use sasa 0.9 - sasa 2.0
				s20 = std::max(0,std::min(s20,   500))+1;
				float w = bsasa920_weights(s20);

				if( w > 0.1 && atom_sasa_dots_(pr_bin_20,atom1,res1) == 0 ) {
					float sc = bsasa920_quantiles(s20,s9);
					if( sc==0 )
						continue;
					bsasa_score_                  += sc;
					bsasa_score_weighted_         += w*sc;
					bsasa_score_log_              += log(sc);
					bsasa_score_weighted_log_     += w*log(sc);
					atom_count++;
					tot_weight += w;
				}
      }
    }

    bsasa_score_          = bsasa_score_          / atom_count;
    bsasa_score_weighted_ = bsasa_score_weighted_ / tot_weight ;
    bsasa_score_log_          = exp( bsasa_score_log_     / atom_count );
    bsasa_score_weighted_log_ = exp( bsasa_score_weighted_log_ / tot_weight );

    for ( int res1 = 1; res1 <= misc::total_residue; ++res1 ) {
      int const aa1 = misc::res(res1);
      int const aav1 = misc::res_variant(res1);
      int total_atoms = 0;
      float total_weight = 0;
      float tmp_score = 0;
      for ( int atom1 = 1, atom1e = aaproperties_pack::natoms(aa1,aav1);
						atom1 <= atom1e; ++atom1 ) {
				int s20 = ball_atom_sasa_count_(packing_ns::pr_bin_20,atom1,res1);
				int s9  = ball_atom_sasa_count_(packing_ns::pr_bin_9 ,atom1,res1) ;
				s9  = std::max(0,std::min(s9-s20,600))+1; // use sasa 0.9 - sasa 2.0
				s20 = std::max(0,std::min(s20,   500))+1;
				float w = bsasa920_weights(s20);
				if( w > 0.1 && atom_sasa_dots_( packing_ns::pr_bin_20,atom1,res1) == 0 ) {
					float sc = bsasa920_quantiles(s20,s9);
					if( sc==0 )
						continue;
					atom_bsasa_score_(atom1,res1) = sc;
					atom_bsasa_score_weighted_(atom1,res1) = w*sc+ (1-w)*bsasa_score_weighted_;
					total_atoms += 1;
					tmp_score += sc;
					total_weight += w;
				}
      }
      float n = aaproperties_pack::natoms(aa1,aav1);
      if (total_atoms > n/2 ) {
				res_bsasa_score_(res1) = tmp_score/total_atoms;
      }
    }

    float mx = -0.1;
    int mxa(-1),mxr(-1);
    for( int rr = 1; rr <= MAX_RES()(); rr++ ) {
      for( int aa = 1; aa <= MAX_ATOM()(); aa++ ) {
				if( atom_bsasa_score(aa,rr) > mx ) {
					mxa = aa;
					mxr = rr;
					mx = atom_bsasa_score(aa,rr);
				}
      }
    }
    worst_hole_neighbors_ = hole_neighbors_[ mxr * MAX_ATOM()() + mxa ];

    //for( set<int>::iterator i = worst_hole_neighbors_.begin(); i != worst_hole_hneighbors_.end(); i++ )
    // cout << "HOLE NB " << *i << endl;
		setup_fasc_cols();
		//cerr<< "         done" << endl;
  }

  void ProteinSasa::setup_fasc_cols() {
		if ( !packing_flags["fasc_cols"]) {
			return;
		}
		using namespace score_file_ns;
		if( !valid_ )
			this->compute_atom_bsasa_score();
    new_float_cols["packing"] = this->bsasa_score_weighted_log();
		new_int_cols   ["length"]    = misc::total_residue;
    if ( cavity_ball_burial_computed_ ) {
      new_float_cols ["packprune"] = bsasa_score_pruned_;
			new_int_cols   ["num_holes"] = num_buried_cavity_balls_;
		} else {
      new_float_cols ["packprune"] = -1;
			new_int_cols   ["num_holes"] = -1;
		}
		// lots of stuff about clusters could be added here
  }



bool read_bsasa920_quantiles() {

		static bool init = { false };
		if ( init ) return true;
		init = true;

		bsasa920_weights.dimension(N_DIM_S20,-1234.0f);
		bsasa920_quantiles.dimension(N_DIM_S20,N_DIM_S09,-1234.0f);

    bool fail;
    bool defined;
    string fname = "bsasa-9-600_given_bsasa-20-500_quantiles.data";
    utility::io::izstream & datafile( try_to_open_data_file(fname , fail ) );
    if ( fail ) {
      defined = false;
      cout << "WARNING: can't find data file " << fname << endl;
      cout << "Should be in whip:/work/sheffler/data/rosetta_database/" << endl;
      cout << "Talk to Will" << endl;
      datafile.clear();
      exit(0);
      return false;
    } else {
      defined = true;
    }
    if( defined ) {
      double tmp = 0.0;
      for(int ii=1; ii <= N_DIM_S20 ; ii++) {
				for(int jj=1; jj <= N_DIM_S09; jj++){
					datafile >> tmp;
					bsasa920_quantiles(ii,jj) = (float)tmp;
				}
      }
      if( datafile >> tmp )
				cout << "WARNING some data left in file after reading in!!!" << endl;
      datafile.close();
    }

    fname = "bsasa-9-600_given_bsasa-20-500_weights.data";
    utility::io::izstream & weightfile( try_to_open_data_file( fname , fail ) );
    if ( fail ) {
      defined = false;
      cout << "WARNING: can't find data file " << fname << endl;
      cout << "Should be in whip:/work/sheffler/data/rosetta_database/" << endl;
      cout << "Talk to Will" << endl;
      weightfile.clear();
      exit(0);
      return false;
    } else {
      defined = true;
    }
    if( defined ) {
      double tmp = 0.0;
      for(int ii=1; ii <= N_DIM_S20 ; ii++){
				weightfile >> tmp;
				bsasa920_weights(ii) = (float)tmp;
      }
      if( weightfile >> tmp )
				cout << "WARNING some data left in file after reading in!!!" << endl;
      weightfile.close();
    }

    return defined;

}


	int CavityBall::recursive_mark_hole_neighbors( vector1<CavityBall> & holes, int const cluster ) {
		if ( cluster_id_ != -1234 ) {
			return 0;
		}
		cluster_id_ = cluster;
		int count = 1;
		for ( int ii=1; ii<=(int)big_buried_neighboring_cavity_balls_.size(); ii++) {
			/*cerr << "PACKING: add hole "
			     << big_buried_neighboring_cavity_balls_[ii]->id_
			     << " to cluster "
			     << cluster
			     << " base atom "
			     << id_
			     << endl; */
			count += big_buried_neighboring_cavity_balls_[ii]->recursive_mark_hole_neighbors( holes, cluster );
		}
		return count;
	}


	// maek this  a member and it'll be cleaner!!!
	// is the pruned arg really necessaery?
	// "null" -1234 sasa is good enough? no, best to keep buried counts undefined
	void ProteinSasa::compute_neighboring_holes( )
	{
			//cerr<< "PACKING: compute hole overlaps" << endl;
		for( int ii=1; ii<= (int)cavity_balls_.size(); ii++ ) {
			cavity_balls_[ii].num_other_balls_overlap_ = 0;
			cavity_balls_[ii].num_big_other_balls_overlap_ = 0;
			if( cavity_ball_burial_computed_ ) {
				cavity_balls_[ii].num_buried_other_balls_overlap_ = 0;
				cavity_balls_[ii].num_big_buried_other_balls_overlap_ = 0;
			}
			cavity_balls_[ii].neighboring_cavity_balls_.clear();
			cavity_balls_[ii].buried_neighboring_cavity_balls_.clear();
			cavity_balls_[ii].big_neighboring_cavity_balls_.clear();
			cavity_balls_[ii].big_buried_neighboring_cavity_balls_.clear();
		}
		for( int ii=2; ii<= (int)cavity_balls_.size(); ii++ ) {
			CavityBall * hii = &cavity_balls_[ii];
			for( int jj=1; jj < ii; jj++ ) {
				CavityBall * hjj = &cavity_balls_[jj]; // triangle loop...

				if( hii->overlaps(hjj) ) { //!!!!!!!!!!!!!!!!!!!!!!!
					hii->num_other_balls_overlap_++;
					hjj->num_other_balls_overlap_++;
					hii->neighboring_cavity_balls_.push_back(hjj);
					hjj->neighboring_cavity_balls_.push_back(hii);
					if( hii->radius_ >= packing_options::min_hole_radius && hii->radius_ <= packing_options::max_hole_radius ) {
						hjj->num_big_other_balls_overlap_++;
						hjj->big_neighboring_cavity_balls_.push_back(hii);
					}
					if( hjj->radius_ >= packing_options::min_hole_radius && hjj->radius_ <= packing_options::max_hole_radius ) {
						hii->num_big_other_balls_overlap_++;
						hii->big_neighboring_cavity_balls_.push_back(hjj);
					}
					if ( cavity_ball_burial_computed_ ) {
						if( hii->sasa_ <= packing_options::max_hole_sasa ) {
							hjj->num_buried_other_balls_overlap_++;
							hjj->buried_neighboring_cavity_balls_.push_back(hii);
							if( hii->radius_ >= packing_options::min_hole_radius && hii->radius_ <= packing_options::max_hole_radius ) {
								hjj->num_big_buried_other_balls_overlap_++;
								hjj->big_buried_neighboring_cavity_balls_.push_back(hii);
							}
						}
						if( hjj->sasa_ <= packing_options::max_hole_sasa ) {
							hii->num_buried_other_balls_overlap_++;
							hii->buried_neighboring_cavity_balls_.push_back(hjj);
							if( hjj->radius_ >= packing_options::min_hole_radius && hjj->radius_ <= packing_options::max_hole_radius ) {
								hii->num_big_buried_other_balls_overlap_++;
								hii->big_buried_neighboring_cavity_balls_.push_back(hjj);
							}
						}
					}
				}
			}
		}

		// CLUSTERING!
		if ( cavity_ball_burial_computed_ ) {
			for (int ii=1; ii<=(int)cavity_balls_.size(); ii+=1) {
				cavity_balls_[ii].cluster_id_ = -1234; // resert all holes
			}
			int cluster = 1; // start at clust id 1
			for (int ii=1; ii<=(int)cavity_balls_.size(); ii++) { // for each hole..
				if ( cavity_balls_[ii].cluster_id_ == -1234 &&
						 cavity_ball_buried(ii) &&
						 cavity_ball_size_ok(ii) ) // if no clust and eligable
				{
					cavity_balls_[ii].recursive_mark_hole_neighbors( cavity_balls_ , cluster ); // recursively mark neighbors
					//cerr << "PACKING: created cluster "<< cluster << endl;
					cluster++;                                 // increment cluster id
				}
			}
			int const clusters = cluster - 1; // from last ++ before stoped
			cavity_ball_clusters_.clear();
			for (int ii=1; ii<=clusters; ii++) {
				vector1<CavityBall*> balls;
				for (int jj=1; jj<=(int)cavity_balls_.size(); jj++) {
					float bigball = -1234;
					if ( cavity_balls_[jj].cluster_id_ == ii ) {
						float const r = cavity_balls_[jj].radius();
						if ( r > bigball )
							bigball = r;
						balls.push_back( &cavity_balls_[jj] );
					}
				}
				CavityBallCluster	const c( ii, balls );
				cavity_ball_clusters_.push_back( c );
			}

			// clusters are defined, now sort them so largest come first
			sort< vector1<CavityBallCluster>::iterator >( cavity_ball_clusters_.begin(),
																										cavity_ball_clusters_.end()    );
			for ( int ii=1; ii<=(int)cavity_ball_clusters_.size(); ii++) {
				CavityBallCluster *cbc = &cavity_ball_clusters_[ii];
				cbc->set_id(ii);
				cbc->volume_ = 0.;
				cbc->surface_area_ = 0.;
				for (int jj=1; jj<=(int)cbc->size(); jj++) {
					CavityBall *cb = cbc->cavity_ball(jj);
					cb->set_cluster_id(ii); // change cav.ball cluster_id_'s to match
					cb->cluster_ = cbc;
					// TODO: this is a really really bad approximation... like off by 2X or more
					float const PI = 3.14159;
					cbc->volume_ += 4/3*PI*cb->radius()*cb->radius()*cb->radius();
					cbc->surface_area_   += 4*PI*cb->radius()*cb->radius();
				}
			}
		} // end clustering


		//print_all_holes();
		//print_all_clusters();


		// sanity check
		for (int ii=1; ii<=(int)cavity_balls_.size(); ii++) {
			assert( (int)cavity_balls_[ii].neighboring_cavity_balls_.size()==cavity_balls_[ii].num_other_balls_overlap_ );
			assert( (int)cavity_balls_[ii].big_neighboring_cavity_balls_.size()==cavity_balls_[ii].num_big_other_balls_overlap_ );
			if ( cavity_ball_burial_computed_) {
				assert( (int)cavity_balls_[ii].buried_neighboring_cavity_balls_.size()==cavity_balls_[ii].num_buried_other_balls_overlap_ );
				assert( (int)cavity_balls_[ii].big_buried_neighboring_cavity_balls_.size()==cavity_balls_[ii].num_big_buried_other_balls_overlap_ );
			}
		}

		//cerr<< "         done" << endl;

	}


void ballsasa_probe_radii_decrement_initializer() {

		static bool init = { false };
		if ( init ) return;
		init = true;

		ballsasa_probe_radii.dimension(N_PR_BIN);
    for(int ii = 1; ii <= (int)ballsasa_probe_radii.size1(); ii++) {
      ballsasa_probe_radii(ii) = float(ballsasa_probe_radii.size1()+1-ii)/10.0;
    }
}



  void sasa_dot_locations_initializer() {

		static bool init = { false };
		if ( init ) return;
		init = true;

	sasa_dot_locations.dimension(3,162);
	sasa_dot_neighbors.dimension(6,162);

    sasa_dot_locations(1,1) = 0.000000;
    sasa_dot_locations(2,1) = 0.000000;
    sasa_dot_locations(3,1) = 1.000000;
    sasa_dot_locations(1,2) = 0.276393;
    sasa_dot_locations(2,2) = 0.850651;
    sasa_dot_locations(3,2) = 0.447214;
    sasa_dot_locations(1,3) = 0.894427;
    sasa_dot_locations(2,3) = 0.000000;
    sasa_dot_locations(3,3) = 0.447214;
    sasa_dot_locations(1,4) = 0.162460;
    sasa_dot_locations(2,4) = 0.500000;
    sasa_dot_locations(3,4) = 0.850651;
    sasa_dot_locations(1,5) = 0.525731;
    sasa_dot_locations(2,5) = 0.000000;
    sasa_dot_locations(3,5) = 0.850651;
    sasa_dot_locations(1,6) = 0.077609;
    sasa_dot_locations(2,6) = 0.238856;
    sasa_dot_locations(3,6) = 0.967949;
    sasa_dot_locations(1,7) = 0.251148;
    sasa_dot_locations(2,7) = 0.000000;
    sasa_dot_locations(3,7) = 0.967949;
    sasa_dot_locations(1,8) = 0.361803;
    sasa_dot_locations(2,8) = 0.262866;
    sasa_dot_locations(3,8) = 0.894427;
    sasa_dot_locations(1,9) = 0.688191;
    sasa_dot_locations(2,9) = 0.500000;
    sasa_dot_locations(3,9) = 0.525731;
    sasa_dot_locations(1,10) = 0.232827;
    sasa_dot_locations(2,10) = 0.716567;
    sasa_dot_locations(3,10) = 0.657513;
    sasa_dot_locations(1,11) = 0.447214;
    sasa_dot_locations(2,11) = 0.525731;
    sasa_dot_locations(3,11) = 0.723607;
    sasa_dot_locations(1,12) = 0.483974;
    sasa_dot_locations(2,12) = 0.716567;
    sasa_dot_locations(3,12) = 0.502295;
    sasa_dot_locations(1,13) = 0.638197;
    sasa_dot_locations(2,13) = 0.262866;
    sasa_dot_locations(3,13) = 0.723607;
    sasa_dot_locations(1,14) = 0.753443;
    sasa_dot_locations(2,14) = 0.000000;
    sasa_dot_locations(3,14) = 0.657513;
    sasa_dot_locations(1,15) = 0.831052;
    sasa_dot_locations(2,15) = 0.238856;
    sasa_dot_locations(3,15) = 0.502295;
    sasa_dot_locations(1,16) = -0.723607;
    sasa_dot_locations(2,16) = 0.525731;
    sasa_dot_locations(3,16) = 0.447214;
    sasa_dot_locations(1,17) = -0.425325;
    sasa_dot_locations(2,17) = 0.309017;
    sasa_dot_locations(3,17) = 0.850651;
    sasa_dot_locations(1,18) = -0.203183;
    sasa_dot_locations(2,18) = 0.147621;
    sasa_dot_locations(3,18) = 0.967949;
    sasa_dot_locations(1,19) = -0.138197;
    sasa_dot_locations(2,19) = 0.425325;
    sasa_dot_locations(3,19) = 0.894427;
    sasa_dot_locations(1,20) = -0.262866;
    sasa_dot_locations(2,20) = 0.809017;
    sasa_dot_locations(3,20) = 0.525731;
    sasa_dot_locations(1,21) = -0.609548;
    sasa_dot_locations(2,21) = 0.442863;
    sasa_dot_locations(3,21) = 0.657513;
    sasa_dot_locations(1,22) = -0.361803;
    sasa_dot_locations(2,22) = 0.587785;
    sasa_dot_locations(3,22) = 0.723607;
    sasa_dot_locations(1,23) = -0.531939;
    sasa_dot_locations(2,23) = 0.681718;
    sasa_dot_locations(3,23) = 0.502295;
    sasa_dot_locations(1,24) = -0.052786;
    sasa_dot_locations(2,24) = 0.688191;
    sasa_dot_locations(3,24) = 0.723607;
    sasa_dot_locations(1,25) = 0.029644;
    sasa_dot_locations(2,25) = 0.864188;
    sasa_dot_locations(3,25) = 0.502295;
    sasa_dot_locations(1,26) = -0.723607;
    sasa_dot_locations(2,26) = -0.525731;
    sasa_dot_locations(3,26) = 0.447214;
    sasa_dot_locations(1,27) = -0.425325;
    sasa_dot_locations(2,27) = -0.309017;
    sasa_dot_locations(3,27) = 0.850651;
    sasa_dot_locations(1,28) = -0.203183;
    sasa_dot_locations(2,28) = -0.147621;
    sasa_dot_locations(3,28) = 0.967949;
    sasa_dot_locations(1,29) = -0.447214;
    sasa_dot_locations(2,29) = 0.000000;
    sasa_dot_locations(3,29) = 0.894427;
    sasa_dot_locations(1,30) = -0.850651;
    sasa_dot_locations(2,30) = 0.000000;
    sasa_dot_locations(3,30) = 0.525731;
    sasa_dot_locations(1,31) = -0.609548;
    sasa_dot_locations(2,31) = -0.442863;
    sasa_dot_locations(3,31) = 0.657513;
    sasa_dot_locations(1,32) = -0.670820;
    sasa_dot_locations(2,32) = -0.162460;
    sasa_dot_locations(3,32) = 0.723607;
    sasa_dot_locations(1,33) = -0.812731;
    sasa_dot_locations(2,33) = -0.295242;
    sasa_dot_locations(3,33) = 0.502295;
    sasa_dot_locations(1,34) = -0.670820;
    sasa_dot_locations(2,34) = 0.162460;
    sasa_dot_locations(3,34) = 0.723607;
    sasa_dot_locations(1,35) = -0.812731;
    sasa_dot_locations(2,35) = 0.295242;
    sasa_dot_locations(3,35) = 0.502295;
    sasa_dot_locations(1,36) = 0.276393;
    sasa_dot_locations(2,36) = -0.850651;
    sasa_dot_locations(3,36) = 0.447214;
    sasa_dot_locations(1,37) = 0.162460;
    sasa_dot_locations(2,37) = -0.500000;
    sasa_dot_locations(3,37) = 0.850651;
    sasa_dot_locations(1,38) = 0.077609;
    sasa_dot_locations(2,38) = -0.238856;
    sasa_dot_locations(3,38) = 0.967949;
    sasa_dot_locations(1,39) = -0.138197;
    sasa_dot_locations(2,39) = -0.425325;
    sasa_dot_locations(3,39) = 0.894427;
    sasa_dot_locations(1,40) = -0.262866;
    sasa_dot_locations(2,40) = -0.809017;
    sasa_dot_locations(3,40) = 0.525731;
    sasa_dot_locations(1,41) = 0.232827;
    sasa_dot_locations(2,41) = -0.716567;
    sasa_dot_locations(3,41) = 0.657513;
    sasa_dot_locations(1,42) = -0.052786;
    sasa_dot_locations(2,42) = -0.688191;
    sasa_dot_locations(3,42) = 0.723607;
    sasa_dot_locations(1,43) = 0.029644;
    sasa_dot_locations(2,43) = -0.864188;
    sasa_dot_locations(3,43) = 0.502295;
    sasa_dot_locations(1,44) = -0.361803;
    sasa_dot_locations(2,44) = -0.587785;
    sasa_dot_locations(3,44) = 0.723607;
    sasa_dot_locations(1,45) = -0.531939;
    sasa_dot_locations(2,45) = -0.681718;
    sasa_dot_locations(3,45) = 0.502295;
    sasa_dot_locations(1,46) = 0.361803;
    sasa_dot_locations(2,46) = -0.262866;
    sasa_dot_locations(3,46) = 0.894427;
    sasa_dot_locations(1,47) = 0.688191;
    sasa_dot_locations(2,47) = -0.500000;
    sasa_dot_locations(3,47) = 0.525731;
    sasa_dot_locations(1,48) = 0.638197;
    sasa_dot_locations(2,48) = -0.262866;
    sasa_dot_locations(3,48) = 0.723607;
    sasa_dot_locations(1,49) = 0.831052;
    sasa_dot_locations(2,49) = -0.238856;
    sasa_dot_locations(3,49) = 0.502295;
    sasa_dot_locations(1,50) = 0.447214;
    sasa_dot_locations(2,50) = -0.525731;
    sasa_dot_locations(3,50) = 0.723607;
    sasa_dot_locations(1,51) = 0.483974;
    sasa_dot_locations(2,51) = -0.716567;
    sasa_dot_locations(3,51) = 0.502295;
    sasa_dot_locations(1,52) = 0.723607;
    sasa_dot_locations(2,52) = 0.525731;
    sasa_dot_locations(3,52) = -0.447214;
    sasa_dot_locations(1,53) = 0.951057;
    sasa_dot_locations(2,53) = 0.309017;
    sasa_dot_locations(3,53) = 0.000000;
    sasa_dot_locations(1,54) = 0.956626;
    sasa_dot_locations(2,54) = 0.147621;
    sasa_dot_locations(3,54) = 0.251148;
    sasa_dot_locations(1,55) = 0.861803;
    sasa_dot_locations(2,55) = 0.425325;
    sasa_dot_locations(3,55) = 0.276393;
    sasa_dot_locations(1,56) = 0.587785;
    sasa_dot_locations(2,56) = 0.809017;
    sasa_dot_locations(3,56) = 0.000000;
    sasa_dot_locations(1,57) = 0.670820;
    sasa_dot_locations(2,57) = 0.688191;
    sasa_dot_locations(3,57) = 0.276393;
    sasa_dot_locations(1,58) = 0.436009;
    sasa_dot_locations(2,58) = 0.864188;
    sasa_dot_locations(3,58) = 0.251148;
    sasa_dot_locations(1,59) = 0.809017;
    sasa_dot_locations(2,59) = 0.587785;
    sasa_dot_locations(3,59) = 0.000000;
    sasa_dot_locations(1,60) = 0.860696;
    sasa_dot_locations(2,60) = 0.442863;
    sasa_dot_locations(3,60) = -0.251148;
    sasa_dot_locations(1,61) = 0.687157;
    sasa_dot_locations(2,61) = 0.681718;
    sasa_dot_locations(3,61) = -0.251148;
    sasa_dot_locations(1,62) = -0.276393;
    sasa_dot_locations(2,62) = 0.850651;
    sasa_dot_locations(3,62) = -0.447214;
    sasa_dot_locations(1,63) = 0.000000;
    sasa_dot_locations(2,63) = 1.000000;
    sasa_dot_locations(3,63) = 0.000000;
    sasa_dot_locations(1,64) = 0.155218;
    sasa_dot_locations(2,64) = 0.955423;
    sasa_dot_locations(3,64) = 0.251148;
    sasa_dot_locations(1,65) = -0.138197;
    sasa_dot_locations(2,65) = 0.951057;
    sasa_dot_locations(3,65) = 0.276393;
    sasa_dot_locations(1,66) = -0.587785;
    sasa_dot_locations(2,66) = 0.809017;
    sasa_dot_locations(3,66) = 0.000000;
    sasa_dot_locations(1,67) = -0.447214;
    sasa_dot_locations(2,67) = 0.850651;
    sasa_dot_locations(3,67) = 0.276393;
    sasa_dot_locations(1,68) = -0.687157;
    sasa_dot_locations(2,68) = 0.681718;
    sasa_dot_locations(3,68) = 0.251148;
    sasa_dot_locations(1,69) = -0.309017;
    sasa_dot_locations(2,69) = 0.951057;
    sasa_dot_locations(3,69) = 0.000000;
    sasa_dot_locations(1,70) = -0.155218;
    sasa_dot_locations(2,70) = 0.955423;
    sasa_dot_locations(3,70) = -0.251148;
    sasa_dot_locations(1,71) = -0.436009;
    sasa_dot_locations(2,71) = 0.864188;
    sasa_dot_locations(3,71) = -0.251148;
    sasa_dot_locations(1,72) = -0.894427;
    sasa_dot_locations(2,72) = 0.000000;
    sasa_dot_locations(3,72) = -0.447214;
    sasa_dot_locations(1,73) = -0.951057;
    sasa_dot_locations(2,73) = 0.309017;
    sasa_dot_locations(3,73) = 0.000000;
    sasa_dot_locations(1,74) = -0.860696;
    sasa_dot_locations(2,74) = 0.442863;
    sasa_dot_locations(3,74) = 0.251148;
    sasa_dot_locations(1,75) = -0.947214;
    sasa_dot_locations(2,75) = 0.162460;
    sasa_dot_locations(3,75) = 0.276393;
    sasa_dot_locations(1,76) = -0.951057;
    sasa_dot_locations(2,76) = -0.309017;
    sasa_dot_locations(3,76) = 0.000000;
    sasa_dot_locations(1,77) = -0.947214;
    sasa_dot_locations(2,77) = -0.162460;
    sasa_dot_locations(3,77) = 0.276393;
    sasa_dot_locations(1,78) = -0.860696;
    sasa_dot_locations(2,78) = -0.442863;
    sasa_dot_locations(3,78) = 0.251148;
    sasa_dot_locations(1,79) = -1.000000;
    sasa_dot_locations(2,79) = 0.000000;
    sasa_dot_locations(3,79) = 0.000000;
    sasa_dot_locations(1,80) = -0.956626;
    sasa_dot_locations(2,80) = 0.147621;
    sasa_dot_locations(3,80) = -0.251148;
    sasa_dot_locations(1,81) = -0.956626;
    sasa_dot_locations(2,81) = -0.147621;
    sasa_dot_locations(3,81) = -0.251148;
    sasa_dot_locations(1,82) = -0.276393;
    sasa_dot_locations(2,82) = -0.850651;
    sasa_dot_locations(3,82) = -0.447214;
    sasa_dot_locations(1,83) = -0.587785;
    sasa_dot_locations(2,83) = -0.809017;
    sasa_dot_locations(3,83) = 0.000000;
    sasa_dot_locations(1,84) = -0.687157;
    sasa_dot_locations(2,84) = -0.681718;
    sasa_dot_locations(3,84) = 0.251148;
    sasa_dot_locations(1,85) = -0.447214;
    sasa_dot_locations(2,85) = -0.850651;
    sasa_dot_locations(3,85) = 0.276393;
    sasa_dot_locations(1,86) = 0.000000;
    sasa_dot_locations(2,86) = -1.000000;
    sasa_dot_locations(3,86) = 0.000000;
    sasa_dot_locations(1,87) = -0.138197;
    sasa_dot_locations(2,87) = -0.951057;
    sasa_dot_locations(3,87) = 0.276393;
    sasa_dot_locations(1,88) = 0.155218;
    sasa_dot_locations(2,88) = -0.955423;
    sasa_dot_locations(3,88) = 0.251148;
    sasa_dot_locations(1,89) = -0.309017;
    sasa_dot_locations(2,89) = -0.951057;
    sasa_dot_locations(3,89) = 0.000000;
    sasa_dot_locations(1,90) = -0.436009;
    sasa_dot_locations(2,90) = -0.864188;
    sasa_dot_locations(3,90) = -0.251148;
    sasa_dot_locations(1,91) = -0.155218;
    sasa_dot_locations(2,91) = -0.955423;
    sasa_dot_locations(3,91) = -0.251148;
    sasa_dot_locations(1,92) = 0.723607;
    sasa_dot_locations(2,92) = -0.525731;
    sasa_dot_locations(3,92) = -0.447214;
    sasa_dot_locations(1,93) = 0.587785;
    sasa_dot_locations(2,93) = -0.809017;
    sasa_dot_locations(3,93) = 0.000000;
    sasa_dot_locations(1,94) = 0.436009;
    sasa_dot_locations(2,94) = -0.864188;
    sasa_dot_locations(3,94) = 0.251148;
    sasa_dot_locations(1,95) = 0.670820;
    sasa_dot_locations(2,95) = -0.688191;
    sasa_dot_locations(3,95) = 0.276393;
    sasa_dot_locations(1,96) = 0.951057;
    sasa_dot_locations(2,96) = -0.309017;
    sasa_dot_locations(3,96) = 0.000000;
    sasa_dot_locations(1,97) = 0.861803;
    sasa_dot_locations(2,97) = -0.425325;
    sasa_dot_locations(3,97) = 0.276393;
    sasa_dot_locations(1,98) = 0.956626;
    sasa_dot_locations(2,98) = -0.147621;
    sasa_dot_locations(3,98) = 0.251148;
    sasa_dot_locations(1,99) = 0.809017;
    sasa_dot_locations(2,99) = -0.587785;
    sasa_dot_locations(3,99) = 0.000000;
    sasa_dot_locations(1,100) = 0.687157;
    sasa_dot_locations(2,100) = -0.681718;
    sasa_dot_locations(3,100) = -0.251148;
    sasa_dot_locations(1,101) = 0.860696;
    sasa_dot_locations(2,101) = -0.442863;
    sasa_dot_locations(3,101) = -0.251148;
    sasa_dot_locations(1,102) = 0.262866;
    sasa_dot_locations(2,102) = 0.809017;
    sasa_dot_locations(3,102) = -0.525731;
    sasa_dot_locations(1,103) = 0.531939;
    sasa_dot_locations(2,103) = 0.681718;
    sasa_dot_locations(3,103) = -0.502295;
    sasa_dot_locations(1,104) = 0.447214;
    sasa_dot_locations(2,104) = 0.850651;
    sasa_dot_locations(3,104) = -0.276393;
    sasa_dot_locations(1,105) = 0.309017;
    sasa_dot_locations(2,105) = 0.951057;
    sasa_dot_locations(3,105) = 0.000000;
    sasa_dot_locations(1,106) = 0.138197;
    sasa_dot_locations(2,106) = 0.951057;
    sasa_dot_locations(3,106) = -0.276393;
    sasa_dot_locations(1,107) = -0.029644;
    sasa_dot_locations(2,107) = 0.864188;
    sasa_dot_locations(3,107) = -0.502295;
    sasa_dot_locations(1,108) = -0.688191;
    sasa_dot_locations(2,108) = 0.500000;
    sasa_dot_locations(3,108) = -0.525731;
    sasa_dot_locations(1,109) = -0.483974;
    sasa_dot_locations(2,109) = 0.716567;
    sasa_dot_locations(3,109) = -0.502295;
    sasa_dot_locations(1,110) = -0.670820;
    sasa_dot_locations(2,110) = 0.688191;
    sasa_dot_locations(3,110) = -0.276393;
    sasa_dot_locations(1,111) = -0.809017;
    sasa_dot_locations(2,111) = 0.587785;
    sasa_dot_locations(3,111) = 0.000000;
    sasa_dot_locations(1,112) = -0.861803;
    sasa_dot_locations(2,112) = 0.425325;
    sasa_dot_locations(3,112) = -0.276393;
    sasa_dot_locations(1,113) = -0.831052;
    sasa_dot_locations(2,113) = 0.238856;
    sasa_dot_locations(3,113) = -0.502295;
    sasa_dot_locations(1,114) = -0.688191;
    sasa_dot_locations(2,114) = -0.500000;
    sasa_dot_locations(3,114) = -0.525731;
    sasa_dot_locations(1,115) = -0.831052;
    sasa_dot_locations(2,115) = -0.238856;
    sasa_dot_locations(3,115) = -0.502295;
    sasa_dot_locations(1,116) = -0.861803;
    sasa_dot_locations(2,116) = -0.425325;
    sasa_dot_locations(3,116) = -0.276393;
    sasa_dot_locations(1,117) = -0.809017;
    sasa_dot_locations(2,117) = -0.587785;
    sasa_dot_locations(3,117) = 0.000000;
    sasa_dot_locations(1,118) = -0.670820;
    sasa_dot_locations(2,118) = -0.688191;
    sasa_dot_locations(3,118) = -0.276393;
    sasa_dot_locations(1,119) = -0.483974;
    sasa_dot_locations(2,119) = -0.716567;
    sasa_dot_locations(3,119) = -0.502295;
    sasa_dot_locations(1,120) = 0.262866;
    sasa_dot_locations(2,120) = -0.809017;
    sasa_dot_locations(3,120) = -0.525731;
    sasa_dot_locations(1,121) = -0.029644;
    sasa_dot_locations(2,121) = -0.864188;
    sasa_dot_locations(3,121) = -0.502295;
    sasa_dot_locations(1,122) = 0.138197;
    sasa_dot_locations(2,122) = -0.951057;
    sasa_dot_locations(3,122) = -0.276393;
    sasa_dot_locations(1,123) = 0.309017;
    sasa_dot_locations(2,123) = -0.951057;
    sasa_dot_locations(3,123) = 0.000000;
    sasa_dot_locations(1,124) = 0.447214;
    sasa_dot_locations(2,124) = -0.850651;
    sasa_dot_locations(3,124) = -0.276393;
    sasa_dot_locations(1,125) = 0.531939;
    sasa_dot_locations(2,125) = -0.681718;
    sasa_dot_locations(3,125) = -0.502295;
    sasa_dot_locations(1,126) = 0.850651;
    sasa_dot_locations(2,126) = 0.000000;
    sasa_dot_locations(3,126) = -0.525731;
    sasa_dot_locations(1,127) = 0.812731;
    sasa_dot_locations(2,127) = -0.295242;
    sasa_dot_locations(3,127) = -0.502295;
    sasa_dot_locations(1,128) = 0.947214;
    sasa_dot_locations(2,128) = -0.162460;
    sasa_dot_locations(3,128) = -0.276393;
    sasa_dot_locations(1,129) = 1.000000;
    sasa_dot_locations(2,129) = 0.000000;
    sasa_dot_locations(3,129) = 0.000000;
    sasa_dot_locations(1,130) = 0.947214;
    sasa_dot_locations(2,130) = 0.162460;
    sasa_dot_locations(3,130) = -0.276393;
    sasa_dot_locations(1,131) = 0.812731;
    sasa_dot_locations(2,131) = 0.295242;
    sasa_dot_locations(3,131) = -0.502295;
    sasa_dot_locations(1,132) = 0.000000;
    sasa_dot_locations(2,132) = 0.000000;
    sasa_dot_locations(3,132) = -1.000000;
    sasa_dot_locations(1,133) = 0.425325;
    sasa_dot_locations(2,133) = 0.309017;
    sasa_dot_locations(3,133) = -0.850651;
    sasa_dot_locations(1,134) = 0.609548;
    sasa_dot_locations(2,134) = 0.442863;
    sasa_dot_locations(3,134) = -0.657513;
    sasa_dot_locations(1,135) = 0.361803;
    sasa_dot_locations(2,135) = 0.587785;
    sasa_dot_locations(3,135) = -0.723607;
    sasa_dot_locations(1,136) = -0.162460;
    sasa_dot_locations(2,136) = 0.500000;
    sasa_dot_locations(3,136) = -0.850651;
    sasa_dot_locations(1,137) = 0.052786;
    sasa_dot_locations(2,137) = 0.688191;
    sasa_dot_locations(3,137) = -0.723607;
    sasa_dot_locations(1,138) = -0.232827;
    sasa_dot_locations(2,138) = 0.716567;
    sasa_dot_locations(3,138) = -0.657513;
    sasa_dot_locations(1,139) = 0.138197;
    sasa_dot_locations(2,139) = 0.425325;
    sasa_dot_locations(3,139) = -0.894427;
    sasa_dot_locations(1,140) = 0.203183;
    sasa_dot_locations(2,140) = 0.147621;
    sasa_dot_locations(3,140) = -0.967949;
    sasa_dot_locations(1,141) = -0.077609;
    sasa_dot_locations(2,141) = 0.238856;
    sasa_dot_locations(3,141) = -0.967949;
    sasa_dot_locations(1,142) = -0.447214;
    sasa_dot_locations(2,142) = 0.525731;
    sasa_dot_locations(3,142) = -0.723607;
    sasa_dot_locations(1,143) = -0.525731;
    sasa_dot_locations(2,143) = 0.000000;
    sasa_dot_locations(3,143) = -0.850651;
    sasa_dot_locations(1,144) = -0.638197;
    sasa_dot_locations(2,144) = 0.262866;
    sasa_dot_locations(3,144) = -0.723607;
    sasa_dot_locations(1,145) = -0.753443;
    sasa_dot_locations(2,145) = 0.000000;
    sasa_dot_locations(3,145) = -0.657513;
    sasa_dot_locations(1,146) = -0.361803;
    sasa_dot_locations(2,146) = 0.262866;
    sasa_dot_locations(3,146) = -0.894427;
    sasa_dot_locations(1,147) = -0.251148;
    sasa_dot_locations(2,147) = 0.000000;
    sasa_dot_locations(3,147) = -0.967949;
    sasa_dot_locations(1,148) = -0.638197;
    sasa_dot_locations(2,148) = -0.262866;
    sasa_dot_locations(3,148) = -0.723607;
    sasa_dot_locations(1,149) = -0.162460;
    sasa_dot_locations(2,149) = -0.500000;
    sasa_dot_locations(3,149) = -0.850651;
    sasa_dot_locations(1,150) = -0.447214;
    sasa_dot_locations(2,150) = -0.525731;
    sasa_dot_locations(3,150) = -0.723607;
    sasa_dot_locations(1,151) = -0.232827;
    sasa_dot_locations(2,151) = -0.716567;
    sasa_dot_locations(3,151) = -0.657513;
    sasa_dot_locations(1,152) = -0.361803;
    sasa_dot_locations(2,152) = -0.262866;
    sasa_dot_locations(3,152) = -0.894427;
    sasa_dot_locations(1,153) = -0.077609;
    sasa_dot_locations(2,153) = -0.238856;
    sasa_dot_locations(3,153) = -0.967949;
    sasa_dot_locations(1,154) = 0.052786;
    sasa_dot_locations(2,154) = -0.688191;
    sasa_dot_locations(3,154) = -0.723607;
    sasa_dot_locations(1,155) = 0.425325;
    sasa_dot_locations(2,155) = -0.309017;
    sasa_dot_locations(3,155) = -0.850651;
    sasa_dot_locations(1,156) = 0.361803;
    sasa_dot_locations(2,156) = -0.587785;
    sasa_dot_locations(3,156) = -0.723607;
    sasa_dot_locations(1,157) = 0.609548;
    sasa_dot_locations(2,157) = -0.442863;
    sasa_dot_locations(3,157) = -0.657513;
    sasa_dot_locations(1,158) = 0.138197;
    sasa_dot_locations(2,158) = -0.425325;
    sasa_dot_locations(3,158) = -0.894427;
    sasa_dot_locations(1,159) = 0.203183;
    sasa_dot_locations(2,159) = -0.147621;
    sasa_dot_locations(3,159) = -0.967949;
    sasa_dot_locations(1,160) = 0.670820;
    sasa_dot_locations(2,160) = -0.162460;
    sasa_dot_locations(3,160) = -0.723607;
    sasa_dot_locations(1,161) = 0.670820;
    sasa_dot_locations(2,161) = 0.162460;
    sasa_dot_locations(3,161) = -0.723607;
    sasa_dot_locations(1,162) = 0.447214;
    sasa_dot_locations(2,162) = 0.000000;
    sasa_dot_locations(3,162) = -0.894427;

    // locations are negative so reverse them!!!
    for(int ii = 1; ii <= 162; ii++)
      for(int jj = 1; jj <= 3; jj++)
				sasa_dot_locations(jj,ii) *= -1;

		float mn = 0.26;

		if ( false ) {
			for (int ii=1; ii<=1; ii++) {
				for( int jj = 1; jj <= 162; jj += 1 ) {
					float const xx = sasa_dot_locations(1,ii) + sasa_dot_locations(1,jj);
					float const yy = sasa_dot_locations(2,ii) + sasa_dot_locations(2,jj);
					float const zz = sasa_dot_locations(3,ii) + sasa_dot_locations(3,jj);
					float const dis = sqrt(xx*xx + yy*yy + zz*zz);
					if ( 0 < dis && dis < mn ) {
						cout << ii << ' ' << jj << ' ' << dis << endl;
					}
				}
			}
		}

		bool perturb_dots = false;
		if ( perturb_dots ) {

			FArray2D_float newsdl(3,162,-1234);

			float rx,ry,rz;
			float r2 = 9999;
			while ( r2 > 1.0f )  {
				rx = ran3();
				ry = ran3();
				rz = ran3();
				r2 = rx*rx + ry*ry + rz*rz;
			}
			float r = sqrt(r2);
			rx = rx/r;
			ry = ry/r;
			rz = rz/r;
			float const phi = acos( rz );
			numeric::xyzVector_float const axis( rx,ry,0 );
			numeric::xyzMatrix_float rot( rotation_matrix(axis,phi) );
			for (int ii=1; ii <= 162; ++ii ) {
				xyzVector_float x(sasa_dot_locations(1,ii));
				x = rot * x;
				newsdl(1,ii) = x.x();
				newsdl(2,ii) = x.y();
				newsdl(3,ii) = x.z();
			}

			if ( false ) {
				for (int ii=1; ii<=1; ii++) {
					float const xx = sasa_dot_locations(1,ii);
					float const yy = sasa_dot_locations(2,ii);
					float const zz = sasa_dot_locations(3,ii);
					cout << F( 7,2, xx) <<  F( 7,2, yy) <<  F( 7,2, zz)
						<< F( 7,2, newsdl(1,ii)) <<  F( 7,2, newsdl(2,ii)) <<  F( 7,2, newsdl(3,ii) )
						<< endl;
				}
			}


		}



  }
}


