// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12328 $
//  $Date: 2007-01-30 05:08:39 -0800 (Tue, 30 Jan 2007) $
//  $Author: sheffler $


#ifndef INCLUDED_packing_measures
#define INCLUDED_packing_measures


//Rosetta Headers
#include "atom_is_backbone.h"
#include "pack_geom_inline.h"
#include "RotamerDotsFWD.h"
#include "pose.h"
#include "misc.h"
#include "aaproperties_pack.h"
#include "RotamerDotsFWD.h"
#include "fullatom_sasa.h"
#include "fullatom_sasa_ns.h"
#include "RotamerDots.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray4Da.hh>
#include <ObjexxFCL/FArray5Da.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>
#include <ObjexxFCL/Fmath.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/constants.hh>

// Utility Headers
#include <utility/vector1.hh>
#include <utility/vector1.fwd.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>

// C++ Headers
#include <cstdlib>
#include <vector>
#include <map>
#include <string>
#include <set>


namespace packing_ns {
	using namespace std;
	using namespace pose_ns;
	using namespace utility;
	using numeric::xyzVector_float;
	using numeric::xyzMatrix_float;

	extern map<string,bool> packing_flags; // better system, for the future
	namespace packing_options {
		extern float min_hole_radius             ;
		extern float max_hole_radius             ;
		extern float cavity_burial_probe_radius    ;
		extern float max_hole_sasa               ;
		//extern int   min_cluster_size            ;
		//extern int   min_cluster_size_aspiration ;
		extern float min_cluster_volume          ;
		extern float min_cluster_surface_area    ;
		extern float min_cluster_ball_radius     ;
		extern float max_cluster_ball_radius     ;
		extern int   use_occ_rms                 ;
		//extern bool  compute_complete_burial     ;
		//extern bool  holes_bury_holes            ;
		//extern bool  compute_rms_stats           ;
		//extern bool  stats_ignore_exposed_holes  ;
		//extern bool  skip_missing_density        ;
	}


	extern int const N_CAVBALL_DISBINS;

	class ProteinSasa;
	class CavityBallCluster;
	class CavityBall;
	//class ResidueSasa;
	//class AtomSasa;


	extern unsigned int const HUGE_UNSIGNED_INT;

	extern int const N_DIM_S09;
	extern int const N_DIM_S20;
	extern FArray1D_float bsasa920_weights;
	extern FArray2D_float bsasa920_quantiles;
	// Stuff copied right from void_ns -- temporary hack
	extern FArray2D_float sasa_dot_locations;
	extern FArray1D_float ballsasa_probe_radii;
	//void sasa_dot_locations_initializer(FArray2D_float & sasa_dot_locations);

	extern int const n_pr_bin;
	extern int const pr_bin_5;
	extern int const pr_bin_9;
	extern int const pr_bin_14;
	extern int const pr_bin_20;
	extern int const pr_bin_30;
	extern bool heavy_atoms_only;
	extern int const	max_sasa_offset_bins;

	typedef int AtomType;

	void initialize_packing_measures();
	void packing_initialize_options();

	//struct RosAtm {
	//	int const atom;
	//	int const res;
	//};

	/* TODO MOVE RMS CODE TO THESE MORE GENERAL FUNCTIONS!!!!!!!
	float const relative_rms( vector1<xyzVector_float> const p1,
														vector1<xyzVector_float> const p2,
														vector1<float>           const w            ) ;

	float const absolute_rms( vector1<xyzVector_float> const p1,
														vector1<xyzVector_float> const p2,
														vector1<float>           const w,
														vector1<xyzVector_float> const ca1,
														vector1<xyzVector_float> const ca2						) ;
		*/

///////////////////////// CavityBall ///////////////////
class CavityBall {
public:
	CavityBall(int const id,
						 int const atom, int const res,
						 float const x, float const y, float const z,
						 float const r);

		string const heteroAtomLine( int const hetresnum, float const occ ) const ;
		bool cmp( CavityBall * a, CavityBall * b );
		inline float distto( CavityBall & b) const { return distto( &b );	}
		inline bool touches( CavityBall & b ) const { return touches( &b ); }
		inline float overlap( CavityBall & b ) const { return overlap( &b ); }

		bool overlaps( CavityBall const *b) const ;

		inline float distto( CavityBall const * b) const {
			return distance(this->xyz_,b->xyz_) - radius_ - b->radius();
		}
		inline bool touches( CavityBall * b) const {
			return distance_squared(this->xyz_,b->xyz_) <
			(radius_+b->radius())*(radius_+b->radius());
		}

		inline float overlap( CavityBall * b) const {
			float o = abs(distance(this->xyz_,b->xyz_) - (radius_+b->radius()));
			return std::
max( o/radius_, o/b->radius_ );
		}
		int recursive_mark_hole_neighbors( vector1<CavityBall> & holes, int const cluster );

		string const str() const;

		inline int    atom()   const { return atom_;   };
		inline int    res()    const { return res_;    };
		inline float  radius() const { return radius_; };
		inline float  sasa()   const { return sasa_;   };
		inline int    id()     const { return id_;     };
		inline void   set_cluster_id(int cid) { cluster_id_ = cid; }

		int operator<(const CavityBall &rhs) const {
			return radius() > rhs.radius();
		}

		ostream& operator <<(ostream &os) {
			os << str();
			return os;
		}
		inline CavityBallCluster * cluster() const { return cluster_; }


		int get_cluster_id() const { return cluster_id_; }
//private: // make this stuf private at some point

		int atom_,res_;
		xyzVector_float xyz_;
		float radius_;
		float sasa_; // if this > 0, the ball is considered pruned

		vector1<float> hole_sasa_;				// these will only be computed if
		FArray2D_float surrounding_sasa_; // compute_packing_statistics is called
		//FArray1D_float surrounding_sasa_5A_; // withing 5A of center, like before for comparison
		vector1<int>  neighbor_count_; // # atoms within 1A, 2A, 3A...
		vector1<float> avg_occupancy_;
		vector1<float> avg_bfactor_;
		vector1<float> absolute_shell_rms_;
		vector1<float> relative_shell_rms_;
		//int  neighbor_count_5A_;  // within 5A of center, like before

		bool heavyatom_;
		int num_other_balls_overlap_;        // number of other "holes" we overlap with (any and all)
		int num_buried_other_balls_overlap_; // number of non-exposed balls we overlap with
		int num_big_other_balls_overlap_;    // number of properly sized (not too small) balls overlap
		int num_big_buried_other_balls_overlap_; // num. properly sized and not exposed overlapers

		vector1<CavityBall*> neighboring_cavity_balls_;            // number of other "holes" we overlap with (any and all)
		vector1<CavityBall*> buried_neighboring_cavity_balls_;     // number of non-exposed balls we overlap with
		vector1<CavityBall*> big_neighboring_cavity_balls_;        // number of properly sized (not too small) balls overlap
		vector1<CavityBall*> big_buried_neighboring_cavity_balls_; // num. properly sized and not exposed overlapers

		int cluster_id_; // used for grouping holesa
		int id_;
		CavityBallCluster *cluster_;

};


////////////////// Cavity ///////////////////////
class  CavityBallCluster {
public:
	CavityBallCluster(int const id, vector1<CavityBall*> const balls);
	//vector1<RosAtm> const atomNeighbors( float const radius );
	inline int size() { return (int)cavity_balls_.size(); }
	void compute_surface_area();
	void compute_volume();
	inline float surface_area() const { return surface_area_; };
	inline float volume() const { return volume_; };
	string const str() const;
	bool cmp( CavityBallCluster * a, CavityBallCluster * b );
	inline int size() const { return (int)cavity_balls_.size();	}
	inline float largest_cavity_ball_radius() const { return largest_cavity_ball_radius_; }
	inline CavityBall * cavity_ball(int const ii) const { return cavity_balls_[ii]; }
	int operator<(const CavityBallCluster &rhs) const {
		return size() > rhs.size();
	}
	void set_id( int id ) { id_ = id; }
	ostream& operator <<(ostream &os) {
		os << str();
		return os;
	}

	// make these private and set with accessor functions!
	vector1<CavityBall*> cavity_balls_;
	int id_;
	float largest_cavity_ball_radius_;
	float surface_area_;
	float volume_;

//private:
	//	;
};


////////////////
	class ProteinSasa {
public:
		ProteinSasa();
		~ProteinSasa();

		//////////////////////////////////////////////////////////////////////////////
		// this is pretty much it for now...


		void compute_atom_bsasa_score();

		// accessors
		inline float atom_bsasa_score( int const atom, int const res ) const {
			return atom_bsasa_score_(atom,res); }
		inline float atom_bsasa_score_weighted( int const atom, int const res ) const {
			return atom_bsasa_score_weighted_(atom,res); }
		inline float bsasa_score( ) const { return bsasa_score_; }
		inline float bsasa_score_weighted( ) const { return bsasa_score_weighted_; }
		inline float bsasa_score_log( ) const { return bsasa_score_log_; }
		inline float bsasa_score_weighted_log( ) const { return bsasa_score_weighted_log_; }
		inline float bsasa_score_pruned( ) const { return bsasa_score_pruned_; }

		inline float rsd_sasa(int const pr_bin, int const res) const {
			return rsd_sasa_(pr_bin,res); }

		inline float atom_sasa(int const pr_bin, int const atom,int const res) const {
			return atom_sasa_(pr_bin,atom,res); }

		inline xyzVector_float atom_sasa_center(int const atom, int const res ) const {
			return xyzVector_float( atom_sasa_center_(1,atom,res) ,
															atom_sasa_center_(2,atom,res) ,
															atom_sasa_center_(3,atom,res) );
		}

		inline float largest_probe_radius(int const atom, int const res) const {
			int const i = largest_probe_radius_bin_(atom,res);
			if( i > 0 )
				return ballsasa_probe_radii(i);
			else
				return -12345.0f;
		}
		inline int atom_sasa_dots(int const pr_bin, int const atom, int const res) const {
			return atom_sasa_dots_(pr_bin,atom,res);
		}

		inline int unsigned bigrad_count(int const atom, int const res) const {
			return ball_atom_sasa_count_(1,atom,res);
		}

		inline int unsigned ball_atom_sasa_count(int pr_index, int const atom, int const res) const {
			return ball_atom_sasa_count_(pr_index,atom,res);
		}
		inline float ball_atom_sasa_area(int pr_index, int const atom, int const res) const {
			return ball_atom_sasa_area_(pr_index,atom,res);
		}

		inline float res_bsasa_score(int const res) const {
			return res_bsasa_score_(res);
		}

		inline set<int> hole_neighbors(int const atom, int const res) const {
			return hole_neighbors_[ atom + param::MAX_ATOM()()*res ];
		}

		inline set<int> worst_hole_neighbors() const {
			return worst_hole_neighbors_;
		}

		int compute_cavity_ball_burial( bool  const holes_bury_holes = true,
																		int   const max_iters      = 10, // this now reads probe radius from member var
																		int   const threshold_diff = 0 ) ;


		void compute_cavity_ball_burial_single_pass( float const probe_radius_large,
																								 bool  const holes_bury_holes    );

		void print_all_holes() const ;
		void print_all_clusters() const;

		float compute_pruned_bsasa_score(bool const require_size_ok    = false, // defaults here are
																		 bool const require_buried     = true, // pretty permissive
																		 bool const require_cluster_ok = false ) const;

		void output_packing_statistics( utility::io::ozstream & out,
																		std::string decoy_id,
																		bool const require_size_ok    = false, // defaults here are
																		bool const require_buried     = true, // pretty permissive
																		bool const require_cluster_ok = false ) ;

		void build_restricted_hole_set(FArray1D_bool & allowed_residue,
																	 vector< CavityBall > & restricted_hole_set,
																	 bool const require_size_ok    = true, // enforce min/max hole size
																	 bool const require_buried     = true,  // hole must be buried
																	 bool const require_cluster_ok = true  ) const;  // cluster hole is part of must satisfy requirements
																																													// one large ball in cluster
		void build_restricted_hole_set(FArray2D_bool & allowed_atom,
																	 vector< CavityBall > & restricted_hole_set,
																	 bool const require_size_ok    = true, // enforce min/max hole size
																	 bool const require_buried     = true, // hole must be buried
																	 bool const require_cluster_ok = true  ) const;  // cluster hole is part of must satisfy requirements

	void build_restricted_cluster_set(FArray1D_bool & allowed_residue,
																 vector< CavityBallCluster > & restricted_cluster_set,
																 bool const require_size_ok    = true, // enforce min/max hole size
																 bool const require_buried     = true,  // hole must be buried
																 bool const require_cluster_ok = true  ) const;  // cluster hole is part of must satisfy requirements
	// one large ball in cluster
	void build_restricted_cluster_set(FArray2D_bool & allowed_atom,
																 vector< CavityBallCluster > & restricted_cluster_set,
																 bool const require_size_ok    = true, // enforce min/max hole size
																 bool const require_buried     = true, // hole must be buried
																 bool const require_cluster_ok = true  ) const;  // cluster hole is part of must satisfy requirements

		float find_sidechain_max_hole( int const resnum, bool const require_hydrophobic = false );



		float sasa_of_sphere( xyzVector_float zyx, float radius, float probe_radius );


		// methods for checking params
		bool inline cavity_ball_size_ok(int ii) const {
			return packing_options::min_hole_radius <= cavity_balls_[ii].radius() && cavity_balls_[ii].radius() <= packing_options::max_hole_radius;
		}
		bool inline cavity_ball_buried(int const ii) const {
			return cavity_balls_[ii].sasa() <= packing_options::max_hole_sasa;
		}
		bool inline cluster_ok( CavityBallCluster const & cbc ) const {
			//cout << cbc.str() << endl;
			//cout <<  packing_options::min_cluster_ball_radius << ' ' << packing_options::min_cluster_size << ' ' << packing_options::min_cluster_size_aspiration << endl;
			return packing_options::min_cluster_volume       <= cbc.volume_ &&
			       packing_options::min_cluster_surface_area <= cbc.surface_area_ &&
						 packing_options::min_cluster_ball_radius  <= cbc.largest_cavity_ball_radius() &&
			       packing_options::max_cluster_ball_radius  >= cbc.largest_cavity_ball_radius()
			;
		}
		bool inline cluster_ok( CavityBallCluster const * const cbc ) const {
			return cluster_ok(*cbc);
		}
		bool inline cavity_ball_cluster_ok(int const ii) const {
			if (cavity_balls_[ii].cluster_id_ < 1)
				return false;
			else
				return cluster_ok( cavity_balls_[ii].cluster() );
		}
		bool inline cavity_ball_all_ok(int const ii,
																				 bool const require_size_ok    = true,
																				 bool const require_buried     = true,
																				 bool const require_cluster_ok = true  ) const
		{
			return ( cavity_ball_size_ok(ii)    || !require_size_ok    ) &&
						 ( cavity_ball_buried(ii)     || !require_buried     ) &&
             ( cavity_ball_cluster_ok(ii) || !require_cluster_ok );
		}
		CavityBallCluster const & hole_cluster( int const ii ) const {
			assert( cavity_balls_[ii].cluster_id_ > 0 );
			return cavity_ball_clusters_[ cavity_balls_[ii].cluster_id_ ] ;
		}

		string getHeteroAtoms( bool const require_size_ok    = true,
													 bool const require_buried     = true,
													 bool const require_cluster_ok = true  ) const;

		void compute_neighboring_holes();


		// this now has to take some options, but there are sensable defaults
		bool include_packing_in_outpdbs(bool const require_size_ok    = true,
																		bool const require_buried     = true,
																		bool const require_cluster_ok = true  )  const;
		bool uninclude_packing_in_outpdbs() const;

		//////////////////////////////////////////////////////////////////////////////

		void update();

		bool init();
		bool init_MAX_RES();
		void set_atom_radii( FArray1D_float const & radii );
		void set_atom_radii( vector<float>  const & radii );
		bool precompute_sasa(float radius);
		bool precompute_sasa_multiple_radii(vector<float> radii);
		void phils_sasa_routine();
		bool valid() { return valid_; }

		//float ballsasa_probe_radii(int ii) { return ballsasa_probe_radii_(ii); }

		bool makePackingPDB( utility::io::ozstream& out,
												 bool const compute_burial = true,
												 bool const require_size = true,
												 bool const require_buried = true,
												 bool const require_cluster_ok = true );

		void setup_fasc_cols();

		float compute_hole_sasa( CavityBall *cb,
														 float const probe_radius,
														 vector1<CavityBall*> & other_holes );

private:

		void probe_calc_min_rsq( FArray2Da_float rsq_min, float const radius, float & overall_min);
		map<AtomType,float> atom_radii_;

		// Stuff copied right from void_ns -- temporary hack
		FArray2D_float sasa_dot_locations_;
		//FArray1D_float ballsasa_probe_radii_;

		FArray2D_float rsd_sasa_;
		FArray3D_float atom_sasa_;
		FArray3D_float atom_sasa_center_;
		FArray3D_int   atom_sasa_dots_;

		vector1< CavityBall > cavity_balls_;           // now just keep one set of holes and
																								//vector1< CavityBall > removed_cavity_balls_;
																								// annotate them.. better than separate lists
		vector1< set<int> >    hole_neighbors_;
		set<int> worst_hole_neighbors_;
		int num_buried_cavity_balls_;
		int num_exposed_cavity_balls_;

		float bsasa_score_;
		float bsasa_score_weighted_;
		float bsasa_score_log_;
		float bsasa_score_weighted_log_;
		float bsasa_score_pruned_;
		FArray2D_float atom_bsasa_score_;
		FArray2D_float atom_bsasa_score_weighted_;
		FArray3D_int   ball_atom_sasa_count_;
		FArray3D_float ball_atom_sasa_area_;
		FArray2D_int   largest_probe_radius_bin_;
		FArray1D_float bsasa920_weights_;
		FArray2D_float bsasa920_quantiles_;
		FArray1D_float res_bsasa_score_;

		bool valid_;
		bool cavity_ball_burial_computed_;

		FArray4D_ubyte atom_sasa_masks_;

		bool done_init_;

		void clear_exposed_balls();

		vector1<CavityBallCluster> cavity_ball_clusters_;

	};

}

#endif
