// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 20824 $
//  $Date: 2008-03-05 05:37:02 -0800 (Wed, 05 Mar 2008) $
//  $Author: matan_kob $

// Rosetta Headers
#include "add_pser.h"
#include "design.h"
#include "dna.h" // dna_enabled()
#include "enzyme.h"
#include "param_aa.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/string.functions.hh>

// Using
using namespace param;


//ctsa
//     shared generic amino acid data and enumerators
//


namespace param_aa {


int const aa_ala = { 1 };
int const aa_cys = { 2 };
int const aa_asp = { 3 };
int const aa_glu = { 4 };
int const aa_phe = { 5 };
int const aa_gly = { 6 };
int const aa_his = { 7 };
int const aa_ile = { 8 };
int const aa_lys = { 9 };
int const aa_leu = { 10 };
int const aa_met = { 11 };
int const aa_asn = { 12 };
int const aa_pro = { 13 };
int const aa_gln = { 14 };
int const aa_arg = { 15 };
int const aa_ser = { 16 };
int const aa_thr = { 17 };
int const aa_val = { 18 };
int const aa_trp = { 19 };
int const aa_tyr = { 20 };
int const aa_sep = { 21 };//KMa phospho_ser 2006-01
int const na_gua = { 22 };
int const na_ade = { 23 };
int const na_cyt = { 24 };
int const na_thy = { 25 };
int const na_rgu = { 26 };
int const na_rad = { 27 };
int const na_rcy = { 28 };
int const na_ura = { 29 };
//int lig1;
//int lig2;
utility::vector1<int> ligand_aa_vector;

namespace param_aa_data {

	void
	aa_is_polar_initializer( FArray1D_bool & aa_is_polar )
	{
		aa_is_polar( aa_ala ) = false; // ACDEF
		aa_is_polar( aa_cys ) = false;
		aa_is_polar( aa_asp ) = true;
		aa_is_polar( aa_glu ) = true;
		aa_is_polar( aa_phe ) = false;
		aa_is_polar( aa_gly ) = false; // GHIKL
		aa_is_polar( aa_his ) = true;
		aa_is_polar( aa_ile ) = false;
		aa_is_polar( aa_lys ) = true;
		aa_is_polar( aa_leu ) = false;
		aa_is_polar( aa_met ) = false; // MNPQR
		aa_is_polar( aa_asn ) = true;
		aa_is_polar( aa_pro ) = false;
		aa_is_polar( aa_gln ) = true;
		aa_is_polar( aa_arg ) = true;
		aa_is_polar( aa_ser ) = true; // STVWY
		aa_is_polar( aa_thr ) = true;
		aa_is_polar( aa_val ) = false;
		aa_is_polar( aa_trp ) = false;
		aa_is_polar( aa_tyr ) = false;
		if ( add_pser() ) {
			aa_is_polar( aa_sep ) = true;//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			aa_is_polar( na_gua ) = true; // Nucleics
			aa_is_polar( na_ade ) = true;
			aa_is_polar( na_cyt ) = true;
			aa_is_polar( na_thy ) = true;
			aa_is_polar( na_rgu ) = true; // Nucleics
			aa_is_polar( na_rad ) = true;
			aa_is_polar( na_rcy ) = true;
			aa_is_polar( na_ura ) = true;
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				aa_is_polar( *cligaa) =true;
//			aa_is_polar( lig1 ) = true; // Ligand aa
//			aa_is_polar( lig2 ) = true;
			}
		}
	}

	void
	aa_is_nonpolar_initializer( FArray1D_bool & aa_is_nonpolar )
	{
		aa_is_nonpolar(	aa_ala ) = true; // ACDEF
		aa_is_nonpolar(	aa_cys ) = true;
		aa_is_nonpolar(	aa_asp ) = false;
		aa_is_nonpolar(	aa_glu ) = false;
		aa_is_nonpolar(	aa_phe ) = true;
		aa_is_nonpolar(	aa_gly ) = true; // GHIKL
		aa_is_nonpolar(	aa_his ) = false;
		aa_is_nonpolar(	aa_ile ) = true;
		aa_is_nonpolar(	aa_lys ) = false;
		aa_is_nonpolar(	aa_leu ) = true;
		aa_is_nonpolar(	aa_met ) = true; // MNPQR
		aa_is_nonpolar(	aa_asn ) = false;
		aa_is_nonpolar(	aa_pro ) = true;
		aa_is_nonpolar(	aa_gln ) = false;
		aa_is_nonpolar(	aa_arg ) = false;
		aa_is_nonpolar(	aa_ser ) = false; // STVWY
		aa_is_nonpolar(	aa_thr ) = false;
		aa_is_nonpolar(	aa_val ) = true;
		aa_is_nonpolar(	aa_trp ) = true;
		aa_is_nonpolar(	aa_tyr ) = true;
		if ( add_pser() ) {
			aa_is_nonpolar( aa_sep ) = false;//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			aa_is_nonpolar( na_gua ) = false; // Nucleics
			aa_is_nonpolar( na_ade ) = false;
			aa_is_nonpolar( na_cyt ) = false;
			aa_is_nonpolar( na_thy ) = false;
			aa_is_nonpolar( na_rgu ) = false; // Nucleics
			aa_is_nonpolar( na_rad ) = false;
			aa_is_nonpolar( na_rcy ) = false;
			aa_is_nonpolar( na_ura ) = false;
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				aa_is_nonpolar( *cligaa) =false;
			}
//			aa_is_nonpolar( lig1 ) = false; // ligand
//			aa_is_nonpolar( lig2 ) = false;
		}

	}

	void
	aa_is_aromatic_initializer( FArray1D_bool & aa_is_aromatic )
	{
		aa_is_aromatic(	aa_ala ) = false; // ACDEF
		aa_is_aromatic(	aa_cys ) = false;
		aa_is_aromatic(	aa_asp ) = false;
		aa_is_aromatic(	aa_glu ) = false;
		aa_is_aromatic(	aa_phe ) = true;
		aa_is_aromatic(	aa_gly ) = false; // GHIKL
		aa_is_aromatic(	aa_his ) = false;
		aa_is_aromatic(	aa_ile ) = false;
		aa_is_aromatic(	aa_lys ) = false;
		aa_is_aromatic(	aa_leu ) = false;
		aa_is_aromatic(	aa_met ) = false; // MNPQR
		aa_is_aromatic(	aa_asn ) = false;
		aa_is_aromatic(	aa_pro ) = false;
		aa_is_aromatic(	aa_gln ) = false;
		aa_is_aromatic(	aa_arg ) = false;
		aa_is_aromatic(	aa_ser ) = false; // STVWY
		aa_is_aromatic(	aa_thr ) = false;
		aa_is_aromatic(	aa_val ) = false;
		aa_is_aromatic(	aa_trp ) = true;
		aa_is_aromatic(	aa_tyr ) = true;
		if ( add_pser() ) {
			aa_is_aromatic( aa_sep ) = false;//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			aa_is_aromatic( na_gua ) = true; // Nucleics
			aa_is_aromatic( na_ade ) = true;
			aa_is_aromatic( na_cyt ) = true;
			aa_is_aromatic( na_thy ) = true;
			aa_is_aromatic( na_rgu ) = true; // Nucleics
			aa_is_aromatic( na_rad ) = true;
			aa_is_aromatic( na_rcy ) = true;
			aa_is_aromatic( na_ura ) = true;
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				aa_is_aromatic( *cligaa) =true;
			}
//			aa_is_aromatic( lig1 ) = true; // ligand
//			aa_is_aromatic( lig2 ) = true;
		}

	}

	void
	aa_is_charged_initializer( FArray1D_bool & aa_is_charged )
	{ // ( at physio. PH )

		aa_is_charged( aa_ala ) = false; // ACDEF
		aa_is_charged( aa_cys ) = false;
		aa_is_charged( aa_asp ) = true;
		aa_is_charged( aa_glu ) = true;
		aa_is_charged( aa_phe ) = false;
		aa_is_charged( aa_gly ) = false; // GHIKL
		aa_is_charged( aa_his ) = false;
		aa_is_charged( aa_ile ) = false;
		aa_is_charged( aa_lys ) = true;
		aa_is_charged( aa_leu ) = false;
		aa_is_charged( aa_met ) = false; // MNPQR
		aa_is_charged( aa_asn ) = false;
		aa_is_charged( aa_pro ) = false;
		aa_is_charged( aa_gln ) = false;
		aa_is_charged( aa_arg ) = true;
		aa_is_charged( aa_ser ) = false; // STVWY
		aa_is_charged( aa_thr ) = false;
		aa_is_charged( aa_val ) = false;
		aa_is_charged( aa_trp ) = false;
		aa_is_charged( aa_tyr ) = false;
		if ( add_pser() ) {
			aa_is_charged( aa_sep ) = true;//KMa phospho_ser 2006-01; matan_kob, sep is charged,2008-02
		}
		if ( dna_enabled() ) {
			aa_is_charged( na_gua ) = true; // Nucleics
			aa_is_charged( na_ade ) = true;
			aa_is_charged( na_cyt ) = true;
			aa_is_charged( na_thy ) = true;
			aa_is_charged( na_rgu ) = true; // Nucleics
			aa_is_charged( na_rad ) = true;
			aa_is_charged( na_rcy ) = true;
			aa_is_charged( na_ura ) = true;
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				aa_is_charged( *cligaa) =true;
			}
//			aa_is_charged( lig1 ) = true; // ligand
//			aa_is_charged( lig2 ) = true;
		}

	}

	void
	is_protein_initializer( FArray1D_bool & is_protein )
	{
		is_protein(	aa_ala ) = true; // ACDEF
		is_protein(	aa_cys ) = true;
		is_protein(	aa_asp ) = true;
		is_protein(	aa_glu ) = true;
		is_protein(	aa_phe ) = true;
		is_protein(	aa_gly ) = true; // GHIKL
		is_protein(	aa_his ) = true;
		is_protein(	aa_ile ) = true;
		is_protein(	aa_lys ) = true;
		is_protein(	aa_leu ) = true;
		is_protein(	aa_met ) = true; // MNPQR
		is_protein(	aa_asn ) = true;
		is_protein(	aa_pro ) = true;
		is_protein(	aa_gln ) = true;
		is_protein(	aa_arg ) = true;
		is_protein(	aa_ser ) = true; // STVWY
		is_protein(	aa_thr ) = true;
		is_protein(	aa_val ) = true;
		is_protein(	aa_trp ) = true;
		is_protein(	aa_tyr ) = true;
		if ( add_pser() ) {
			is_protein(	aa_sep ) = true;//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			is_protein(	na_gua ) = false; // NucAcids
			is_protein(	na_ade ) = false;
			is_protein(	na_cyt ) = false;
			is_protein(	na_thy ) = false;
			is_protein(	na_rgu ) = false; // NucAcids
			is_protein(	na_rad ) = false;
			is_protein(	na_rcy ) = false;
			is_protein(	na_ura ) = false;
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				is_protein( *cligaa) =false;
			}
//			is_protein( lig1 ) = false; // Ligand aa
//			is_protein( lig2 ) = false;
		}

	}

	void
	is_RNA_initializer( FArray1D_bool & is_RNA )
	{
    is_RNA(	aa_ala ) = false; // ACDEF
		is_RNA(	aa_cys ) = false;
		is_RNA(	aa_asp ) = false;
		is_RNA(	aa_glu ) = false;
		is_RNA(	aa_phe ) = false;
		is_RNA(	aa_gly ) = false; // GHIKL
		is_RNA(	aa_his ) = false;
		is_RNA(	aa_ile ) = false;
		is_RNA(	aa_lys ) = false;
		is_RNA(	aa_leu ) = false;
		is_RNA(	aa_met ) = false; // MNPQR
		is_RNA(	aa_asn ) = false;
		is_RNA(	aa_pro ) = false;
		is_RNA(	aa_gln ) = false;
		is_RNA(	aa_arg ) = false;
		is_RNA(	aa_ser ) = false; // STVWY
		is_RNA(	aa_thr ) = false;
		is_RNA(	aa_val ) = false;
		is_RNA(	aa_trp ) = false;
		is_RNA(	aa_tyr ) = false;
		if ( add_pser() ) {
			is_RNA(	aa_sep ) = false;//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			is_RNA(	na_gua ) = false; // NucAcids
			is_RNA(	na_ade ) = false;
			is_RNA(	na_cyt ) = false;
			is_RNA(	na_thy ) = false;
			is_RNA(	na_rgu ) = true; // NucAcids
			is_RNA(	na_rad ) = true;
			is_RNA(	na_rcy ) = true;
			is_RNA(	na_ura ) = true;
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				is_RNA( *cligaa) =false;
			}

//			is_RNA( lig1 ) = false; // Ligand aa
//			is_RNA( lig2 ) = false;
		}

	}

	void
	aa_name1_initializer( FArray1D_char & aa_name1 )
	{
		aa_name1(	aa_ala ) = 'A'; // ACDEF
		aa_name1(	aa_cys ) = 'C';
		aa_name1(	aa_asp ) = 'D';
		aa_name1(	aa_glu ) = 'E';
		aa_name1(	aa_phe ) = 'F';
		aa_name1(	aa_gly ) = 'G'; // GHIKL
		aa_name1(	aa_his ) = 'H';
		aa_name1(	aa_ile ) = 'I';
		aa_name1(	aa_lys ) = 'K';
		aa_name1(	aa_leu ) = 'L';
		aa_name1(	aa_met ) = 'M'; // MNPQR
		aa_name1(	aa_asn ) = 'N';
		aa_name1(	aa_pro ) = 'P';
		aa_name1(	aa_gln ) = 'Q';
		aa_name1(	aa_arg ) = 'R';
		aa_name1(	aa_ser ) = 'S'; // STVWY
		aa_name1(	aa_thr ) = 'T';
		aa_name1(	aa_val ) = 'V';
		aa_name1(	aa_trp ) = 'W';
		aa_name1(	aa_tyr ) = 'Y';
		if ( add_pser() ) {
			aa_name1(	aa_sep ) = 'O';//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			aa_name1(	na_gua ) = 'g'; // NucAcids
			aa_name1(	na_ade ) = 'a';
			aa_name1(	na_cyt ) = 'c';
			aa_name1(	na_thy ) = 't';
			aa_name1(	na_rgu ) = 'X'; // NucAcids
			aa_name1(	na_rad ) = 'X';
			aa_name1(	na_rcy ) = 'X';
			aa_name1(	na_ura ) = 'X';
		}
		//Note that this overrrides dna_enabled.
		if ( rna_enabled() ) {
			aa_name1(	na_gua ) = 'X'; // NucAcids
			aa_name1(	na_ade ) = 'X';
			aa_name1(	na_cyt ) = 'X';
			aa_name1(	na_thy ) = 'X';
			aa_name1(	na_rgu ) = 'g'; // NucAcids
			aa_name1(	na_rad ) = 'a';
			aa_name1(	na_rcy ) = 'c';
			aa_name1(	na_ura ) = 'u';
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				aa_name1( *cligaa) ='X';
			}
//			aa_name1( lig1 ) = 'X'; // Ligand aa
//			aa_name1( lig2 ) = 'X';
		}

	}

	void
	aa_name3_initializer( FArray1D_string & aa_name3 )
	{
		aa_name3(	aa_ala ) = "ALA"; // ACDEF
		aa_name3(	aa_cys ) = "CYS";
		aa_name3(	aa_asp ) = "ASP";
		aa_name3(	aa_glu ) = "GLU";
		aa_name3(	aa_phe ) = "PHE";
		aa_name3(	aa_gly ) = "GLY"; // GHIKL
		aa_name3(	aa_his ) = "HIS";
		aa_name3(	aa_ile ) = "ILE";
		aa_name3(	aa_lys ) = "LYS";
		aa_name3(	aa_leu ) = "LEU";
		aa_name3(	aa_met ) = "MET"; // MNPQR
		aa_name3(	aa_asn ) = "ASN";
		aa_name3(	aa_pro ) = "PRO";
		aa_name3(	aa_gln ) = "GLN";
		aa_name3(	aa_arg ) = "ARG";
		aa_name3(	aa_ser ) = "SER"; // STVWY
		aa_name3(	aa_thr ) = "THR";
		aa_name3(	aa_val ) = "VAL";
		aa_name3(	aa_trp ) = "TRP";
		aa_name3(	aa_tyr ) = "TYR";
		if ( add_pser() ) {
			aa_name3(	aa_sep ) = "SEP";//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			aa_name3(	na_gua ) = "  G"; // NucAcids
			aa_name3(	na_ade ) = "  A";
			aa_name3(	na_cyt ) = "  C";
			aa_name3(	na_thy ) = "  T";
			aa_name3(	na_rgu ) = " rG"; // NucAcids
			aa_name3(	na_rad ) = " rA";
			aa_name3(	na_rcy ) = " rC";
			aa_name3(	na_ura ) = " rU";
		}
		if( get_enable_ligaa_flag() ){
			int lig_counter=1;
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				if( lig_counter >2 ){
					aa_name3( *cligaa) ='L' + lead_zero_string_of(lig_counter,2);
				}else{
					//this solves some back compatibility issues talk to lin about
					//removing the compile time decisions involving constraint residue
					//name dependencies.
					aa_name3( *cligaa) = "LG" + lead_zero_string_of(lig_counter,1);
				}
				lig_counter++;
			}		
//			aa_name3( lig1 ) = "LG1"; // Ligand aa
//			aa_name3( lig2 ) = "LG2";
		}

	}


	void
	is_nonnatural_initializer( FArray1D_bool & is_nonnatural)
	{
		is_nonnatural(	aa_ala ) = false;
		is_nonnatural(	aa_cys ) = false;
		is_nonnatural(	aa_asp ) = false;
		is_nonnatural(	aa_glu ) = false;
		is_nonnatural(	aa_phe ) = false;
		is_nonnatural(	aa_gly ) = false;
		is_nonnatural(	aa_his ) = false;
		is_nonnatural(	aa_ile ) = false;
		is_nonnatural(	aa_lys ) = false;
		is_nonnatural(	aa_leu ) = false;
		is_nonnatural(	aa_met ) = false;
		is_nonnatural(	aa_asn ) = false;
		is_nonnatural(	aa_pro ) = false;
		is_nonnatural(	aa_gln ) = false;
		is_nonnatural(	aa_arg ) = false;
		is_nonnatural(	aa_ser ) = false;
		is_nonnatural(	aa_thr ) = false;
		is_nonnatural(	aa_val ) = false;
		is_nonnatural(	aa_trp ) = false;
		is_nonnatural(	aa_tyr ) = false;
		if ( add_pser() ) {
			is_nonnatural(	aa_sep ) = false;//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			is_nonnatural( na_gua ) = false;
			is_nonnatural( na_ade ) = false;
			is_nonnatural( na_cyt ) = false;
			is_nonnatural( na_thy ) = false;
			is_nonnatural( na_rgu ) = false;
			is_nonnatural( na_rad ) = false;
			is_nonnatural( na_rcy ) = false;
			is_nonnatural( na_ura ) = false;
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				is_nonnatural( *cligaa) = false;
			}
//			is_nonnatural( lig1 ) = false; // Ligand aa
//			is_nonnatural( lig2 ) = false;
		}

	}

	void
	is_DNA_initializer( FArray1D_bool & is_DNA)
	{
		is_DNA(	aa_ala ) = false;
		is_DNA(	aa_cys ) = false;
		is_DNA(	aa_asp ) = false;
		is_DNA(	aa_glu ) = false;
		is_DNA(	aa_phe ) = false;
		is_DNA(	aa_gly ) = false;
		is_DNA(	aa_his ) = false;
		is_DNA(	aa_ile ) = false;
		is_DNA(	aa_lys ) = false;
		is_DNA(	aa_leu ) = false;
		is_DNA(	aa_met ) = false;
		is_DNA(	aa_asn ) = false;
		is_DNA(	aa_pro ) = false;
		is_DNA(	aa_gln ) = false;
		is_DNA(	aa_arg ) = false;
		is_DNA(	aa_ser ) = false;
		is_DNA(	aa_thr ) = false;
		is_DNA(	aa_val ) = false;
		is_DNA(	aa_trp ) = false;
		is_DNA(	aa_tyr ) = false;
		if ( add_pser() ) {
			is_DNA(	aa_sep ) = false;//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			is_DNA( aa_sep ) = false;
			is_DNA( na_gua ) = true;
			is_DNA( na_ade ) = true;
			is_DNA( na_cyt ) = true;
			is_DNA( na_thy ) = true;
			is_DNA( na_rgu ) = false;
			is_DNA( na_rad ) = false;
			is_DNA( na_rcy ) = false;
			is_DNA( na_ura ) = false;
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				is_DNA( *cligaa) =false;
			}
//			is_DNA( lig1 ) = false; // Ligand aa
//			is_DNA( lig2 ) = false;
		}

	}

	void
	is_NA_initializer( FArray1D_bool & is_NA)
	{
		is_NA(	aa_ala ) = false;
		is_NA(	aa_cys ) = false;
		is_NA(	aa_asp ) = false;
		is_NA(	aa_glu ) = false;
		is_NA(	aa_phe ) = false;
		is_NA(	aa_gly ) = false;
		is_NA(	aa_his ) = false;
		is_NA(	aa_ile ) = false;
		is_NA(	aa_lys ) = false;
		is_NA(	aa_leu ) = false;
		is_NA(	aa_met ) = false;
		is_NA(	aa_asn ) = false;
		is_NA(	aa_pro ) = false;
		is_NA(	aa_gln ) = false;
		is_NA(	aa_arg ) = false;
		is_NA(	aa_ser ) = false;
		is_NA(	aa_thr ) = false;
		is_NA(	aa_val ) = false;
		is_NA(	aa_trp ) = false;
		is_NA(	aa_tyr ) = false;
		if ( add_pser() ) {
			is_NA(	aa_sep ) = false;//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			is_NA( na_gua ) = true;
			is_NA( na_ade ) = true;
			is_NA( na_cyt ) = true;
			is_NA( na_thy ) = true;
			is_NA( na_rgu ) = true;
			is_NA( na_rad ) = true;
			is_NA( na_rcy ) = true;
			is_NA( na_ura ) = true;
		}
		if( get_enable_ligaa_flag() ){
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				is_NA( *cligaa) =false;
			}
//			is_NA( lig1 ) = false; // Ligand aa
//			is_NA( lig2 ) = false;
		}
	}

	void
	has_ligand_no_initializer( FArray1D_int & has_ligand_no )
	{
    has_ligand_no(	aa_ala ) = 0; // ACDEF
		has_ligand_no(	aa_cys ) = 0;
		has_ligand_no(	aa_asp ) = 0;
		has_ligand_no(	aa_glu ) = 0;
		has_ligand_no(	aa_phe ) = 0;
		has_ligand_no(	aa_gly ) = 0; // GHIKL
		has_ligand_no(	aa_his ) = 0;
		has_ligand_no(	aa_ile ) = 0;
		has_ligand_no(	aa_lys ) = 0;
		has_ligand_no(	aa_leu ) = 0;
		has_ligand_no(	aa_met ) = 0; // MNPQR
		has_ligand_no(	aa_asn ) = 0;
		has_ligand_no(	aa_pro ) = 0;
		has_ligand_no(	aa_gln ) = 0;
		has_ligand_no(	aa_arg ) = 0;
		has_ligand_no(	aa_ser ) = 0; // STVWY
		has_ligand_no(	aa_thr ) = 0;
		has_ligand_no(	aa_val ) = 0;
		has_ligand_no(	aa_trp ) = 0;
		has_ligand_no(	aa_tyr ) = 0;
		if ( add_pser() ) {
			has_ligand_no(	aa_sep ) = 0;//KMa phospho_ser 2006-01
		}
		if ( dna_enabled() ) {
			has_ligand_no(	na_gua ) = 0; // NucAcids
			has_ligand_no(	na_ade ) = 0;
			has_ligand_no(	na_cyt ) = 0;
			has_ligand_no(	na_thy ) = 0;
			has_ligand_no(	na_rgu ) = 0; // NucAcids
			has_ligand_no(	na_rad ) = 0;
			has_ligand_no(	na_rcy ) = 0;
			has_ligand_no(	na_ura ) = 0;
		}
		if ( get_enable_ligaa_flag() ) {
			int lig_counter=1;
			for( utility::vector1< int >::iterator cligaa=ligand_aa_vector.begin();
				cligaa!=ligand_aa_vector.end(); cligaa++){

				has_ligand_no( *cligaa) =lig_counter;
				lig_counter++;
			}	
//				has_ligand_no( lig1 ) = 1; // ligand
//				has_ligand_no( lig2 ) = 2;
		}

	}

	FArray1D_bool const aa_is_polar( MAX_AA(), aa_is_polar_initializer );
	FArray1D_bool const aa_is_nonpolar( MAX_AA(), aa_is_nonpolar_initializer );
	FArray1D_bool const aa_is_aromatic( MAX_AA(), aa_is_aromatic_initializer );
	FArray1D_bool const aa_is_charged( MAX_AA(), aa_is_charged_initializer );
	FArray1D_bool const is_nonnatural( MAX_AA(), is_nonnatural_initializer );
	FArray1D_bool const is_DNA( MAX_AA(), is_DNA_initializer );
	FArray1D_bool is_NA( MAX_AA(), is_NA_initializer );
	FArray1D_bool const is_protein( MAX_AA(), is_protein_initializer );
	FArray1D_bool is_RNA( MAX_AA(), is_RNA_initializer );
	FArray1D_int has_ligand_no( MAX_AA(), has_ligand_no_initializer );
	FArray1D_char const aa_name1( MAX_AA(), aa_name1_initializer );
	FArray1D_string const aa_name3( MAX_AA(), aa_name3_initializer );

	int const dna_bb_atoms = 11; //# of heavy backbone atoms in DNA
	int const rna_bb_atoms = 12; //# of heavy backbone atoms in RNA
}

	bool is_ligand( int aa_id ) {
		return ( param_aa::has_ligand_no(aa_id) > 0 );
	}


} // namespace param_aa
