////////////////////////////////////////////////////////////////////////////////
//     pathways.h: module for computing pathways between two conformations
//                      based on various criteria, either for kinetic or sampling
//                      applications
//
//     Typical Usage with initialization from misc:
//          Pathways pw(); // TODO: direct initialization from PDB
//          pw.run();
//			fp.dump_info(); // TODO: implement this?
//
//	   Author: Barak Raveh & Angela Enosh
//     Created: 29/11/2007
//
// methods list:
//     TODO: fill this in
//
/////////////////////////////////////////////////////////////////////////////////

#ifndef INCLUDED_pathways
#define INCLUDED_pathways


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include "pose.h"
#include "loop_class.h"
#include "score_data.h"
#include "pathways_algorithms.h"
#include "pathways_DOFs_manager.h"
#include "pathways_parameters.h"
#include "pathways_partial_data_manager.h"

//#include "pathways_RRT_conformation_tree.h"

//// Types
//typedef  float (*Scoring_Function)();

// TODO: read these parameters from a file:



// dock_structure Function Declarations

namespace pathways{

	// wrapping function for invoke pathways protocol for generating conformation pathways
	// invoked from job_distributor::run_jobs() or something similar
	void pathways_generator_main(bool &failed);

    /* Main class for generating pathways of conformations */
	class Pathways {
	private:
		////////////////////
		// class properties:
		////////////////////
		pose_ns::Pose  _src_pose, _trg_pose, _trg_pose_partial,_src_pose_origin, _trg_pose_origin; // pose of the strucutres
		pose_ns::Score_weight_map _score_weight_map; // current weight map
		Params_handler _params_h;
		Partial_Data _partial_data;
		bool _full_atom;
		bool _is_fail; // flag for failures in class operation

		// flags of fold tree:
		// ===================
		DOFs_manager _dofs_manager;

		// flags for building pose:
		// =======================
		bool ideal_pos;
			bool coords_init;
			bool full_atom;	 // flag for building pose - fullatom vs. centroid mode

//			GraphNode *_rootS,*_rootT,*_root; // better to define vector of roots for the future
//			GraphNode *_rootS_origin,*_rootT_origin;
//			vector<GraphNode * >* _nodesS,*_nodesT,*_nodes;
//			char _status;//which tree is grown S = source, T = target
//			GraphNode* _minDistS,*_minDistT; // the closest nodes in bothe trees

		public:

			// ctr - loads pose from misc + loop list
			Pathways();

			// start generat
			void run();

			// check fail flag
			bool fail()
				{ return _is_fail; }

			Partial_Data& get_partial_data() {return _partial_data;}

			DOFs_manager& get_dofs_manager()
				{ return _dofs_manager; }

			/* Getters & Setters: */
							
			pose_ns::Pose& get_src_pose(){return _src_pose;}
			
			pose_ns::Pose& get_trg_pose(){return _trg_pose;}

			
			pose_ns::Pose& get_trg_partial_data_pose(){return _trg_pose_partial;}
			

			pose_ns::Score_weight_map& get_score_weight_map(){return _score_weight_map;} // current weight map
				
			// set fail flag to false
			void resetFail()
				{ _is_fail = false; }
			
			Params_handler& get_params_h(){ return _params_h; }
			
			bool is_full_atom(){ return _full_atom; }

		private:

			// create a pose, a fold tree and a DOFs manager
			// according to parameters
			void initialize_from_params(Params_handler& ph);

	}; // class Pathways
	
	/* function wrapping the macro */ 
	// NOTE: this is just a small utility stuff to wrap the macro "toupper", 
	// so that it can be passed as function ptr to std::transform().
	// TODO: move somewhere else, to a utility header of some form 
	char toupper_wrapper (const char c);
	
	// auxilary class for storing chain residue range
	struct Chain_boundaries{
		int first, last;
		bool valid;
		// ctrs
		Chain_boundaries() :
			valid(false) {}
		Chain_boundaries(int _first, int _last) :
			first(_first), last(_last), valid(true) {}
	};
		

	

} // namespace pathways

#endif
