// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15095 $
//  $Date: 2007-05-23 06:25:07 -0700 (Wed, 23 May 2007) $
//  $Author: sarel $

#ifndef INCLUDED_pdbstats
#define INCLUDED_pdbstats


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>


// pdbstats Function Declarations


void
get_pdbstats();


void
output_pdbstats();


void
get_pdbstats_hbonds_and_water();


void
get_pdbstats_dis();


void
get_pdbstats_avgE();


void
get_born_placeholder();


void
output_stats_hbond();


void
output_stats_dis();


void
output_stats_avgE();


void
output_born_placeholder();


void
get_pdbstats_phipsichi();


void
output_stats_phipsichi();


void
get_pdbstats_dun_rot();


void
get_arom_hbond_stats();

void
output_stats_dun_rot();


void
get_pdbstats_atom_pair_repE();


void
output_stats_atom_pair_repE();


void
get_sasa_stats();


void
output_sasa_stats();


void
find_planes_in_sidechains();


void
find_cation_pi();


void
find_carbonyl_o();


void
calculate_180angle_distance(
	numeric::xyzVector_float const & p1,
	numeric::xyzVector_float const & q1,
	numeric::xyzVector_float const & r1,
	numeric::xyzVector_float const & s1,
	numeric::xyzVector_float const & p2,
	numeric::xyzVector_float const & q2,
	numeric::xyzVector_float const & r2,
	numeric::xyzVector_float const & s2,
	float & plane_angle,
	float & vert_distance,
	float & horiz_distance
);


void
calculate_cation_distance(
	numeric::xyzVector_float const & p1,
	numeric::xyzVector_float const & q1,
	numeric::xyzVector_float const & r1,
	numeric::xyzVector_float const & s1,
	numeric::xyzVector_float const & point,
	float & vert_distance,
	float & horiz_distance
);


void
get_rama_stats();


void
get_solvation_stats();


void
output_solv_stats();


void
output_pair_energies(
);


void
get_env_stats(
);


void
output_env_stats(
);


void
get_pdbensemble_stats(
);

void
output_arom_hbond_stats();

void
output_pdbensemble_stats(
);

void
show_hb_stats(
	FArray1DB_int const & res,
	FArray1DB_int const & res_variant,
	FArray3DB_float const & xyz,
	int const hbno
	);

void
collect_hb_stats();

#endif
