// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 19866 $
//  $Date: 2008-01-23 11:54:04 -0800 (Wed, 23 Jan 2008) $
//  $Author: possu $


// Rosetta Headers
#include "pdbstats_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Using
using namespace param;


namespace pdbstats {


//bk variables specific to pdbstats mode


//bk flags

namespace pdbstats_flags {
	bool avg_dis;
	bool avg_E;
	bool hbond_stats;
	bool phipsichi;
	bool dun_rot;
	bool pdbstat_dotcutoff;
	bool rep_atm_pair;
	bool phe_planes;
	bool cation_pi;
	bool carbonyl_o;
	bool rama_stats;
	bool solv_stats;
	bool born_placeholder;
	bool sasa_stats;
	bool pair_energies;
	bool env_stats;
  bool arom_hbonds; // SJF
}


//bk parameters average energies

namespace pdb_stats {
	FArray2D_float atr_n( MAX_AA(), 30, 0.0f );
	FArray2D_float rep_n( MAX_AA(), 30, 0.0f );
	FArray2D_float tot_n( MAX_AA(), 30, 0.0f );
	FArray2D_float sol_n( MAX_AA(), 30, 0.0f );
	FArray2D_float pair_n( MAX_AA(), 30, 0.0f );
	FArray2D_float dun_n( MAX_AA(), 30, 0.0f );
	FArray2D_float one_n( MAX_AA(), 30, 0.0f );
	FArray2D_float hb_n( MAX_AA(), 30, 0.0f );
	FArray2D_int cnt_n( MAX_AA(), 30, 0 );
	FArray2D_float tlj_n( MAX_AA(), 30, 0.0f );
	FArray2D_float intrares_n( MAX_AA(), 30, 0.0f );
}


//bk parameters for average distances between atom types

namespace pdb_stats_avgd {
	float const disbin_size = { 0.1 };
	float const max_dis = { 14.0 };
	int const ndisbins =
	 { static_cast< int >( ( max_dis + 0.5f * disbin_size ) / disbin_size ) };
	FArray3D_int cnt_dis( MAX_ATOMTYPES(), MAX_ATOMTYPES(), ndisbins, 0 );
}


//bk parameters for hydrogen bonds

namespace pdb_stats_hbonding {
	int numNH = { 0 };
	int numNH_nhb = { 0 };
	int numNH_nwat = { 0 };
	int numNH_nhb_nwat = { 0 };
	int numO = { 0 };
	int numO_nhb = { 0 };
	int numO_nwat = { 0 };
	int numO_nhb_nwat = { 0 };
}


//chu parameters for phi,psi,chi angles and the closest rotamers in Dunbrack

namespace pdb_stats_rotamers {
	FArray1D_float input_phi( MAX_RES() );
	FArray1D_float input_psi( MAX_RES() );
	FArray2D_float input_chi( MAX_CHI, MAX_RES() );
	FArray2D_int input_rot( MAX_CHI, MAX_RES() );
	FArray2D_float dun_closest_chi( MAX_CHI, MAX_RES() );
	FArray2D_float delta_chi( MAX_CHI, MAX_RES() );
}


//chu parameters for clashing atom-pairs in pdbs

namespace pdb_stats_clashing {
	float const repE_atom_pair_cutoff = { 0.1 };
	FArray2D_float repE_atom_pair( MAX_ATOMTYPES(), MAX_ATOMTYPES(), 0.0f );
	FArray2D_int repN_atom_pair( MAX_ATOMTYPES(), MAX_ATOMTYPES(), 0 );
}


//jjh parameters for determining optimal GB placeholders

namespace born_place {
	double rb_err_accum = { 0.0 };
	FArray2D_float real_rb( MAX_AA(), MAX_RES(), 0.0f );
}


//km parameters for calculate planes

//namespace pdb_stats_planes {
//  float plane_angle;
//  float plane_angle;
//  float plane_angle;
//  int pair_found;
//  FArray2D_float output_array( 3, MAX_RES() );
//  int const number_angle_bins = { 3 };
//  FArray1D_int angles_distances( number_angle_bins );
//}


//km parameters for lk calculations

namespace lk_solv_stats {
	int const number_bins = { 40 };
	float const bin_size = { 0.20 };
	FArray2D_int counted_nohb( MAX_ATOMTYPES(), number_bins );
	FArray2D_int counted_hb( MAX_ATOMTYPES(), number_bins );
	FArray2D_int counted_total( MAX_ATOMTYPES(), number_bins );
}

//bq parameters for sasa stats
namespace sasa_stats_ns {
	FArray1D_float rsd_sasa( MAX_RES() );
	FArray1D_float rsd_sasa_fraction( MAX_RES() );
}


//bq parameters for sasa stats
namespace env_stats_ns {
	FArray2D_float homolog_env( MAX_RES(), 40, 0.0 );
	FArray3D_float homolog_pair( 5, MAX_RES(), MAX_RES(), 0.0 );
	FArray2D_float pdb_pair( 5, MAX_RES(), 0.0 );
	FArray1D_int nenvs( MAX_RES(), 0 );
	FArray2D_int npairs( MAX_RES(), MAX_RES(), 0 );

}

// SJF
// delta - distance between donor h and acceptor.
// theta - angle between donor heavy atom, h, and acceptor.
// phi   - angle between acceptor heavy atom, h, and donor.
// in aromatic rings, the acceptor is the ring center. Phi is then defined as
// the angle between the plane of the aromatic ring and the h atom.
namespace arom_hbonds_stats {
  float delta_cutoff2( 3.5 * 3.5 ); // distance cutoff between hyd and acceptor site squared
  int delta_bins( static_cast<int> (std::sqrt( delta_cutoff2 ) / 0.1 ) );
  int theta_bins( 36 ), phi_bins( 36 ); // the number of count bins
  float short_cutoff2( 2.7 * 2.7 ); // separating the 'short' and 'long' angle bins below
  float vlong_cutoff2( 3.1 * 3.1 ); // very long cutoff

  FArray1D_float arom_arom_delta       ( delta_bins + 1, 0.0f );
  FArray1D_float arom_arom_theta_short ( theta_bins + 1, 0.0f );
  FArray1D_float arom_arom_phi_short   ( phi_bins + 1, 0.0f )  ;
  FArray1D_float arom_arom_theta_long  ( theta_bins + 1, 0.0f );
  FArray1D_float arom_arom_phi_long    ( phi_bins + 1, 0.0f )  ;
  FArray1D_float arom_arom_theta_vlong ( theta_bins + 1, 0.0f );
  FArray1D_float arom_arom_phi_vlong   ( phi_bins + 1, 0.0f )  ;


  FArray1D_float polar_arom_acceptor_delta       ( delta_bins + 1, 0.0f ); // arom is acceptor
  FArray1D_float polar_arom_acceptor_theta_short ( theta_bins + 1, 0.0f );
  FArray1D_float polar_arom_acceptor_phi_short   ( phi_bins   + 1, 0.0f );
  FArray1D_float polar_arom_acceptor_theta_long  ( theta_bins + 1, 0.0f );
  FArray1D_float polar_arom_acceptor_phi_long    ( phi_bins   + 1, 0.0f );
  FArray1D_float polar_arom_acceptor_theta_vlong ( theta_bins + 1, 0.0f );
  FArray1D_float polar_arom_acceptor_phi_vlong   ( phi_bins   + 1, 0.0f );



  FArray1D_float polar_arom_donor_delta       ( delta_bins + 1, 0.0f ); // arom is donor
  FArray1D_float polar_arom_donor_theta_short ( theta_bins + 1, 0.0f );
  FArray1D_float polar_arom_donor_phi_short   ( phi_bins   + 1, 0.0f );
  FArray1D_float polar_arom_donor_theta_long  ( theta_bins + 1, 0.0f );
  FArray1D_float polar_arom_donor_phi_long    ( phi_bins   + 1, 0.0f );
  FArray1D_float polar_arom_donor_theta_vlong ( theta_bins + 1, 0.0f );
  FArray1D_float polar_arom_donor_phi_vlong   ( phi_bins   + 1, 0.0f );

// backbone stats

  FArray1D_float bb_polar_arom_acceptor_delta       ( delta_bins + 1, 0.0f ); // arom is acceptor
  FArray1D_float bb_polar_arom_acceptor_theta_short ( theta_bins + 1, 0.0f );
  FArray1D_float bb_polar_arom_acceptor_phi_short   ( phi_bins   + 1, 0.0f );
  FArray1D_float bb_polar_arom_acceptor_theta_long  ( theta_bins + 1, 0.0f );
  FArray1D_float bb_polar_arom_acceptor_phi_long    ( phi_bins   + 1, 0.0f );
  FArray1D_float bb_polar_arom_acceptor_theta_vlong ( theta_bins + 1, 0.0f );
  FArray1D_float bb_polar_arom_acceptor_phi_vlong   ( phi_bins   + 1, 0.0f );



  FArray1D_float bb_polar_arom_donor_delta       ( delta_bins + 1, 0.0f ); // arom is donor
  FArray1D_float bb_polar_arom_donor_theta_short ( theta_bins + 1, 0.0f );
  FArray1D_float bb_polar_arom_donor_phi_short   ( phi_bins   + 1, 0.0f );
  FArray1D_float bb_polar_arom_donor_theta_long  ( theta_bins + 1, 0.0f );
  FArray1D_float bb_polar_arom_donor_phi_long    ( phi_bins   + 1, 0.0f );
  FArray1D_float bb_polar_arom_donor_theta_vlong ( theta_bins + 1, 0.0f );
  FArray1D_float bb_polar_arom_donor_phi_vlong   ( phi_bins   + 1, 0.0f );

}

} // namespace pdbstats
