// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13347 $
//  $Date: 2007-03-08 04:43:32 -0800 (Thu, 08 Mar 2007) $
//  $Author: ion $

//////////////////////////////////////////////
#ifndef INCLUDED_pose_constraints
#define INCLUDED_pose_constraints

// Rosetta Headers
#include "cst_set.h"
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers



bool
pose_constraints_exist(
	pose_ns::Pose const & pose,
	int const pos1,
	int const pos2
);


float
pose_get_res_res_cstE(
	pose_ns::Pose const & pose,
	int const res1,
	int const res2,
	int const aa1,
	int const aav1,
	int const aa2,
	int const aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	bool const bb1,
	bool const sc1,
	bool const bb2,
	bool const sc2
);


void fill_atom_cst_F1_F2(
	pose_ns::Pose const & pose,
	float const kin_3D_cst_weight,
	float const atompair_cst_weight,
	float const coord_cst_weight,
	float const chainbreak_cst_weight,
	int const seqpos,
	int const atomno,
	numeric::xyzVector_float & F1,
	numeric::xyzVector_float & F2
);

void
fill_cst_set(
	cst_set_ns::Cst_set & cst_set,
	pose_ns::Pose const & pose,
	bool const & just_use_bb_heavy_atoms
);


float
calc_pose_constraint_scores(
	pose_ns::Pose & pose, // non-const for setting scores
	float const phipsi_cst_weight,
	float const omega_cst_weight,
	float const chi_cst_weight,
	float const kin_1D_cst_weight,
	float const kin_3D_cst_weight,
	float const atompair_cst_weight,
	float const coord_cst_weight,
	float const chainbreak_cst_weight
);


void
add_chainbreak_constraint(
	int const cutpoint,
	int const aa, // aa after the cutpoint !!
	int const aav,
	cst_set_ns::Cst_set & cst_set
);


void
build_overlap_coords(
	int const cutpoint,
	float const psi,
	float const omega,
	float const phi,
	FArray3DB_float const & coords,
	FArray2D_float & overlap_xyz,
	bool const Epos_index = false,
	int const dir = 0
);


#endif
