// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7212 $
//  $Date: 2006-01-04 07:49:01 -0800 (Wed, 04 Jan 2006) $
//  $Author: pbradley $
// Rosetta Headers

#include "atom_tree_routines.h"
#include "after_opts.h"
#include "aaproperties_pack.h"
#include "disulfides.h"
#include "fullatom.h"
#include "pose.h"
#include "pose_io.h"
#include "read_aaproperties.h"
#include "score.h" //Possu? score12?
#include "util_vector.h"

// Numeric Headers
#include <numeric/xyz.functions.hh> // for dihedral()

typedef numeric::xyzVector_float Vec;


///////////////////////////////////////////////////////////////////////////
// Rhiju and Colin, checking out a CHARMM like addition to make
// sure that when bond angles are varied, they reproduce the
// correlations expected.
///////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////
void
set_all_bond_angle_allow_move_CHARMM(
			      pose_ns::Pose & pose,
			      pose_ns::Pose & pose_with_desired_geometry
)
{
  using namespace cst_set_ns;
  using namespace kin;
  using namespace aaproperties_pack;

  // Dynamically allocate a cst_set, which will be pointed to by a pose.
	// The cst_set will delete itself when the pose no longer points to it, but this
	// requires that we call "remove_ptr_reference()" once the pose pointer is setup (below)
  Cst_set * cst_set_p;
  cst_set_p = new Cst_set();

  static float const bond_angle_tether( realafteroption("bond_angle_tether", 10.0) );

  Atom_tree const * atom_tree = pose_with_desired_geometry.atom_tree(); //Need the atom tree to see where jumps are.

  if (truefalseoption("crazy_tau")){
    //Silly block to move a single CA-CB angle.
    static float const crazy_angle_tether( realafteroption("crazy_angle_tether", 1000.0) );
    int const i = 2;
    int const j = 3;
    Atom_id current_atom_id( j, i );
    float stretch_factor = realafteroption( "stretch_factor", 1.5 );
    Torsion_id this_bond_angle( current_atom_id, THETA );
    float const current_angle( pose_with_desired_geometry.get_atom_tree_torsion(this_bond_angle));
    std::cout << "CURRENT ANGLE: " << current_angle << std::endl;

    cst_set_p -> add_kin_torsion_constraint( this_bond_angle, stretch_factor * current_angle,
					     crazy_angle_tether );
    pose.set_allow_move( this_bond_angle, true );
  }

  bool const just_vary_one_calpha_center_test = true;

  if (truefalseoption("kin_3d")){
    kin::Coords_FArray_const coords( pose_with_desired_geometry.full_coord());

    //Hacky thing to be replaced by Colin's super smart angle minimizer.
    int const nres( pose_with_desired_geometry.total_residue() );
    for (int i = 1; i <= nres; ++i) {
      int const aa  = pose_with_desired_geometry.res(i);
      int const aav = pose_with_desired_geometry.res_variant(i);
      int const natoms( aaproperties_pack::natoms( aa, aav ) );

      if (just_vary_one_calpha_center_test && i!=2 ) continue;

      // These "3D constraints" will be expensive.

      //This currently actually double counts the angles,
      // not sure if that double the numebr of constraints,
      // or if they get written over.
      for ( int j = 1; j <= natoms; ++j ) {
	if (fullatom_type(j,aa,aav) > 21 &&
	    get_vary_bond_geometry_no_hydrogens()) continue;

	Atom_id current_atom_id( j, i );

	bool const this_is_a_jump = atom_tree->atom( current_atom_id )->is_jump();

	if (this_is_a_jump) continue;

	int const num_neighbors = nbonded_neighbors( j, aa, aav);

	for (int m = 1; m <= num_neighbors; m++){
	  Atom_id const neighbor1_id( bonded_neighbor(m,j,aa,aav), i);

	  for (int n = m+1; n <= num_neighbors; n++){
	    Atom_id const neighbor2_id( bonded_neighbor(n,j,aa,aav), i);

	    if (just_vary_one_calpha_center_test && j!=2 && m!=2 && n!=2) continue;

	    add_angle_cst_with_theta_from_3_atoms( neighbor1_id, current_atom_id, neighbor2_id,
						  bond_angle_tether, coords, *cst_set_p);
	  }
	}
      }//j

      if (just_vary_one_calpha_center_test) continue;

      /////////////////////////////////////////////////////////////////////////
      // Also need to add in N-C-CA and Ca-C-N connections to next residue.
      /////////////////////////////////////////////////////////////////////////
      if (i > 1){
	{
	  //N, CA, C
	  Atom_id current_atom_id1( LookupByName(pose.res(i-1), pose.res_variant(i-1), " CA " ), i);
	  Atom_id current_atom_id2( LookupByName(pose.res(i-1), pose.res_variant(i-1), " C  " ), i);
	  Atom_id current_atom_id3( LookupByName(pose.res(i  ), pose.res_variant(i  ), " N  " ), i);
	  add_angle_cst_with_theta_from_3_atoms( current_atom_id1, current_atom_id2, current_atom_id3,
						 bond_angle_tether, coords, *cst_set_p);
	}

	{
	  Atom_id current_atom_id1( LookupByName(pose.res(i-1), pose.res_variant(i-1), " C  " ), i);
	  Atom_id current_atom_id2( LookupByName(pose.res(i  ), pose.res_variant(i  ), " N  " ), i);
	  Atom_id current_atom_id3( LookupByName(pose.res(i  ), pose.res_variant(i  ), " CA " ), i);
	  add_angle_cst_with_theta_from_3_atoms( current_atom_id1, current_atom_id2, current_atom_id3,
						 bond_angle_tether, coords, *cst_set_p);
	}
      }

    } //i


      //OK, now the constraints are in ... allow those degrees of freedom to move.
    for (int i = 1; i <= nres; ++i) {
      int const aa  = pose_with_desired_geometry.res(i);
      int const aav = pose_with_desired_geometry.res_variant(i);
      int const natoms( aaproperties_pack::natoms( aa, aav ) );

      if (just_vary_one_calpha_center_test && i!=2) continue;

      //Most of the distance constraints can be implemented as atom
      // tree constraints... very efficient.
      for ( int j = 1; j <= natoms; ++j ) {
	if (aaproperties_pack::fullatom_type(j,aa,aav) > 21 &&
	    get_vary_bond_geometry_no_hydrogens()) continue;
	Atom_id current_atom_id( j, i );

	bool const this_is_a_jump = atom_tree->atom( current_atom_id )->is_jump();

	if (just_vary_one_calpha_center_test &&
	    (j!=LookupByName(pose.res(i  ), pose.res_variant(i  ), " CB " )) &&
	    (j!=LookupByName(pose.res(i  ), pose.res_variant(i  ), " HA " )) ) continue;

	if (!this_is_a_jump) {
	  Torsion_id this_bond_angle( current_atom_id, THETA );
	  pose.set_allow_move( this_bond_angle, true );

	  Torsion_id this_bond_torsion( current_atom_id, PHI );
	  if ( !is_this_phi_psi_omega_chi(pose_with_desired_geometry, i, j)){
	    pose.set_allow_move( this_bond_torsion, true );
	  }
	}
      }
    }
  }

  //Finalize constraints.
  if (pose.constraints_exist()){
    cst_set_p -> collect( pose.constraints() );
  }
  pose.set_constraints( *cst_set_p );

	// this was allocated by "new" (above), and will cause a memory leak otherwise
	cst_set_p->remove_ptr_reference();

  pose.set_vary_bond_geometry_flag( true );

}
