// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision:  $
//  $Date:  $
//  $Author:  $

#ifndef INCLUDED_pose_disulfides
#define INCLUDED_pose_disulfides


// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <list>
#include <map>
#include <vector>

//ROBERT - MOVE TO OWN FILE
namespace rvjumpdb {
	extern bool rvjumpdb_read;
	extern std::map<int, std::vector<pose_ns::Jump> > seqsep_dJumps;
	extern std::vector<pose_ns::Jump> dJumps;
}

namespace pose_disulf {
	extern bool found_disulf;
	extern FArray2D_int jump_point;
	extern int num_jump;

	extern int last_jumppos;
	extern pose_ns::Jump last_jumpmove;
	extern pose_ns::Jump secondlast_jumpmove;

}

void
find_disulfides( pose_ns::Pose & pose, FArray2D_int & jump_point, int & num_jump);

void
copy_jumps( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

void
setup_disulfide_fold_tree( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

//void
//read_in_opdbs( FArray1D_string & file_list, int & num);

void
read_in_rvjumpdb();

//void
//setup_disulfide_fold_tree_from_pdb();

void
setup_disulfide_fold_tree_with_onejump_from_db( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

void
smooth_move_disulfide_fold_tree( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

void
score25_move_disulfide_fold_tree( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

void
move_disulfide_fold_tree( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

void
move_disulfide_fold_tree_with_seqsep( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

void
setup_disulfide_fold_tree_with_onejump_from_seqsepdb( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

//void
//setup_disulfide_fold_tree_with_onejump_from_seqsepdb_with_barcodes( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

//void
//setup_close_cut_disulfide_fold_tree_with_onejump_from_seqsepdb( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

int
pick_jump( int const & seq_sep );

void
fold_posedisulf_abinitio(
	pose_ns::Pose & pose,
	bool const score_chainbreaks = true,
	bool const choose_frag_ss_check = true,
	float const cycle_factor = 1.0,
	float const init_temp = 2.0
);

void
fold_salvagejumpmoves_posedisulf_abinitio(
	pose_ns::Pose & pose,
	bool const score_chainbreaks = true,
	bool const choose_frag_ss_check = true,
	float const cycle_factor = 1.0,
	float const init_temp = 2.0
);

void
redo_last_jump_move( pose_ns::Pose & pose, pose_ns::Pose & src_pose );

void
revert_to_unmoved_jump( pose_ns::Pose & pose, pose_ns::Pose & src_pose );


#endif
