// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 32333 $
//  $Date: 2009-08-25 17:05:32 -0700 (Tue, 25 Aug 2009) $
//  $Author: aroop $

// Rosetta Headers
#include "pose_docking.h"
#include "after_opts.h"
#include "analyze_interface_ddg.h"
#include "analyze_interface_ddg_ns.h"
#include "antibody_modeling.h"
#include "are_they_neighbors.h"
#include "bonds_class.h"
#include "design.h"
#include "design_structure.h"
#include "dock_structure.h"
#include "dock_loops.h"
#include "docking.h"
#include "docking_constraints.h"
#include "dock_ensemble.h"
#include "dock_loop_ensemble.h"
#include "dock_loop_ensemble_ns.h"
#include "docking_minimize.h"
#include "docking_movement.h"
#include "docking_ns.h"
#include "docking_score.h"
#include "docking_scoring.h"
#include "docking_ns.h"
#include "enzyme.h"
#include "files_paths.h"
#include "fold_tree.h"
#include "fragment_class.h"
#include "fragments_pose.h"
#include "fullatom.h"
#include "fullatom_setup.h"
#include "grid_docking.h"
#include "initialize.h"
#include "interface.h"
#include "jumping_diagnostics.h"
#include "jumping_refold.h"
#include "jumping_util.h"
#include "ligand.h"
#include "loop_relax.h"
#include "loop_class.h"
#include "loops_ns.h"
#include "loops.h"
#include "make_pdb.h"
#include "map_sequence.h"
#include "monte_carlo.h"
#include "misc.h"
#include "minimize.h"
#include "nblist.h"
#include "orient_rms.h"
#include "output_decoy.h"
#include "pack_fwd.h"
#include "param.h"
#include "pose.h"
#include "pose_design.h"
#include "pose_idealize.h"
#include "pose_docking_flexible.h"
#include "pose_io.h"
#include "pose_ligand.h"
#include "pose_loops.h"
#include "pose_param.h"
#include "pose_rotamer_trials.h"
#include "pose_vdw.h"
#include "ramachandran.h"
#include "random_numbers.h"
#include "recover.h"
#include "rotamer_trials.h"
#include "runlevel.h"
#include "silent_input.h"
#include "smallmove.h"
#include "score.h"
#include "score_ns.h"
#include "start.h"
#include "status.h"
#include "pose_fold_and_dock.h"
#include "pose_symmetric_docking.h"
#include "timer.h"
#include "torsion_bbmove_trials.h"
#include "util_basic.h"
#include "util_vector.h"
#include "vdw.h"

// Numeric Headers
#include <numeric/xyzVector.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray3Dp.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// Utility Headers
#include <utility/vector1.hh>
#include <utility/io/ozstream.hh>

// C++ Headers
#include <cstdlib>
#include <fstream>
#include <iostream>

/////////////////////////////////////////////////////////////////////////////
void
pose_docking_main( bool & fail )
{
	using namespace pose_ns;
	using namespace runlevel_ns;

	fail = false;
	set_pose_flag( true );

	// set up a pose for docking, mainly tree map
	Pose docking_pose;
	Loops loops; // may use it later

	//copy misc to pose
  bool const ideal_pos( false );
  bool const coords_init( true );
  bool const fullatom( get_docking_fullatom_flag() ); //vats HACK remove this !!!
	//	bool const fullatom( false );
	//  set_fullatom_flag( fullatom );
  pose_from_misc( docking_pose, fullatom, ideal_pos, coords_init );
	int const nres( docking_pose.total_residue() );
	// aroop: various loop processes for docking whilst iterating through a
	// loop library
	if( dle_process_loops( docking_pose ) )
		return;

	if ( docking::score_only ) {
		std::cout << "pose_docking score the model only " << std::endl;
	}

	if ( get_docking_silent_input_flag() ) {
		pose_docking_read_silent_input( docking_pose );
		if ( fail ) return;
	}

	// minimize parameters
	minimize_exclude_sstype( false, false );
	minimize_set_vary_phipsi( true );
	minimize_set_vary_omega( false );
	minimize_set_vary_chi( true );
	minimize_set_vary_rb_trans( true );
	minimize_set_vary_rb_angle( true );
	minimize_set_local_min( false, 0 );
	pose_set_use_nblist( true );

	// choose which protocol to use;

	if ( get_pose_loop_flag() ) {
		pose_loops_init_from_file( loops );
	}

	if ( truefalseoption("grid_dock") ) {
		grid_dock_output_all_pdbs( docking_pose, docking::part_end(1) );
	}

	if (docking::docking_pose_symmetry) {
		if ( docking::docking_pose_symm_looprlx ) {
			pose_symm_loop_relax( docking_pose, docking::part_end(1) );
		}	else if ( docking::docking_pose_symm_loops ) {
				if ( loops.num_loop() > 0) pose_docking_symm_loop_protocol(docking_pose,docking::part_end(1),loops);
		} else if ( truefalseoption("hinge") ) {
        pose_docking_hinge_protocol_symm(docking_pose,docking::part_end(1));
    } else {
      pose_docking_symm_protocol(docking_pose, docking::part_end(1) );
    }
    //pose_docking_setup_dock_loop_tree( docking_pose,
    //      nres, docking::part_end(1),loops );
		pose_docking_build_simple_tree( docking_pose,
      nres, docking::part_end(1) );
    silent_out_save_decoy_pose( docking_pose );

		docking_pose.copy_to_misc();
		set_pose_flag( false );
		monte_carlo_reset();
		return;
  }

	// docking fold_tree may have been setup in silent_input_file
	bool const dock_tree_init ( docking_pose.fold_tree().get_num_jump() != 0 );
	if ( loops.num_loop() > 0 ) {
		// setup dock_loop tree
		if ( ! dock_tree_init ) pose_docking_setup_dock_loop_tree( docking_pose,
			nres, docking::part_end(1),loops );
		// choose protocol to be used
		if ( truefalseoption("use_protocol_2") ) {
			std::cout << "pose_docking: loop(s) defined, "
								<< "use docking_loops protocol_2\n";
			if ( !docking::score_only )
				pose_docking_loops_protocol_2( docking_pose, loops );
		} else if ( truefalseoption("minimize_loop") ) {
			std::cout << "pose_docking: loop(s) defined, "
								<< "use minimize_loop protocol\n";
			if( !docking::score_only )
				pose_docking_minimize_loop_protocol( docking_pose, loops );
		} else {
			std::cout << "pose_docking: loop(s) defined, "
								<< "use docking_loops protocol\n";
			if ( !docking::score_only )
				pose_docking_loops_protocol( docking_pose, loops );
		}
	} else if ( loops.num_loop() == 0 ) {
		// setup dock tree
		if ( !dock_tree_init ) pose_docking_build_simple_tree( docking_pose,
			nres, docking::part_end(1) );
		// choose protocol to be used.
		std::cout << "pose_docking: no loop defined, use standard protocol\n";

		if ( !docking::score_only ) pose_docking_standard_protocol( docking_pose );
	} else {
		std::cout << "ERROR: pose_docking_main -- can not decide which protocol "
							<< "to use, exit... " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	score_set_default_function( fullatom );

	std::cout << "pose_docking_score: " << std::endl;
	docking_pose.score( scorefxn );
	docking_pose.show_scores(std::cout); std::cout << std::endl;

	pose_docking_calc_interf_energy( docking_pose, loops );

	silent_out_save_decoy_pose( docking_pose );

	// align loop containing partner one to native
	if(docking::dle_loops_flag)
		dle_orient_to_native( docking_pose );

	docking_pose.copy_to_misc();

	set_pose_flag( false );

	if(!docking::dle_loops_flag)
		docking_orient_current_to_start();

	// hack here to make sure rama score is calculated correctly
	for ( int i=1; i<= docking::n_monomers; ++i ) {
		misc::phi( docking::part_begin(i) ) = 0.0;
		misc::psi( docking::part_end(i) ) = 0.0;
		misc::omega( docking::part_end(i) ) = 0.0;
	}
	if ( get_enable_ligaa_flag() ) {
		set_use_nblist( false );
			misc::ints::total_domains++;
			for (int i = 1; i <= docking_pose.total_residue(); ++i) {
				start::start_pose::start_res(i) = docking_pose.res(i);
			}
			misc::ints::total_residue--;
	}
	monte_carlo_reset();
}
/////////////////////////////////////////////////////////////////////////////
void
pose_docking_standard_protocol(
	pose_ns::Pose & pose
)
{
	using namespace pose_ns;
	using namespace docking;

	// set allow_move properly
	pose.set_allow_jump_move( false );
	if( docking::minimize_backbone ) {
		pose.set_allow_bb_move( true );
	} else {
		pose.set_allow_bb_move( false );
	}
	pose.set_allow_chi_move( true );
	pose_docking_set_general_allow_move( pose );

	if(docking::dle_loops_flag || antibody_ns::snugdock_ns::snugloop) {
		FArray1D_bool allow_moves( pose.total_residue() );
		pose_loops_select_loop_residues( pose,
      dle_ns::dle_loops,
       false /*include_neighbors*/,allow_moves);
		pose.set_allow_bb_move( allow_moves );
	}

	if ( get_docking_prepack_mode() ) {
		pose_docking_prepack_protocol( pose );
		return;
	}

	Score_weight_map weight_map;

	Pose pose_save;
	pose_save = pose;

	pose.set_fullatom_flag( false );

	static bool const pose_docking_centroid_jumpout = truefalseoption( "pose_docking_centroid_jumpout" );
	static int ntries = intafteroption("ntries",10000);
	if ( pose_docking_centroid_jumpout) docking_jumpout_mode = 1;
	if (!pose_docking_centroid_jumpout) ntries = 1;

	if ( ! get_docking_local_refine() ) {

		for ( int n = 1; n <= ntries; n++ ) {

			std::cout << "Doing " << n << " out of " << ntries << " rounds of initial centroid search" << std::endl;

			// perturb
			if ( !dle_ns::insert_all_loops_with_local_refine )
				pose_docking_perturb_rigid_body( pose );
			pose_docking_calc_rmsd( pose );
			docking_store_initial_rms();
			// centroid MC search
			setup_score_weight_map( weight_map, score4d );

			static const int docking_centroid_outer_cycles = intafteroption( "docking_centroid_outer_cycles", 10 );
			static const int docking_centroid_inner_cycles = intafteroption( "docking_centroid_inner_cycles", 50 );

			pose_docking_centroid_rigid_body_adaptive( pose,
																								 docking_centroid_outer_cycles /*outer_cycle*/,
																								 docking_centroid_inner_cycles /*inner_cycle*/,
																								 weight_map, 0.7/*trans_mag*/, 5.0/*rot_mag*/);

			if (docking::docking_ensemble_flag)
				detect_current_conformer( pose );

			// aroop: enables centroid relaxation of CDR H3/H2
			dle_dump_next_pdb(	pose, false, "pre_cen_rlx" ); // aroop: temp remove
			if (docking::antibody_modeling_dock_n_snug_flag ) {
				if( antibody_ns::snugdock_ns::snugh3 )
					dle_refine_modeled_loop( pose, "h3" );
				if( antibody_ns::snugdock_ns::snugh2 )
					dle_refine_modeled_loop( pose, "h2" );
			}
			dle_dump_next_pdb(	pose, false, "post_cen_rlx" ); // aroop: temp remove

			pose.score( weight_map );
			if ( docking_jumpout_check() )  break; //we're there!

		}

	}
	pose_docking_calc_rmsd( pose );
	docking_store_cenmode_rms();

	if ( get_docking_fullatom_flag() ) {
		// fullatom mode
		pose.set_fullatom_flag( true, false );
		// copy back the starting sidechain first
		pose.recover_sidechain( pose_save );

		if (docking::docking_ensemble_flag) ensemble_recover_sidechains( pose );

		if ( get_enable_ligaa_flag() )
			attach_ligand_to_docking_pose( pose ); // SJF

		setup_score_weight_map( weight_map, score10d );
		const float temperature( 0.8 );
		Monte_carlo mc( pose, weight_map, temperature );

		// repack interface sidechains
		bool const interface_only(true), include_current(true);
		pose_docking_repack( pose, interface_only, include_current );

		if( docking::dle_flag ) { // aroop: docking flexible
			if( dle_ns::simultaneous_minimization) {
				dle_relax( pose ); // change fold tree
				dle_repulsive_ramp( pose ); // slowly ramp up rep sc
				//pose.dump_pdb( "post_ramp.pdb" ); // aroop_temp remove
			}
			else {
				dle_repulsive_ramp( pose ); // slowly ramp up rep sc
				dle_relax( pose ); // relax modelled regions
			}
		}

		if( files_paths::antibody_modeler ||
				docking::antibody_modeling_dock_n_snug_flag )
			pose.update_backbone_bonds_and_torsions();

		// dock_rtmin if requested so
		if ( docking::dock_rtmin ) {
      set_docking_interface_pack( interface_only );
      score_set_try_rotamers( true );
      score_set_minimize_rot( true );
      pose.score( weight_map );
      score_set_minimize_rot( false );
      score_set_try_rotamers( false );
    }

		// this is to prevent accidental changes by mc
		// since mc was instantiated with a pose containing a different fold tree
		{
			// Storing source status
			FArray1D_bool bb_move_old,chi_move_old,jump_move_old;
			pose.retrieve_allow_move(bb_move_old, chi_move_old, jump_move_old);
			Fold_tree const f( pose.fold_tree() );

			// this is to prevent accidental score increase after repack+rtmin
			mc.boltzmann( pose );
			pose = mc.low_pose();

			if( files_paths::antibody_modeler ||
					docking::antibody_modeling_dock_n_snug_flag ) {
				pose.set_fold_tree( f );
				pose.set_allow_jump_move( jump_move_old );//restore the jump move
				pose.set_allow_bb_move( bb_move_old );
				pose.set_allow_chi_move( chi_move_old );
			}
		}

		setup_score_weight_map( weight_map, score10d_min );
		// first option enables multi dock for light and heavy chain and
		// simultaneous docking of antigen
		if (docking::antibody_modeling_dock_n_snug_flag )
			antibody_modeling_snugdock( pose );
    else if ( get_docking_mcm_flag() )
      pose_docking_mcm_protocol( pose, weight_map );
    else if ( get_docking_minimize_flag() )
      pose_docking_minimize_trial( pose, "dfpmin_atol", weight_map, 0.02 );

		if( files_paths::antibody_modeler ||
				docking::antibody_modeling_dock_n_snug_flag )
		pose.update_backbone_bonds_and_torsions();

		dle_dump_next_pdb(	pose, false, "rtrn_to_main" ); // aroop: temp remove

		// aroop: taking care of chain breaks in loop building mode
		// max separation at cutpoint of closed loop
		float const gap_upper_limit( 1.90 );
		// min separation at cutpoint ( clashes if less than this )
		float const gap_lower_limit( 1.00 );
		float cutpoint_separation = dle_cutpoint_separation( pose );
		//pose.dump_pdb( "pre_snug_relax.pdb" ); // aroop_temp remove
		if( ( docking::dle_loops_flag && dle_ns::simultaneous_minimization &&
        ( ( cutpoint_separation > gap_upper_limit ) || ( cutpoint_separation <
						gap_lower_limit ) ) ) ) {
			if( antibody_ns::freeze_h3 ) {
				setup_score_weight_map( weight_map, score12 );
				dle_modify_weightmap( pose, weight_map );
				int outer_cycles(1);
				int inner_cycles(
					dle_ns::dle_loops.loop_size());
				int n_moves(1);
				if( runlevel_ns::benchmark )
					inner_cycles = 1;
				pose_refine_loops_with_ccd( pose, weight_map,
				  dle_ns::dle_loops, outer_cycles,
					  inner_cycles, n_moves, true, true );
			}
			else
				dle_refine_modeled_loop( pose );
		}
	}
}
/////////////////////////////////////////////////////////
void
pose_docking_mcm_protocol(
	pose_ns::Pose & docking_pose,
	pose_ns::Score_weight_map & weight_map
)
{
	using namespace docking;

	//MC move
	const float trans_magnitude = get_dock_mcm_trans_magnitude(); /* 0.1 angstrom default */
	float rot_magnitude   = get_dock_mcm_rot_magnitude(); /*5.0 degrees default */
	// rb minimization
	const float loose_func_tol = 1.0;  /* absolute tolerance */
	const float tight_func_tol = 0.02; /* absolute tolerance */
	const std::string min_type = "dfpmin_atol";
	// monte carlo
	const float minimization_threshold = 15.0; /* score unit */

	// aroop: taking care of chain breaks in loop building mode
	if(docking::dle_loops_flag &&
		 dle_ns::simultaneous_minimization)
		dle_modify_weightmap( docking_pose, weight_map);
	mc_global_track::mc_score::score = docking_pose.score( score10d );
	if ( docking_mcm_filter(delta_before_mcm, score_before_mcm) ) {
		pose_docking_minimize_trial( docking_pose, min_type, weight_map,
																 loose_func_tol);
		mc_global_track::mc_score::score = docking_pose.score( score10d );
		if ( docking_mcm_filter(delta_after_one_min, score_after_one_min) ) {
			const int cycles = 4; /* 4 cycles mcm first */
			pose_docking_monte_carlo_minimize( docking_pose, cycles, min_type,
    		weight_map, trans_magnitude,rot_magnitude, minimization_threshold,
					loose_func_tol );
			mc_global_track::mc_score::score = docking_pose.score( score10d );
			if ( ! runlevel_ns::benchmark &&
					 docking_mcm_filter(delta_after_five_mcm, score_after_five_mcm) ) {
				int cycles = 45; /* 45 cycles of extensive mcm */
				if( antibody_ns::snug_fit ) {
					rot_magnitude = 2.0; /* 2 degrees default */
					cycles = 3;
					if( runlevel_ns::benchmark )
						cycles = 1;
				}
				pose_docking_monte_carlo_minimize( docking_pose, cycles, min_type,
					weight_map, trans_magnitude, rot_magnitude, minimization_threshold,
					loose_func_tol );
				// minimize to a strict tolerance
				pose_docking_minimize_trial( docking_pose, min_type, weight_map,
					tight_func_tol );

			} /* after_five_mcm */

		} /* after_one_min */

	} /* before_min */
}
////////////////////////////////////////////////////////////////////////////
void
pose_docking_minimize_trial(
	pose_ns::Pose & docking_pose,
	const std::string & min_type,
	const pose_ns::Score_weight_map & wt_map,
	const float func_tol
)
{
	std::cout << std::endl;
	std::cout << "***** pose_docking_minimize_trial *****" << std:: endl;

	using namespace pose_ns;

	const float temperature( 0.8 );
	Monte_carlo mc( docking_pose, wt_map, temperature );

	pose_docking_set_rb_center ( docking_pose );

	if ( docking::minimize_backbone ) {
		if ( get_pose_docking_minimize_all() ) {
			pose_docking_minimize_all_position( docking_pose, min_type, wt_map,
				func_tol );
		} else {
			pose_docking_minimize_rb_position( docking_pose, min_type, wt_map,
				func_tol );
			pose_docking_minimize_torsion_position( docking_pose, min_type,
				wt_map, func_tol/200.0 );
		} // minmize_backbone
	} else {
		pose_docking_minimize_rb_position( docking_pose, min_type, wt_map,
			func_tol );
	}
	mc.boltzmann( docking_pose );
	mc.show_scores();

	docking_pose = mc.low_pose();

	std::cout << "***** pose_docking_minimize_trial *****" << std:: endl;
	std::cout << std::endl;
}
////////////////////////////////////////////////////////////////////////////
void
pose_docking_monte_carlo_minimize(
	pose_ns::Pose & docking_pose,
	const int cycles,
	const std::string & min_type,
	const pose_ns::Score_weight_map & wt_map,
	const float trans_magnitude,
	const float rot_magnitude,
	const float minimization_threshold,
	const float func_tol
)
{
	std::cout << "***** pose_docking_monte_carlo_minimize *****" << std::endl;

	using namespace pose_ns;

	// create a monte_carlo object
	const float temperature ( 0.8 ); // default: 0.8
	Monte_carlo mc ( docking_pose, wt_map, temperature );

	// start MCM
	int n_accepted = 0; // diagnostic counter

	const bool interface_only = true;
	const bool include_current_sidechain = true;
	// for rotamer_trials
	const float energycut = get_energycut();
	const int nres = docking_pose.total_residue();
	const int rottrial_cycles = 1;

	for( int i=1; i<=cycles; ++i ) {
		pose_docking_set_rb_center( docking_pose );
		pose_docking_gaussian_rigid_body_move( docking_pose, 1/*jump*/, trans_magnitude,
																					 rot_magnitude );
		bool save_docking_interface_pack = get_docking_interface_pack();

		if ( ( i % 8 == 0 ) || ( files_paths::antibody_modeler &&
													( i == cycles ))) { // default 8
			// full repacking
			pose_docking_repack( docking_pose, interface_only,
													 include_current_sidechain );
			// rotamer_trials_minimization ?
			if ( docking::dock_rtmin ) {
				set_docking_interface_pack( interface_only );
				score_set_try_rotamers( true );
				score_set_minimize_rot( true );
				docking_pose.score( wt_map );
				score_set_minimize_rot( false );
				score_set_try_rotamers( false );
			} else { // or just scoring with rotamer_trials off
				score_enable_rotamer_trials( false );
				docking_pose.score( wt_map );
				score_enable_rotamer_trials( true );
			}
		} else {
			//rotamer_trials for the whole protein
			//chu 06/11/21 -- be dependent on energycut, otherwise it will be slow.
			set_docking_interface_pack( ! interface_only );
			score_set_try_rotamers( true );
			set_rotamer_trials_by_deltaE( pose_ns::RESENERGY, energycut, nres,
				mc.best_pose().get_1D_score( pose_ns::RESENERGY ), rottrial_cycles);
			docking_pose.score( wt_map );
			score_set_try_rotamers( false );
		}

		set_docking_interface_pack( save_docking_interface_pack );
		const float current_score ( docking_pose.get_0D_score( SCORE ) );
		const float best_score ( mc.best_pose().get_0D_score( SCORE ) );

		if ( current_score - best_score < minimization_threshold ) {
			if ( docking::minimize_backbone ) {
				if ( get_pose_docking_minimize_all() ) {
					pose_docking_minimize_all_position( docking_pose, min_type, wt_map,
						func_tol );
				} else {
					pose_docking_minimize_rb_position( docking_pose, min_type, wt_map,
						func_tol );
					pose_docking_minimize_torsion_position( docking_pose, min_type,
						wt_map, func_tol/200.0 );
				} // minmize_backbone
			} else {
				pose_docking_minimize_rb_position( docking_pose, min_type, wt_map,
					func_tol );
			}
		}

 		const bool accepted = mc.boltzmann( docking_pose );

		if( accepted ) {
#ifdef BOINC
			calc_docking_rmsd();
			mc_global_track::diagnose::best_rms = get_docking_rmsd();
			mc_global_track::mc_score::best_score = mc.best_pose().get_0D_score( SCORE );
#endif
			++n_accepted;
		}
		std::cout << "Cycle: " << i << " -- ";
		mc.show_scores();
	}

	std::cout << "pose_docking_mcm --" << n_accepted << " out of " << cycles
						<< " monte carlo cycles accepted" << std::endl;

	docking_pose = mc.low_pose();

	std::cout << "***** pose_docking_monte_carlo_minimize *****" << std:: endl;
}


/////////////////////////////////////////////////////////////////////////////
void
slide_into_contact( pose_ns::Pose & pose ){
	using namespace pose_ns;
	using namespace docking;
	using namespace pose_ns::pose_param;

	pose_ns::Jump perturbed_jump( pose.get_jump( dock_jump ) );

	int const pos1( pose.fold_tree().get_jump_point()(1, dock_jump) );
	int const pos2( pose.fold_tree().get_jump_point()(2, dock_jump) );

	float const step_size( 1.0 );
	Score_weight_map weight_map;
	setup_score_weight_map( weight_map, score4d );
	// first try moving away from each other
	pose.score( weight_map );
	const FArray3D_float & Epos( pose.Eposition() );
	numeric::xyzVector_double trans_axis (
		numeric::xyzVector_double( &Epos(1,2,pos2) ) -
		numeric::xyzVector_double( &Epos(1,2,pos1) ) );

	while( pose.get_0D_score( DOCK_VDW ) > 0.1 ) {
		perturbed_jump.translation_along_axis( Epos(1,1,pos1), trans_axis, step_size );
		pose.set_jump( dock_jump, perturbed_jump );
		pose.score( weight_map );
	}
	// then try moving towards each other
	trans_axis.negate();
	while( pose.get_0D_score( DOCK_VDW ) < 0.1 ) {
		perturbed_jump.translation_along_axis( Epos(1,1,pos1), trans_axis, step_size );
		pose.set_jump( dock_jump, perturbed_jump );
		pose.score( weight_map );
	}
	trans_axis.negate();
	//back to the optimal touching condition
	perturbed_jump.translation_along_axis( Epos(1,1,pos1), trans_axis, step_size );
	pose.set_jump( dock_jump, perturbed_jump );
	pose.score( weight_map ); // aroop: ensures refold and copy to misc and
	                          // updating of interface residues needed if
                            // fab filter is present
}


/////////////////////////////////////////////////////////////////////////////
void
pose_docking_perturb_rigid_body(
	pose_ns::Pose & pose
)
{
	using namespace pose_ns;
	using namespace docking;
	using namespace runlevel_ns;
	using namespace pose_ns::pose_param;

	if ( ! pose.get_allow_jump_move( dock_jump ) ) return;
	pose_ns::Jump perturbed_jump( pose.get_jump( dock_jump ) );
	int const pos1( pose.fold_tree().get_jump_point()(1, dock_jump) );
	int const pos2( pose.fold_tree().get_jump_point()(2, dock_jump) );
	int const n2c( 1 );//dir
	int const ca( 2 );//atom
	//const FArray3D_float & Epos( pose.Eposition() );
	//make the const reference to Epos local to each if block below
	//this fixes a bug that consecutive calls of pose.set_jump does not trigger
	//refold to update Epos. With the fix, when each reference to Epos is made,
	//it will trigger a refold. 2006/04/13 chu
	numeric::xyzVector_double rot_center, spin_axis;

 	if ( docking_randomize1 ) {
		const FArray3D_float & Epos( pose.Eposition() );
 		rot_center = &Epos(1,ca,pos1); // ca of jump_pos1
		perturbed_jump.set_rb_center( n2c, Epos(1,1,pos2)/*downstream_jump*/, rot_center );
		//perturbed_jump.random_rot( 360.0f * ran3() );
		//use the new function random_reorientation_matrx() to fix the non-uniform
		//rigid-body distribution sampling. 2006/11/28 chu
		perturbed_jump.rotation_by_matrix( Epos(1,1,pos1), rot_center,
			random_reorientation_matrix() );
 		pose.set_jump( dock_jump, perturbed_jump );
 	}

 	if ( docking_randomize2 ) {
		const FArray3D_float & Epos( pose.Eposition() );
		rot_center = &Epos(1,ca,pos2); // ca of jump_pos2
		perturbed_jump.set_rb_center( n2c, Epos(1,1,pos2)/*downstream_jump*/, rot_center );
		//perturbed_jump.random_rot( 360.0f * ran3() );
		//use the new function random_reorientation_matrx() to fix the non-uniform
		//rigid-body distribution sampling. 2006/11/28 chu
		perturbed_jump.rotation_by_matrix( Epos(1,1,pos1), rot_center,
			random_reorientation_matrix() );
		pose.set_jump( dock_jump, perturbed_jump );
	}

	if ( docking_small_perturbation ) {
		std::cout << "pose_docking_perturb_rigid_body: trans/rot mag "
							<< normal_perturbation << "/" << rotational_perturbation << "\n";
		const FArray3D_float & Epos( pose.Eposition() );
		rot_center = &Epos(1,ca,pos2); // ca of jump_pos2
		perturbed_jump.set_rb_center( n2c, Epos(1,1,pos2)/*downstream_jump*/, rot_center );
		perturbed_jump.gaussian_move( n2c, normal_perturbation, rotational_perturbation );
		pose.set_jump( dock_jump, perturbed_jump );
	}

	if ( docking_axis_spin_flag ) {
		const FArray3D_float & Epos( pose.Eposition() );
		rot_center = &Epos(1,ca,pos2); // ca of jump_pos2
		spin_axis = &Epos(1,ca,pos1); // ca of jump_pos1
		spin_axis -= rot_center; // vector from jump_pos2 to jump_pos1
		perturbed_jump.rotation_by_axis( Epos(1,1,pos1), spin_axis, rot_center, 360.0f*ran3() );
		pose.set_jump( dock_jump, perturbed_jump );
	}

	// slide_into_contact
	slide_into_contact( pose );

	if(!docking_fab_filter()) // aroop: checking if decoy passes fab filter
		{
			if(runlevel > standard)
				std::cout << "Structure failed fab filter; Re-randomizing" << std::endl;
			pose_docking_perturb_rigid_body( pose ); // aroop: re-initialize decoy
		}

}
/////////////////////////////////////////////////////////////////////////////
void
pose_docking_centroid_rigid_body_adaptive(
	pose_ns::Pose & pose,
	int const outer_cycles,
	int const inner_cycles,
	const pose_ns::Score_weight_map & wt_map,
	float trans_mag,
	float rot_mag
)
{
	using namespace pose_ns;

	float accept_rate(0); // acceptance rate of moves
	if (docking::docking_ensemble_flag){
		scorefxns::scorefxn_flags::docking_ensemble_scorefxn = true;
		pose_docking_ensemble_move( pose );
		}

	for ( int i = 1; i <= outer_cycles; ++i ) {
		if ( !dle_ns::insert_all_loops_with_local_refine ) // insert one loop at a time and do a local refine
			accept_rate = pose_docking_rigid_body_trial( pose, inner_cycles, wt_map, false/*fullatom*/, trans_mag, rot_mag );
		if(i == 1) // randomize flexible regions only once
			{
				if( docking::dle_flag ) { // aroop: docking flexible
					if(dle_ns::dle_cter_flag)
						dle_cter( pose, trans_mag, rot_mag);
					accept_rate = dle_insert_loops(pose, trans_mag, rot_mag);
					i++;
				}
			}

		if ( accept_rate > 0.5 ) {
			trans_mag *= 1.1;
			rot_mag *= 1.1;
		}	else {
			trans_mag *= 0.9;
			rot_mag *= 0.9;
		}
	}

	if (docking::docking_ensemble_flag) scorefxns::docking_ensemble_scorefxn = false;
}
////////////////////////////////////////////////////////////////////////////////
float
pose_docking_rigid_body_trial(
	pose_ns::Pose & pose,
	int const cycles,
	const pose_ns::Score_weight_map & wt_map,
	bool  const repack,
	float const trans_mag,
	float const rot_mag
)
{
	using namespace pose_ns;

	float const temperature( 0.8 );
	Monte_carlo mc( pose, wt_map, temperature );
	int n_accepted = 0;

	for ( int i = 1; i <= cycles; ++i ) {
		pose_docking_gaussian_rigid_body_move( pose, 1/*jump*/, trans_mag, rot_mag );

		if (docking::docking_ensemble_flag && !repack) pose_docking_ensemble_move( pose );

		if ( repack ) pose_docking_repack( pose, true/*interface*/, true/*include_current*/ );

		pose.score( wt_map );

		if ( mc.boltzmann( pose ) ) {
#ifdef BOINC
			calc_docking_rmsd();
			mc_global_track::diagnose::best_rms = get_docking_rmsd();
			mc_global_track::mc_score::best_score = mc.best_pose().get_0D_score( SCORE );
#endif
			++n_accepted;
		}
	}


	pose = mc.low_pose();

	std::cout << "pose_docking_rigid_body_trial -- "
						<< (repack ? "fullatom ":"centroid ")
						<< n_accepted << " out of " << cycles << " accepted\n";

	return n_accepted/cycles;

}
/////////////////////////////////////////////////////////////////////////////
void
pose_docking_gaussian_rigid_body_move(
	pose_ns::Pose & pose,
	int jump,
	const float trans_delta,
	const float rot_delta
)
{
	for( int i=1; i<=3; ++i ) { // first 3 are translation
		 const float rb_tmp( pose.get_jump_rb_delta( jump ,i/*rg*/,1/*dir*/) );
		 pose.set_jump_rb_delta(jump,i,1,rb_tmp+trans_delta*gaussian());
	}

	for( int i=4; i<=6; ++i ) { // next 3 are rotations
		const float rb_tmp( pose.get_jump_rb_delta(jump,i,1) );
		pose.set_jump_rb_delta(jump,i,1,rb_tmp+rot_delta*gaussian());
	}

	return;
}
 //////////////////////////////////////////////////////////////////////////////
void
pose_docking_repack(
	pose_ns::Pose & pose,
	const bool pack_interface,
	const bool include_current
)
{
	const int nres( pose.total_residue() );
	FArray1D_bool allow_repack( nres, false );

	if ( pack_interface ) {
		if ( docking::antibody_modeling_dock_n_snug_flag &&
				 ( pose.fold_tree().get_num_jump() > 1 ) )
			anitbody_modeling_snugdock_calc_interface( pose, allow_repack);
		else
			pose_docking_calc_interface( pose, allow_repack );
	} else {
		allow_repack = true;
	}

	// repack moveable residue
	if( docking::dle_flag )
		dle_calc_loops_environ( pose, allow_repack );

	// repack minimized cdrs and neighbors
	if( antibody_ns::snugdock_ns::snugloop)
		pose_loops_select_loop_residues( pose, dle_ns::dle_loops,
																		 true /*include_neighbors*/,allow_repack);

	if ( docking::antibody_modeling_dock_n_snug_flag )
		pose_loops_select_loop_residues( pose, antibody_ns::all_cdrs,
																		 true /*include_neighbors*/,allow_repack);

	if ( docking::norepack1 ) {
		for ( int i = 1; i <= docking::part_end(1); i++ ) {
			allow_repack(i) = false;
		}
	}

	if ( docking::norepack2 ) {
		for ( int i = docking::part_begin(2); i <= pose.total_residue(); i++ ) {
			allow_repack(i) = false;
		}
	}

	if ( get_enable_ligaa_flag() ) {
    allow_repack( pose.total_residue() ) = false;
  }

	pose.repack( allow_repack, include_current );

	return;
}
 //////////////////////////////////////////////////////////////////////////////
void
pose_docking_minimize_rb_position(
	pose_ns::Pose & pose,
	const std::string & type,
	const pose_ns::Score_weight_map & wt_map,
	const float func_tol
)
{
	using namespace pose_ns;

	if ( ! pose.fullatom() )
		error_stop("must be in fullatom mode for docking rb minimization");

	minimize_set_tolerance( func_tol );

	// minimize
	pose_minimize_rigid_body( pose, wt_map, type );
	pose.score( wt_map );

	return;
}
//////////////////////////////////////////////////////////////////////////
void
pose_docking_minimize_torsion_position(
	pose_ns::Pose & pose,
	const std::string & type,
	const pose_ns::Score_weight_map & wt_map,
	const float func_tol
)
{
	//start_timer("docking_pose_minimize");
	using namespace pose_ns;
	using namespace docking;

	if ( ! pose.fullatom() )
		error_stop("must be in fullatom mode for docking torsion minimization");

	minimize_set_tolerance( func_tol );

	//minimize
	pose_minimize_torsion( pose, wt_map, type );
	pose.score( wt_map );

	return;
}
///////////////////////////////////////////////////////////////////////////////
void
pose_docking_minimize_all_position(
	pose_ns::Pose & pose,
	const std::string & type,
	const pose_ns::Score_weight_map & wt_map,
	const float func_tol
)
{
	using namespace pose_ns;
	using namespace docking;

	if ( ! pose.fullatom() )
		error_stop("must be in fullatom mode for docking minimization");

	minimize_set_tolerance( func_tol );

	//minimize
	pose.main_minimize( wt_map, type );
	pose.score( wt_map );

	return;
}

/////////////////////////////////////////////////////////////////////////////
void
pose_docking_calc_interface(
	pose_ns::Pose & pose,
	FArray1DB_bool & int_res
)
{
	using namespace pose_ns;

	int const total_residue( pose.total_residue() );
	assert( int(int_res.size1()) == total_residue );

	pose_update_cendist( pose );
	Fold_tree const & fold_tree ( pose.fold_tree() );
	FArray1D_bool partner( pose.total_residue(), false );

	fold_tree.partition_by_jump( pose_param::dock_jump, partner );

	FArray2D_float const & cendist ( pose.get_2D_score( CENDIST ) );

	for ( int i=1; i<=total_residue; ++i ) {
		for ( int j=i+1; j<=total_residue; ++j ) {
			if ( partner(i) == partner(j) ) continue;
			if ( int_res(i) && int_res(j) ) continue;
			if ( cendist(i,j) < 64 ) int_res(i) = int_res(j) = true;
		}
	}

	return;
}
//////////////////////////////////////////////////////////////////////////
void
eval_dock_elec_dE_dR(
	float q1,
	float q2,
	float r2,
	FArray1DB_float const & atomi,
	FArray1DB_float const & atomj,
	float & dE_dR,
	FArray1DB_float & f1,
	FArray1DB_float & f2
)
{
	// this function is called from jmp_dfunc_vdw
	// it uses the f1 and f2 trick, thus different from that in normal docking

	dE_dR = 0.0;

	if ( q1 == 0.0 || q2 == 0.0 ) return; // skip if any one of the atoms neutral

	static float const cutoff = 1.5 * 1.5;
	if ( r2 <= cutoff ) return; // 0 derivative if distance smaller than 1.5

	//ora: based on inverse_r_elec

	float E = 322.0637 * q1 * q2 / r2;
	if ( E == 0.0 ) return;

	float one_r = 1.0/std::sqrt(r2); // 1/r
	dE_dR = -2*one_r*E;
	if ( dE_dR == 0.0 ) return;

	dE_dR *= scorefxns::docking_warshel_elec_weight;
	dE_dR *= one_r;

	subvec( atomi, atomj, f2 );
	cros( atomi, atomj, f1 );
}
//////////////////////////////////////////////////////////////////////////////
void
docking_orient_current_to_start()
{
	using namespace param;
	using namespace misc;
	using namespace docking;
	//using namespace native;
	using namespace start;
	using namespace loops_ns;


	// this function rigid-body transforms the current misc pose by superimpose
	// the docking_partner1 in the current pose to that in the native

	int total_residue1 = part_end(1) - part_begin(1) + 1;
	FArray2D_double p1a( 3, total_residue1 );
	FArray2D_double p2a( 3, total_residue1 );
	FArray1D_double ww( total_residue1 );
	FArray1D_double p1_offset (3), p2_offset(3);
	FArray2D_double uu( 3, 3 );
	double ctx;

	int j = 2;
	for ( int k = 1; k <= total_residue1; ++k ) {
		ww(k) = ( loop_map(k) > 0 ? 0.0 : 1.0 );
		//ww(k) = 1.0;
		for ( int i = 1; i <= 3; ++i ) {
			//p1a(i,k) = native_ca(i,k); // single to double
			p1a(i,k) = Estart_position(i,2,k);
			p2a(i,k) = position(i,j); // pick out c_alphas
		}
		j += 5;
	}

	// matrix UU and offset to superimpose p2a onto p1a
	findUU_trans(p2a,p1a,ww,total_residue1,uu,ctx,p2_offset,p1_offset);

	// Eposition
	UU_rotate(Eposition, total_residue*MAX_POS, p2_offset, p1_offset, uu);

	// centroid
	UU_rotate(centroid, total_residue, p2_offset, p1_offset, uu);

	// full_coord
	if (get_fullatom_flag()) {
		UU_rotate(full_coord, total_residue*MAX_ATOM()(),p2_offset, p1_offset, uu);
	}

	// update docking geometry
	for ( int i = 1; i <= n_monomers; ++i ) {
		chain_centroid_CA(position,part_begin(i),part_end(i),part_centroid(1,i));
	}

	docking_derive_coord_frame();

}
///////////////////////////////////////////////////////////////////////
void
pose_docking_set_rb_center( pose_ns::Pose & pose )
{
	const int rb_jump_num = { 1 }; /* jump 1 is always main rigid-body */

	/* calculate center of interface residues */
	FArray1D_float center(3);

	pose_update_cendist( pose );

	calculate_interface_centroid( center );
	/* set as the jump rb_center */
	numeric::xyzVector_double tmp_center( &center(1) );
	pose.set_jump_rb_center( rb_jump_num, tmp_center );

}

///////////////////////////////////////////////////////////////////////////
// two docking partners, one rigid-body freedom
void pose_docking_build_simple_tree(
 	pose_ns::Pose & pose,
	int const nres,
	int const cutpoint
)
{	// use overall geometrical center
 	using namespace pose_ns;

 	int const jump_pos1 ( pose.residue_center_of_mass(1, cutpoint) );
 	int const jump_pos2 ( pose.residue_center_of_mass(cutpoint+1, nres) );

 	pose.one_jump_tree( nres, jump_pos1, jump_pos2, cutpoint, jump_pos1);
	std::cout << "pose_docking_build_simple_tree:\n" << pose.fold_tree();
}

///////////////////////////////////////////////////////////////////////////////
float
pose_docking_calc_rmsd(
	pose_ns::Pose & pose
)
{
	// currently a hack, first copy pose to misc, then align current with start
	// in case pose has moved in absolute space, finally calc rmsd value.
	pose.copy_to_misc();

	docking_orient_current_to_start();

	calc_docking_rmsd();

	return docking::docking_rmsd;
}
///////////////////////////////////////////////////////////////////////////////
namespace pose_ns {

	int
	Pose::residue_center_of_mass(
		int const start,
		int const stop
	) const
	{
		using numeric::xyzVector_float;

		assert( start < stop );

		xyzVector_float center(0.0);
		for (int i=start; i<=stop; ++i) {

			xyzVector_float ca_pos( &Eposition_(1,2,i) );

			center += ca_pos;
		}

		center /= (stop-start+1);

		int res = return_nearest_residue(start, stop, center);
		return res;
	}

	// overloaded version of function above in which the vector is passed in
	// instead of the pieces of the vector
	//
	// Monica Berrondo
	// April 13 2006
	int
	Pose::residue_center_of_mass(
			std::vector< numeric::xyzVector< double > > const partner_positions
	) const
	{
		using numeric::xyzVector_float;

		xyzVector_float center(0.0);

		center = vector_centroid( partner_positions );

		int res = return_nearest_residue(1, total_residue_, center);
		return res;
	}

	////////////////////////////////////////////////////////////////////////////////
	/// @begin return_nearest_residue
	///
	/// @brief return the nearest residue to a given location in space
	///
	/// @detailed
	///		pass in an xyzVector with a location in space and get back the residue that
	///		is nearby
	///
	///	@author: Monica Berrondo
	///
	///	@last_modified: April 14 2006
	//////////////////////////////////////////////////////////////////////////////
	int
	Pose::return_nearest_residue(
			int const begin,
			int const end,
			numeric::xyzVector_float center
	) const
	{
		using numeric::xyzVector_float;

		float min_dist = 9999.9;
		int res = 0;
		for (int i=begin; i<=end; ++i ) {
			xyzVector_float ca_pos ( &Eposition_(1,2,i) );
			ca_pos -= center;
			float tmp_dist( ca_pos.length_squared() );
			if( tmp_dist < min_dist ) {
				res = i;
				min_dist = tmp_dist;
			}
		}

		return res;
	}
}

///////////////////////////////////////////////////////////////////////////////
void
pose_minimize_backbone(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map,
	std::string const & min_type
)
{
	int nres( pose.total_residue() );
	FArray1D_bool save_allow_chi_move( nres );
  for ( int i=1; i<=nres; ++i ) {
		save_allow_chi_move(i) = pose.get_allow_chi_move(i) ;
	}
	int n_jump( pose.num_jump() );
	FArray1D_bool save_allow_jump_move( n_jump );
	for ( int i=1; i<=n_jump; ++i ) {
		save_allow_jump_move(i) = pose.get_allow_jump_move(i);
	}
	pose.set_allow_chi_move( false );
	pose.set_allow_jump_move( false );

	pose.main_minimize( wt_map, min_type );

	pose.set_allow_chi_move( save_allow_chi_move );
	pose.set_allow_jump_move( save_allow_jump_move );
}
///////////////////////////////////////////////////////////////////////////////
void
pose_minimize_sidechain(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map,
	std::string const & min_type
)
{
	int nres( pose.total_residue() );
	FArray1D_bool save_allow_bb_move( nres );
  for ( int i=1; i<=nres; ++i ) {
		save_allow_bb_move(i) = pose.get_allow_bb_move(i) ;
	}
	int n_jump( pose.num_jump() );
	FArray1D_bool save_allow_jump_move( n_jump );
	for ( int i=1; i<=n_jump; ++i ) {
		save_allow_jump_move(i) = pose.get_allow_jump_move(i);
	}
	pose.set_allow_bb_move( false );
	pose.set_allow_jump_move( false );

	pose.main_minimize( wt_map, min_type );

	pose.set_allow_bb_move( save_allow_bb_move );
	pose.set_allow_jump_move( save_allow_jump_move );
}
///////////////////////////////////////////////////////////////////////////////
void
pose_minimize_torsion(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map,
	std::string const & min_type
)
{
	int n_jump( pose.num_jump() );
	FArray1D_bool save_allow_jump_move ( n_jump );
	for ( int i=1; i<=n_jump; ++i ) {
		save_allow_jump_move(i) = pose.get_allow_jump_move(i) ;
	}
	pose.set_allow_jump_move( false );

	pose.main_minimize( wt_map, min_type );

	pose.set_allow_jump_move( save_allow_jump_move );
}
///////////////////////////////////////////////////////////////////////////////
void
pose_minimize_rigid_body(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map,
	std::string const & min_type
)
{
	int nres( pose.total_residue() );
	FArray1D_bool save_allow_bb_move( nres );
	FArray1D_bool save_allow_chi_move ( nres );
	for( int i=1; i<=nres; ++i ) {
		save_allow_bb_move(i) = pose.get_allow_bb_move(i);
		save_allow_chi_move(i) = pose.get_allow_chi_move(i);
	}
	if((docking::dle_loops_flag && dle_ns::simultaneous_minimization) ||
		 ( antibody_ns::snugdock_ns::snugloop &&
			 antibody_ns::snugdock_ns::local_loop_min)  ) {
		FArray1D_bool allow_moves( pose.total_residue(), false );
		pose_loops_select_loop_residues( pose,
			dle_ns::dle_loops,
			  false /*include_neighbors*/,allow_moves);
		pose.set_allow_bb_move( allow_moves );
		pose_loops_select_loop_residues( pose,
      dle_ns::dle_loops,
			  true /*include_neighbors*/,allow_moves);
		for( int i = 1; i <= nres; i++ ) {
			if( save_allow_chi_move(i) )
				allow_moves(i) = true;
		}
		pose.set_allow_chi_move( allow_moves );
	}
	else {
		pose.set_allow_bb_move( false );
		pose.set_allow_chi_move( false );
	}

	pose.main_minimize( wt_map, min_type );

	pose.set_allow_bb_move( save_allow_bb_move );
	pose.set_allow_chi_move( save_allow_chi_move );
}
///////////////////////////////////////////////////////////////////////////////
void
pose_docking_prepack_protocol(
	pose_ns::Pose & pose
)
{
	using namespace pose_ns;
	using namespace pose_ns::pose_param;
	using namespace docking;

	Score_weight_map weight_map( score10d );//default for scoring

	if ( ! pose.fullatom() ) pose.set_fullatom_flag( true, true );
	if ( get_enable_ligaa_flag() ) attach_ligand_to_docking_pose( pose ); // IA

	int no;
	retrieve_decoy_number( no );
	std::string const number(
		lead_zero_string_of( no, files_paths::NUMBER_MAX_LENGTH ) );

	std::cout << "pose_docking_prepack: separating" << std::endl;
	Jump perturbed_jump( pose.get_jump( dock_jump ) );
	int const pos1( pose.fold_tree().get_jump_point()(1, dock_jump) );
	int const pos2( pose.fold_tree().get_jump_point()(2, dock_jump) );
	const FArray3D_float & Epos( pose.Eposition() );
	numeric::xyzVector_double trans_axis (
		numeric::xyzVector_double( &Epos(1,2,pos2) ) -
		numeric::xyzVector_double( &Epos(1,2,pos1) ) );
	float const step_size = 99.0;
	perturbed_jump.translation_along_axis(Epos(1,1,pos1), trans_axis, step_size);
	pose.set_jump( dock_jump, perturbed_jump );
	float apart_original = pose.score( weight_map );
	std::cout << number+"_away_original: "; pose.show_scores( std::cout );
	bool interface_only = false; // repack everything

	if ( prepack_full ) {
		std::cout << "pose_docking_prepack: repacking" << std::endl;
		pose_docking_repack( pose, interface_only, files_paths::include_inputchi );
	}
	float apart_repacked = pose.score( weight_map );
	std::cout << number+"_away_repacked: "; pose.show_scores( std::cout );

	if ( prepack_rtmin ) {
		std::cout << "pose_docking_prepack: rottrial minimization" << std::endl;
		set_docking_interface_pack( interface_only );
		score_set_try_rotamers( true );
		score_set_minimize_rot( true );
		pose.score( weight_map );
		score_set_minimize_rot( false );
		score_set_try_rotamers( false );
	}
	float apart_rtmined = pose.score( weight_map );
	std::cout << number+"_away_rtmined: "; pose.show_scores( std::cout );

	if ( docking::minimize_backbone ){
		std::cout << "pose_docking_prepack: bb & sc minimization" << std::endl;
		pose.set_allow_jump_move( dock_jump, false );
		minimize_set_tolerance( 0.02 );
		setup_score_weight_map( weight_map, score10d_min ); // just minimization
		pose_minimize_torsion( pose, weight_map, "dfpmin_atol" );
		setup_score_weight_map( weight_map, score10d );
		pose.set_allow_jump_move( dock_jump, true );
	}
	float apart_minimized = pose.score( weight_map );
	std::cout << number+"_away_minimized: "; pose.show_scores( std::cout );

	std::cout << "pose_docking_prepack_protocol: "
						<< "score of apart_orginal/repacked/rtmined/minimized\n"
						<< apart_original << "/" << apart_repacked << "/"
						<< apart_rtmined << "/" << apart_minimized << std::endl;

	//chu these scores are not being used anyway, so we just borrow them !
	docking::score_before_mcm = apart_repacked;
	docking::score_after_one_min = apart_rtmined;
	docking::score_after_five_mcm = apart_minimized;

	trans_axis.negate();
	perturbed_jump.translation_along_axis(Epos(1,1,pos1), trans_axis, step_size);
	pose.set_jump( dock_jump, perturbed_jump );
	pose.score( weight_map );

	return;
}
////////////////////////////////////////////////////////////////////////////////
/// @begin pose_mininmize_interface
///
/// @brief full atom minimization of an interface
///
/// @detailed jumps at closest c-alphasi between partners, residues to move are
///           selevted by calling "interface_residues()", apply backbone
///           constraints outside of this function
///
//////////////////////////////////////////////////////////////////////////////
void
pose_mininmize_interface(
	pose_ns::Pose & pose,
	const float min_tolerance,
	const pose_ns::Score_weight_map & weight_map,
	const std::string & min_type
){
	using namespace design;
	using namespace pose_ns;
	using namespace analyze_interface_ddg_ns;
	using numeric::xyzVector_float;

	int p1_start,p1_end, p2_start, p2_end;
	float min_dis2(10000.0);
	int const nres( pose.total_residue() );

	assert( misc_in_sync( pose ));
	interface_residues();
	get_complex_boundaries(p1_start, p1_end, p2_start, p2_end);
	assert( nres == p2_end);

	// setup the fold_tree
	int jump_pos1(0), jump_pos2(0);

	// find the closest c-alphas between the two partners, anchor the
	// jump at these residues
	for ( int ii=1; ii<= nres; ++ii ) {
		xyzVector_float i_ca( &pose.Eposition()(1,2,ii) );
		float i_min_dis2(10000.0);
		for ( int jj=1; jj<= nres; ++jj ) {
			if ( ii <= p1_end && jj <= p1_end || ii > p1_end && jj > p1_end ) continue;
			xyzVector_float j_ca( &pose.Eposition()(1,2,jj) );
			float const dis2( distance_squared( i_ca, j_ca ) );
			if ( dis2 < min_dis2 ) {
				min_dis2 = dis2;
				jump_pos1 = std::min(ii,jj);
				jump_pos2 = std::max(ii,jj);
			}
			i_min_dis2 = std::min( dis2, i_min_dis2 );
		}
	}

	std::cout << "Anchoring jump at residues: " << jump_pos1 << " and " <<
		jump_pos2 << " CA_distance= " << std::sqrt( min_dis2 ) << std::endl;

	// set the fold_tree
	pose_setup_minimizer( min_tolerance );
	pose.one_jump_tree( nres, jump_pos1, jump_pos2, p1_end );
	pose.set_allow_chi_move( interface_residue ); // pass FArray
	pose.set_allow_bb_move( interface_residue ); // pass FArray
	pose.set_allow_jump_move( true );
	pose.main_minimize( weight_map, min_type );
	assert( misc_in_sync( pose ));
	pose.copy_to_misc();  // make sure complex is in misc
}

///////////////////////////////////////////////////////////////////////////////
void
pose_docking_silent_output_setup(
	pose_ns::Pose & pose,
	silent_io::Silent_out & silent_out
)
{
	using namespace pose_ns;
	using namespace files_paths;
	using namespace silent_io;

	// store rotamer
	std::string filename = pdb_out_path + code + protein_name + ".out";
	silent_out.open( filename );
	if ( pose.fullatom() ) silent_out.store_rotamers( pose );

	int num;
	retrieve_decoy_number( num );
	if ( num != 1 ) return; // write bonds and rot_template files only once

	// make .bonds file if necessary:
	if ( !pose.ideal_backbone() ) {
		std::string const bonds_filename( filename+".bonds" );
		std::ofstream out( bonds_filename.c_str() );
		pose.bonds().dump( out );
		out.close();
		out.clear();
	}

	// make rotamers file if necessary:
	if ( ! silent_out.ideal_rotamers() ) {
		std::string const rot_filename( filename+".rot_templates" );
		std::ofstream out( rot_filename.c_str() );
		std::map< int, std::vector<Rotamer_template> > const &
			rotamer_template_map ( silent_out.rotamer_template_map () );
		const int nres( pose.total_residue() );
		for( int i=1; i<= nres; ++i ) {
			if ( !rotamer_template_map.count(i) ) {
				std::cout << "i not in rotamer_template_map: " << i << std::endl;
				utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			}
			std::vector< Rotamer_template > const & rot_list
				( rotamer_template_map.find( i )->second );

			for( int j=0,j_end=rot_list.size(); j<j_end; ++j ) {
				out << i << ' ' << j << ' ' << rot_list[j] << std::endl;
			}
		}
		out.close();
		out.clear();
	}
	return;
}
///////////////////////////////////////////////////////////////////////////////
void
pose_docking_output_silent_structure(
	pose_ns::Pose & pose,
	silent_io::Silent_out & silent_out
)
{
	using namespace pose_ns;
	using namespace files_paths;
	using namespace silent_io;

	int const nres( pose.total_residue() );
	std::string filename, tempfile;
	retrieve_decoy_name( filename );
	tempfile = pdb_out_path + filename;
	utility::io::ozstream out_stream(
		tempfile, std::ios_base::in|std::ios_base::out
	);
	if ( ! out_stream ) {
		std::cout << "Open failed for file: " << tempfile << " " << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
	FArray1D_bool output_rsd( nres, true );
	FArray1D_int rot_template( nres, 0 );
	if ( ! silent_out.ideal_rotamers() ) {
		silent_out.get_rot_templates( pose, rot_template );
	}
	tempfile=" ";
	dump_compressed_pose( tempfile, pose, output_rsd, rot_template, 0/*symm*/,
												out_stream );
}
/////////////////////////////////////////////////////////////////////////////
bool
pose_docking_read_silent_input(
	pose_ns::Pose & pose
)
{
	using namespace pose_ns;
	using namespace silent_io;
	using namespace docking;

	static silent_io::Silent_file_data silent_file_data(
		docking_silent_input_file.c_str(), docking_fa_silent_input
	);

	std::string decoy_tag = docking_silent_input_get_current_tag( true );

	if ( silent_file_data.has_key( decoy_tag ) ) {
		bool const check_coords( true );
		silent_file_data.get_structure(decoy_tag).fill_pose( pose,check_coords );
		return true;
	} else {
		std::cout << decoy_tag << " is not found in "
							<< docking_silent_input_file << std::endl;
		return false;
	}
}
///////////////////////////////////////////////////////////////////////////////
bool
get_pose_docking_minimize_all()
{
	static bool pose_docking_minimize_all( false );
	static bool init( false );

	if ( !init ) {
		pose_docking_minimize_all = truefalseoption("minimize_all");
		init = true;
	}
	return pose_docking_minimize_all;
}
/////////////////////////////////////////////////////////
float get_dock_mcm_trans_magnitude()
{
	static bool init = {false};
	static float dock_mcm_trans_magnitude( 0.1 );
	if (!init){
		dock_mcm_trans_magnitude = realafteroption("dock_mcm_trans_magnitude", 0.1); /* angstroms */
		init = true;
	}
	return dock_mcm_trans_magnitude;
}
/////////////////////////////////////////////////////////
float get_dock_mcm_rot_magnitude()
{
	static bool init = {false};
	static float dock_mcm_rot_magnitude( 5.0 );
	if (!init){
		dock_mcm_rot_magnitude = realafteroption("dock_mcm_rot_magnitude", 5.0); /* degrees */
		init = true;
	}
	return dock_mcm_rot_magnitude;
}


void
attach_ligand_to_docking_pose( pose_ns::Pose & docking_pose )
{
    using namespace param_aa;

    //////  START ATTACHMENT  //////
    int lig_root_atomno( 1 );   // 1st hetero heavyatom in pdb file
    int anchor_rsd( 1 );        // attach to first res, Ca
    int anchor_atomno( 2 );     // CA

    FArray2D_float lig_coord( 3, param::MAX_ATOM() );
    {
      has_ligand_no( ligand_aa_vector[1] ) = 1;
      setup_ligand_aa( ligand_aa_vector[1], 1, get_ligand_one(), lig_coord ); // aav=1
    }

    std::cout << std::endl << "ATTACHING POSE LIGAND..." << std::endl << std::endl;

    // no longer using ligand mode to manage the ligand
    // that's the hack -- it's been setup as an amino acid now
    bool attach_by_jump( true );  // alternative is to attach by a bond
    set_ligand_flag( false );

    docking_pose.attach_ligand( ligand_aa_vector[1], 1 /* aav */, anchor_atomno, anchor_rsd,
lig_root_atomno, lig_coord, attach_by_jump );
    docking_pose.setup_atom_tree();
    docking_pose.set_allow_jump_move( docking_pose.num_jump(), false ); // SJF
		docking_pose.set_allow_jump_move(  pose_ns::pose_param::dock_jump, true);
		docking_pose.new_score_pose();
		 get_ligand_one().recompute_ligand_interface = true;
    // docking_pose.dump_scored_pdb( "attached_ligand.pdb", score_weight );
    //////  END ATTACHMENT
}
///////////////////////////////////////////////////////////
void
pose_docking_set_general_allow_move(
	pose_ns::Pose & pose
)
{
	// check various command line flags to set allow move correctly
	using namespace docking;
	using namespace pose_ns;

	// allow_jump_move
	pose.set_allow_jump_move( pose_param::dock_jump, true );

	// allow_bb_move
	if ( truefalseoption("nominimize1")) {
		for ( int i = part_begin(1); i<= part_end(1); ++i ) {
			pose.set_allow_bb_move(i,false);
		}
	}
	if ( truefalseoption("nominimize2")) {
		for ( int i = part_begin(2); i<= part_end(2); ++i ) {
			pose.set_allow_bb_move(i,false);
		}
	}
	int const nres = pose.total_residue();
	FArray1D_bool chainbreaks( nres, false );
	pose.identify_backbone_chainbreaks( chainbreaks );
	for ( int i = 1; i < nres; ++i ) {
		if ( chainbreaks(i) ) {
			pose.set_allow_bb_move(i,false);
			pose.set_allow_bb_move(i+1,false);
		}
	}
	// allow_chi_move
	if ( norepack1 ) {
		for ( int i = part_begin(1); i<= part_end(1); ++i ) {
			pose.set_allow_chi_move(i,false);
		}
	}
	if ( norepack2 ) {
		for ( int i = part_begin(2); i<= part_end(2); ++i ) {
			pose.set_allow_chi_move(i,false);
		}
	}
}
