// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17140 $
//  $Date: 2007-09-11 20:02:11 -0700 (Tue, 11 Sep 2007) $
//  $Author: andre $

#ifndef INCLUDED_pose_docking
#define INCLUDED_pose_docking

// C++ Headers
#include <string>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// Forward declarations
namespace pose_ns { class Pose; class Score_weight_map; }
namespace silent_io { class Silent_out; }

void
pose_docking_main( bool & fail );


void
pose_docking_standard_protocol(
	pose_ns::Pose & pose
);


void
pose_docking_minimize_trial(
	pose_ns::Pose & docking_pose,
	const std::string & min_type,
	const pose_ns::Score_weight_map & wt_map,
	const float func_tol
);


void
pose_docking_mcm_protocol(
	pose_ns::Pose & docking_pose,
	pose_ns::Score_weight_map & wt_map
);


void
pose_docking_monte_carlo_minimize(
	pose_ns::Pose & docking_pose,
	const int cycles,
	const std::string & min_type,
	const pose_ns::Score_weight_map & wt_map,
	const float trans_magnitude,
	const float rot_magnitude,
	const float minimization_threshold,
	const float func_tol
);


void
slide_into_contact( pose_ns::Pose & pose );

void
pose_docking_perturb_rigid_body(
	pose_ns::Pose & pose
);


void
pose_docking_centroid_rigid_body_adaptive(
	pose_ns::Pose & pose,
	int const outer_cycles,
	int const inner_cycles,
	const pose_ns::Score_weight_map & wt_map,
	float trans_mag,
	float rot_mag
);


float
pose_docking_rigid_body_trial(
	pose_ns::Pose & pose,
	int const cycles,
	const pose_ns::Score_weight_map & wt_map,
	bool const repack,
	float const trans_mag,
	float const rot_mag
);



void
pose_docking_gaussian_rigid_body_move(
	pose_ns::Pose & pose,
	int jump,
	const float trans_delta,
	const float rot_delta
);


void
pose_docking_repack(
	pose_ns::Pose & pose,
	const bool pack_interface,
	const bool include_current
);


void
pose_docking_minimize_rb_position(
	pose_ns::Pose & pose,
	const std::string & type,
	const pose_ns::Score_weight_map & wt_map,
	float func_tol
);


void
pose_docking_minimize_torsion_position(
	pose_ns::Pose & pose,
	const std::string & type,
	const pose_ns::Score_weight_map & wt_map,
	float func_tol
);

void
pose_docking_minimize_all_position(
	pose_ns::Pose & pose,
	const std::string & type,
	const pose_ns::Score_weight_map & wt_map,
	float func_tol
);


void
pose_docking_calc_interface(
	pose_ns::Pose & pose,
	FArray1DB_bool & int_res
);


void
eval_dock_elec_dE_dR(
	float q1,
	float q2,
	float r2,
	FArray1DB_float const & atomi,
	FArray1DB_float const & atomj,
	float & dE_dR,
	FArray1DB_float & f1,
	FArray1DB_float & f2
);

void
docking_orient_current_to_start();

void
pose_docking_set_rb_center(
	pose_ns::Pose & pose
);

float
pose_docking_calc_rmsd(
	pose_ns::Pose & pose
);

void
pose_docking_build_simple_tree(
	pose_ns::Pose & pose,
	int const nres,
	int const cutpoint
);

void
pose_minimize_backbone(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map,
	std::string const & min_type
);

void
pose_minimize_sidechain(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map,
	std::string const & min_type
);

void
pose_minimize_torsion(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map,
	std::string const & min_type
);

void
pose_minimize_rigid_body(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map,
	std::string const & min_type
);

void
pose_docking_prepack_protocol(
	pose_ns::Pose & pose
);

void
pose_mininmize_interface(
	pose_ns::Pose & pose,
	const float min_tolerance,
	const pose_ns::Score_weight_map & weight_map,
	const std::string & min_type
);


void
pose_docking_silent_output_setup(
	pose_ns::Pose & pose,
	silent_io::Silent_out & silent_out
);

void
pose_docking_output_silent_structure(
	pose_ns::Pose & pose,
	silent_io::Silent_out & silent_out
);

bool
pose_docking_read_silent_input(
	pose_ns::Pose & pose
);


bool
get_pose_docking_minimize_all();

float
get_dock_mcm_trans_magnitude();

float
get_dock_mcm_rot_magnitude();

void
attach_ligand_to_docking_pose( pose_ns::Pose & docking_pose );

void
pose_docking_set_general_allow_move(
	pose_ns::Pose & pose
);
#endif
