// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.13 $
//  $Date: 2005/05/18 07:35:25 $
//  $Author: mentzer $

// Rosetta Headers
#include "pose_docking_flexible.h"
#include "after_opts.h"
#include "are_they_neighbors.h"
#include "cenlist.h"
#include "dock_structure.h"
#include "dock_loop_ensemble_ns.h"
#include "dock_loops.h"
#include "dock_pivot.h"
#include "docking.h"
#include "docking_constraints.h"
#include "docking_minimize.h"
#include "docking_movement.h"
#include "docking_ns.h"
#include "docking_score.h"
#include "docking_scoring.h"
#include "docking_ns.h"
#include "enzyme.h"
#include "files_paths.h"
#include "fold_loops.h"
#include "fullatom.h"
#include "initialize.h"
#include "input_pdb.h"
#include "interface.h"
#include "jumping_diagnostics.h"
#include "jumping_loops.h"
#include "jumping_refold.h"
#include "jumping_util.h"
#include "ligand.h"
#include "loop_class.h"
#include "loops_ns.h"
#include "loops.h"
#include "make_pdb.h"
#include "monte_carlo.h"
#include "misc.h"
#include "minimize.h"
#include "native.h"
#include "nblist.h"
#include "orient_rms.h"
#include "output_decoy.h"
#include "pack_fwd.h"
#include "param.h"
#include "pose.h"
#include "pose_docking.h"
#include "pose_io.h"
#include "pose_loops.h"
#include "pose_param.h"
#include "pose_vdw.h"
#include "ramachandran.h"
#include "random_numbers.h"
#include "recover.h"
#include "refold.h"
#include "rotamer_trials.h"
#include "runlevel.h"
#include "score.h"
#include "score_ns.h"
#include "smallmove.h"
#include "start.h" //chutmp
#include "status.h"
#include "timer.h"
#include "util_basic.h"
#include "util_vector.h"
#include "vdw.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Da.hh>
#include <ObjexxFCL/FArray3Dp.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/FArray.io.hh>

// Numeric Headers
//#include <numeric/all.fwd.hh>
#include <numeric/xyzVector.hh>

// C++ Headers
#include <cstdlib>
#include <fstream>
#include <iostream>

/////////////////////////////////////////////////////////////////////////////
void
pose_docking_loops_protocol(
	pose_ns::Pose & pose,
	//int const rb_cutpoint,
	pose_ns::Loops & loops
)
{
	using namespace pose_ns;
	using namespace pose_ns::pose_param;

	int const local_debug = { false };

	int const nres( pose.total_residue() );

	// setup a tree
	//pose_docking_setup_dock_loop_tree( pose, nres, rb_cutpoint, loops );
	const Fold_tree & f( pose.fold_tree() );
	int const num_fold_tree_cutpoint( f.get_num_fold_tree_cutpoint() );
	const FArray1D_int & cutpoint_map( f.get_cutpoint_map() );
	if ( local_debug ) pose.dump_pdb("chutmp1.pdb");

	Pose save_fa_pose;
	if ( pose.fullatom() ) {
		save_fa_pose = pose;
		pose.set_fullatom_flag( false );
		if ( local_debug ) pose.dump_pdb("chutmp2.pdb");
	}

	// trimm the loop off
	Pose trimmed_pose;
	trimmed_pose = pose;
	Loops ordered_loops = loops;
	ordered_loops.sequential_order();
	int offset=0;
	for ( Loops::const_iterator it = ordered_loops.begin(),
					it_end = ordered_loops.end();it != it_end; ++it ) {
		trimmed_pose.delete_segment( it->start()-offset, it->stop()-offset );
		offset += it->size();
	}
	pose_update_docking_query( trimmed_pose, pose_param::dock_jump );
	trimmed_pose.set_allow_bb_move( false );
	if ( local_debug ) trimmed_pose.dump_pdb("chutmp3.pdb");

	// perturb rigid-body
	if ( !get_docking_local_refine() )
		pose_docking_perturb_rigid_body( trimmed_pose );
	if ( local_debug ) trimmed_pose.dump_pdb("chutmp4.pdb");

	// centroid mc search
	// score4d w/o chainbreack weight
	Score_weight_map weight_map( score4d );
	if ( ! get_docking_local_refine() )
		pose_docking_centroid_rigid_body_adaptive( trimmed_pose, 10, 50,
			weight_map, 0.7, 5.0 );
  if ( local_debug ) trimmed_pose.dump_pdb("chutmp5.pdb");

	// restore the trimmed loop back to pose
	int last_loop_end = 0;
	int trimmed_seg_begin = 1;
	for ( Loops::const_iterator it=ordered_loops.begin(),
					it_end=ordered_loops.end(); it != it_end; ++it ) {
		//int const seg_size = it->start() - last_loop_end - 1;
		int const seg_size = (it->start()-1) - (last_loop_end+1) + 1;
		int const seg_begin = last_loop_end+1;
		pose.copy_segment( seg_size, trimmed_pose, seg_begin, trimmed_seg_begin);
		trimmed_seg_begin += seg_size;
		last_loop_end = it->stop();
	}
	int const seg_size = nres - last_loop_end - 1;
	int const seg_begin = last_loop_end + 1;
	pose.copy_segment( seg_size, trimmed_pose, seg_begin, trimmed_seg_begin );
	pose_update_docking_query( pose, pose_param::dock_jump );

	pose_loops_random_start( pose, loops );
	if ( local_debug ) pose.dump_pdb("chutmp6.pdb");

	// build the missing loop from scratch in centroid one by one
	pose.set_allow_jump_move( false );
	// score4L with chainbreak weight and cut_weight
	setup_score_weight_map( weight_map, score4L );
	weight_map.set_weight( CHAINBREAK, 1.0 );
	weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );
	FArray1D_float cut_weight( num_fold_tree_cutpoint, 0.0 );
	weight_map.set_1D_weight( CUT_WEIGHT, cut_weight );
	pose.score( weight_map );

	for ( Loops::const_iterator it = loops.begin(), it_end = loops.end();
				it != it_end; ++it ) {
		cut_weight( cutpoint_map(it->cut()) ) = 1.0;
		weight_map.set_1D_weight( CUT_WEIGHT, cut_weight );
		// do centroid build-up only if the loop starts from an extend conformation
		if ( it->is_extended() ) {
			Loops one_loop;
			one_loop.add_loop( it );
			pose_loops_set_allow_bb_move( pose, one_loop );
			std::cout << "perturb one_loop in centroid mode " << "\n" << one_loop;
			pose_perturb_one_loop_with_ccd( pose, weight_map, one_loop );
		}
	}
	if ( local_debug ) pose.dump_pdb("chutmp7.pdb");

	if ( pose.get_0D_score( CHAINBREAK ) > 1.0 ) {
		std::cout << "pose_docking_loops_protocol: loop can not be closed!"
							<< "skip.....\n";
		return;
	}

	// restore the fullatom mode
	if ( save_fa_pose.fullatom() ) {
		pose.set_fullatom_flag( true, false );
		pose.recover_sidechain( save_fa_pose );
		if ( get_enable_ligaa_flag() ) attach_ligand_to_docking_pose( pose ); // IA
		if ( local_debug ) pose.dump_pdb("chutmp8.pdb");
	} else {
		return;
	}

	// repack
	FArray1D_bool docking_repack(nres,false);
	FArray1D_bool loop_repack(nres,false);
	FArray1D_bool allow_repack(nres,false);
	pose_docking_calc_interface( pose, docking_repack );
	pose_loops_select_loop_residues( pose, loops, true/*w/ nbs*/, loop_repack );
	for( int i = 1; i <= nres; ++i ) {
		allow_repack(i) = docking_repack(i) || loop_repack(i);
	}
	pose.repack( allow_repack, true/*include_current*/ );

	if ( local_debug ) pose.dump_pdb("chutmp9.pdb");

	// initialize a fullatom weight_map with cut_weight
	setup_score_weight_map( weight_map, score10d_min );
	weight_map.set_weight( CHAINBREAK, 1.0 );
	weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );
	weight_map.set_1D_weight( CUT_WEIGHT, cut_weight );

	// dampen fa_rep weight
	float rep_weight_max = weight_map.get_weight( FA_REP );
	int rep_ramp_cycles = { 5 };
	float rep_ramp_step = (rep_weight_max - 0.02) / float(rep_ramp_cycles-1);
	bool no_ramp_rep = truefalseoption("no_ramp_rep");
	for ( int i = 1; i <= rep_ramp_cycles; i++ ) {
		if ( ! no_ramp_rep ) {
			float rep_weight = 0.02 + rep_ramp_step * float(i-1);
			std::cout << "rep_ramp_cycle/rep_weight/rep_weight_max: "
								<< i << " / " << rep_weight << " / " << rep_weight_max << std::endl;
			weight_map.set_weight( FA_REP, rep_weight );
		}
		pose.set_allow_jump_move( dock_jump, true );
		pose_docking_monte_carlo_minimize( pose, 8, "dfpmin_atol", weight_map,
			0.1, 5.0, 15.0, 1.0 );
		pose.set_allow_jump_move( dock_jump, false );
		pose_refine_loops_with_ccd( pose, weight_map, loops, 1,
			loops.loop_size(), 1, true, true );
	}

	// minimize with full rep weight
	pose.set_allow_jump_move( dock_jump, true );
	pose_docking_monte_carlo_minimize( pose, 8, "dfpmin_atol", weight_map,
		0.1, 5.0, 15.0, 1.0 );
	pose_docking_minimize_trial( pose, "dfpmin_atol", weight_map, 0.02 );

	scores::chainbreak_score = pose.get_0D_score( CHAINBREAK );

}

///////////////////////////////////////////////////////////////////////////
void
pose_docking_loops_protocol_2(
	pose_ns::Pose & pose,
	pose_ns::Loops & loops
)
{
	using namespace pose_ns;
	int const local_debug = { false };

	int const nres( pose.total_residue() );

	if ( local_debug ) pose.dump_pdb("chutmp1.pdb");

	// trimm the loop off
	Pose trimmed_pose;
	trimmed_pose = pose;
	Loops ordered_loops = loops;
	ordered_loops.sequential_order();
	int offset=0;
	for ( Loops::const_iterator it = ordered_loops.begin(),
					it_end = ordered_loops.end();it != it_end; ++it ) {
		trimmed_pose.delete_segment( it->start()-offset, it->stop()-offset );
		offset += it->size();
	}
	pose_update_docking_query( trimmed_pose, pose_param::dock_jump );
	trimmed_pose.set_allow_bb_move( false );
	if ( local_debug ) trimmed_pose.dump_pdb("chutmp2.pdb");

	pose_docking_standard_protocol( trimmed_pose );

	if ( local_debug ) trimmed_pose.dump_pdb("chutmp3.pdb");

	// restore the trimmed loop back to pose
	int last_loop_end = 0;
	int trimmed_seg_begin = 1;
	for ( Loops::const_iterator it=ordered_loops.begin(),
					it_end=ordered_loops.end(); it != it_end; ++it ) {
		//int const seg_size = it->start() - last_loop_end - 1;
		int const seg_size = (it->start()-1) - (last_loop_end+1) + 1;
		int const seg_begin = last_loop_end+1;
		pose.copy_segment( seg_size, trimmed_pose, seg_begin, trimmed_seg_begin);
		trimmed_seg_begin += seg_size;
		last_loop_end = it->stop();
	}
	int const seg_size = nres - last_loop_end - 1;
	int const seg_begin = last_loop_end + 1;
	pose.copy_segment( seg_size, trimmed_pose, seg_begin, trimmed_seg_begin );
	pose_update_docking_query( pose, pose_param::dock_jump );

	if ( local_debug ) pose.dump_pdb("chutmp4.pdb");

	pose.set_allow_jump_move( false );

	pose_loops_random_start( pose, loops );
	pose_fold_loops_with_ccd( pose, loops );

	if ( local_debug ) pose.dump_pdb("chutmp5.pdb");

	scores::chainbreak_score = pose.get_0D_score( CHAINBREAK );

	pose_docking_repack( pose, true, true );

}
//////////////////////////////////////////////////////////////////////
void
pose_docking_minimize_loop_protocol(
	pose_ns::Pose & pose,
	pose_ns::Loops & loops
)
{
	using namespace pose_ns;
	using namespace docking;

	// set jump_move properly
	pose.set_allow_jump_move( false );
	pose_loops_set_allow_bb_move( pose, loops );
	pose.set_allow_chi_move( true );
	pose_docking_set_general_allow_move( pose );

	Score_weight_map weight_map;

	Pose pose_save;
	pose_save = pose;

	pose.set_fullatom_flag( false );

	if ( ! get_docking_local_refine() ) {
		// perturb
		pose_docking_perturb_rigid_body( pose );
		pose_docking_calc_rmsd( pose );
		docking_store_initial_rms();
		// centroid MC search
		setup_score_weight_map( weight_map, score4d );
		pose_docking_centroid_rigid_body_adaptive( pose, 10/*outer_cycle*/,
			50 /*inner_cycle*/, weight_map, 0.7/*trans_mag*/, 5.0/*rot_mag*/);
	}
	pose_docking_calc_rmsd( pose );
	docking_store_cenmode_rms();

  if ( get_docking_fullatom_flag() ) {
    // fullatom mode
    pose.set_fullatom_flag( true, false );
    // copy back the starting sidechain first
    pose.recover_sidechain( pose_save );
		// set up weight map with loop weight
		setup_score_weight_map( weight_map, score10d );

		// Attach ligand jump. for Capri
		if ( get_enable_ligaa_flag() )
		  attach_ligand_to_docking_pose( pose ); // IA

		const float temperature( 0.8 );
		Monte_carlo mc( pose, weight_map, temperature );

		// repack interface sidechains
    bool const interface_only(true), include_current(true);
    pose_docking_repack( pose, interface_only, include_current );

		// dock_rtmin if requested so
		if ( docking::dock_rtmin ) {
      set_docking_interface_pack( interface_only );
      score_set_try_rotamers( true );
      score_set_minimize_rot( true );
      pose.score( weight_map );
      score_set_minimize_rot( false );
      score_set_try_rotamers( false );
    }
		// this is to prevent accidental score increase after repack+rtmin
		mc.boltzmann( pose );
		pose = mc.low_pose();

		// set up weight_map with loop chainbreak weight
		setup_score_weight_map( weight_map, score10d_min );
		weight_map.set_weight( CHAINBREAK, 1.0 );
		weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );
		const Fold_tree & f( pose.fold_tree() );
		int const num_fold_tree_cutpoint( f.get_num_fold_tree_cutpoint() );
		const FArray1D_int & cutpoint_map( f.get_cutpoint_map() );
		FArray1D_float cut_weight( num_fold_tree_cutpoint, 0.0 );
		for ( Loops::const_iterator it = loops.begin(), it_end = loops.end();
					it != it_end; ++it ) {
			cut_weight( cutpoint_map(it->cut()) ) = 1.0;
		}
		weight_map.set_1D_weight( CUT_WEIGHT, cut_weight );

    if ( get_docking_mcm_flag() ) {
      pose_docking_mcm_protocol( pose, weight_map );
    } else if ( get_docking_minimize_flag() ) {
      pose_docking_minimize_trial( pose, "dfpmin_atol",
        weight_map, 0.02 );
    }
	}
}
/////////////////////////////////////////////////////////////////////////////
// two docking partners with one rigid-body freedom and multiple loops
// note that termini loops are not supported yet and any two loops have to be
// separated by at least one residue.
void
pose_docking_setup_dock_loop_tree(
  pose_ns::Pose & pose,
  int const nres,
  int const rb_cutpoint,
	const pose_ns::Loops & loops
)

{
  using namespace pose_ns;

  int p1_center ( pose.residue_center_of_mass(1, rb_cutpoint) );
  int p2_center ( pose.residue_center_of_mass(rb_cutpoint+1, nres) );
  // make sure rb jumps do not reside in the loop region
	for( Loops::const_iterator it= loops.begin(), it_end=loops.end();
			 it != it_end; ++it ) {
		if ( docking::dle_loops_flag &&
				 dle_ns::simultaneous_minimization ) {
			if ( p1_center >= ( it->start() - 1 ) && p1_center <= ( it->stop() + 1) )
				p1_center = it->stop() + 2;
			if ( p2_center >= ( it->start() - 1 ) && p2_center <= ( it->stop() + 1) )
				p2_center = it->start() - 2;
		}
		else { // default
			if ( p1_center >= it->start() && p1_center <= it->stop())
				p1_center = it->start()-1;
			if ( p2_center >= it->start() && p2_center <= it->stop())
				p2_center = it->start() - 1;
		}
	}
  // make a simple rigid-body jump first
  pose.one_jump_tree( nres, p1_center, p2_center, rb_cutpoint );
  // add the loop jump into the current tree, delete some old edge accordingly
  Fold_tree f( pose.fold_tree() );

	for( Loops::const_iterator it=loops.begin(), it_end=loops.end();
			 it != it_end; ++it ) {
		int const loop_start ( it->start() );
		int const loop_stop ( it->stop() );
		int const loop_cutpoint ( it->cut() );
		int edge_start(0), edge_stop(0);
		bool edge_found = false;
		int const num_jump = f.get_num_jump();
		for( Fold_tree::const_iterator it2=f.begin(), it2_end=f.end();
			 it2 !=it2_end; ++it2) {
			edge_start = min( it2->start, it2->stop );
			edge_stop = max( it2->start, it2->stop );
			if ( ! it2->is_jump() && loop_start>edge_start && loop_stop<edge_stop )
				{ edge_found = true; goto L100; }
		}
	L100:
		f.delete_unordered_edge( edge_start, edge_stop, pose_param::PEPTIDE);
		f.add_edge( loop_start-1, loop_stop+1, num_jump+1 );
		f.add_edge( edge_start, loop_start-1, pose_param::PEPTIDE );
		f.add_edge( loop_start-1, loop_cutpoint, pose_param::PEPTIDE );
		f.add_edge( loop_cutpoint+1, loop_stop+1, pose_param::PEPTIDE );
		f.add_edge( loop_stop+1, edge_stop, pose_param::PEPTIDE );
	}
	assert( f.get_num_jump() == loops.num_loop() + 1 ); //

  f.reorder(1);
  pose.set_fold_tree(f);

  pose.set_allow_jump_move(1, true); //rigid-body jump
	for ( int i = 2; i<= f.get_num_jump(); ++i ) {
		pose.set_allow_jump_move(i, false); // loop jump
	}
	std::cout << "pose_docking_setup_dock_loop_tree:\n" << pose.fold_tree();
}
///////////////////////////////////////////////////////////////////////////////
void
pose_docking_calc_interf_energy(
	pose_ns::Pose & pose,
	const pose_ns::Loops & loops
)
{
	using namespace pose_ns;
	using namespace pose_ns::pose_param;

  using namespace scores;
	Score_weight_map weight_map( scorefxn );

	Pose trimmed_pose;
	trimmed_pose = pose;

	float score_complex = trimmed_pose.score( weight_map );

	Score_state dummy_score_state;
  float elec_complex = trimmed_pose.get_0D_score( FA_ELEC, dummy_score_state );

	//trimmed_pose.dump_pdb("chutmp1.pdb");

	if ( loops.num_loop() > 0 ) {
		std::cout << "interface energy for docking models with flexible loops\n";
		Loops ordered_loops = loops;
		ordered_loops.sequential_order();
		int offset=0;
		for ( Loops::const_iterator it = ordered_loops.begin(),
						it_end = ordered_loops.end();it != it_end; ++it ) {
			trimmed_pose.delete_segment( it->start()-offset, it->stop()-offset );
			offset += it->size();
		}
		pose_update_docking_query( trimmed_pose, dock_jump );
		trimmed_pose.set_allow_bb_move( false );
		trimmed_pose.reset_score_data();
		//trimmed_pose.dump_pdb("chutmp2.pdb");
	}

	pose_ns::Jump perturbed_jump( trimmed_pose.get_jump( dock_jump ) );
	int const pos1( trimmed_pose.fold_tree().get_jump_point()(1, dock_jump) );
	int const pos2( trimmed_pose.fold_tree().get_jump_point()(2, dock_jump) );
	const FArray3D_float & Epos( trimmed_pose.Eposition() );
	numeric::xyzVector_double trans_axis (
		numeric::xyzVector_double( &Epos(1,2,pos2) ) -
		numeric::xyzVector_double( &Epos(1,2,pos1) ) );

	float const step_size = 499.0;
	perturbed_jump.translation_along_axis(Epos(1,1,pos1), trans_axis, step_size);
	trimmed_pose.set_jump( dock_jump, perturbed_jump );
  float score_apart = trimmed_pose.score( weight_map );

	float elec_apart = trimmed_pose.get_0D_score( FA_ELEC, dummy_score_state );
	if ( get_simple_elec() && (dummy_score_state == GOOD) ) {
		fa_d_elec_score = elec_complex - elec_apart;
		pose.set_0D_score( DOCK_ELEC, fa_d_elec_score );
	}
	//trimmed_pose.dump_pdb("chutmp3.pdb");

	if ( loops.num_loop() > 0 ) {
		pose_update_docking_query( pose, dock_jump );
	}

	docking::docking_interf_energy = score_complex - score_apart;

	std::cout << "pose_docking_calc_interface_energy complex/apart/diff: "
						<< score_complex <<  "/" << score_apart << "/"
						<< docking::docking_interf_energy << std::endl;

	return;
}
///////////////////////////////////////////////////////////////////////////////
void
pose_update_docking_query(
	pose_ns::Pose const & pose,
	int const dock_jump
)
{
	const pose_ns::Fold_tree & f( pose.fold_tree() );
	if( docking::n_monomers != 2 ) {
		std::cout << "ERROR: only works for two-body docking now !!" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	docking::part_begin(1) = 1;
	docking::part_end(1) = f.get_jump_edge_count()(dock_jump);
	docking::part_begin(2) = docking::part_end(1) + 1;
	docking::part_end(2) = pose.total_residue();

}

//////////////////////////////////////////////////////////////////////////////
void
pose_docking_hinge_protocol(
	pose_ns::Pose & pose
)
{
	using namespace pose_ns;

	int const hinge_start = intafteroption( "hinge_start" );
	int const hinge_end = intafteroption( "hinge_end" );
	bool const fix_rigid_body =  truefalseoption( "fix_rigid_body" );

	Score_weight_map weight_map;

	// set allow_move
	pose.set_allow_jump_move( ! fix_rigid_body );
	pose.set_allow_bb_move( false );
	for (int i=hinge_start; i<=hinge_end; ++i) {
		pose.set_allow_bb_move( i, true);
	}
	pose.set_allow_chi_move( true );

	Pose pose_save;
	pose_save = pose;

	pose.set_fullatom_flag( false );
	if ( ! get_docking_local_refine() ) {
		// perturb
		float helix_size, strand_size, other_size;
		real3afteroption("hinge_pert",0.0, helix_size, 25.0, strand_size,
			30.0, other_size);
		//pose_docking_perturb_hinge_region( pose, hinge_start, hinge_end,
		//	helix_size, strand_size, other_size );
		set_smallmove_size( helix_size, strand_size, other_size );
		pose_small_moves( pose, hinge_end-hinge_start+1 );
		pose_docking_perturb_rigid_body( pose );
		pose_docking_calc_rmsd( pose );
		docking_store_initial_rms();
		// centroid MC search
		setup_score_weight_map( weight_map, score4d );
		set_smallmove_size(0.0, 15.0, 18.0 );
		int const cycles( 1000 );
		float const trans_mag( 0.7 ), rot_mag( 5.0 );
		pose_docking_hinge_move_trial( pose, cycles, weight_map, trans_mag,
			rot_mag );
		pose_docking_calc_rmsd( pose );
		docking_store_cenmode_rms();
	}
	// fullatom mode
	pose.set_fullatom_flag( true, false );
	// copy back the starting sidechain first
	pose.recover_sidechain( pose_save );
	// fullatom scorefxn
	setup_score_weight_map( weight_map, score10d );
	// repack
	FArray1D_bool allow_repack( pose.total_residue(), false );
	bool const include_current = true;
	pose_docking_calc_interface( pose, allow_repack );
	pose.repack( allow_repack, include_current );
	pose.score( weight_map );

	if ( truefalseoption("use_score10d_min") ) {
		setup_score_weight_map( weight_map, score10d_min );
	}
	pose_docking_hinge_mcm_trial( pose, weight_map );
}
///////////////////////////////////////////////////////////////////////////////
void
pose_docking_hinge_mcm_trial(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & weight_map
)
{
	using namespace pose_ns;

	bool const separate = truefalseoption( "minimize_separately" );
	// params
	minimize_set_func( 2 );
	minimize_set_tolerance( 0.05 );
	set_smallmove_size(0.0, 5.0, 6.0 );
	float const trans_mag( 0.1 );
	float const rot_mag( 5.0 );
	int const outer_cycles = min(10, pose.get_total_insert() );
	int const inner_cycles = 10;
	float const init_temp = { 1.5 };
	float const last_temp = { 0.5 };
	float const gamma =
		std::pow( last_temp/init_temp, 1.0f/(outer_cycles*inner_cycles) );
	int n_trial(0), small_accepted(0), shear_accepted(0), jump_accepted(0);
	float temperature( init_temp );
	// mc obj
	Monte_carlo mc( pose, weight_map, init_temp );

	for ( int i = 1; i <= outer_cycles; ++i ) {
		int nmoves = static_cast<int>(outer_cycles/i);
		for ( int j = 1; j <= inner_cycles; ++j ) {
			temperature *= gamma;
			mc.set_temperature( temperature );
			n_trial++;;
			// small min trial
			pose_small_moves( pose, nmoves );
			if ( separate ) {
				pose_minimize_torsion( pose, weight_map, "dfpmin_atol" );
			} else {
				pose.main_minimize( weight_map, "dfpmin_atol" );
			}
			if( mc.boltzmann( pose ) ) { small_accepted++; }
			// shear min trial
			pose_shear_moves( pose, nmoves );
			if ( separate ) {
				pose_minimize_torsion( pose, weight_map, "dfpmin_atol" );
			} else {
				pose.main_minimize( weight_map, "dfpmin_atol" );
			}
			if( mc.boltzmann( pose ) ) { shear_accepted++; }
			// jump min trial
			if ( pose.get_allow_jump_move( pose_param::dock_jump ) ) {
				pose_docking_set_rb_center( pose );
				pose_docking_gaussian_rigid_body_move( pose, 1/*jump*/, trans_mag, rot_mag );
				if ( separate ) {
					pose_minimize_rigid_body( pose, weight_map, "dfpmin_atol" );
				} else {
					pose.main_minimize( weight_map, "dfpmin_atol" );
				}
				if ( mc.boltzmann( pose ) ) { jump_accepted++; }
			}
		} // inner cycle
		// repack every outer_cycle
		FArray1D_bool allow_repack( pose.total_residue(), false );
		pose_docking_calc_interface( pose, allow_repack );
		pose.repack( allow_repack );
		pose.score( weight_map );
		mc.boltzmann( pose );

		std::cout << "Cycle: " << i << " -- ";
		mc.show_scores();
		pose = mc.low_pose();
	} // outer cycle

	std::cout << "pose_docking_hinge_protocol -- trial/accepted/ratio:\n"
						<< small_accepted << "/" << n_trial << "/"
						<< float(small_accepted)/float(n_trial) << " for small moves\n"
						<< shear_accepted << "/" << n_trial << "/"
						<< float(shear_accepted)/float(n_trial) << " for shear moves\n"
						<< jump_accepted  << "/" << n_trial << "/"
						<< float(jump_accepted) /float(n_trial) << " for jump  moves\n"
						<< std::endl;
}
//////////////////////////////////////////////////////////////////////////////
float
pose_docking_hinge_move_trial(
	pose_ns::Pose & pose,
	int const cycles,
	const pose_ns::Score_weight_map & wt_map,
	float trans_mag,
	float rot_mag
)
{
	using namespace pose_ns;

	float const temperature( 0.8 );
	int const nmoves = static_cast<int> ( pose.get_total_insert() * 0.5 );
	Monte_carlo mc( pose, wt_map, temperature );
	int n_accepted = 0;

	for( int i = 1; i <= cycles; ++i ) {
		if ( ran3()>=0.5 || ! pose.get_allow_jump_move( pose_param::dock_jump ) ) {
			pose_small_moves( pose, nmoves );
		}	else {
			pose_docking_gaussian_rigid_body_move( pose, 1/*jump*/, trans_mag, rot_mag );
		}
		pose.score( wt_map );
		if( mc.boltzmann( pose ) ) ++n_accepted;
	}
	pose = mc.low_pose();

	std::cout << "pose_docking_hinge_move_trial -- "
						<< n_accepted << " out of " << cycles << " accepted\n";

	return n_accepted / cycles;
}

//////////////////////////////////////////////////////////////////////////////
void
pose_docking_perturb_hinge_region(
	pose_ns::Pose & pose,
	int const hinge_start,
	int const hinge_end,
	float const helix_size,
	float const strand_size,
	float const other_size
)
{
	// retreive info from pose
	FArray1D_char  const & secstruct( pose.secstruct() );

	// local variable
	float small_angle, big_angle; //move magnitude
	float phi_tmp, psi_tmp; // new phi/psi

	for ( int j = hinge_start ; j <= hinge_end; ++j ) {

		if ( !pose.get_allow_bb_move(j) ) continue; // fixed position, next

		if ( secstruct(j) == 'H' ) {
			big_angle = helix_size;
		} else if ( secstruct(j) == 'E' ) {
			big_angle = strand_size;
		} else {
			big_angle = other_size;
		}
		small_angle = big_angle/2.0;

		// new angles after moves
		phi_tmp = periodic_range( pose.phi(j)-small_angle+ran3()*big_angle, 360.0f );
		psi_tmp = periodic_range( pose.psi(j)-small_angle+ran3()*big_angle, 360.0f );

		// make moves and store this position
		pose.set_phi( j, phi_tmp );
		pose.set_psi( j, psi_tmp );
		pose.set_name( j, "-PT-" );
	}
}
//////////////////////////////////////////////////////////////////////
