// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7212 $
//  $Date: 2006-01-04 07:49:01 -0800 (Wed, 04 Jan 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_pose_ligand
#define INCLUDED_pose_ligand

//#include "pose_fwd.h"
#include "ligand_ns.h"
#include <ObjexxFCL/ObjexxFCL.hh>
#include<utility/vector0.hh>
//////////////////////////////////
//lin  the enable_ligand_aa handles setup ligand as a new type of amino acid
//lin  otherwise, ligand design and energy share the same functions as protein
//

namespace enable_ligaa_ns {

	namespace ligaa_atomEarrays {
		extern FArray2D_float ligaa_atrE;
		extern FArray2D_float ligaa_repE;
		extern FArray2D_float ligaa_solE;
		extern FArray2D_float ligaa_hbE;
		extern FArray2D_float ligaa_sasa5;
		extern FArray2D_float ligaa_sasa14;
		extern FArray2D_float ligaa_sasa_pack;
		//the first three atom coordinates should be used to superimpose
		// the ligand rotamers to the current cartesian placement
		// in the setup of the ligand object as a residue the
		// get_base_atom function chooses the first three atoms
// 		extern FArray1D_float ligaa_pairE;
// 		extern FArray1D_float ligaa_intraE;
// 		extern FArray1D_float ligaa_gbE;
// 		extern FArray1D_float ligaa_cstE;
// 		extern FArray1D_float ligaa_h2oE;

	}
	using namespace ligaa_atomEarrays;
	inline Dimension & MAX_LIGAA() { static Dimension d; return d; }
	extern int const MAX_LIGAND_ROTAMERS;
	extern int const MAX_LIGAND_CHI;
	extern FArray5D_float ligand_cartesian_rotamers;
	extern FArray4D_float ligand_rotamer_chi_angles;
	extern FArray2D_int nligandrotamers;
	extern FArray2D< Ligand * > ligand_ptr_array;
	extern FArray3D< size_t > ligaa_ligand_atom_map;
	extern FArray2D< utility::vector0< int > > ligand_ligaa_atom_map;
	extern FArray2D_int ligand_nchi;
	extern FArray4D_int ligand_chi_atoms;
	extern FArray4D_bool ligand_chi_required;
	extern FArray3D_int ligand_length_chi_rigid_atom_list;
	extern FArray4D_int ligand_chi_rigid_atom_list;
	extern FArray3D_float lig_icoord;
	extern FArray2D_float lig_iocc_weight;
	extern FArray2D_float lig_icharge;

  FArray2Da_float
  get_ligaa_icoord(int const LG);

  FArray1Da_float
  get_ligaa_iocc_weight(int const LG);

  FArray1Da_float
  get_ligaa_icharge(int const LG);

	void read_ligand( std::string const & filename );

  void read_ligand( utility::io::irstream & iunit );

	void fill_ligaa_repEarray(
					 int const atom,
					 int const aa,
					 float const repE
					 );

	void fill_ligaa_hbEarray(
					 int const atom1,
					 int const aa1,
					 bool const atom1_is_sc,
					 int const atom2,
					 int const aa2,
					 bool const atom2_is_sc,
					 float const hbE
					 );

	void fill_ligaa_pairEarrays(
					 int const atom,
					 int const aa,
					 float const solE,
					 float const atrE,
					 float const repE
					 );
	void fill_ligaa_sasa_arrays(
					 int const atom,
					 int const aa,
					 float const sasa14,
					 float const sasa5,
					 float const sasa_pack
					 );

}//end namespace enable_ligaa_ns

void
ligand_docking_function(
);

int
ligand_docking_protocol1(
	pose_ns::Pose & pose,
	std::string const filename
);

float
pose_ligand_docking_rigid_body_trial(
	pose_ns::Pose & pose,
	int const cycles,
	const pose_ns::Score_weight_map & wt_map,
	float const trans_mag,
	float const rot_mag,
	float const perturb_ligand_trans,
	float const perturb_ligand_rot
);

int
find_nearest_res(
	const pose_ns::Pose & pose,
	const numeric::xyzVector_float point
);

int
repack_for_ligand(
	pose_ns::Pose & pose,
	float translation,
	float rotation
);

FArray3D_float
small_dock_perturbation_pose_ligand(
	int const aa,
	int const aav,
	float const max_translation,
	float const max_rotation,
	FArray2D_float & input_conformation,
	int & nconformations
);

FArray2D_float
change_conformation_to_rotamer(
	int const conf,
	FArray2D_float & coord,
	int const aa,
	int const aav
);

FArray1D_int
create_rotid(
	int const rot_integer
);

int
create_int_from_rotid(
	FArray1D_int rotid
);

void
load_conformation_into_FArray3D_float(
	FArray2D_float & coord,
	int const conf,
	int const rotid,
	int const aa,
	int const aav,
	FArray3D_float & conf_lib
);

FArray2D_float
load_conformation_from_FArray3D_float(
	FArray3D_float & conf_lib,
	int const conf,
	int const aa,
	int const aav
);

FArray2D_float
rotate_translate_conformation(
	FArray2D_float & input_conformation,
	int const aa,
	int const aav,
	float const max_rotation,
	float const max_translation
);

FArray1D_float
get_current_chi(
	FArray2D_float input_conformation,
	int const aa,
	int const aav
);



void
setup_ligand_aa(
	int const aa,
	int const aav,
	Ligand & ligand,
	FArray2D_float & coords
);


#endif
