// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:

//  CVS information:
//  $Revision: 15327 $
//  $Date: 2007-06-05 07:58:57 -0700 (Tue, 05 Jun 2007) $
//  $Author: sarel $

// /////////////////////////////////////////////////////////////////////////////////////
// @pose_looping.cc
//
// @brief
// Routine to create a loop using pose
//
// @detailed:
// To use this mode, enter -pose_looping, -loop_name {name of loop file}
// For loop mode, loop_name is a file that contains gap_begin, gap_end,
// loop_begin, and loop_end, which are the insertion points for the loop
// If you do not want to define gap_begin and gap_end, set the value to 0 in
// the input file
//
// @authors: Monica Berrondo
//
// @last_modified: March 21 2006
// /////////////////////////////////////////////////////////////////////////////////////

#ifndef INCLUDED_pose_looping
#define INCLUDED_pose_looping

#include "pose_fwd.h"

#include <vector>
#include <map>
#include <list>
#include <string>
#include <utility>

void
looping_main();

void
build_insertion_loop(
	pose_ns::Pose & pose,
	const int max_loop_size,
	const int min_good_loops,
	const int min_loop_begin,
	const int min_loop_end,
	const int iter
);

void
insert_loop(
	pose_ns::Pose & pose,
	const int loop_begin,
	const int loop_end,
	const int iter
);

void
one_loop_build_fragment(
				const int frag_size,
				pose_ns::Pose & pose,
				const int loop_begin,
				const int loop_end,
				const int frag_offset
);

void
get_loop_parameters(
				std::map<std::string, std::string> & params,
				std::string filename
);
#endif
