// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $


// Rosetta Headers
#include "pose_rna_fragments.h"
#include "aaproperties_pack.h"
#include "after_opts.h"
#include "dna.h"
#include "dna_ns.h"
#include "files_paths.h"
#include "fullatom_energies.h"
#include "gunn.h"
#include "hbonds_ns.h"
#include "jumping_loops.h"
#include "kin_stub.h"
#include "minimize.h"
#include "misc.h" //To use sequence conversion, etc.
#include "nblist.h"
#include "pack_fwd.h"
#include "param.h"
#include "param_aa.h"
#include "pose.h"
#include "pose_io.h"
#include "pose_rms.h"
#include "pose_rna.h" //for initialize_query_rna.
#include "pose_rna_ns.h" //for NUM_EDGES ( 3 )
#include "pose_rna_pdbstats.h" //for read in decoys.
#include "pose_constraints.h"
#include "pose_design.h"
#include "pose_rna_fragments_classes.h"
#include "pose_vdw.h"
#include "read_aaproperties.h"
#include "read_aa_ss.h" //for read_fasta
#include "random_numbers.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/StaticIndexRange.hh>
#include <ObjexxFCL/formatted.i.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
#include <numeric/constants.hh>
#include <numeric/xyz.functions.hh>
#include <numeric/xyzVector.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <fstream>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/file/file_sys_util.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>

/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
//
// A lot of the following will be deprecated soon, after I put together a class.
// This will allow for much more efficient use of memory and more versatile
// ab initio runs in which fragment size -- or sequence specificity -- can be
// changed during the run.
//
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////

// alpha,beta,gamma,delta,epsilon,zeta, AND chi AND a couple "nu"s (of sugar).
//int const NUM_RNA_TORSIONS = param_torsion::total_rna_torsion; hmmmm...
int const NUM_RNA_TORSIONS = 9;
int const TEMP_MAX_DEPTH = 1000;
int const MAX_VALL_SIZE = 3000; // Ribosome and others...

///////////////////////////////////////////////////////////////////////////////
// may want to attach a weight to each fragment, so that we can, e.g.,
// easily downweight fragments with too much Watson-Crick helix.
namespace rna_fragments{
	int FRAG_SIZE = 3;
	FArray4D_float align_torsions_3 ( SRange(0, NUM_RNA_TORSIONS), param::MAX_RES(), TEMP_MAX_DEPTH, SRange(0, 3), 0.0 );
	FArray1D_int align_depth( param::MAX_RES(), 0 ); // Make this an array.

	int nres_fragments( 0 );
}

namespace rna_gunn{
	//	bool init_rna_gunn = { false }; //this led to lots of problems, though I don't understand why.
	//Storage of Gunn parameters for smooth fragment insertions.
	FArray2D_float q1( MAX_VALL_SIZE, TEMP_MAX_DEPTH );
	FArray2D_float q2( MAX_VALL_SIZE, TEMP_MAX_DEPTH );
	FArray2D_float q3( MAX_VALL_SIZE, TEMP_MAX_DEPTH );
	FArray2D_float q4( MAX_VALL_SIZE, TEMP_MAX_DEPTH );
	FArray2D_float q5( MAX_VALL_SIZE, TEMP_MAX_DEPTH );
	FArray2D_float q6( MAX_VALL_SIZE, TEMP_MAX_DEPTH );
}

namespace rna_vall{
	//	FArray3D_float align_torsions_3 ( SRange(0, NUM_RNA_TORSIONS), MAX_NEIGH(), SRange(0, 3), 0.0 );
	FArray2D_float vall_torsions ( SRange(0, NUM_RNA_TORSIONS), MAX_VALL_SIZE, 0.0 );
	FArray1D_int   vall_sequence ( MAX_VALL_SIZE, 0 );
	FArray1D_bool  vall_is_chainbreak ( MAX_VALL_SIZE, false );
	FArray2D_bool  vall_edge_is_base_pairing( MAX_VALL_SIZE, rna_scoring::NUM_EDGES );
	int vall_size;
}


///////////////////////////////////////////////////////////////////////////////
// A vall from the ribosome.
void
readin_rna_vall( pose_ns::Pose & pose ){

	using namespace rna_vall;
	using namespace numeric;

	int const total_residue = pose.total_residue();

	float const chainbreak_cutoff ( 7.5 * 7.5 );

	int count = 0;
	for (int i = 1; i <= total_residue; i++) {

		if ( !pose.is_RNA(i) ) continue;

		count++;

		for (int j = 1; j <= NUM_RNA_TORSIONS; j++) {
			vall_torsions( j , count ) =
				pose.get_torsion_by_number( i, j );
		} //torsions

		vall_sequence( count ) = pose.res( i ); // RNA numbering 26-29
		assert( param_aa::is_RNA(  pose.res( i )));


		//Check for chainbreak:
		vall_is_chainbreak( count ) = false;
		if (i < total_residue){
			xyzVector_float P1 = pose.full_coord( rna_variables::c4star, i   );
			xyzVector_float P2 = pose.full_coord( rna_variables::c4star, i+1 );
			if ((P1-P2).length_squared() > chainbreak_cutoff){
				std::cout << " CHAINBREAK? " << i << " " << "  dist to next residue " << (P1-P2).length() << std::endl;
				vall_is_chainbreak( count ) = true;
			}
		} // chainbreak check

	} //fill vall


	vall_size = count;
	std::cout << " VALL_SIZE " << vall_size << std::endl;

	//Need to know which parts might be base paired.
	float rna_bs_score, rna_bp_w_score, rna_bp_h_score,
		rna_bp_s_score, rna_axis_score, rna_stagger_score, rna_bulge_score,
		rna_contact_score, rna_long_range_contact_score;
	FArray2D_bool scored_base_pair( vall_size, vall_size );
	eval_rna_score( pose, rna_bs_score, rna_bp_w_score, rna_bp_h_score,
									rna_bp_s_score, rna_axis_score, rna_stagger_score, rna_bulge_score,
									rna_contact_score, rna_long_range_contact_score,
									scored_base_pair, vall_edge_is_base_pairing);

}


void
writeout_vall_torsions( utility::io::ozstream & frag_out ){

	using namespace rna_vall;

	for (int count = 1; count <= vall_size; count++ ){
		frag_out << param_aa::aa_name1( vall_sequence(count) ) ;

		for (int i = 1; i <= NUM_RNA_TORSIONS; i++ ) {
			frag_out << ' ' << F( 8, 3, vall_torsions( i, count ) );
		}

		//		frag_out << ' ' << vall_is_chainbreak( count );
		frag_out << ' ' << '0';

		for (int i = 1; i <= rna_scoring::NUM_EDGES; i++ ) {
			frag_out <<  ' ' << vall_edge_is_base_pairing( count, i );
		}

		frag_out << std::endl;

	}

}

///////////////////////////////////////////////////////////////////////////////
bool pur_pyr_comp( int const res1, int const res2 ){
	using namespace param_aa;
	if ( (res1 == na_rad || res1 == na_rgu) &&  (res2 == na_rgu || res2 == na_rad)) return true;
	if ( (res1 == na_rcy || res1 == na_ura) &&  (res2 == na_ura || res2 == na_rcy)) return true;
	return false;
}


///////////////////////////////////////////////////////////////////////////////
bool comp_rna_sequence( int const res1, int const res2 ){
	static bool const match_all = truefalseoption("match_all");
	static bool const match_YR  = truefalseoption("match_YR");

	if (match_all) return true; //everything matches.
	if (match_YR) return pur_pyr_comp( res1, res2);

	// else look for exact matches.
	return (res1 == res2 );
}


///////////////////////////////////////////////////////////////////////////////
bool
too_much_watson_crick( int const k, int const frag_size)
{
	using namespace rna_vall;

	static float const watson_crick_reweight = realafteroption("watson_crick_reweight", 1.0f);

	float weight( 1.0f );

	for (int pos = k; pos <= k + frag_size - 1; pos++){
		if (vall_edge_is_base_pairing(k, 1 /*WATSON-CRICK*/)) weight *= watson_crick_reweight;
	}

	//	std::cout << "WEIGHT: " << k << " " <<  weight << " " <<
	//		vall_edge_is_base_pairing(k,1) << " " <<
	//		vall_edge_is_base_pairing(k,2) << " " <<
	//		vall_edge_is_base_pairing(k,3) << std::endl;

	if ( ran3() > weight ) return true; //Too much watson-crick!

	return false;
}

///////////////////////////////////////////////////////////////////////////////
// generate rna fragments
void
pick_rna_fragments( int const total_residue, FArray1D_int const & res ){

	using namespace rna_fragments;
	using namespace rna_vall;

	intafteroption( "frag_size", 3, FRAG_SIZE );

	//	align_depth = total_residue - FRAG_SIZE;

	//Clear this out.
	align_depth = 0;

	//This is not very efficient... but a more realistic loop doing
	// profile-profile matching will take just as long.
	for (int i = 1; i <= total_residue - FRAG_SIZE + 1; i++) {

		for (int k = 1; k <= vall_size - FRAG_SIZE + 1; k++ ){

			bool fragment_matches = true;
			for (int res_offset = 1; res_offset <= FRAG_SIZE; res_offset++){
				if ( vall_is_chainbreak( k - 1 + res_offset) ||
						 !comp_rna_sequence( vall_sequence( k - 1 + res_offset ),
																 res( i - 1 + res_offset )) ){
					fragment_matches = false;
					break;
				}
			} // fragment_matches check

			if (!fragment_matches) continue;

			//			std::cout << " FOUND A MATCH" << std::endl;

			// Following will randomly reject the fragment if
			// all the bases are involved in watson-crick interactions.
			// Instead of randomly rejecting, it would probably better to
			// save all fragments along with
			// this information on base pairing in the fragment file.
			// Then we could reweight the probability of each fragment "on the fly".
			if (too_much_watson_crick(k, FRAG_SIZE)) continue;

			int count = ++align_depth(i);
			for (int res_offset = 1; res_offset <= FRAG_SIZE; res_offset++){
				for (int j = 1; j <= NUM_RNA_TORSIONS; j++) {
					 align_torsions_3( j , i, count, res_offset ) =
						 vall_torsions( j, k - 1 + res_offset);
					 //					 std::cout << " TORSION " << j << " " << i << " " << count << " " << res_offset  << " "<<  align_torsions_3( j , i, count, res_offset ) <<   std::endl;
				}
			} //fill fragment

		} // search through vall.

	}//Each RNA position

	for (int i = 1; i <= total_residue - FRAG_SIZE; i++) {
		std::cout << " ALIGN_DEPTH at pos " << param_aa::aa_name1(res(i)) << i << " :  " << align_depth(i) << std::endl;
	}

}

//////////////////////////////////////////////////////////////
void
pick_rna_fragments( pose_ns::Pose & pose )
{
	int const total_residue = pose.total_residue();
	FArray1D_int res(total_residue);
	for (int i = 1; i <= total_residue; i++)
		res(i) = pose.res(i);
	pick_rna_fragments( total_residue, res );
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// Smooth moves!
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void set_Epos_for_RNA( FArray3D_float & Epos, pose_ns::Pose & pose, int const position )
{
	using namespace rna_fragments;
	static float const length	= FRAG_SIZE;
	static int const offset = position - 1;

	FArray3D_float const & full_coord_RNA( pose.full_coord() );
	for (int k = 1; k <= 3; k++ ){
		for (int m = 1; m <= length; m++){
			Epos( k, 1, m) = full_coord_RNA( k, 1 , m + offset); // P   is the "N"
			Epos( k, 2, m) = full_coord_RNA( k, 5 , m + offset); // C3* is the "CA"
			Epos( k, 4, m) = full_coord_RNA( k, 8 , m + offset); // C1* is the "C"
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
void
rna_precompute_frag_movement( pose_ns::Pose & pose )
{
	using namespace rna_fragments;
	using namespace rna_gunn;

	//silly MAX_RES issue:
	pose.copy_to_misc(); //initialize phi,psi,etc. properly.

	static bool init_rna_gunn = false;
	if ( init_rna_gunn ) return; // already initialized
	init_rna_gunn = true;

	static int const length = FRAG_SIZE; //Could generalize to more lengths, of course.
	//	static int const size_bin = 1; //Could have more than one sizebin, too.

	pose_ns::Pose mini_scratch_pose;
	mini_scratch_pose.simple_fold_tree( length + 2 );
	for (int i=1; i<= mini_scratch_pose.total_residue(); ++i ) {
		mini_scratch_pose.set_res( i, 29 ); //uracil. doesn't matter.
		mini_scratch_pose.set_allow_bb_move( i, true );
		mini_scratch_pose.set_allow_chi_move( i, true );
	}
	make_ideal_rna_fullcoord( mini_scratch_pose );

	std::cout << "pre-computing chuck/gunn move set for frag length " << length <<
	 std::endl;

	int const position( 2 ); //To avoid edge artefacts.
	float q1f,q2f,q3f,q4f,q5f,q6f;
	for ( int i = 1; i <= nres_fragments - length + 1; ++i ) {
		for ( int j = 1; j <= align_depth(i); ++j ) {
			insert_fragment_old( mini_scratch_pose, position, j);

			mini_scratch_pose.copy_to_misc(); //Force a refold.

			FArray3D_float Epos( 3, param::MAX_POS, length );
			set_Epos_for_RNA( Epos, mini_scratch_pose, position );
			gunn(1, length, Epos(1,1,1), q1f,q2f,q3f,q4f,q5f,q6f);
			q1(i,j)=q1f;
			q2(i,j)=q2f;
			q3(i,j)=q3f;
			q4(i,j)=q4f;
			q5(i,j)=q5f;
			q6(i,j)=q6f;
		} // j,  next frag  at same residue position
	} // i ,  next residue insertion window

	pose.copy_to_misc(); //Just in case.

}

///////////////////////////////////////////////////////////////////////////////
void
compare_gunn_RNA( int const i, pose_ns::Pose & pose, FArray1D_float & cost ){
	using namespace rna_fragments;
	using namespace rna_gunn;
	using namespace numeric::constants::f;

	rna_precompute_frag_movement( pose ); //returns if already init.

	float d3,d4,d5;
	float q1p,q2p,q3p,q4p,q5p,q6p,c1,c2,c3,c4;

	//These are taken from proteins. Hmm.
	c1 = 2.035;
	c2 = 0.346;
	c3 = 5.72;
	c4 = 3.84;

//  compute gunn variables for current protein structure
	int const length = FRAG_SIZE;

	FArray3D_float Epos( 3, param::MAX_POS, length, 0.0 );
	set_Epos_for_RNA( Epos, pose, i );
	gunn(1, length, Epos(1,1,1), q1p,q2p,q3p,q4p,q5p,q6p);

// 	//	FArray2D_float q1f(nres_fragments, TEMP_MAX_DEPTH, 0.0),q2f(nres_fragments, TEMP_MAX_DEPTH, 0.0),q3f(nres_fragments, TEMP_MAX_DEPTH, 0.0),q4f(nres_fragments, TEMP_MAX_DEPTH, 0.0),q5f(nres_fragments, TEMP_MAX_DEPTH, 0.0),q6f(nres_fragments, TEMP_MAX_DEPTH, 0.0);

//  compute gunn variables for all frags
// [stolen from gunn.cc, the protein routine, too]
// Got rid of the linear indexing stuff -- was causing some memory problem that I couldn't track down.
	for ( int j = 1; j <= align_depth( i ); j++ ) {
		d3 = std::abs(q3(i,j)-q3p);
		if ( d3 > pi_over_2 ) d3 = pi - d3;
		d4 = std::abs(q4(i,j)-q4p);
		if ( d4 > pi_over_2 ) d4 = pi - d4;
		d5 = std::abs(q5(i,j)-q5p);
		if ( d5 > pi_over_2 ) d5 = pi - d5;

		cost(j) = 2.92 +
		 c3 * std::log( 1.0 + ( std::abs(q1(i,j)-q1p) + std::abs(q2(i,j)-q2p) ) ) +
		 c2 * std::log( 1.0 + std::abs(q6(i,j)-q6p) ) +
		 c1 * std::log( 1.0 + d3 ) +
		 c4 * std::log( 1.0 + d4 + d5 );
	}

}

///////////////////////////////////////////////////////////////////////////////
int
choose_fragment_number_smooth( int const position, pose_ns::Pose & pose ) {
	using namespace rna_fragments;
	int fragment_number( 1 );

	int const num_neighbors = align_depth( position );
	FArray1D_float cost( num_neighbors, 0.0 );

	compare_gunn_RNA( position, pose, cost );

	//Choose from the closest 10 potential fragments,
	// sorted by similarity to current fragment ( as judged by Gunn cost ).
	typedef std::list< std::pair<float,int> > Indexed_cost;
	Indexed_cost cost_position;
	for (int k = 1; k <= num_neighbors; k++) cost_position.push_back( std::make_pair( cost(k), k) );
	cost_position.sort();

	//Oh man, I hate iterators.
	int const shortlist = 10;
	int const shortlist_fragment_num = static_cast<int>( ran3() * shortlist );
	int count = 0;
	for (Indexed_cost::const_iterator it = cost_position.begin();
			 count < shortlist_fragment_num && it != cost_position.end();
			 count++, it++)          fragment_number = it->second;

	return fragment_number;
}

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void
insert_fragment_old( pose_ns::Pose & pose, int const position, int const fragment_number ){
	using namespace rna_fragments;

	for (int res_offset = 1; res_offset <= FRAG_SIZE; res_offset++){

		int const position_offset = position - 1 + res_offset;

		for (int j = 1; j <= NUM_RNA_TORSIONS; j++) {

			if ( !check_RNA_torsion_insertable( pose, position_offset, j) ) continue;

			pose.set_torsion_by_number( position_offset, j,
																	align_torsions_3( j, position, fragment_number, res_offset) );
		}

		pose.set_secstruct( position_offset, 'L' );

	}
}
///////////////////////////////////////////////////////////////////////////////
int
choose_fragment_number( int const position, pose_ns::Pose & pose, bool const smooth) {
	using namespace rna_fragments;
	int fragment_number( 1 );

	if (smooth){
		fragment_number = choose_fragment_number_smooth( position, pose );
	}	else {
		fragment_number = static_cast <int> ( ran3() * align_depth(position) ) + 1;
	}

	return fragment_number;
}

///////////////////////////////////////////////////////////////////////////////
void
write_rna_fragments( int const nres, FArray1D_int const & res, std::string fragment_file ){
	using namespace rna_fragments;

	//	std::string const fragment_file = stringafteroption( "fragments", "blah.fragments");

	utility::io::ozstream frag_out( fragment_file );

	frag_out << "SEQUENCE: ";
	for (int i = 1; i <= nres; i++) frag_out << param_aa::aa_name1(res(i));
	frag_out << std::endl;

	for (int i = 1; i <= nres - FRAG_SIZE + 1; i++){
		int const num_frags = align_depth( i );
		frag_out << std::endl;
		frag_out << "Position: " << I(6,i) << " Fragments: " << I(6,num_frags) << std::endl;
		for (int count = 1; count <= num_frags; count++){
			frag_out << std::endl;
			for (int pos = 1; pos <= FRAG_SIZE; pos++){
				frag_out << I(6,i) << " " << I(6,count) << " " << I(6,pos);
				for (int j = 1; j <= NUM_RNA_TORSIONS; j++) {
					frag_out << " " << F(9,4,align_torsions_3( j , i, count, pos ));
				}
				frag_out << std::endl;
			}
		}
	}
	frag_out.close();
}

///////////////////////////////////////////////////////////////////////////////
// This is not very robust ....
void
read_rna_fragments_old(){
	using namespace pose_ns;
	using namespace rna_fragments;

	int nres;
	std::string sequence;

	std::string const fragment_file = stringafteroption( "fragments", "blah.fragments");

	utility::io::izstream frag_in( fragment_file );

	std::string line, tag;
	int dummy;
	getline( frag_in, line);

	{	//SEQUENCE line

		std::istringstream line_stream( line );
		//		std::cout << "READING SEQUENCE? " << line ;
		line_stream >> tag >> sequence;

		if ( line_stream.fail() || tag != "SEQUENCE:" ) {
			std::cout << "bad format in first lines of fragment file\n";
			std::cout << fragment_file << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}

		nres = sequence.size();
	}

	nres_fragments = nres; //saved in rna_scoring namespace.

	for (int i = 1; i <= nres - FRAG_SIZE + 1; i++){
		getline( frag_in, line);
		getline( frag_in, line);
		{ 	//"align depth" line
			std::istringstream line_stream( line );
			line_stream >> tag >> dummy >> tag >> align_depth( i );
		}
		int const num_frags = align_depth( i );

		std::cout << " ALIGN_DEPTH at pos " << i << " :  " << align_depth(i) << std::endl;

		for (int count= 1; count <= num_frags; count++){
			getline( frag_in, line);
			for (int pos = 1; pos <= FRAG_SIZE; pos++){
				getline( frag_in, line);
				//				std::cout << "TORSION LINE? " << line << std::endl;
				//Actual torsions.
				std::istringstream line_stream( line );
				line_stream >> dummy >> dummy >> dummy; //Dummy.
				for (int j = 1; j <= NUM_RNA_TORSIONS; j++) {
					line_stream >> align_torsions_3( j , i, count, pos );
				}
			}
		}
	}


	frag_in.close();
}
///////////////////////////////////////////////////////////////////////////////
void
pick_rna_fragments_main(){
	using namespace files_paths;
	using namespace misc; //For fasta readin, conversion.

	pose_ns::Pose fragments_pose;


// a stupid piece of book-keeping.
// Fragment reading can change the user-input protein_chain,
// which is necessary for the fasta filename
	char chain_save = protein_chain;

	pose_from_pdb( fragments_pose, stringafteroption("rna_vall"),
								 true, false, true );
	//	fragments_pose.dump_pdb( "fragments.pdb" );
	readin_rna_vall( fragments_pose );

	std::vector< std::string > files;

	if (truefalseoption("l")) {
		std::ifstream data( stringafteroption("l").c_str() );
		std::string line;
		while ( getline( data,line ) ) {
			files.push_back(line);
		}
		data.close();
	} else {
		files.push_back( seq_path+"/"+
										 protein_name+chain_save+".fasta" );
	}



	for ( std::vector< std::string >::const_iterator file=files.begin();
				file != files.end(); ++file ) {

		bool fail( true );
		int count( 0 );
		std::cout << "Pick fragments for: " << *file << std::endl;

		read_fasta( *file, misc::residue1, count, fail);
		misc::total_residue = count;

		convert1_num(); //Fills res with integers!

		pick_rna_fragments( misc::total_residue, misc::res );

		write_rna_fragments( misc::total_residue, misc::res, *file+".fragments" );
	}

}


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// TESTING NEW FRAGMENT CLASS
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
void
create_vall_torsions_file_test(){
	using namespace pose_ns;
	using namespace silent_io;

	std::string const vall_torsions_filename = stringafteroption("vall_torsions","1ffk.vall_torsions");
	utility::io::ozstream frag_out( vall_torsions_filename );

  Silent_file_data * decoys_p;
	std::vector< std::string > files;
  bool silent_input;

	read_decoys_silent_or_not( decoys_p, files, silent_input );

	for ( std::vector< std::string >::const_iterator file=files.begin();
				file != files.end(); ++file ) {

		std::string const start_file( *file);
		std::cout << "Reading in ... " << start_file << std::endl;

		pose_ns::Pose vall_pose;
		fill_decoy_silent_or_not( vall_pose, decoys_p, start_file, silent_input );

		readin_rna_vall( vall_pose );

		writeout_vall_torsions(frag_out);
	}

	frag_out.close();

	std::cout << std::endl << " Created new vall_torsions file: " << vall_torsions_filename << std::endl;
	std::cout << std::endl;

}

namespace rna_fragments_new{
	rna_fragments_class::RNA_Fragments all_rna_fragments;
	bool new_style_fragments = true;
}


///////////////////////////////////////////////////////////////////////////////
void
simple_fragment_check( pose_ns::Pose & test_pose, int const position, int const size, int const type ){

	using namespace rna_fragments_class;
	using namespace rna_fragments_new;

	TorsionSet torsion_set( size );
	all_rna_fragments.pick_random_fragment( torsion_set, test_pose, position, size, type  );

	for (int count = 0; count < size ; count ++ ){
		std::cout << count;
		for (int i = 1; i <= NUM_RNA_TORSIONS; i++ ){
			std::cout << ' ' << torsion_set.torsions( i, count );
		}
		std::cout << std::endl;
	}

}

///////////////////////////////////////////////////////////////////////////////
void
rna_fragments_classes_test()
{
	using namespace rna_fragments_class;
	using namespace rna_fragments_new;
	using namespace pose_ns;



	std::string const vall_torsions_filename = stringafteroption( "vall_torsions", "1ffk.vall_torsions" );

	all_rna_fragments.read_vall_torsions( vall_torsions_filename );

	//What would be a good test?
	//Pick three random fragments for a pose...

	pose_ns::Pose test_pose;
	pose_from_pdb( test_pose, stringafteroption("s"),
								 true, false, true );

	int size, position, type;

	position = 3;
	size = 4;
	type = MATCH_EXACT;
	simple_fragment_check( test_pose, position, size, type );


	size = 4;
	type = MATCH_YR;
	simple_fragment_check( test_pose, position, size, type );

	size = 4;
	type = MATCH_ALL;
	simple_fragment_check( test_pose, position, size, type );

}



///////////////////////////////////////////////////////////////////////////////
void
read_rna_fragments(){

	using namespace rna_fragments_class;
	using namespace rna_fragments_new;

	//The old style -- will be deprecated soon.
	if (truefalseoption( "fragments" ) ) {
		read_rna_fragments_old();
		new_style_fragments = false;
		return;
	}

	//The new style.
	std::string const vall_torsions_filename = stringafteroption( "vall_torsions", "1ffk.vall_torsions");
	all_rna_fragments.read_vall_torsions( vall_torsions_filename );


}

///////////////////////////////////////////////////////////////////////////////
void
random_fragment_trial( pose_ns::Pose & pose, pose_ns::Monte_carlo & mc, bool const smooth, std::string trial_type, int const frag_size /* = 3*/ ){

	random_fragment_insertions( pose, 1, smooth, frag_size );
	mc.boltzmann( pose, trial_type );

}

///////////////////////////////////////////////////////////////////////////////
bool check_RNA_torsion_insertable(
		 pose_ns::Pose & pose,
		 int const position_offset,
		 int const which_torsion)
{

	//obviously some torsions don't make sense for first and last residues.
	// There must be a more clever way to deal with this.
	int const total_residue = pose.total_residue();

	assert( position_offset <= total_residue );
	assert( position_offset > 0 );

	if (which_torsion == 1 && position_offset == 1) return false;
	if (which_torsion == 5 && position_offset == total_residue) return false;
	if (which_torsion == 6 && position_offset == total_residue) return false;

	if (which_torsion == 1 && pose.is_cutpoint( position_offset-1 ) ) return false;
	if (which_torsion == 5 && pose.is_cutpoint( position_offset ) ) return false;
	if (which_torsion == 6 && pose.is_cutpoint( position_offset ) ) return false;

	return true;

}


///////////////////////////////////////////////////////////////////////////////
bool check_RNA_torsion_insertable_strict(
		 pose_ns::Pose & pose,
		 int const position_offset,
		 int const which_torsion)
{

	//Look for pose cutpoints.
	if (!check_RNA_torsion_insertable( pose, position_offset, which_torsion) ) return false;

	//Be even more careful -- use a distance criterion to check
	// for chainbreaks!
	if (which_torsion == 1 && check_chainbreak( position_offset-1, pose ) ) return false;
	if (which_torsion == 5 && check_chainbreak( position_offset, pose ) ) return false;
	if (which_torsion == 6 && check_chainbreak( position_offset, pose ) ) return false;


	return true;

}


///////////////////////////////////////////////////////////////////////////////
void
insert_fragment( pose_ns::Pose & pose, int const position, rna_fragments_class::TorsionSet const torsion_set ){

	int const size = torsion_set.get_size();

	for (int offset = 0; offset < size; offset++){

		int const position_offset = position + offset;

		for (int j = 1; j <= NUM_RNA_TORSIONS; j++) {

			if ( !check_RNA_torsion_insertable( pose, position_offset, j) ) continue;

			pose.set_torsion_by_number( position_offset, j,
																	torsion_set.torsions( j, offset ) );

			pose.set_secstruct( position_offset, 'L' );

			pose.set_name( position_offset, torsion_set.torsion_source_name( offset ) );

		}

	}

}


///////////////////////////////////////////////////////////////////////////////
void
choose_and_insert_fragment( int const position, pose_ns::Pose & pose, int const size, int const type, bool const smooth ){

	using namespace rna_fragments_new;
	using namespace rna_fragments_class;

	//Soon to be deprecated...
	if (!new_style_fragments){
	  int const fragment_number = choose_fragment_number( position, pose, smooth );
		insert_fragment_old( pose, position, fragment_number);
		return;
	}

	TorsionSet torsion_set( size );
	all_rna_fragments.pick_random_fragment( torsion_set, pose, position, size, type  );
	insert_fragment( pose, position, torsion_set );

}

///////////////////////////////////////////////////////////////////////////////
void
random_fragment_insertions( pose_ns::Pose & pose, int const num_fragment_insertions,
														bool const smooth /* = false */ ,
														int const frag_size /* = 3 */){

	int const total_residue = pose.total_residue();

	//User input can override default sizes...
	static int const type = intafteroption( "frag_match", 1);

	for (int i = 1; i <= num_fragment_insertions; i++){

		int position = static_cast <int> ( ran3() * (total_residue - frag_size + 1) ) + 1;

		choose_and_insert_fragment( position, pose, frag_size, type, smooth );

	}

}

///////////////////////////////////////////////////////////////////////////////
// Diagnostics...
void
cycle_through_fragments( pose_ns::Pose & mini_pose_native, silent_io::Silent_out & out ){

	using namespace rna_fragments_new;
	using namespace rna_fragments_class;
	using namespace pose_ns;

	read_rna_fragments();

	//Make a copy for reference, so that we can start trying new fragments.
	Pose mini_pose;
	mini_pose = mini_pose_native; // should copy over the sequence.
	initialize_query_pose_rna( mini_pose, false /*use_fasta*/);
	mini_pose.dump_pdb( "START.pdb" );
	mini_pose.set_native_pose( mini_pose_native );

	out.write( "NATIVE", mini_pose_native );

	int const frag_size = mini_pose_native.total_residue();
	int const frag_match = intafteroption( "frag_match", 2 );

	TorsionSet torsion_set( frag_size );
	//triggers the picking of fragments...
	all_rna_fragments.pick_random_fragment( torsion_set, mini_pose, 1, frag_size, frag_match );

	int const num_vall_torsions = all_rna_fragments.get_align_depth( mini_pose, 1, frag_size, frag_match );

	std::vector < std::pair<float,int> > rms_index_list;

	for ( int i = 1; i <= num_vall_torsions - frag_size + 1; i++){

		all_rna_fragments.get_fragment( torsion_set, mini_pose, 1, frag_size, frag_match, i );
		insert_fragment( mini_pose, 1, torsion_set );

		float const rms_frag = allatom_rmsd( mini_pose, mini_pose_native );
		std::cout << "FRAG " << i << " :   " << rms_frag << std::endl;

		rms_index_list.push_back( std::make_pair( rms_frag, i ) );

	}

	//Sort through RMSD list, output five best fragments as PDB's and in outfile (to look at torsions!).
	int const num_frags_to_output = intafteroption("num_frags_to_output", 5);
	std::sort( rms_index_list.begin(), rms_index_list.end() );

	for (int j = 0; j < num_frags_to_output; j++ ){
		int const i = rms_index_list[j].second;
		all_rna_fragments.get_fragment( torsion_set, mini_pose, 1, frag_size, frag_match, i );
		insert_fragment( mini_pose, 1, torsion_set );

		float const rms_frag = allatom_rmsd( mini_pose, mini_pose_native );
		std::cout << "LOWRMS FRAG " << i << " :   " << rms_frag << std::endl;

		mini_pose.allatom_orient( mini_pose_native );

		std::string const tag = "S_"+string_of( j );
		mini_pose.dump_pdb( tag+".pdb" );
		out.write( tag, mini_pose );
	}

}

///////////////////////////////////////////////////////////////////////////////
void
rna_closest_frag_test()
{
  using namespace pose_ns;
  using namespace param_aa;
	using namespace silent_io;

	Pose pose;
	bool success = pose_from_pdb( pose, stringafteroption("s","BLAH.pdb"),
																true, false, true );
	if (!success){
		std::cout << "Had trouble with input pdb" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	std::string const tag = stringafteroption("o","");

	int const seqpos    = intafteroption("seqpos", 1 );
	int const frag_size = intafteroption("frag_size", 3 );

	Silent_out out ( (tag+"closest_frag.out").c_str() );

	//create mini_pose with just the fragment we care about.
	// output to make sure everything is OK.
	Pose mini_pose_native;

	mini_pose_native.simple_fold_tree( frag_size );
	mini_pose_native.set_fullatom_flag( true, false/*repack rotamers*/ );
	mini_pose_native.copy_segment( frag_size, pose, 1, seqpos, false );
	mini_pose_native.dump_pdb( "NATIVE.pdb" );

	//Cycle through vall, try all fragment insertions, and save RMSD's.
	cycle_through_fragments( mini_pose_native, out );

	//done.
}
