// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

#ifndef INCLUDED_pose_rna_ns
#define INCLUDED_pose_rna_ns


// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <map>

namespace rna_scoring {
	extern int const NUM_RNA_VDW_ATOMS;
	extern FArray4D_float rna_vdw_parameter;
	extern FArray2D_int rna_vdw_atom;
	extern float rna_vdw_scale;
	extern int num_rna_vdw_atoms_check;

	extern int const NUM_EDGES; /* 3 */
	enum {X, WATSON_CRICK, HOOGSTEEN, SUGAR };

	extern FArray5D_float rna_basepair_xy;
	extern float rna_basepair_stagger_cutoff;
	extern float rna_basepair_radius_cutoff;

	typedef std::pair< int, std::pair <int,int> >  rnaBasepairKey ;
	extern std::map< rnaBasepairKey, FArray3D_float > rna_basepair_rho_omega1_omega2;

	extern FArray1D_float rna_o2star_potential;
	extern FArray1D_float rna_o2star_weight;

	extern FArray1D_float rna_phosphate_potential;
	extern FArray1D_float rna_phosphate_weight;

	extern FArray1D_float rna_axis;
	extern FArray1D_float rna_stagger;

	extern int const num_RNA_backbone_oxygen_atoms;
	extern FArray1D_int RNA_backbone_oxygen_atom;
	extern FArray4D_float rna_nonbasebase_xy;

	extern bool rna_fullatom; //Switch for count_pair.h and hbonds.cc
	extern bool count_pair_ignore_neighbor_backbone;

	extern float const o2star_torsion_offset;

}

void
initialize_rna_basepair_xy();

void
initialize_rna_basepair_rho_omega1_omega2();

void
initialize_RNA_backbone_oxygen_atoms();

void
initialize_rna_nonbasebase_xy();

void
initialize_rna_o2star_score();

void
initialize_vdw_rna_parameter();

#endif
