// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15613 $
//  $Date: 2007-06-22 18:05:20 -0700 (Fri, 22 Jun 2007) $
//  $Author: andre $


// Rosetta Headers
#include "design.h"
#include "disulfides.h"
#include "pose_rotamer_trials.h"
#include "constraints.h"
#include "pose.h"
#include "rotamer_trials.h"
#include "score.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <cassert>
#include <cmath>
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <vector>

///////////////////////////////////////////////////////////////////////////////


void
pose_setup_repack_list(
	pose_ns::Pose const & pose,
	FArray1D_int & repack_list,
	int & numpositions,
	int & cycles
)
{
	using namespace disulfides::BOUNDARY;

	int const nres( pose.total_residue() );
	assert( nres <= int(repack_list.size1()) );

	std::vector< int > const & pos_list ( get_rt_pos_list( pose, cycles ) );
	//bool const shuffle( true );

	numpositions = 0;
	for ( int i=0; i< int(pos_list.size()); ++i ) {
		int const seqpos( pos_list[i] );
		if ( pose.get_allow_chi_move( seqpos ) ||
				 param_aa::is_DNA( pose.res(seqpos) ) && design::hydrate_dna ) {
                        if ( pose.symmetric() &&
                                !pose.symmetry_info().chi_independent(seqpos) ) continue;
												if ( get_norepack_disulf() && cys_res_in_disulf(seqpos) ) continue;
			++numpositions;
			repack_list(numpositions) = seqpos;
		}
	}

	random_order( repack_list, numpositions );
	reset_rt_pos_list();

	// hijack get_res_res_cstE:
// 	if ( pose.constraints_exist() ) {
// 		set_pose_constraints( pose.constraints() );
// 	}

}

// problem: how to weight constraints inside packer?
//
// basically -- how to evaluate get_res_res_cstE
//
// simplify -- assume at first only atompair constraints...
//
// options:
// 1. set weights inside cst_set
//    con - Monte_carlo needs to know if scorefxn changes...
//    actually, this is OK if these weights are only used by packer...
//    essentially only used by get_res_res_cstE...
//
// 2. Wpose_cst in param_pack, pack_set_pose_constraint_weight
// 3. use score_ns variables...
// 4.


///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
// namespace
///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////

namespace rt_pos_list_ns
{
	std::vector< int > pos_list;
	int cycles(1);

	// for setting pos_list by deltaE
	bool pos_list_by_deltaE( false );
	FArray1D_float best_energy;
	float energycut;
	pose_ns::Score_name score_name;

}

///////////////////////////////////////////////////////////////////////////////
void
reset_rt_pos_list()
{
	using namespace rt_pos_list_ns;
	pos_list.clear();
	pos_list_by_deltaE = false;
	cycles = 1;
}

///////////////////////////////////////////////////////////////////////////////
void
set_rt_pos_list_by_allow(
	FArray1D_bool const & allow,
	int const nres,
	int const cycles_in
)
{
	using namespace rt_pos_list_ns;
	cycles = cycles_in;
	pos_list.clear();
	for ( int i=1; i<= nres; ++i ) {
		if ( allow(i) ) {
			pos_list.push_back( i );
		}
	}
}

///////////////////////////////////////////////////////////////////////////////
// no support for multiple-cycle rotamer trials as in jumping_refactor
// actually now there is!


std::vector< int > const &
get_rt_pos_list(
	pose_ns::Pose const & pose,
	int & cycles_out
)
{
	using namespace rt_pos_list_ns;
	cycles_out = cycles;
	if ( pos_list_by_deltaE ) {
		pos_list.clear();
		int const nres( best_energy.size1());
		assert( nres == pose.total_residue() || (  pose.symmetric() && (nres == (pose.total_residue() + pose.total_pseudo_residue() ) ) ) );
		FArray1D_float const & energy ( pose.get_1D_score( score_name ) );
		for ( int i=1; i<= nres; ++i ) {
			if ( energy(i) - best_energy(i) > energycut ) {
				// no allow_chi_move check here anymore
				pos_list.push_back( i );
			}
		}
	}
	return pos_list;
}

///////////////////////////////////////////////////////////////////////////////
void
set_rotamer_trials_by_deltaE(
	const pose_ns::Score_name score_name_in,
	float const energycut_in,
	int const nres,
	FArray1D_float const & energy,
	int const cycles_in
)
{
	using namespace rt_pos_list_ns;
	cycles = cycles_in;
	pos_list_by_deltaE = true;
	energycut = energycut_in;
	score_name = score_name_in;
	best_energy.dimension( nres );
	for ( int i=1; i<= nres; ++i ) {
		best_energy(i) = energy(i);
	}
}
///////////////////////////////////////////////////////////////////////////////
bool
get_rotamer_trials_by_deltaE()
{
	return rt_pos_list_ns::pos_list_by_deltaE;
}
///////////////////////////////////////////////////////////////////////////////
void
pose_rottrial_minimization(
	pose_ns::Pose & pose,
	const pose_ns::Score_weight_map & wt_map
)
{

	using namespace pose_ns;

	bool const save_try_rotamers = score_get_try_rotamers();
	bool const save_min_rotamers = get_minimize_rot_flag();
	score_set_try_rotamers( true );
	score_set_minimize_rot( true );
	if (! get_rotamer_trials_by_deltaE() ) {
		int const nres = pose.total_residue();
		int const cycles(1);
		FArray1D_bool allow_rottrial( nres );
		for ( int i=1; i<=nres; ++i) {
			allow_rottrial(i) = pose.get_allow_chi_move(i);
		}
		set_rt_pos_list_by_allow(allow_rottrial, nres, cycles);
	}
	pose.score(wt_map);
	score_set_try_rotamers( save_try_rotamers );
	score_set_minimize_rot( save_min_rotamers );
}
///////////////////////////////////////////////////////////////////////////////
