// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

#ifndef INCLUDED_pose_sse
#define INCLUDED_pose_sse

// Rosetta Headers
#include "pose_fwd.h"
#include "silent_input.h"

void
pose_sse_test();

void
extract_segment_test();

void minimize_and_output( pose_ns::Pose & start_pose,
													pose_ns::Pose & native_pose,
													std::string tag, silent_io::Silent_out out,
													bool const output_start = true,
													bool const dump_pdb = true
);

void
rigid_body_segment_moves( pose_ns::Pose & pose,
													int const num_moves,
													float const RMSD_per_move,
													bool const just_one_segment,
													pose_ns::Score_weight_map fast_weight_map);

void
rigid_body_segment_moves( pose_ns::Pose & pose,
													int const num_moves,
													float const RMSD_per_move,
													bool const just_one_segment);

void
rigid_body_gaussian( pose_ns::Pose & pose,
										 int const which_segment,
										 float const input_rms_shift = 1.0 /* Angstroms */);

void
get_moment_of_inertia( FArray3Da_float Epos, int const total_residue,
                       numeric::xyzVector_float & center_of_mass, numeric::xyzMatrix_float & M );

#endif
