// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-17 23:39:36 -0700 (Sat, 17 Mar 2007) $
//  $Author: stuartm $


// Rosetta Headers
#include "pose_util.h"
#include "jumping_util.h"
#include "pose.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/Time_Date.hh>
#include <ObjexxFCL/formatted.o.hh>

// C++ Headers
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <fstream>


using namespace pose_ns; // DANGER!!


// increase length of SS runs around jump_points
// to avoid choose-fragment problems
// used before fold_abinitio when we have beta-sheet jumps

void
safe_secstruct(
	pose_ns::Pose & pose
)
{
	FArray2D_int const & jump_point ( pose.fold_tree().get_jump_point() );
	int const num_jump ( pose.num_jump() );
	int const nres( pose.total_residue() );

	for ( int i = 1; i <= num_jump; ++i ) {
		for ( int j = 1; j <= 2; ++j ) {
			int const pos = jump_point(j,i);
			char const ss( pose.secstruct(pos) );
			if ( ss != 'L' ) {
				for ( int k = std::max(1,pos-2), ke = std::min(nres,pos+2);
							k <= ke; ++k ) {
					if ( pose.secstruct(k) != ss ) {
						if ( pose.get_allow_bb_move(k) ) {
							pose.set_secstruct( k, ss );
						} else {
							std::cout << "WARNING:: move not allowed in safe_secstruct!" <<
								std::endl;
						}
					}
				}
			}
		}
	}
}



//Utility Headers
#include <utility/basic_sys_util.hh>

	////////////////////////////////////////////////////////////////////////
	// update the domain map
	//
	// this uses the arrays new_XXX_score
	// currently it sets new_jump_score to be true if either endpoint
	// has moved
	//
	// NOTE to self:
	// when we are using subset energies during minimization, want
	// to make sure that the score data is being correctly updated
	// after each calculation!!!!

	// PB:: if we added a new jump, we should just have set
	// new_jump_SCORE = true for that jump
	//
	// if we deleted a jump, the trick is to set new_bb_score, new_bb_refold
	// equal to true at cutpoint, cutpoint+1 where cutpoint is the
	// place where we glued ( the cutpoint that existed in the old tree
	// but no longer exists )

void
calc_domain_map(
	Fold_tree const & fold_tree,
	bool const fullatom,
	FArray1D_bool const & bb_moved,
	FArray1D_bool const & sc_moved,
	FArray1D_bool const & jump_moved_in,
	FArray1D_int & domain_map // output
)
{
	FArray2D_int const & jump_point ( fold_tree.get_jump_point() );

	int const nres( fold_tree.get_nres() );
	int const num_jump( fold_tree.get_num_jump() );

	// we modify the jmp_moved array, so make a local copy (static for speed):
	// we set jmp_moved(i) = true if either of the jump end-points have moved
	static FArray1D_bool jmp_moved;
	if ( int( jmp_moved.size1() ) != num_jump ) jmp_moved.dimension( num_jump );
	jmp_moved = jump_moved_in;

	// static local array: only re-dimension upon changes of total_residue
	static FArray1D_int color;
	if ( int( color.size1() ) < nres ) {
		color.dimension( nres );
	}
	//params:
	int const init_color = { -1 };
	int const moving_color = { 0 }; // dont change this !!!
	bool const local_debug = { false };

	// initialize ---------------------------------------------------
	for ( int i = 1; i <= num_jump; ++i ) {
		if ( bb_moved(jump_point(1,i)) || bb_moved(jump_point(2,i)) ) {
			jmp_moved(i) = true; // makes the logic simpler below
		}
	}

	for ( int i = 1; i <= nres; ++i ) {
		if ( bb_moved(i) ) {
			color(i) = moving_color; // domain=0: moving residues
		} else {
			color(i) = init_color; // unassigned, for debugging
		}
	}

	int new_color, prev_color, iterate, start_color, stop_color;
	new_color = 1;

	// now traverse the tree in reverse-fold-order ------------------
	for ( Fold_tree::const_iterator it = fold_tree.end(),
					it_begin = fold_tree.begin(); it != it_begin; ) {
		--it;
		int const estart( it->start);
		int const estop ( it->stop);
		int const elabel( it->label);

		start_color = color(estart);
		stop_color = color(estop);

		if ( elabel > 0 ) { // jump

			if ( ! jmp_moved(elabel) ) { // both colors should be the same,
				// b/c we know that the jump is unchanged AND
				// neither of the jump_point residues has moved either

				if ( start_color != init_color ) {

					if ( stop_color != init_color ) {
						change_color( color, nres, stop_color, start_color );
						// globally replace stop_color with start_color
					} else {
						color(estop) = start_color;
					}

				} else { // start is uncolored

					if ( stop_color != init_color ) {
						color(estart) = stop_color;
					} else { // both uncolored
						color(estop) = new_color;
						color(estart) = new_color;
						++new_color;
					}
				}

			} else { // jump has changed

				if ( stop_color == init_color ) {
					color(estop) = new_color;
					++new_color;
				}

				if ( start_color == init_color ) {
					color(estart) = new_color;
					++new_color;
				}
			} // has the jump changed?

		} else if ( elabel == -1 ) { // peptide segment

			if ( stop_color == init_color ) {
				color(estop) = new_color;
				++new_color;
			}

			if ( estart < estop ) {
				iterate = -1;
			} else {
				iterate = 1;
			}

			for ( int i = estop + iterate, iend = estart * iterate; i * iterate <= iend; i += iterate ) {
				prev_color = color(i-iterate);

				if ( color(i) == init_color ) {
					if ( prev_color == moving_color ) {
						color(i) = new_color;
						++new_color;
					} else if ( prev_color != init_color ) {
						color(i) = prev_color;
					} else {          // debug
						std::cout << "color problem:" << SS( i ) << SS( prev_color ) << std::endl;
					}

				} else if ( color(i) != moving_color ) {
					if ( prev_color != moving_color ) {
						change_color( color, nres, prev_color, color(i) );
						// globally replace prev_color w/ color(i)
					}
				}
			}

		} else {                   // debug
			std::cout << "funny edge:" <<
				SS( estart ) << SS( estop ) << SS( elabel ) << std::endl;
			std::cout << fold_tree;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
	}                     // edge_num

	// now add the sc-movers ------------------------
	if ( fullatom ) {
		for ( int i = 1; i <= nres; ++i ) {
			if ( sc_moved(i) ) color(i) = moving_color;
		}
	}

	for ( int i = 1; i <= nres; ++i ) {
		domain_map(i) = color(i);
	}


	if ( ! local_debug ) return;

	if ( true ) {
		std::cout << "local_debugging in update_domain_map" << std::endl;
	}

	// ---------------all debugging from here on down ----------------------------

	// ------------------- debug the coloring ----------------------
	// temporarily only do if fullatom!
	if ( fullatom ) {

		for ( int i = 1; i <= nres; ++i ) {
			if ( color(i) == init_color ||
					 ( color(i) == moving_color && ! ( bb_moved(i) || sc_moved(i) ) ) ||
					 ( color(i) != moving_color && ( bb_moved(i) || sc_moved(i) ) ) ) {
				std::cout << "res color prob:" << SS( i ) << SS( color(i) ) <<
					SS( bb_moved(i) ) << std::endl;
				utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			}
		}

		for ( Fold_tree::const_iterator it = fold_tree.begin(),
						it_end = fold_tree.end(); it != it_end; ++it ) {

			int const estart( it->start);
			int const estop ( it->stop);
			int const elabel( it->label);

			if ( elabel > 0 ) { // jump

				if ( ( jmp_moved(elabel) && color(estart) == color(estop) &&
							 color(estart) != moving_color ) ||
						 ( ! jmp_moved(elabel) && ! ( sc_moved(estart) || sc_moved(estop) ) &&
							 color(estart) != color(estop) ) ) {
					std::cout << "jump color problem:" << SS( jmp_moved(elabel) ) <<
						SS( color(estart) ) << SS( color(estop) ) << std::endl;
					utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
				}

			} else {                   // peptide segment
				if ( estart < estop ) {
					iterate = -1;
				} else {
					iterate = 1;
				}

				for ( int i = estop + iterate, iend = estart * iterate; i * iterate <= iend; i += iterate ) {
					prev_color = color(i-iterate);

					if ( ( color(i) == prev_color && color(i) != moving_color &&
								 ( bb_moved(i) || bb_moved(i-iterate) || sc_moved(i) ||
									 sc_moved(i-iterate) ) ) ||
							 ( color(i) != prev_color && ! ( bb_moved(i) || bb_moved(i-iterate) ||
																							 sc_moved(i) || sc_moved(i-iterate) ) ) ) {
						std::cout << "res-res color problem:" <<
							SS( color(i) ) << SS( color(i-iterate) ) <<
							SS( bb_moved(i) ) << SS( bb_moved(i-iterate) ) <<
							SS( sc_moved(i) ) << SS( sc_moved(i-iterate) ) << std::endl;
						utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
					}
				}
			}
		}
	} // debugging
}
