// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7755 $
//  $Date: 2006-03-24 12:36:17 -0800 (Fri, 24 Mar 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_prof
#define INCLUDED_prof
// ObjexxFCL Headers
//#include <ObjexxFCL/ObjexxFCL.h>
#include <cstdlib>
#include <cstdio>
#include <iostream>
#include <ctime>
#include <map>

// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
//
// not intended for profiling inside tight loops
// the clock() routine currently being used has fairly crappy
// resolution and it will introduce some small overhead with the
// function calls and the if-check even if not using -profile on
// the command line
//
// you can wrap it around large-ish chunks of code, like fullatom_energy
// or rotamer_trials...
//
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER
// DANGER DANGER DANGER WARNING WARNING WARNING DANGER DANGER DANGER

//
// A simple setup for timing code fragments. Probably not optimal timing
// functions -- I'm open to suggestions.
//
// looks like (see eg fullatom_energy or scorefxn)
//
// PROF_START( prof::TAG );
//
// <function call>
//
// PROF_STOP( prof::TAG );
//
// where TAG is in the enum "Prof_tag" below (feel free to add new ones)
// also add to tag2string if you want friendly output.
//
// PROF_STOP checks the time and increments the total time assigned to TAG
//
//
// 2. later on, in your simulation code you can do:
//
// prof::reset();
//
//  -- miscellaneous simulation --
//
// prof::show();
//
// The final call to prof::show() will display the time usage measured
// by all the PROF_* calls between reset() and show()
//

#ifdef NO_PROF
#define PROF_START(expr)
#define PROF_STOP(expr)
#else
#define PROF_START(expr) ( prof::prof_start_function_body(expr) )
#define PROF_STOP(expr) ( prof::prof_stop_function_body(expr) )
#endif

namespace prof {

	enum // try to keep this line at line 99 then it's easy to check numbers
	Prof_tag { /*  0 */ TEST0,
						 /*  1 */ TEST1,
						 /*  2 */ TEST2,
						 /*  3 */ TEST3,
						 /*  4 */ TEST4,
						 /*  5 */ TEST5,
						 /*  6 */ TEST6,
						 /*  7 */ TEST7,
						 /*  8 */ TEST8,
						 /*  9 */ TEST9,
						 /* 10 */ FULLATOM_ENERGY,
						 /* 11 */ F_E_PAIR_ENERGY,
						 /* 12 */ F_E_GB,
						 /* 13 */ F_E_GB_RADII,
						 /* 14 */ F_E_GB_ENERGY,
						 /* 15 */ F_E_HBOND,
						 /* 16 */ F_E_FA_PAIR,
						 /* 17 */ F_E_FA_CACHE,
						 /* 18 */ F_E_NB_INFO,
						 /* 19 */ F_E_DUNBRACK,
						 /* 20 */ F_E_ANGLES_FROM_PDB,
						 /* 21 */ F_E_WATER,
						 /* 22 */ ATOM_TREE_REFOLD,
						 /* 23 */ DOMAIN_MAP,
						 /* 24 */ DFPMIN,
						 /* 25 */ ATOM_TREE_FUNC_VDW,
						 /* 26 */ ATOM_TREE_DFUNC_VDW,
						 /* 27 */ ATOMPAIR_DERIV,
						 /* 28 */ DFUNC_NB,
						 /* 29 */ DFUNC_HB,
						 /* 30 */ MIN_MAP_UPDATE_NBLIST,
						 /* 31 */ MMUN_NB_INFO,
						 /* 32 */ POSE_COPY_SCORE_DATA,
						 /* 33 */ POSE_COPY_COORDS,
						 /* 34 */ ATOM_TREE_COPY_TORSIONS,
						 /* 35 */ CCD_CLOSE,
						 /* 36 */ CCD_MOVES,
						 /* 37 */ SCOREFXN,
						 /* 38 */ ROTAMER_TRIALS,
						 /* 39 */ MAIN_REPACK,
						 /* 40 */ DFUNC,
						 /* 41 */ UPDATE_NBLIST,
						 /* 42 */ RTCALC_ENERGIES,
						 /* 43 */ GET_ENERGIES,
						 /* 44 */ PACKER_SIMANNEALING,
						 /* 45 */ GET_ROTAMERS_BORN_RADII,
						 /* 46 */ POSE_VDW_COMPUTE,
						 /* 47 */ POSE_UPDATE_CENDIST,
						 /* 48 */ DOMINS_PERTURB,
						 /* 49 */ DOMINS_RB,
						 /* 50 */ DOMINS_LOOP,
						 /* 51 */ DOMINS_FLOP,
						 /* 52 */ DOMINS_RELAX,
						 /* 53 */ DOMINS_MCM,
						 /* 54 */ DOMINS_SM,
						 /* 55 */ DOMINS_SHM,
						 /* 56 */ INSERT_LOOP,
						 /* 57 */ CST_ENERGY,
						 /* 58 */ DOCK_REPACK,
						 /* 59 */ RTMIN,
						 /* 60 */ F_E_H2O,
						 /* 61 */ F_E_PAIR,
						 /* 62 */ DSSP,
						 /*add more here and remember to add to tag2string in prof.cc !*/
						 /*LAST*/ TOTAL
	};

	extern std::map< Prof_tag, std::string > tag2string;

	extern std::map< Prof_tag, clock_t > start_clock;
	extern std::map< Prof_tag, double > total_clock;
	extern std::map< Prof_tag, int > calls;
	extern std::map< Prof_tag, int > bad_calls;

	extern double const clock_factor;
	extern clock_t const SHRINK_FACTOR; // prevent overflow
	extern bool profiling;

	inline
	void
	prof_start_function_body( Prof_tag const tag )
	{
		if (!profiling) return;
		start_clock[ tag ] = clock() / SHRINK_FACTOR;
		++calls[ tag ];
	}


	inline
	void
	prof_stop_function_body( Prof_tag const tag )
	{
		if (!profiling) return;

		clock_t const current( clock() / SHRINK_FACTOR );
		clock_t const start( start_clock[tag] );

		if ( current >= start ) {
			total_clock[ tag ] += clock_factor * ( current - start );
		} else {
			--calls[ tag ];
			++bad_calls[ tag ];
		}
	}


	void
	reset( bool const force_profiling = false );


	void
	show();

}



#endif
