// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12599 $
//  $Date: 2007-02-09 12:34:20 -0800 (Fri, 09 Feb 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_ramachandran
#define INCLUDED_ramachandran


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// ramachandran Function Declarations


void
read_rama();


float
eval_rama_score_all(
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_int res,
	FArray1Da_char ss,
	int & total_residue
);


void
write_rama_score_all(
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_int res,
	FArray1Da_char ss,
	int & total_residue
);


void
eval_rama_score_residue(
	int const res,
	float const phi,
	float const psi,
	char const ss,
	float & rama,
	float & drama_dphi,
	float & drama_dpsi
);


float
get_rama_score_residue_deriv(
	int const aa,
	float const phi,
	float const psi,
	char const ss,
	int const torsion
);

bool
use_alpha_rama_flag();

void
eval_procheck_rama(
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_int res,
	int & total_residue,
	float & favorable,
	float & allowed,
	float & generous
);


#endif
