// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-17 23:39:36 -0700 (Sat, 17 Mar 2007) $
//  $Author: stuartm $


// Rosetta Headers
#include "read_paths.h"
#include "after_opts.h"
#include "files_paths.h"
#include "misc.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/formatted.i.hh>
#include <ObjexxFCL/string.functions.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>

// C++ Headers
#include <cstdlib>
#include <fstream>
#include <iostream>
#include <string>


// Path strings
#if defined (WIN32) && defined (_MSC_VER)
static std::string PATH_SEP = "\\";
static std::string DEFAULT_PATH = ".\\";
#else   // Linux/Unix paths
static std::string PATH_SEP = "/";
static std::string DEFAULT_PATH = "./";
#endif

#if defined (BAKERLAB)
static std::string DEFAULT_DATA_PATH1 = "/scratch/shared/rosetta_database/";
static std::string DEFAULT_DATA_PATH2 = "/net/shared/rosetta_database/";
#else
static std::string DEFAULT_DATA_PATH1 = DEFAULT_PATH;
static std::string DEFAULT_DATA_PATH2 = DEFAULT_PATH;
#endif


////////////////////////////////////////////////////////////////////////////////
/// @begin read_paths
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
read_paths()
{
	using namespace files_paths;

	utility::io::izstream paths_x;

	std::string path_file;

//==============================================================================
//
//   PATH DEFINTIONS
//
//==============================================================================
//
//     paths end with a slash
//     paths and filenames may not contain whitespace
//     line length limit in files_path.h
//
//     file purpose  +'_x' is the stream of input/output files

	stringafteroption( "paths", "paths.txt", path_file );

#if defined (WIN32) && defined (_MSC_VER)
	if ( truefalseoption( "unix_paths" ) ) {
		PATH_SEP = "/";
		DEFAULT_PATH = "./";
	}
#endif

	paths_x.open( path_file );

	if ( !paths_x ) {
		std::cout << "--------------------------------------------" << std::endl;
		std::cout << "WARNING::  paths.txt file not found!!" << std::endl;
		std::cout << "           Setting all paths to ." << PATH_SEP << std::endl;
		pdb_path_1 = DEFAULT_PATH;
		pdb_path_2 = DEFAULT_PATH;
		//data_path_2 = DEFAULT_PATH;
		data_path_2 = DEFAULT_DATA_PATH2;
		fragments_path_1 = DEFAULT_PATH;
		ss_path = DEFAULT_PATH;
		seq_path = DEFAULT_PATH;
		constraints_path = DEFAULT_PATH;
		start_path = DEFAULT_PATH;
		//data_path = DEFAULT_PATH;
		data_path = DEFAULT_DATA_PATH1;
		movie_path = DEFAULT_PATH;
		pdb_out_path = DEFAULT_PATH;
		score_path = DEFAULT_PATH;
		status_path = DEFAULT_PATH;
		user_path = DEFAULT_PATH;

		std::cout << "           Using default fragment file names:" << std::endl;
		std::cout << "             aa*****03_05.200_v1_3" << std::endl;
		std::cout << "             aa*****03_05.200_v1_3" << std::endl;
		std::cout << "--------------------------------------------" << std::endl;
		n_frag_files() = 2;
		frag_sizes(1) = 3;
		frag_file_name(1) = "aa*****03_05.200_v1_3";

		frag_sizes(2) = 9;
		frag_file_name(2) = "aa*****09_05.200_v1_3";

		return;
	}

	paths_x >> skip; // comments
	paths_x >> skip;

// INPUT PATHS
	paths_x >> skip; // INPUT PATHS comment line

// pdb files:
	read_nextpath( paths_x, pdb_path_1 );
	read_nextpath( paths_x, pdb_path_2 );

//car alternate data path
	read_nextpath( paths_x, data_path_2 );

// fragment files:
	read_nextpath( paths_x, fragments_path_1 );


// secondary structure files:
	read_nextpath( paths_x, ss_path );


// fasta files:
	read_nextpath( paths_x, seq_path );

// constraints (if not found, constraints are not used):
	read_nextpath( paths_x, constraints_path );

// starting structure
	read_nextpath( paths_x, start_path );

// data files
	read_nextpath( paths_x, data_path );

// OUTPUT PATHS
	paths_x >> skip; // OUTPUT PATHS comment line

// movies:
	read_nextpath( paths_x, movie_path );

// pdb output:
	read_nextpath( paths_x, pdb_out_path );

// score file:
	read_nextpath( paths_x, score_path );

// status file:
	read_nextpath( paths_x, status_path );

// user file:  (for debugging, other)
	read_nextpath( paths_x, user_path );

//--------------------------
//  FRAGMENT FILES
//--------------------------

	paths_x >> skip; // comments

	paths_x >> bite( 3, n_frag_files() ) >> skip;

	for ( int i = 1, ie = n_frag_files(); i <= ie; ++i ) {
		paths_x >> bite( 3, frag_sizes(i) ) >> skip;
		paths_x >> frag_file_name(i) >> skip; // Gets leading string (leaves trailing comment)
	}

	paths_x.close();
	paths_x.clear();
	check_files_paths();

}

////////////////////////////////////////////////////////////////////////////////
/// @begin read_nextpath
///
/// @brief
///
/// @detailed
///
/// @param  iunit - [in/out]? -
/// @param  path - [in/out]? -
/// @param  length - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
read_nextpath(
	utility::io::izstream & iunit,
	std::string & path
)
{
	std::string line;
	iunit.getline( line );
	ObjexxFCL::strip_whitespace( line ); // Remove surrounding whitespace

	// replace alternate path separator with correct one
	if ( PATH_SEP == "/" ) {
		std::replace( line.begin(), line.end(), '\\', '/' );
	} else {
		std::replace( line.begin(), line.end(), '/', '\\' );
	}

	std::string::size_type first = line.find( PATH_SEP );
	if ( first == std::string::npos ) {
		std::cout << "EXITING :: error in paths.txt file" << std::endl;
		std::cout << "no path found on line: " << line << std::endl;
		std::cerr << "EXITING :: error in paths.txt file" << std::endl;
		std::cerr << "no path found on line: " << line << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	} else if ( first >= 2 ) {
		if ( line.substr( first-2, 2 ) == ".." ) {
			first -= 2;
		} else if ( line[first-1] == '.' ) {
			--first;
		}
	} else if ( first >= 1 ) {
		if ( line[first-1] == '.' ) --first;
	}

	if ( line[line.length()-1] != PATH_SEP[PATH_SEP.length()-1] ) {
		std::cout << "EXITING :: error in paths.txt file" << std::endl;
		std::cout << "all paths must terminate with " << PATH_SEP << std::endl;
		std::cout << "last path: " << line.substr(first) << std::endl;
		std::cerr << "EXITING :: error in paths.txt file" << std::endl;
		std::cerr << "all paths must terminate with " << PATH_SEP << std::endl;
		std::cerr << "last path: " << line.substr(first) << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}

	path = line.substr(first);
}

////////////////////////////////////////////////////////////////////////////////
/// @begin check_files_paths
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
check_files_paths()
{
	using namespace files_paths;

	//car check that frag filenames have indicators for name and chain
	std::string const search( NAME_LENGTH + 1, '*' );
	for ( int i = 1, ie = n_frag_files(); i <= ie; ++i ) {
		if ( frag_file_name(i).find( search ) == std::string::npos ) {
			std::cout << "frag filenames should contain " << search <<
			 " in place of the protein name and chain" << std::endl;
			std::cout << frag_file_name(i) << std::endl;
			std::cerr << "frag filenames should contain " << search <<
			 " in place of the protein name and chain" << std::endl;
			std::cerr << frag_file_name(i) << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin open_data_file
///
/// @brief
///
/// @detailed
///
/// @param  filename - [in/out]? -
/// @param  iunit - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
utility::io::izstream &
open_data_file( std::string const & filename )
{
	using namespace files_paths;

	std::string fullname( data_path + filename );

	data_x.open( fullname );

	if ( !data_x ) {
		std::cout << "trouble finding " << data_x.filename() << std::endl;
		fullname = data_path_2 + filename;

		data_x.open( fullname );

		if ( !data_x ) {
			fullname = data_path_2 + filename;

			data_x.open( filename );

			if (!data_x){
				std::cout << "trouble finding " << data_x.filename() << std::endl;
				std::cerr << "trouble finding " << data_x.filename() << std::endl;
				utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			}
		}
	}

	std::cout << "Reading " << data_x.filename() << std::endl;
	return data_x;
}

////////////////////////////////////////////////////////////////////////////////
//pb   dont stop if you fail, just let me know

utility::io::izstream &
try_to_open_data_file(
	std::string const & filename,
	bool & fail
)
{
	using namespace files_paths;

	std::string fullname( data_path + filename );

	fail = true;

	data_x.open( fullname );

	if ( !data_x ) {
		std::cout << "trouble finding " << data_x.filename() << std::endl;
		fullname = data_path_2 + filename;

		data_x.open( fullname );

		if ( !data_x ) {
			std::cout << "trouble finding " << data_x.filename() << std::endl;
			data_x.close();
			data_x.clear();

			return data_x;
		}
	}

	std::cout << "Reading " << data_x.filename() << std::endl;
	fail = false;
	return data_x;
}
