// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 09:37:52 -0800 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_refold_ns
#define INCLUDED_refold_ns


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


namespace refold_ns {


extern int const n;
extern int const ca;
extern int const cb;
extern int const c;
extern int const ox;
extern int const cen;

extern int const ph;
extern int const ps;
extern int const om;

extern int const n2c;
extern int const c2n;


namespace refold_param {
	extern FArray1D_float const cb_phi_offset;
	extern FArray1D_float const ox_psi_offset;
	extern FArray2D_float const D;
	extern FArray2D_float const angle;
	extern FArray2D_float cT;
	extern FArray2D_float sT;
	extern FArray3D_float const centroid_parm;
}
using namespace refold_param;


namespace huber {
	extern FArray2D_float default_template;
}
using namespace huber;


// namespaces without using directives
namespace refold_mat {
	extern int refold_dir;
	extern int force_refold_dir;
}

namespace refold_segments {
	extern FArray1D_int seg_begin;
	extern FArray1D_int seg_end;
	extern FArray1D_int seg_dir;
	extern FArray1D_int seg_map;
	extern int first_segment;
	extern int last_segment;
}

namespace orient_flag_bool {
	extern bool refold_orient_flag;
}

namespace refold_orient_pos {
	extern int orient_total_residue;
	extern FArray3D_float refold_orient_position;
}

namespace st_bond_switch {
	extern bool st_bond;
}

namespace refold_switch {
	extern bool new_refold;
}

}


#endif
